/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.config;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.launching.config.RootContextIdentifierType;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.internal.launching.JavaMigrationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;

@Singleton
public class LaunchConfigurationConfigurator
implements ILaunchConfigurationConfigurator,
ILaunchConfigurationAccessor {
    public static final String ATTR_AGENT_NAME = "io.sarl.eclipse.AGENT_NAME";
    public static final String ATTR_ROOT_CONTEXT_ID_TYPE = "io.sarl.eclipse.ROOT_CONTEXT_ID_TYPE";
    public static final String ATTR_SARL_RUNTIME_ENVIRONMENT = "io.sarl.eclipse.SARL_RUNTIME_ENVIRONMENT";
    public static final String ATTR_USE_SYSTEM_SARL_RUNTIME_ENVIRONMENT = "io.sarl.eclipse.USE_SYSTEM_SARL_RUNTIME_ENVIRONMENT";
    public static final String ATTR_USE_PROJECT_SARL_RUNTIME_ENVIRONMENT = "io.sarl.eclipse.USE_PROJECT_SARL_RUNTIME_ENVIRONMENT";
    public static final String ATTR_CONTRIB_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS_POSTFIX = ".CONTRIB_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS";
    public static final String ATTR_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS = "io.sarl.eclipse.SARL_RUNTIME_ENVIRONMENT_ARGUMENTS";
    public static final String ATTR_EXTRA_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS = ".EXTRA_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS";
    public static final String ATTR_EXTRA_VM_ARGUMENTS = ".EXTRA_VM_ARGUMENTS";
    public static final String ATTR_EXTRA_CLASSPATH_PROVIDER = ".EXTRA_CLASSPATH_PROVIDER";
    public static final String ATTR_EMBEDDED_SRE = "io.sarl.eclipse.EMBEDDED_SRE";
    public static final String ATTR_ENABLE_LAUNCHING_PARAMETERS_PRINT_OUT = "io.sarl.eclipse.ENABLE_LAUNCHING_PARAMETERS_PRINT_OUT";
    public static final String ATTR_ENABLE_ASSERTIONS_IN_DEBUG_MODE = "io.sarl.eclipse.ENABLE_ASSERTIONS_DEBUG";
    public static final String ATTR_ENABLE_ASSERTIONS_IN_RUN_MODE = "io.sarl.eclipse.ENABLE_ASSERTIONS_RUN";
    public static final String ATTR_LOG_OPTION_NAME = "io.sarl.eclipse.LOG_OPTION_NAME";
    public static final String ATTR_LOG_OPTION_VALUE = "io.sarl.eclipse.LOG_OPTION_VALUE";
    public static final String SARL_AGENT_LAUNCH_CONFIG_TYPE = "io.sarl.eclipse.debug.AgentLaunchConfigType";
    public static final String SARL_APPLICATION_LAUNCH_CONFIG_TYPE = "io.sarl.eclipse.debug.ApplicationLaunchConfigType";
    private static final boolean DEFAULT_USE_SYSTEM_SRE = true;
    private static final boolean DEFAULT_USE_PROJECT_SRE = false;
    private static final boolean DEFAULT_EMBEDDED_SRE = false;
    private static final boolean DEFAULT_ENABLE_LAUNCHING_PARAMETERS_PRINT_OUT = false;
    private static final boolean DEFAULT_ENABLE_ASSERTIONS_IN_DEBUG_MODE = true;
    private static final boolean DEFAULT_ENABLE_ASSERTIONS_IN_RUN_MODE = false;

    @Override
    public String getAgentLaunchConfigurationType() {
        return SARL_AGENT_LAUNCH_CONFIG_TYPE;
    }

    @Override
    public String getApplicationLaunchConfigurationType() {
        return SARL_APPLICATION_LAUNCH_CONFIG_TYPE;
    }

    private static String simpleName(String fullName) {
        int index;
        if (!Strings.isNullOrEmpty((String)fullName) && (index = fullName.lastIndexOf(46)) >= 0 && index < fullName.length() - 1) {
            return fullName.substring(index + 1);
        }
        return fullName;
    }

    @Override
    public ILaunchConfiguration newAgentLaunchConfiguration(String projectName, String launchConfigurationName, String fullyQualifiedNameOfAgent, String logLevel) throws CoreException {
        String name = Strings.isNullOrEmpty((String)launchConfigurationName) ? LaunchConfigurationConfigurator.simpleName(fullyQualifiedNameOfAgent) : launchConfigurationName;
        ILaunchConfigurationWorkingCopy wc = this.initLaunchConfiguration(this.getAgentLaunchConfigurationType(), projectName, name, true, logLevel);
        this.setAgent(wc, fullyQualifiedNameOfAgent);
        return wc.doSave();
    }

    @Override
    public ILaunchConfiguration newApplicationLaunchConfiguration(String projectName, String launchConfigurationName, String fullyQualifiedNameOfClass, Class<? extends IRuntimeClasspathProvider> classPathProvider, String logLevel) throws CoreException {
        String name = Strings.isNullOrEmpty((String)launchConfigurationName) ? LaunchConfigurationConfigurator.simpleName(fullyQualifiedNameOfClass) : launchConfigurationName;
        ILaunchConfigurationWorkingCopy wc = this.initLaunchConfiguration(this.getApplicationLaunchConfigurationType(), projectName, name, false, logLevel);
        LaunchConfigurationConfigurator.setMainJavaClass(wc, fullyQualifiedNameOfClass);
        if (classPathProvider != null) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, classPathProvider.getName());
        }
        return wc.doSave();
    }

    protected static void setMainJavaClass(ILaunchConfigurationWorkingCopy wc, String name) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
    }

    protected ILaunchConfigurationWorkingCopy initLaunchConfiguration(String configurationType, String projectName, String id, boolean resetJavaMainClass, String logLevel) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(configurationType);
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchManager.generateLaunchConfigurationName(id));
        this.setProjectName(wc, projectName);
        this.setDefaultContextIdentifier(wc, null);
        ISREInstall sre = SARLRuntime.getDefaultSREInstall();
        this.setRuntimeConfiguration(wc, sre, true, false, resetJavaMainClass);
        if (!Strings.isNullOrEmpty((String)logLevel)) {
            String logOpt = (String)sre.getAvailableCommandLineOptions().get("CLI-Log");
            this.setLogArgument(wc, logOpt, logLevel);
        }
        JavaMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)wc);
        return wc;
    }

    @Override
    public void attachResources(ILaunchConfigurationWorkingCopy configuration, IResource ... resources) throws CoreException {
        IResource[] newTab;
        IResource[] oldTab = configuration.getMappedResources();
        if (oldTab == null) {
            newTab = Arrays.copyOf(resources, resources.length);
        } else {
            newTab = Arrays.copyOf(oldTab, oldTab.length + resources.length);
            System.arraycopy(resources, 0, newTab, oldTab.length, resources.length);
        }
        configuration.setMappedResources(newTab);
    }

    @Override
    public void detachResources(ILaunchConfigurationWorkingCopy configuration, IResource ... resources) throws CoreException {
        ArrayList<IResource> res = new ArrayList<IResource>();
        IResource[] oldTab = configuration.getMappedResources();
        if (oldTab != null) {
            res.addAll(Arrays.asList(oldTab));
        }
        if (res.removeAll(Arrays.asList(resources))) {
            configuration.setMappedResources(res.toArray(new IResource[res.size()]));
        }
    }

    @Override
    public void setRuntimeConfiguration(ILaunchConfigurationWorkingCopy configuration, ISREInstall sre, Boolean useSystemSre, Boolean useProjectSre, boolean resetJavaMainClass) {
        boolean project;
        boolean system = useSystemSre == null ? true : useSystemSre;
        boolean bl = project = useProjectSre == null ? false : useProjectSre;
        if (system && project) {
            system = true;
            project = false;
        }
        if (sre != null) {
            configuration.setAttribute(ATTR_SARL_RUNTIME_ENVIRONMENT, sre.getId());
            String mainClass = sre.getMainClass();
            if (resetJavaMainClass) {
                if (Strings.isNullOrEmpty((String)mainClass)) {
                    configuration.removeAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
                } else {
                    LaunchConfigurationConfigurator.setMainJavaClass(configuration, mainClass);
                }
            }
        } else {
            configuration.removeAttribute(ATTR_SARL_RUNTIME_ENVIRONMENT);
            if (resetJavaMainClass) {
                configuration.removeAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
            }
        }
        configuration.setAttribute(ATTR_USE_SYSTEM_SARL_RUNTIME_ENVIRONMENT, system);
        configuration.setAttribute(ATTR_USE_PROJECT_SARL_RUNTIME_ENVIRONMENT, project);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
    }

    @Override
    public void setProjectName(ILaunchConfigurationWorkingCopy configuration, String projectName) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, Strings.emptyToNull((String)projectName));
    }

    @Override
    public void setAgent(ILaunchConfigurationWorkingCopy configuration, String agentFullyQualifiedName) {
        configuration.setAttribute(ATTR_AGENT_NAME, Strings.emptyToNull((String)agentFullyQualifiedName));
    }

    @Override
    public void setDefaultContextIdentifier(ILaunchConfigurationWorkingCopy configuration, RootContextIdentifierType contextID) {
        if (contextID == null) {
            configuration.setAttribute(ATTR_ROOT_CONTEXT_ID_TYPE, RootContextIdentifierType.DEFAULT_CONTEXT_ID.name());
        } else {
            configuration.setAttribute(ATTR_ROOT_CONTEXT_ID_TYPE, contextID.name());
        }
    }

    @Override
    public void setAgentLaunchingArguments(ILaunchConfigurationWorkingCopy configuration, String arguments) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, arguments);
    }

    @Override
    public void setSRELaunchingArguments(ILaunchConfigurationWorkingCopy configuration, String arguments) {
        configuration.setAttribute(ATTR_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS, Strings.emptyToNull((String)arguments));
    }

    @Override
    public void setExtraSRELaunchingArguments(ILaunchConfigurationWorkingCopy configuration, String contributorId, String arguments) {
        String attrName = contributorId + ATTR_EXTRA_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS;
        configuration.setAttribute(attrName, Strings.emptyToNull((String)arguments));
    }

    @Override
    public void setJRELaunchingArguments(ILaunchConfigurationWorkingCopy configuration, String arguments) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, Strings.emptyToNull((String)arguments));
    }

    @Override
    public void setExtraJRELaunchingArguments(ILaunchConfigurationWorkingCopy configuration, String contributorId, String arguments) {
        String attrName = contributorId + ATTR_EXTRA_VM_ARGUMENTS;
        configuration.setAttribute(attrName, Strings.emptyToNull((String)arguments));
    }

    @Override
    public String getSREId(ILaunchConfiguration configuration) {
        try {
            return Strings.emptyToNull((String)configuration.getAttribute(ATTR_SARL_RUNTIME_ENVIRONMENT, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getMain(ILaunchConfiguration configuration) {
        try {
            return Strings.emptyToNull((String)configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public boolean getUseSystemSREFlag(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_USE_SYSTEM_SARL_RUNTIME_ENVIRONMENT, true);
        }
        catch (CoreException coreException) {
            try {
                String value = configuration.getAttribute(ATTR_USE_SYSTEM_SARL_RUNTIME_ENVIRONMENT, Boolean.toString(true));
                return Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {
                return true;
            }
        }
    }

    @Override
    public boolean getUseProjectSREFlag(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_USE_PROJECT_SARL_RUNTIME_ENVIRONMENT, false);
        }
        catch (CoreException coreException) {
            try {
                String value = configuration.getAttribute(ATTR_USE_PROJECT_SARL_RUNTIME_ENVIRONMENT, Boolean.toString(false));
                return Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    @Override
    public String getProjectName(ILaunchConfiguration configuration) {
        try {
            return Strings.emptyToNull((String)configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getAgent(ILaunchConfiguration configuration) {
        try {
            return Strings.emptyToNull((String)configuration.getAttribute(ATTR_AGENT_NAME, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public RootContextIdentifierType getDefaultContextIdentifier(ILaunchConfiguration configuration) {
        String name;
        try {
            name = configuration.getAttribute(ATTR_ROOT_CONTEXT_ID_TYPE, null);
        }
        catch (CoreException coreException) {
            name = null;
        }
        if (Strings.isNullOrEmpty((String)name)) {
            try {
                RootContextIdentifierType type = RootContextIdentifierType.valueOf(name);
                return type;
            }
            catch (Throwable throwable) {}
        }
        return RootContextIdentifierType.DEFAULT_CONTEXT_ID;
    }

    @Override
    public String getAgentLaunchingArguments(ILaunchConfiguration configuration) {
        try {
            return Strings.nullToEmpty((String)configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getSRELaunchingArguments(ILaunchConfiguration configuration) {
        try {
            return Strings.nullToEmpty((String)configuration.getAttribute(ATTR_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getExtraSRELaunchingArguments(ILaunchConfiguration configuration, String contributorId) {
        try {
            String attrName = contributorId + ATTR_EXTRA_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS;
            return Strings.nullToEmpty((String)configuration.getAttribute(attrName, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getExtraSRELaunchingArguments(ILaunchConfiguration configuration) {
        StringBuilder builder = new StringBuilder();
        try {
            for (String key : configuration.getAttributes().keySet()) {
                String value;
                if (!key.endsWith(ATTR_EXTRA_SARL_RUNTIME_ENVIRONMENT_ARGUMENTS) || Strings.isNullOrEmpty((String)(value = Strings.nullToEmpty((String)configuration.getAttribute(key, null))))) continue;
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(value);
            }
            return builder.toString();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getJRELaunchingArguments(ILaunchConfiguration configuration) {
        try {
            return Strings.nullToEmpty((String)configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getExtraJRELaunchingArguments(ILaunchConfiguration configuration, String contributorId) {
        try {
            String attrName = contributorId + ATTR_EXTRA_VM_ARGUMENTS;
            return Strings.nullToEmpty((String)configuration.getAttribute(attrName, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getExtraJRELaunchingArguments(ILaunchConfiguration configuration) {
        StringBuilder builder = new StringBuilder();
        try {
            for (String key : configuration.getAttributes().keySet()) {
                String value;
                if (!key.endsWith(ATTR_EXTRA_VM_ARGUMENTS) || Strings.isNullOrEmpty((String)(value = Strings.nullToEmpty((String)configuration.getAttribute(key, null))))) continue;
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(value);
            }
            return builder.toString();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public boolean isEmbeddedSRE(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_EMBEDDED_SRE, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public void setEmbeddedSRE(ILaunchConfigurationWorkingCopy configuration, boolean embedded) {
        configuration.setAttribute(ATTR_EMBEDDED_SRE, embedded);
    }

    @Override
    public boolean isAssertionEnabledInDebugMode(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_ENABLE_ASSERTIONS_IN_DEBUG_MODE, true);
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    @Override
    public void setAssertionEnabledInDebugMode(ILaunchConfigurationWorkingCopy configuration, boolean enable) {
        configuration.setAttribute(ATTR_ENABLE_ASSERTIONS_IN_DEBUG_MODE, enable);
    }

    @Override
    public boolean isAssertionEnabledInRunMode(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_ENABLE_ASSERTIONS_IN_RUN_MODE, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public void setAssertionEnabledInRunMode(ILaunchConfigurationWorkingCopy configuration, boolean enable) {
        configuration.setAttribute(ATTR_ENABLE_ASSERTIONS_IN_RUN_MODE, enable);
    }

    @Override
    public String getExtraClasspathProvider(ILaunchConfiguration configuration, String contributorId) {
        try {
            String attrName = contributorId + ATTR_EXTRA_CLASSPATH_PROVIDER;
            return Strings.nullToEmpty((String)configuration.getAttribute(attrName, null));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public void setExtraClasspathProvider(ILaunchConfigurationWorkingCopy configuration, String contributorId, String classpathContainerId) {
        String attrName = contributorId + ATTR_EXTRA_CLASSPATH_PROVIDER;
        configuration.setAttribute(attrName, Strings.emptyToNull((String)classpathContainerId));
    }

    @Override
    public List<String> getExtraClasspathProviders(ILaunchConfiguration configuration) {
        ArrayList<String> identifiers = new ArrayList<String>();
        try {
            for (String key : configuration.getAttributes().keySet()) {
                String value;
                if (!key.endsWith(ATTR_EXTRA_CLASSPATH_PROVIDER) || Strings.isNullOrEmpty((String)(value = configuration.getAttribute(key, null)))) continue;
                identifiers.add(value);
            }
        }
        catch (CoreException coreException) {}
        return identifiers;
    }

    @Override
    public String getLogArgumentName(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_LOG_OPTION_NAME, null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public String getLogArgumentValue(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_LOG_OPTION_VALUE, null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public void setLogArgument(ILaunchConfigurationWorkingCopy configuration, String optionName, String optionValue) {
        String name = Strings.emptyToNull((String)optionName);
        String value = Strings.emptyToNull((String)optionValue);
        if (name == null || value == null) {
            value = null;
            name = null;
        }
        configuration.setAttribute(ATTR_LOG_OPTION_NAME, name);
        configuration.setAttribute(ATTR_LOG_OPTION_VALUE, value);
    }

    @Override
    public boolean isLaunhcingParametersPrintedOut(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(ATTR_ENABLE_LAUNCHING_PARAMETERS_PRINT_OUT, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public void setLaunchingParametersPrintedOut(ILaunchConfigurationWorkingCopy configuration, boolean enable) {
        configuration.setAttribute(ATTR_ENABLE_LAUNCHING_PARAMETERS_PRINT_OUT, enable);
    }
}

