/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.config;

import com.google.common.base.Strings;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arakhne.afc.bootique.variables.VariableNames;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class LaunchConfigurationUtils {
    private static final String DECL_PREFIX = "-D";
    private static final String DECL_INFIX = "=";

    private LaunchConfigurationUtils() {
    }

    public static String join(String ... values) {
        return LaunchConfigurationUtils.join(Arrays.asList(values));
    }

    public static String join(Iterable<String> values) {
        StringBuilder buffer = new StringBuilder();
        for (String value : values) {
            if (Strings.isNullOrEmpty((String)value)) continue;
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static OutputExtraSreArguments createOutputExtraSreArguments(String contributorId) {
        return new OutputExtraSreArguments(contributorId);
    }

    public static InputExtraSreArguments createInputExtraSreArguments(String contributorId) {
        return new InputExtraSreArguments(contributorId);
    }

    public static OutputExtraJreArguments createOutputExtraJreArguments(String contributorId) {
        return new OutputExtraJreArguments(contributorId);
    }

    public static InputExtraJreArguments createInputExtraJreArguments(String contributorId) {
        return new InputExtraJreArguments(contributorId);
    }

    public static abstract class InputExtraArguments<T extends InputExtraArguments<?>> {
        protected final Map<String, String> arguments = new HashMap<String, String>();
        private final String contributorId;

        InputExtraArguments(String contributorId) {
            this.contributorId = contributorId;
        }

        public String toString() {
            return this.arguments.toString();
        }

        public String getContributorId() {
            return this.contributorId;
        }

        public final T read(ILaunchConfiguration configuration, ILaunchConfigurationAccessor accessor) {
            this.arguments.clear();
            String args = this.readArguments(configuration, accessor);
            if (!Strings.isNullOrEmpty((String)args)) {
                Pattern pattern = Pattern.compile(Pattern.quote(LaunchConfigurationUtils.DECL_PREFIX) + "(.+?)" + Pattern.quote(LaunchConfigurationUtils.DECL_INFIX) + "([^ \n\r]*)");
                Matcher matcher = pattern.matcher(args);
                while (matcher.find()) {
                    this.arguments.put(matcher.group(1), Strings.nullToEmpty((String)matcher.group(2)));
                }
            }
            return (T)this;
        }

        protected abstract String readArguments(ILaunchConfiguration var1, ILaunchConfigurationAccessor var2);

        public String arg(String name, String defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return "";
            }
            return value;
        }

        public boolean arg(String name, boolean defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return false;
            }
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public int arg(String name, int defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public byte arg(String name, byte defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0;
            }
            try {
                return Byte.parseByte(value);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public short arg(String name, short defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0;
            }
            try {
                return Short.parseShort(value);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public long arg(String name, long defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0L;
            }
            try {
                return Long.parseLong(value);
            }
            catch (Throwable throwable) {
                return 0L;
            }
        }

        public float arg(String name, float defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0.0f;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (Throwable throwable) {
                return 0.0f;
            }
        }

        public double arg(String name, double defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return 0.0;
            }
            try {
                return Double.parseDouble(value);
            }
            catch (Throwable throwable) {
                return 0.0;
            }
        }

        public char arg(String name, char defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            String value = this.arguments.get(varName);
            if (value == null) {
                return defaultValue;
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return '\u0000';
            }
            try {
                return value.charAt(0);
            }
            catch (Throwable throwable) {
                return '\u0000';
            }
        }
    }

    public static class InputExtraJreArguments
    extends InputExtraArguments<InputExtraJreArguments> {
        InputExtraJreArguments(String contributorId) {
            super(contributorId);
        }

        @Override
        protected String readArguments(ILaunchConfiguration configuration, ILaunchConfigurationAccessor accessor) {
            return accessor.getExtraJRELaunchingArguments(configuration, this.getContributorId());
        }
    }

    public static class InputExtraSreArguments
    extends InputExtraArguments<InputExtraSreArguments> {
        InputExtraSreArguments(String contributorId) {
            super(contributorId);
        }

        @Override
        protected String readArguments(ILaunchConfiguration configuration, ILaunchConfigurationAccessor accessor) {
            return accessor.getExtraSRELaunchingArguments(configuration, this.getContributorId());
        }
    }

    public static abstract class OutputExtraArguments<T extends OutputExtraArguments<?>> {
        protected final Map<String, String> argumentsToSet = new HashMap<String, String>();
        private final String contributorId;

        OutputExtraArguments(String contributorId) {
            this.contributorId = contributorId;
        }

        public String toString() {
            return this.argumentsToSet.toString();
        }

        public String getContributorId() {
            return this.contributorId;
        }

        public T resetArg(String name) {
            String varName = VariableNames.toPropertyName((String)name);
            this.argumentsToSet.remove(varName);
            return (T)this;
        }

        public T arg(String name, String value, String defaultValue) {
            String varName = VariableNames.toPropertyName((String)name);
            if (Strings.isNullOrEmpty((String)value) || value.equals(defaultValue)) {
                this.argumentsToSet.remove(varName);
            } else {
                String arg = LaunchConfigurationUtils.DECL_PREFIX + varName + LaunchConfigurationUtils.DECL_INFIX + value;
                this.argumentsToSet.put(varName, arg);
            }
            return (T)this;
        }

        public T arg(String name, boolean value, boolean defaultValue) {
            return this.arg(name, Boolean.toString(value), Boolean.toString(defaultValue));
        }

        public T arg(String name, int value, int defaultValue) {
            return this.arg(name, Integer.toString(value), Integer.toString(defaultValue));
        }

        public T arg(String name, float value, float defaultValue) {
            return this.arg(name, Float.toString(value), Float.toString(defaultValue));
        }

        public T arg(String name, double value, double defaultValue) {
            return this.arg(name, Double.toString(value), Double.toString(defaultValue));
        }

        public T arg(String name, long value, long defaultValue) {
            return this.arg(name, Long.toString(value), Long.toString(defaultValue));
        }

        public T arg(String name, byte value, byte defaultValue) {
            return this.arg(name, Byte.toString(value), Byte.toString(defaultValue));
        }

        public T arg(String name, short value, short defaultValue) {
            return this.arg(name, Short.toString(value), Short.toString(defaultValue));
        }

        public T arg(String name, char value, char defaultValue) {
            return this.arg(name, Character.toString(value), Character.toString(defaultValue));
        }

        public final T apply(ILaunchConfigurationWorkingCopy configuration, ILaunchConfigurationConfigurator configurator) {
            this.writeArguments(configuration, configurator);
            this.argumentsToSet.clear();
            return (T)this;
        }

        protected abstract void writeArguments(ILaunchConfigurationWorkingCopy var1, ILaunchConfigurationConfigurator var2);
    }

    public static class OutputExtraJreArguments
    extends OutputExtraArguments<OutputExtraJreArguments> {
        OutputExtraJreArguments(String contributorId) {
            super(contributorId);
        }

        @Override
        protected void writeArguments(ILaunchConfigurationWorkingCopy configuration, ILaunchConfigurationConfigurator configurator) {
            String args = LaunchConfigurationUtils.join(this.argumentsToSet.values());
            configurator.setExtraJRELaunchingArguments(configuration, this.getContributorId(), args);
        }
    }

    public static class OutputExtraSreArguments
    extends OutputExtraArguments<OutputExtraSreArguments> {
        OutputExtraSreArguments(String contributorId) {
            super(contributorId);
        }

        @Override
        protected void writeArguments(ILaunchConfigurationWorkingCopy configuration, ILaunchConfigurationConfigurator configurator) {
            String args = LaunchConfigurationUtils.join(this.argumentsToSet.values());
            configurator.setExtraSRELaunchingArguments(configuration, this.getContributorId(), args);
        }
    }
}

