/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.dialog;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.apputils.eclipseextensions.launching.ISarlLaunchConfigurationPanelFactory;
import io.sarl.apputils.eclipseextensions.launching.ISarlRuntimeEnvironmentTab;
import io.sarl.apputils.eclipseextensions.launching.ISreChangeListener;
import io.sarl.apputils.eclipseextensions.launching.SarlLaunchConfigurationPanels;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaDependenciesTab;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.xbase.lib.Functions;

public abstract class AbstractSARLLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    @Inject
    private Injector injector;

    protected void setTabs(ILaunchConfigurationTab ... tabs) {
        if (this.injector != null) {
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                this.injector.injectMembers((Object)tab);
                ++n2;
            }
        }
        super.setTabs(tabs);
    }

    protected ILaunchConfigurationTab[] buildTabList(ILaunchConfigurationDialog dialog, String mode, Functions.Function1<List<ILaunchConfigurationTab>, Boolean> builder) {
        assert (builder != null);
        ArrayList<Object> list = new ArrayList<Object>();
        Boolean addStandardPanels = (Boolean)builder.apply(list);
        ISarlRuntimeEnvironmentTab runtimeTab = null;
        for (ILaunchConfigurationTab iLaunchConfigurationTab : list) {
            ISarlRuntimeEnvironmentTab cvalue;
            if (!(iLaunchConfigurationTab instanceof ISarlRuntimeEnvironmentTab)) continue;
            runtimeTab = cvalue = (ISarlRuntimeEnvironmentTab)iLaunchConfigurationTab;
            break;
        }
        List list2 = SarlLaunchConfigurationPanels.getPanelFactoriesFromExtension();
        for (ISarlLaunchConfigurationPanelFactory factory : list2) {
            ILaunchConfigurationTab panel;
            if (!factory.canCreatePanel(dialog, mode, list, runtimeTab) || (panel = factory.newLaunchConfigurationPanel(dialog, mode, list, runtimeTab)) == null) continue;
            list.add(panel);
            if (!(panel instanceof ISreChangeListener)) continue;
            ISreChangeListener cvalue = (ISreChangeListener)panel;
            if (runtimeTab == null) continue;
            runtimeTab.addSreChangeListener(cvalue);
        }
        if (addStandardPanels == null || addStandardPanels.booleanValue()) {
            list.add(AbstractSARLLaunchConfigurationTabGroup.getClasspathTab(dialog));
            list.add(new SourceLookupTab());
            list.add(new EnvironmentTab());
            list.add(new CommonTab());
        }
        ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[list.size()];
        list.toArray(array);
        return array;
    }

    protected static void addSreChangeListeners(List<ILaunchConfigurationTab> listOfTabs, ISreChangeListener ... listeners) {
        if (listOfTabs != null && listeners != null) {
            for (ILaunchConfigurationTab tab : listOfTabs) {
                ISarlRuntimeEnvironmentTab cvalue;
                if (!(tab instanceof ISarlRuntimeEnvironmentTab)) continue;
                ISarlRuntimeEnvironmentTab runtimeTab = cvalue = (ISarlRuntimeEnvironmentTab)tab;
                ISreChangeListener[] iSreChangeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ISreChangeListener listener = iSreChangeListenerArray[n2];
                    runtimeTab.addSreChangeListener(listener);
                    ++n2;
                }
            }
        }
    }

    protected static JavaClasspathTab getClasspathTab(ILaunchConfigurationDialog dialog) {
        ILaunchConfiguration configuration;
        Object input;
        LaunchConfigurationsDialog cvalue;
        LaunchConfigurationTabGroupViewer tabViewer;
        JavaClasspathTab tab = null;
        if (dialog instanceof LaunchConfigurationsDialog && (tabViewer = (cvalue = (LaunchConfigurationsDialog)dialog).getTabViewer()) != null && (input = tabViewer.getInput()) instanceof ILaunchConfiguration && JavaRuntime.isModularConfiguration((ILaunchConfiguration)(configuration = (ILaunchConfiguration)input))) {
            tab = new JavaDependenciesTab();
        }
        if (tab == null) {
            tab = new JavaClasspathTab();
        }
        return tab;
    }
}

