/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.dialog;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.apputils.eclipseextensions.launching.ISreChangeListener;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.launching.config.RootContextIdentifierType;
import io.sarl.eclipse.launching.dialog.Messages;
import io.sarl.lang.core.util.CliUtilities;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaMainTab;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SARLAgentMainLaunchConfigurationTab
extends AbstractJavaMainTab
implements ISreChangeListener {
    private volatile SoftReference<Image> image;
    private volatile String lastAgentNameError;
    private Text agentNameTextField;
    private Button agentNameSearchButton;
    private Button runInEclipseButton;
    private Button enableAssertionsInDebugModeButton;
    private Button enableAssertionsInRunModeButton;
    private Button defaultContextIdentifierButton;
    private Button randomContextIdentifierButton;
    private Button bootContextIdentifierButton;
    private Label logLevelLabel;
    private Combo logLevelCombo;
    private Button logShowStartInformationButton;
    private final WidgetListener defaultListener = new WidgetListener();
    @Inject
    private ILaunchConfigurationConfigurator configurator;
    @Inject
    private ILaunchConfigurationAccessor accessor;

    public void sreChanged(ISREInstall sre) {
        String opt;
        Map options;
        Map map = options = sre == null ? Collections.emptyMap() : sre.getAvailableCommandLineOptions();
        assert (options != null);
        String noOpt = CliUtilities.getCommandLineLastOptionPrefix();
        if (this.logLevelCombo != null && this.logLevelLabel != null) {
            int index;
            String[] logOptValues;
            String logOpt = options.getOrDefault("CLI-Log", noOpt);
            boolean enable = !Objects.equals(noOpt, logOpt);
            String logOptValuesStr = options.getOrDefault("CLI-Log-Values", null);
            if (Strings.isNullOrEmpty((String)logOptValuesStr)) {
                logOptValues = new String[]{};
                enable = false;
            } else {
                logOptValues = logOptValuesStr.trim().split("\\s*,\\s*");
            }
            ILaunchConfiguration currentConfig = this.getCurrentLaunchConfiguration();
            if (currentConfig != null) {
                String current = this.accessor.getLogArgumentValue(currentConfig);
                index = Arrays.asList(logOptValues).indexOf(current);
            } else {
                index = this.logLevelCombo.getSelectionIndex();
                if (index >= 0 && index < this.logLevelCombo.getItemCount()) {
                    String selectedValue = this.logLevelCombo.getItem(index);
                    index = Arrays.asList(logOptValues).indexOf(selectedValue);
                }
            }
            String logOptStr = CliUtilities.getUnixCommandLineOption((String)logOpt, (String)Messages.MainLaunchConfigurationTab_16);
            this.logLevelLabel.setText(MessageFormat.format(Messages.MainLaunchConfigurationTab_15, logOptStr));
            this.logLevelLabel.setData((Object)logOpt);
            this.logLevelCombo.setItems(logOptValues);
            if (index >= 0 && index < this.logLevelCombo.getItemCount()) {
                this.logLevelCombo.select(index);
            } else if (this.logLevelCombo.getItemCount() > 0) {
                String defaultValue = options.getOrDefault("CLI-Log-Default-Value", "");
                index = Arrays.asList(logOptValues).indexOf(defaultValue);
                if (index >= 0 && index < this.logLevelCombo.getItemCount()) {
                    this.logLevelCombo.select(index);
                } else {
                    this.logLevelCombo.select(0);
                }
            }
            this.logLevelLabel.setEnabled(enable);
            this.logLevelCombo.setEnabled(enable);
        }
        if (this.defaultContextIdentifierButton != null) {
            opt = options.getOrDefault("CLI-Default-Context-ID", noOpt);
            this.defaultContextIdentifierButton.setText(MessageFormat.format(Messages.MainLaunchConfigurationTab_11, opt));
            this.defaultContextIdentifierButton.requestLayout();
            this.defaultContextIdentifierButton.setEnabled(!Objects.equals(opt, noOpt));
        }
        if (this.randomContextIdentifierButton != null) {
            opt = options.getOrDefault("CLI-Random-Context-ID", noOpt);
            this.randomContextIdentifierButton.setText(MessageFormat.format(Messages.MainLaunchConfigurationTab_12, opt));
            this.randomContextIdentifierButton.requestLayout();
            this.randomContextIdentifierButton.setEnabled(!Objects.equals(opt, noOpt));
        }
        if (this.bootContextIdentifierButton != null) {
            opt = options.getOrDefault("CLI-BootAgent-Context-ID", noOpt);
            this.bootContextIdentifierButton.setText(MessageFormat.format(Messages.MainLaunchConfigurationTab_13, opt));
            this.bootContextIdentifierButton.requestLayout();
            this.bootContextIdentifierButton.setEnabled(!Objects.equals(opt, noOpt));
        }
    }

    public Image getImage() {
        Image img;
        Image image = img = this.image == null ? null : this.image.get();
        if (img == null) {
            img = SARLEclipsePlugin.getDefault().getImage("icons/sarl_16.png");
            this.image = new SoftReference<Image>(img);
        }
        return img;
    }

    public String getId() {
        return "io.sarl.eclipse.debug.ui.sarlMainTab";
    }

    public String getName() {
        return Messages.MainLaunchConfigurationTab_7;
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createAgentNameEditor(comp, Messages.MainLaunchConfigurationTab_0);
        this.createVerticalSpacer(comp, 1);
        this.createContextIdentifierTypeEditor(comp, Messages.MainLaunchConfigurationTab_9);
        this.createVerticalSpacer(comp, 1);
        this.createLaunchOptionEditor(comp, Messages.MainLaunchConfigurationTab_10);
        this.setControl((Control)comp);
        this.sreChanged(null);
    }

    protected void createAgentNameEditor(Composite parent, String text) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)text, (int)2, (int)1, (int)768);
        this.agentNameTextField = SWTFactory.createSingleText((Composite)group, (int)1);
        this.agentNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SARLAgentMainLaunchConfigurationTab.this.lastAgentNameError = null;
                SARLAgentMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        ControlAccessibleListener.addListener((Control)this.agentNameTextField, (String)group.getText());
        this.agentNameSearchButton = this.createPushButton((Composite)group, Messages.MainLaunchConfigurationTab_1, null);
        this.agentNameSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                SARLAgentMainLaunchConfigurationTab.this.handleAgentNameSearchButtonSelected();
            }
        });
    }

    protected void createContextIdentifierTypeEditor(Composite parent, String text) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)text, (int)1, (int)1, (int)768);
        String noOpt = CliUtilities.getCommandLineLastOptionPrefix();
        this.defaultContextIdentifierButton = this.createRadioButton((Composite)group, MessageFormat.format(Messages.MainLaunchConfigurationTab_11, noOpt));
        this.defaultContextIdentifierButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.randomContextIdentifierButton = this.createRadioButton((Composite)group, MessageFormat.format(Messages.MainLaunchConfigurationTab_12, noOpt));
        this.randomContextIdentifierButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.bootContextIdentifierButton = this.createRadioButton((Composite)group, MessageFormat.format(Messages.MainLaunchConfigurationTab_13, noOpt));
        this.bootContextIdentifierButton.addSelectionListener((SelectionListener)this.defaultListener);
    }

    protected RootContextIdentifierType getSelectedContextIdentifierType() {
        if (this.randomContextIdentifierButton.getSelection()) {
            return RootContextIdentifierType.RANDOM_CONTEXT_ID;
        }
        if (this.bootContextIdentifierButton.getSelection()) {
            return RootContextIdentifierType.BOOT_AGENT_CONTEXT_ID;
        }
        return RootContextIdentifierType.DEFAULT_CONTEXT_ID;
    }

    protected void createLaunchOptionEditor(Composite parent, String text) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)text, (int)2, (int)1, (int)768);
        String noOpt = CliUtilities.getCommandLineLastOptionPrefix();
        this.logLevelLabel = SWTFactory.createLabel((Composite)group, (String)MessageFormat.format(Messages.MainLaunchConfigurationTab_15, noOpt), (int)1);
        this.logLevelCombo = SWTFactory.createCombo((Composite)group, (int)8, (int)1, (String[])new String[0]);
        this.logLevelCombo.addSelectionListener((SelectionListener)this.defaultListener);
        this.createVerticalSpacer((Composite)group, 2);
        this.enableAssertionsInRunModeButton = SWTFactory.createCheckButton((Composite)group, (String)Messages.SARLMainLaunchConfigurationTab_2, null, (boolean)false, (int)2);
        this.enableAssertionsInRunModeButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.enableAssertionsInDebugModeButton = SWTFactory.createCheckButton((Composite)group, (String)Messages.SARLMainLaunchConfigurationTab_1, null, (boolean)false, (int)2);
        this.enableAssertionsInDebugModeButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.createVerticalSpacer((Composite)group, 2);
        this.runInEclipseButton = SWTFactory.createCheckButton((Composite)group, (String)MessageFormat.format(Messages.SARLMainLaunchConfigurationTab_0, Messages.SARLMainLaunchConfigurationTab_5), null, (boolean)false, (int)2);
        this.runInEclipseButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.logShowStartInformationButton = SWTFactory.createCheckButton((Composite)group, (String)Messages.SARLMainLaunchConfigurationTab_3, null, (boolean)false, (int)2);
        this.logShowStartInformationButton.addSelectionListener((SelectionListener)this.defaultListener);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAgentNameFromConfig(config);
        this.updateContextIdentifierTypeFromConfig(config);
        this.updateLaunchOptionsFromConfig(config);
    }

    protected void updateContextIdentifierTypeFromConfig(ILaunchConfiguration config) {
        RootContextIdentifierType type = this.accessor.getDefaultContextIdentifier(config);
        assert (type != null);
        switch (type) {
            case RANDOM_CONTEXT_ID: {
                this.randomContextIdentifierButton.setSelection(true);
                break;
            }
            case BOOT_AGENT_CONTEXT_ID: {
                this.bootContextIdentifierButton.setSelection(true);
                break;
            }
            default: {
                this.defaultContextIdentifierButton.setSelection(true);
            }
        }
    }

    protected void updateLaunchOptionsFromConfig(ILaunchConfiguration config) {
        String logOptValue = this.accessor.getLogArgumentValue(config);
        boolean showLaunchingParameters = this.accessor.isLaunhcingParametersPrintedOut(config);
        boolean runInEclipse = this.accessor.isEmbeddedSRE(config);
        boolean enableAssertionsRun = this.accessor.isAssertionEnabledInRunMode(config);
        boolean enableAssertionsDebug = this.accessor.isAssertionEnabledInDebugMode(config);
        int index = Arrays.asList(this.logLevelCombo.getItems()).indexOf(logOptValue);
        if (index >= 0 && index < this.logLevelCombo.getItemCount()) {
            this.logLevelCombo.select(index);
        }
        this.logShowStartInformationButton.setSelection(showLaunchingParameters);
        this.enableAssertionsInRunModeButton.setSelection(enableAssertionsRun);
        this.enableAssertionsInDebugModeButton.setSelection(enableAssertionsDebug);
        this.runInEclipseButton.setSelection(runInEclipse);
    }

    protected void updateAgentNameFromConfig(ILaunchConfiguration config) {
        String agentName = this.accessor.getAgent(config);
        this.agentNameTextField.setText(Strings.nullToEmpty((String)agentName));
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.isValidProjectName() && this.isValidAgentName() && this.isValidContextIdentifierType() && this.isValidLaunchOptions();
    }

    protected boolean isValidContextIdentifierType() {
        return true;
    }

    protected boolean isValidLaunchOptions() {
        return true;
    }

    protected boolean isValidAgentName() {
        if (this.lastAgentNameError != null) {
            boolean isValid = Strings.isNullOrEmpty((String)this.lastAgentNameError);
            if (!isValid) {
                this.setErrorMessage(this.lastAgentNameError);
            }
            return isValid;
        }
        String name = this.agentNameTextField.getText();
        if (Strings.isNullOrEmpty((String)name)) {
            this.lastAgentNameError = Messages.MainLaunchConfigurationTab_2;
            this.setErrorMessage(this.lastAgentNameError);
            return false;
        }
        if (!this.isAgentNameDefined(name)) {
            this.lastAgentNameError = MessageFormat.format(Messages.MainLaunchConfigurationTab_8, name);
            this.setErrorMessage(this.lastAgentNameError);
            return false;
        }
        this.lastAgentNameError = "";
        return true;
    }

    protected boolean isValidProjectName() {
        String name = this.fProjText.getText();
        if (Strings.isNullOrEmpty((String)name)) {
            this.setErrorMessage(Messages.MainLaunchConfigurationTab_3);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(name, 4);
        if (status.isOK()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.exists()) {
                this.setErrorMessage(MessageFormat.format(Messages.MainLaunchConfigurationTab_4, name));
                return false;
            }
            if (!project.isOpen()) {
                this.setErrorMessage(MessageFormat.format(Messages.MainLaunchConfigurationTab_5, name));
                return false;
            }
        } else {
            this.setErrorMessage(MessageFormat.format(Messages.MainLaunchConfigurationTab_6, status.getMessage()));
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.configurator.setProjectName(config, Strings.emptyToNull((String)this.fProjText.getText().trim()));
        this.configurator.setAgent(config, Strings.emptyToNull((String)this.agentNameTextField.getText().trim()));
        this.configurator.setDefaultContextIdentifier(config, this.getSelectedContextIdentifierType());
        Object optObj = this.logLevelLabel.getData();
        String opt = optObj == null ? null : Strings.emptyToNull((String)optObj.toString());
        int index = this.logLevelCombo.getSelectionIndex();
        String optValue = index >= 0 && index < this.logLevelCombo.getItemCount() ? this.logLevelCombo.getItem(index) : null;
        this.configurator.setLogArgument(config, opt, optValue);
        this.configurator.setLaunchingParametersPrintedOut(config, this.logShowStartInformationButton.getSelection());
        this.configurator.setAssertionEnabledInRunMode(config, this.enableAssertionsInRunModeButton.getSelection());
        this.configurator.setAssertionEnabledInDebugMode(config, this.enableAssertionsInDebugModeButton.getSelection());
        this.configurator.setEmbeddedSRE(config, this.runInEclipseButton.getSelection());
        this.mapResources(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.removeAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME);
        }
        this.initializeAgentName(javaElement, config);
        this.initializeContextIdentifierType(config);
        this.initializeLaunchOptions(config);
    }

    protected void initializeContextIdentifierType(ILaunchConfigurationWorkingCopy config) {
        this.configurator.setDefaultContextIdentifier(config, null);
    }

    protected void initializeLaunchOptions(ILaunchConfigurationWorkingCopy config) {
        this.configurator.setLogArgument(config, null, null);
    }

    private String extractNameFromJavaElement(final IJavaElement javaElement) {
        String name = null;
        if (javaElement != null) {
            final String[] nameRef = new String[1];
            try {
                this.getLaunchConfigurationDialog().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            IJavaProject javaProject = javaElement.getJavaProject();
                            IType agentType = javaProject.findType("io.sarl.lang.core.Agent");
                            IType[] types = agentType.newTypeHierarchy(pm).getAllSubtypes(agentType);
                            if (types != null && types.length > 0) {
                                nameRef[0] = types[0].getFullyQualifiedName();
                            }
                        }
                        catch (JavaModelException e) {
                            SARLAgentMainLaunchConfigurationTab.this.setErrorMessage(e.getLocalizedMessage());
                            JDIDebugUIPlugin.log((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setErrorMessage(e.getLocalizedMessage());
                JDIDebugUIPlugin.log((Throwable)e);
            }
            name = nameRef[0];
        }
        return Strings.nullToEmpty(name);
    }

    protected void initializeAgentName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = this.extractNameFromJavaElement(javaElement);
        this.configurator.setAgent(config, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    private IType[] searchAgentNames() {
        final IType[][] res = new IType[][]{new IType[0]};
        final String projectName = this.fProjText.getText();
        IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (status.isOK()) {
            try {
                this.getLaunchConfigurationDialog().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IType agentType = javaProject.findType("io.sarl.lang.core.Agent");
                            res[0] = agentType.newTypeHierarchy(pm).getAllSubtypes(agentType);
                        }
                        catch (JavaModelException e) {
                            SARLAgentMainLaunchConfigurationTab.this.setErrorMessage(e.getLocalizedMessage());
                            JDIDebugUIPlugin.log((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setErrorMessage(e.getLocalizedMessage());
                JDIDebugUIPlugin.log((Throwable)e);
            }
        }
        return res[0];
    }

    private boolean isAgentNameDefined(final String agentName) {
        final String projectName = this.fProjText.getText();
        IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (status.isOK()) {
            try {
                final boolean[] res = new boolean[1];
                this.getLaunchConfigurationDialog().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            IType type;
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IType agentType = javaProject.findType("io.sarl.lang.core.Agent");
                            if (agentType != null && (type = javaProject.findType(agentName)) != null) {
                                res[0] = type.newSupertypeHierarchy(pm).contains(agentType);
                            }
                        }
                        catch (JavaModelException e) {
                            SARLAgentMainLaunchConfigurationTab.this.setErrorMessage(e.getLocalizedMessage());
                            JDIDebugUIPlugin.log((Throwable)e);
                        }
                    }
                });
                return res[0];
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected void handleAgentNameSearchButtonSelected() {
        IType[] types = this.searchAgentNames();
        DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(this.getShell(), types, "");
        if (mmsd.open() == 1) {
            return;
        }
        IType type = (IType)mmsd.getFirstResult();
        if (type != null) {
            this.agentNameTextField.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    private class WidgetListener
    implements SelectionListener {
        WidgetListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            SARLAgentMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

