/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.dialog;

import com.google.inject.Inject;
import io.sarl.apputils.eclipseextensions.launching.ISreChangeListener;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.launching.dialog.Messages;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class SARLApplicationMainLaunchConfigurationTab
extends JavaMainTab
implements ISreChangeListener {
    private volatile SoftReference<Image> image;
    private Button runInEclipseButton;
    private Button logShowStartInformationButton;
    private Button enableAssertionsInDebugModeButton;
    private Button enableAssertionsInRunModeButton;
    private final WidgetListener defaultListener = new WidgetListener();
    @Inject
    private ILaunchConfigurationConfigurator configurator;
    @Inject
    private ILaunchConfigurationAccessor accessor;

    public void sreChanged(ISREInstall sre) {
    }

    public Image getImage() {
        Image img;
        Image image = img = this.image == null ? null : this.image.get();
        if (img == null) {
            img = SARLEclipsePlugin.getDefault().getImage("icons/sarl_application_16.png");
            this.image = new SoftReference<Image>(img);
        }
        return img;
    }

    public String getId() {
        return "io.sarl.eclipse.debug.ui.sarlApplicationMainTab";
    }

    public String getName() {
        return Messages.MainLaunchConfigurationTab_7;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp, LauncherMessages.JavaMainTab_Main_cla_ss__4);
        this.createVerticalSpacer(comp, 1);
        this.createLaunchOptionEditor(comp, Messages.MainLaunchConfigurationTab_10);
        this.setControl((Control)comp);
    }

    protected void createLaunchOptionEditor(Composite parent, String text) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)text, (int)1, (int)1, (int)768);
        this.enableAssertionsInRunModeButton = this.createCheckButton((Composite)group, Messages.SARLMainLaunchConfigurationTab_2);
        this.enableAssertionsInRunModeButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.enableAssertionsInDebugModeButton = this.createCheckButton((Composite)group, Messages.SARLMainLaunchConfigurationTab_1);
        this.enableAssertionsInDebugModeButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.createVerticalSpacer((Composite)group, 1);
        this.runInEclipseButton = this.createCheckButton((Composite)group, MessageFormat.format(Messages.SARLMainLaunchConfigurationTab_0, Messages.SARLMainLaunchConfigurationTab_4));
        this.runInEclipseButton.addSelectionListener((SelectionListener)this.defaultListener);
        this.logShowStartInformationButton = SWTFactory.createCheckButton((Composite)group, (String)Messages.SARLMainLaunchConfigurationTab_3, null, (boolean)false, (int)2);
        this.logShowStartInformationButton.addSelectionListener((SelectionListener)this.defaultListener);
    }

    protected void updateLaunchOptionsFromConfig(ILaunchConfiguration config) {
        boolean runInEclipse = this.accessor.isEmbeddedSRE(config);
        boolean showLaunchingParameters = this.accessor.isLaunhcingParametersPrintedOut(config);
        boolean enableAssertionsRun = this.accessor.isAssertionEnabledInRunMode(config);
        boolean enableAssertionsDebug = this.accessor.isAssertionEnabledInDebugMode(config);
        this.logShowStartInformationButton.setSelection(showLaunchingParameters);
        this.enableAssertionsInRunModeButton.setSelection(enableAssertionsRun);
        this.enableAssertionsInDebugModeButton.setSelection(enableAssertionsDebug);
        this.runInEclipseButton.setSelection(runInEclipse);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateLaunchOptionsFromConfig(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.configurator.setLaunchingParametersPrintedOut(config, this.logShowStartInformationButton.getSelection());
        this.configurator.setAssertionEnabledInRunMode(config, this.enableAssertionsInRunModeButton.getSelection());
        this.configurator.setAssertionEnabledInDebugMode(config, this.enableAssertionsInDebugModeButton.getSelection());
        this.configurator.setEmbeddedSRE(config, this.runInEclipseButton.getSelection());
        super.performApply(config);
    }

    private class WidgetListener
    implements SelectionListener {
        WidgetListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            SARLApplicationMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

