/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.dialog;

import com.google.inject.Inject;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.launching.dialog.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SARLArgumentsTab
extends JavaArgumentsTab {
    private static final int HEIGHT_HINT = 40;
    private static final int WIDTH_HINT = 100;
    protected Text sreArgumentsText;
    @Inject
    private ILaunchConfigurationConfigurator configurator;
    @Inject
    private ILaunchConfigurationAccessor accessor;

    public String getId() {
        return "io.sarl.eclipse.debug.ui.sarlArgumentsTab";
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Group group = (Group)this.fPrgmArgumentsText.getParent();
        group.setText(Messages.SARLArgumentsTab_0);
        ControlAccessibleListener.addListener((Control)this.fPrgmArgumentsText, (String)group.getText());
        this.createSREArgsBlock(group.getParent(), parent.getFont());
    }

    protected void createSREArgsBlock(Composite parent, Font font) {
        Group group = new Group(parent, 0);
        group.setFont(font);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.moveAbove(this.fVMArgumentsBlock.getControl());
        group.setText(Messages.SARLArgumentsTab_1);
        this.createSREArgsText(group, font);
        this.createSREArgsVariableButton(group);
    }

    private void createSREArgsText(Group group, Font font) {
        this.sreArgumentsText = new Text((Composite)group, 2626);
        this.sreArgumentsText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        if ((SARLArgumentsTab.this.sreArgumentsText.getStyle() & 4) != 0) {
                            event.doit = true;
                            break;
                        }
                        if (SARLArgumentsTab.this.sreArgumentsText.isEnabled() && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                        event.doit = true;
                    }
                }
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.sreArgumentsText.setLayoutData((Object)gd);
        this.sreArgumentsText.setFont(font);
        this.sreArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SARLArgumentsTab.this.scheduleUpdateJob();
            }
        });
        ControlAccessibleListener.addListener((Control)this.sreArgumentsText, (String)group.getText());
    }

    private void createSREArgsVariableButton(Group group) {
        Button sreArgVariableButton = this.createPushButton((Composite)group, "", null);
        sreArgVariableButton.setLayoutData((Object)new GridData(128));
        sreArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(SARLArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    SARLArgumentsTab.this.sreArgumentsText.insert(variable);
                }
            }
        });
    }

    protected VMArgumentsBlock createVMArgsBlock() {
        return new JVMArgsBlock();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        this.configurator.setSRELaunchingArguments(config, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.sreArgumentsText.setText(this.accessor.getSRELaunchingArguments(configuration));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.configurator.setSRELaunchingArguments(configuration, this.getAttributeValueFrom(this.sreArgumentsText));
        super.performApply(configuration);
    }

    private static class JVMArgsBlock
    extends VMArgumentsBlock {
        JVMArgsBlock() {
        }

        public String getName() {
            return Messages.SARLArgumentsTab_2;
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            Group group = (Group)this.fVMArgumentsText.getParent();
            group.setText(Messages.SARLArgumentsTab_3);
            ControlAccessibleListener.addListener((Control)this.fVMArgumentsText, (String)group.getText());
            SWTFactory.createLabel((Composite)group, (String)Messages.SARLArgumentsTab_5, (int)0);
        }
    }
}

