/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.dialog;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.apputils.eclipseextensions.launching.ISarlRuntimeEnvironmentTab;
import io.sarl.apputils.eclipseextensions.launching.ISreChangeListener;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProviderFactories;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.launching.dialog.Messages;
import io.sarl.eclipse.launching.sreproviding.EclipseIDEProjectSREProviderFactory;
import io.sarl.eclipse.runtime.ProjectProvider;
import io.sarl.eclipse.runtime.SARLRuntime;
import io.sarl.eclipse.runtime.SREConfigurationBlock;
import io.sarl.lang.util.Utils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SARLRuntimeEnvironmentTab
extends JavaJRETab
implements ISarlRuntimeEnvironmentTab {
    private final boolean resetJvaMainClass;
    private SREConfigurationBlock sreBlock;
    private IPropertyChangeListener listener;
    @Inject
    private ILaunchConfigurationConfigurator configurator;
    @Inject
    private ILaunchConfigurationAccessor accessor;
    private final ListenerList<ISreChangeListener> sreChangeListeners = new ListenerList();

    public SARLRuntimeEnvironmentTab(boolean resetJavaMainClass) {
        this.resetJvaMainClass = resetJavaMainClass;
    }

    public String getName() {
        return Messages.RuntimeEnvironmentTab_0;
    }

    public String getId() {
        return "io.sarl.eclipse.debug.ui.sarlRuntimeEnvironmentTab";
    }

    public void createControl(Composite parent) {
        Control[] children;
        super.createControl(parent);
        ProjectAdapter projectProvider = new ProjectAdapter();
        List sreProviderFactories = ProjectSREProviderFactories.getSREProviderFactoriesFromExtension();
        sreProviderFactories.add(new EclipseIDEProjectSREProviderFactory());
        this.sreBlock = new SREConfigurationBlock(true, projectProvider, sreProviderFactories);
        SREConfigurationBlock blk = this.getSREConfigurationBlock();
        blk.createControl(parent);
        Composite oldComp = (Composite)this.getControl();
        Control[] controlArray = children = oldComp.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctl = controlArray[n2];
            ctl.setParent(blk.getControl());
            ++n2;
        }
        this.setControl((Control)blk.getControl());
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SARLRuntimeEnvironmentTab.this.updateLaunchConfigurationDialog();
                SARLRuntimeEnvironmentTab.this.fireSreChange((ISREInstall)event.getNewValue());
            }
        };
        blk.addPropertyChangeListener(this.listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    public void fireSreChange(ISREInstall sre) {
        Object[] listeners = this.sreChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISreChangeListener listener = (ISreChangeListener)listeners[i];
            listener.sreChanged(sre);
            ++i;
        }
    }

    public void addSreChangeListener(ISreChangeListener listener) {
        this.sreChangeListeners.add((Object)listener);
    }

    public void removeSreChangeListener(ISreChangeListener listener) {
        this.sreChangeListeners.remove((Object)listener);
    }

    public SREConfigurationBlock getSREConfigurationBlock() {
        return this.sreBlock;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.getSREConfigurationBlock().updateEnableState();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.getSREConfigurationBlock().initialize();
        this.selectSREFromConfig(configuration);
    }

    protected void selectSREFromConfig(ILaunchConfiguration config) {
        boolean changed;
        SREConfigurationBlock blk = this.getSREConfigurationBlock();
        boolean notify = blk.getNotify();
        try {
            blk.setNotify(false);
            if (this.accessor.getUseSystemSREFlag(config)) {
                changed = blk.selectSystemWideSRE();
            } else if (this.accessor.getUseProjectSREFlag(config)) {
                changed = blk.selectProjectSRE();
            } else {
                String sreId = this.accessor.getSREId(config);
                ISREInstall sre = SARLRuntime.getSREFromId(Strings.nullToEmpty((String)sreId));
                changed = blk.selectSpecificSRE(sre);
            }
        }
        finally {
            blk.setNotify(notify);
        }
        if (changed) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public void dispose() {
        super.dispose();
        SREConfigurationBlock blk = this.getSREConfigurationBlock();
        if (this.listener != null) {
            if (blk != null) {
                blk.removePropertyChangeListener(this.listener);
            }
            this.listener = null;
        }
        if (blk != null) {
            blk.dispose();
        }
        this.sreChangeListeners.clear();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        this.getSREConfigurationBlock().updateExternalSREButtonLabels();
        this.selectSREFromConfig((ILaunchConfiguration)workingCopy);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String id = this.accessor.getSREId(config);
        SREConfigurationBlock blk = this.getSREConfigurationBlock();
        ISREInstall sre = SARLRuntime.getSREFromId(id);
        if (sre == null) {
            sre = blk.getSelectedSRE();
        }
        IStatus status = sre == null ? (Strings.isNullOrEmpty((String)id) ? SARLEclipsePlugin.getDefault().createStatus(4, Messages.RuntimeEnvironmentTab_7) : SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(Messages.RuntimeEnvironmentTab_6, Strings.nullToEmpty((String)id)))) : blk.validate(sre);
        if (status.isOK()) {
            return super.isValid(config) && this.isValidJREVersion(config);
        }
        this.setErrorMessage(status.getMessage());
        Throwable throwable = status.getException();
        if (throwable != null) {
            JDIDebugUIPlugin.log((Throwable)throwable);
        }
        return false;
    }

    protected boolean isValidJREVersion(ILaunchConfiguration config) {
        IVMInstall install = this.fJREBlock.getJRE();
        if (install instanceof IVMInstall2) {
            IVMInstall2 cvalue = (IVMInstall2)install;
            String version = cvalue.getJavaVersion();
            if (version == null) {
                this.setErrorMessage(MessageFormat.format(Messages.RuntimeEnvironmentTab_3, install.getName()));
                return false;
            }
            if (!Utils.isCompatibleJDKVersionWhenInSARLProjectClasspath((String)version)) {
                this.setErrorMessage(MessageFormat.format(Messages.RuntimeEnvironmentTab_4, install.getName(), version, "21", "27"));
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        SREConfigurationBlock blk = this.getSREConfigurationBlock();
        ISREInstall sre = blk.getSelectedSRE();
        this.configurator.setRuntimeConfiguration(configuration, sre, blk.isSystemWideDefaultSRE(), blk.isProjectSRE(), this.resetJvaMainClass);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        this.configurator.setRuntimeConfiguration(config, SARLRuntime.getDefaultSREInstall(), null, null, this.resetJvaMainClass);
    }

    private class ProjectAdapter
    implements ProjectProvider {
        ProjectAdapter() {
        }

        @Override
        public IProject getProject() {
            ILaunchConfigurationWorkingCopy config = SARLRuntimeEnvironmentTab.this.getLaunchConfigurationWorkingCopy();
            if (config == null) {
                config = SARLRuntimeEnvironmentTab.this.getLaunchConfiguration();
            }
            if (config != null) {
                try {
                    IProject project;
                    String name = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                    if (name != null && name.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)).exists()) {
                        return project;
                    }
                }
                catch (CoreException e) {
                    SARLEclipsePlugin.getDefault().log(e);
                }
            }
            return null;
        }
    }
}

