/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.agent;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.LaunchConfigurationUtils;
import io.sarl.eclipse.launching.config.RootContextIdentifierType;
import io.sarl.eclipse.launching.dialog.Messages;
import io.sarl.eclipse.launching.runner.general.AbstractLaunchProcess;
import io.sarl.eclipse.launching.runner.general.AbstractSARLLaunchConfiguration;
import io.sarl.eclipse.launching.runner.general.ILaunchProcess;
import io.sarl.lang.core.SRE;
import io.sarl.lang.core.util.CliUtilities;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SARLAgentLaunchConfiguration
extends AbstractSARLLaunchConfiguration {
    @Override
    protected ILaunchProcess createLaunchingProcess(ILaunchConfiguration configuration, String mode, ILaunch launch) {
        return new LaunchProcess(this, configuration, mode, launch);
    }

    @Override
    protected String getProgramArguments(ILaunchConfiguration configuration, ISREInstall sre, String standardProgramArguments) throws CoreException {
        String fullOption;
        String bootAgent = this.getAgentName(configuration);
        if (Objects.equals(sre.getMainClass(), SRE.class.getName())) {
            return LaunchConfigurationUtils.join(bootAgent, standardProgramArguments);
        }
        IStringVariableManager substitutor = VariablesPlugin.getDefault().getStringVariableManager();
        String sreArgs1 = substitutor.performStringSubstitution(sre.getSREArguments());
        String sreArgs2 = substitutor.performStringSubstitution(this.getConfigurationAccessor().getSRELaunchingArguments(configuration));
        String sreArgs3 = substitutor.performStringSubstitution(this.getConfigurationAccessor().getExtraSRELaunchingArguments(configuration));
        Map cliOptions = sre.getAvailableCommandLineOptions();
        assert (cliOptions != null);
        String options = null;
        String logOption = this.getConfigurationAccessor().getLogArgumentName(configuration);
        String logValue = this.getConfigurationAccessor().getLogArgumentValue(configuration);
        if (!(Strings.isNullOrEmpty((String)logOption) || Strings.isNullOrEmpty((String)logValue) || Strings.isNullOrEmpty((String)(fullOption = CliUtilities.getUnixCommandLineOption((String)logOption, (String)logValue))))) {
            options = LaunchConfigurationUtils.join(options, fullOption);
        }
        if (this.getConfigurationAccessor().isEmbeddedSRE(configuration)) {
            options = LaunchConfigurationUtils.join(options, (String)cliOptions.get("CLI-Embedded"));
        }
        RootContextIdentifierType type = this.getConfigurationAccessor().getDefaultContextIdentifier(configuration);
        switch (type) {
            case RANDOM_CONTEXT_ID: {
                options = LaunchConfigurationUtils.join(options, (String)cliOptions.get("CLI-Random-Context-ID"));
                break;
            }
            case BOOT_AGENT_CONTEXT_ID: {
                options = LaunchConfigurationUtils.join(options, (String)cliOptions.get("CLI-BootAgent-Context-ID"));
                break;
            }
            default: {
                options = LaunchConfigurationUtils.join(options, (String)cliOptions.get("CLI-Default-Context-ID"));
            }
        }
        options = substitutor.performStringSubstitution(options);
        String noMoreOption = (String)cliOptions.get("CLI-No-More-Option");
        return LaunchConfigurationUtils.join(sreArgs1, sreArgs2, sreArgs3, options, bootAgent, noMoreOption, standardProgramArguments);
    }

    public static String getAgentName(ILaunchConfigurationAccessor accessor, ILaunchConfiguration configuration) throws CoreException {
        String agentName = accessor.getAgent(configuration);
        if (agentName == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(agentName);
    }

    protected String getAgentName(ILaunchConfiguration configuration) throws CoreException {
        return SARLAgentLaunchConfiguration.getAgentName(this.getConfigurationAccessor(), configuration);
    }

    protected void verifyAgentName(ILaunchConfiguration configuration) throws CoreException {
        String name = this.getAgentName(configuration);
        if (name == null) {
            this.abort(Messages.MainLaunchConfigurationTab_2, null, 501);
        }
    }

    private static class LaunchProcess
    extends AbstractLaunchProcess<SARLAgentLaunchConfiguration> {
        LaunchProcess(SARLAgentLaunchConfiguration owner, ILaunchConfiguration configuration, String mode, ILaunch launch) {
            super(owner, configuration, mode, launch);
        }

        @Override
        protected void readConfigurationParameters(IProgressMonitor monitor) throws CoreException {
            super.readConfigurationParameters(monitor);
            ((SARLAgentLaunchConfiguration)((Object)this.getOwner())).verifyAgentName(this.configuration);
        }
    }
}

