/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.general;

import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.runner.general.Messages;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractEmbeddedVMRunner
implements IVMRunner {
    protected static final String JAR_EXTENSION = ".jar";
    protected static final String SLASH = "/";
    protected static final String DEFINITION_PATTERN = "^[-/]D([^=]+)=(.*)$";

    public final void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            Job myJob = this.createJob(configuration, launch);
            monitor.done();
            if (myJob != null) {
                myJob.schedule();
            }
        }
        catch (Exception exception) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, exception));
        }
    }

    protected abstract MainClassFinder getMainClassFinder();

    private static void resetProperties() {
        Properties props = System.getProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String name = entry.getKey().toString();
            if (!name.startsWith("bq.")) continue;
            iterator.remove();
        }
    }

    private static void registerProperties(VMRunnerConfiguration configuration) {
        Properties props = System.getProperties();
        Pattern pattern = Pattern.compile(DEFINITION_PATTERN);
        String[] stringArray = configuration.getVMArguments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Matcher matcher = pattern.matcher(arg);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                props.setProperty(name, value);
            }
            ++n2;
        }
    }

    protected Job createJob(final VMRunnerConfiguration configuration, final ILaunch launch) {
        Job myJob = new Job(launch.getLaunchConfiguration().getName()){

            public IStatus run(IProgressMonitor monitor) {
                monitor.subTask(MessageFormat.format(Messages.AbstractEmbeddedVMRunner_0, launch.getLaunchConfiguration().getName()));
                MainClassFinder mcFinder = AbstractEmbeddedVMRunner.this.getMainClassFinder();
                try {
                    AbstractEmbeddedVMRunner.resetProperties();
                    AbstractEmbeddedVMRunner.registerProperties(configuration);
                    mcFinder.initialize(configuration, launch);
                    String mainClass = configuration.getClassToLaunch();
                    Class<?> clazz = mcFinder.getMainClass(mainClass);
                    Method mainMethod = clazz.getDeclaredMethod("main", String[].class);
                    mainMethod.invoke(null, new Object[]{configuration.getProgramArguments()});
                    IStatus iStatus = SARLEclipsePlugin.getDefault().createOkStatus();
                    return iStatus;
                }
                catch (Throwable exception) {
                    IStatus iStatus = SARLEclipsePlugin.getDefault().createStatus(4, exception);
                    return iStatus;
                }
                finally {
                    mcFinder.release();
                    monitor.done();
                }
            }
        };
        return myJob;
    }

    protected static Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected static interface MainClassFinder {
        public void initialize(VMRunnerConfiguration var1, ILaunch var2);

        public Class<?> getMainClass(String var1) throws Exception;

        public void release();
    }
}

