/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.general;

import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.LaunchConfigurationUtils;
import io.sarl.eclipse.launching.runner.general.AbstractSARLLaunchConfiguration;
import io.sarl.eclipse.launching.runner.general.ILaunchProcess;
import io.sarl.eclipse.launching.runner.general.Messages;
import io.sarl.eclipse.launching.runner.general.PreparationProcessState;
import io.sarl.eclipse.launching.runner.general.RunProcessState;
import io.sarl.eclipse.launching.runner.general.SrePathUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractLaunchProcess<T extends AbstractSARLLaunchConfiguration>
implements ILaunchProcess {
    private static final String OPTION_ENABLEASSERTIONS = "-ea";
    protected final ILaunchConfiguration configuration;
    protected final String mode;
    protected final ILaunch launch;
    private final WeakReference<T> owner;
    private PreparationProcessState preparationState = PreparationProcessState.STEP_0_PREPARE_PARAMETERS;
    private String mainTypeName;
    private IVMRunner runner;
    private String workingDirName;
    private String[] envp;
    private String[] classpath;
    private String[] modulepath;
    private ExecutionArguments execArgs;
    private Map<String, Object> vmAttributesMap;
    private VMRunnerConfiguration runConfig;
    private RunProcessState runState = RunProcessState.STEP_0_CONFIGURE_SOURCE_LOCATOR;

    protected AbstractLaunchProcess(T owner, ILaunchConfiguration configuration, String mode, ILaunch launch) {
        this.owner = new WeakReference<T>(owner);
        this.configuration = configuration;
        this.mode = mode;
        this.launch = launch;
    }

    protected T getOwner() {
        return (T)((Object)((AbstractSARLLaunchConfiguration)((Object)this.owner.get())));
    }

    @Override
    public VMRunnerConfiguration getVirtualMachineRunnerConfiguration() {
        return this.runConfig;
    }

    protected void setVirtualMachineRunnerConfiguration(VMRunnerConfiguration configuration) {
        this.runConfig = configuration;
    }

    protected Map<String, Object> getVirtualMachineAttributes() {
        return this.vmAttributesMap;
    }

    protected void setVirtualMachineAttributes(Map<String, Object> attributes) {
        this.vmAttributesMap = attributes;
    }

    protected ExecutionArguments getExecutionArguments() {
        return this.execArgs;
    }

    protected void setExecutionArguments(ExecutionArguments arguments) {
        this.execArgs = arguments;
    }

    protected String getMainTypeName() {
        return this.mainTypeName;
    }

    protected void setMainTypeName(String name) {
        this.mainTypeName = name;
    }

    protected IVMRunner getRunner() {
        return this.runner;
    }

    protected void setRunner(IVMRunner runner) {
        this.runner = runner;
    }

    protected String getWorkingDirectory() {
        return this.workingDirName;
    }

    protected void setWorkingDirectory(String name) {
        this.workingDirName = name;
    }

    protected String[] getEnvironment() {
        return this.envp;
    }

    protected void setEnvironment(String[] environment) {
        this.envp = environment;
    }

    protected String[] getClasspath() {
        return this.classpath;
    }

    protected void setClasspath(String[] classpath) {
        this.classpath = classpath;
    }

    protected String[] getModulepath() {
        return this.modulepath;
    }

    protected void setModulepath(String[] modulepath) {
        this.modulepath = modulepath;
    }

    @Override
    public int getStepNumber() {
        return PreparationProcessState.values().length + RunProcessState.values().length;
    }

    @Override
    public boolean prepare(IProgressMonitor monitor) throws CoreException {
        switch (this.preparationState) {
            case STEP_0_PREPARE_PARAMETERS: {
                this.readConfigurationParameters(monitor);
                break;
            }
            case STEP_1_BUILD_CLASSPATH: {
                this.buildClasspathAndModulePath(monitor);
                break;
            }
            case STEP_2_PREPARE_LAUNCHING: {
                this.readLaunchingArguments(monitor);
                break;
            }
            case STEP_3_POST_VALIDATION: {
                this.postValidation(monitor);
                break;
            }
            case STEP_4_CREATE_RUN_CONFIGURATION: {
                this.createRunConfiguration(monitor);
                break;
            }
            default: {
                this.configureStopInMain(monitor);
                return false;
            }
        }
        this.preparationState = this.preparationState.next();
        return true;
    }

    protected void readConfigurationParameters(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
        T own = this.getOwner();
        ((AbstractSARLLaunchConfiguration)((Object)own)).clearBuffers();
        this.setMainTypeName(own.verifyMainTypeName(this.configuration));
        this.setRunner(((AbstractSARLLaunchConfiguration)((Object)own)).getVMRunner(this.configuration, this.mode));
        File workingDir = own.verifyWorkingDirectory(this.configuration);
        this.setWorkingDirectory(null);
        if (workingDir != null) {
            this.setWorkingDirectory(workingDir.getAbsolutePath());
        }
        this.setEnvironment(own.getEnvironment(this.configuration));
    }

    protected void buildClasspathAndModulePath(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.AbstractLaunchProcess_0);
        String[][] paths = ((AbstractSARLLaunchConfiguration)((Object)this.getOwner())).getClasspathAndModulepath(this.configuration);
        T own = this.getOwner();
        if (((AbstractSARLLaunchConfiguration)((Object)own)).getConfigurationAccessor().isLaunhcingParametersPrintedOut(this.configuration)) {
            SARLEclipsePlugin.getDefault().getLog().info(MessageFormat.format(Messages.AbstractLaunchProcess_9, Arrays.toString(paths[0])));
            SARLEclipsePlugin.getDefault().getLog().info(MessageFormat.format(Messages.AbstractLaunchProcess_10, Arrays.toString(paths[1])));
        }
        this.setClasspath(paths[0]);
        this.setModulepath(paths[1]);
    }

    protected final void readLaunchingArguments(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.AbstractLaunchProcess_1);
        T own = this.getOwner();
        String pgmArgs = this.getProgramArguments((AbstractSARLLaunchConfiguration)((Object)own));
        String vmArgs = this.getVMArguments((AbstractSARLLaunchConfiguration)((Object)own));
        if (((AbstractSARLLaunchConfiguration)((Object)own)).getConfigurationAccessor().isLaunhcingParametersPrintedOut(this.configuration)) {
            SARLEclipsePlugin.getDefault().getLog().info(MessageFormat.format(Messages.AbstractLaunchProcess_6, pgmArgs));
            SARLEclipsePlugin.getDefault().getLog().info(MessageFormat.format(Messages.AbstractLaunchProcess_7, vmArgs));
        }
        this.setExecutionArguments(new ExecutionArguments(vmArgs, pgmArgs));
        Map vmAttrs = own.getVMSpecificAttributesMap(this.configuration);
        if (((AbstractSARLLaunchConfiguration)((Object)own)).getConfigurationAccessor().isLaunhcingParametersPrintedOut(this.configuration)) {
            SARLEclipsePlugin.getDefault().getLog().info(MessageFormat.format(Messages.AbstractLaunchProcess_8, vmAttrs.toString()));
        }
        this.setVirtualMachineAttributes(vmAttrs);
    }

    protected String getProgramArguments(AbstractSARLLaunchConfiguration own) throws CoreException {
        return own.getProgramArguments(this.configuration);
    }

    protected String getVMArguments(AbstractSARLLaunchConfiguration own) throws CoreException {
        String vmArgs = own.getVMArguments(this.configuration);
        String modeArgs = own.getVMArguments(this.configuration, this.mode);
        String eaArg = Objects.equals(this.mode, "run") && own.getConfigurationAccessor().isAssertionEnabledInRunMode(this.configuration) || Objects.equals(this.mode, "debug") && own.getConfigurationAccessor().isAssertionEnabledInDebugMode(this.configuration) ? OPTION_ENABLEASSERTIONS : null;
        String extraJreArgs = own.getConfigurationAccessor().getExtraJRELaunchingArguments(this.configuration);
        return LaunchConfigurationUtils.join(vmArgs, modeArgs, eaArg, extraJreArgs);
    }

    private void postValidation(IProgressMonitor monitor) throws CoreException {
        Object own;
        ISREInstall sre;
        monitor.subTask(Messages.AbstractLaunchProcess_2);
        if (Strings.isEmpty((String)this.getMainTypeName()) && (sre = SrePathUtils.getSREInstallFor(this.configuration, ((AbstractSARLLaunchConfiguration)((Object)(own = this.getOwner()))).getConfigurationAccessor(), cfg -> own.getJavaProject(cfg))) != null) {
            this.setMainTypeName(sre.getMainClass());
        }
    }

    protected void createRunConfiguration(IProgressMonitor monitor) throws CoreException {
        String[] modulepath;
        String[] classpath;
        monitor.subTask(Messages.AbstractLaunchProcess_3);
        T owner = this.getOwner();
        if (((AbstractSARLLaunchConfiguration)((Object)owner)).supportsModularProjectAndLauncher(this.configuration)) {
            String[][] paths = ((AbstractSARLLaunchConfiguration)((Object)owner)).getClasspathAndModulepath(this.configuration);
            classpath = paths != null && paths[0] != null ? paths[0] : ((AbstractSARLLaunchConfiguration)((Object)owner)).getClasspath(this.configuration);
            modulepath = paths != null && paths.length > 1 ? paths[1] : null;
        } else {
            classpath = ((AbstractSARLLaunchConfiguration)((Object)owner)).getClasspath(this.configuration);
            modulepath = null;
        }
        VMRunnerConfiguration cfg = new VMRunnerConfiguration(this.getMainTypeName(), classpath);
        cfg.setProgramArguments(this.getExecutionArguments().getProgramArgumentsArray());
        cfg.setEnvironment(this.getEnvironment());
        cfg.setVMArguments(this.getExecutionArguments().getVMArgumentsArray());
        cfg.setWorkingDirectory(this.getWorkingDirectory());
        cfg.setVMSpecificAttributesMap(this.getVirtualMachineAttributes());
        cfg.setPreviewEnabled(((AbstractSARLLaunchConfiguration)((Object)owner)).supportsPreviewFeatures(this.configuration));
        if (((AbstractSARLLaunchConfiguration)((Object)owner)).supportsModule() && !this.getMainTypeName().equals("org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain")) {
            try {
                IJavaProject proj = JavaRuntime.getJavaProject((ILaunchConfiguration)this.configuration);
                if (proj != null) {
                    String modName;
                    IModuleDescription module = proj.getModuleDescription();
                    String string = modName = module == null ? null : module.getElementName();
                    if (modName != null && modName.length() > 0) {
                        String moduleName = this.configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, null);
                        if (moduleName != null) {
                            cfg.setModuleDescription(moduleName);
                        } else {
                            cfg.setModuleDescription(modName);
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        if (!JavaRuntime.isModularConfiguration((ILaunchConfiguration)this.configuration)) {
            cfg.setBootClassPath(((AbstractSARLLaunchConfiguration)((Object)this.getOwner())).getBootpath(this.configuration));
        } else if (((AbstractSARLLaunchConfiguration)((Object)owner)).supportsModule()) {
            if (modulepath != null) {
                cfg.setModulepath(modulepath);
            }
            if (!this.configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true)) {
                cfg.setOverrideDependencies(this.configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, ""));
            } else {
                cfg.setOverrideDependencies(owner.getModuleCLIOptions(this.configuration));
            }
        }
        cfg.setMergeOutput(this.configuration.getAttribute("org.eclipse.debug.core.ATTR_MERGE_OUTPUT", false));
        this.setVirtualMachineRunnerConfiguration(cfg);
    }

    protected void configureStopInMain(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.AbstractLaunchProcess_4);
        ((AbstractSARLLaunchConfiguration)((Object)this.getOwner())).prepareStopInMain(this.configuration);
    }

    @Override
    public boolean launch(IProgressMonitor monitor) throws CoreException {
        switch (this.runState) {
            case STEP_0_CONFIGURE_SOURCE_LOCATOR: {
                this.configureSourceLocator(monitor);
                break;
            }
            default: {
                this.launchRunner(monitor);
                return false;
            }
        }
        this.runState = this.runState.next();
        return true;
    }

    private void configureSourceLocator(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
        ((AbstractSARLLaunchConfiguration)((Object)this.getOwner())).setDefaultSourceLocator(this.launch, this.configuration);
    }

    protected void launchRunner(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(MessageFormat.format(Messages.AbstractLaunchProcess_5, this.configuration.getName()));
        this.getRunner().run(this.getVirtualMachineRunnerConfiguration(), this.launch, monitor);
    }
}

