/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.general;

import com.google.inject.Inject;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.config.LaunchConfigurationUtils;
import io.sarl.eclipse.launching.runner.general.EmbeddedNotModularVMRunner;
import io.sarl.eclipse.launching.runner.general.ILaunchProcess;
import io.sarl.eclipse.launching.runner.general.Messages;
import io.sarl.eclipse.launching.runner.general.SrePathUtils;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.io.File;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JRERuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public abstract class AbstractSARLLaunchConfiguration
extends AbstractJavaLaunchConfigurationDelegate {
    @Inject
    private ILaunchConfigurationAccessor configAccessor;
    private SoftReference<IRuntimeClasspathEntry[]> unresolvedClasspath;
    private SoftReference<IRuntimeClasspathEntry[]> resolvedClasspath;
    @Deprecated(forRemoval=true, since="0.12")
    private SoftReference<String[]> bufferedClasspath8;
    private SoftReference<String[]> bufferedClasspath;
    private SoftReference<String[]> bufferedModulepath;
    private SoftReference<SrePathUtils.ExtraClassPathProviders> bufferedClasspathProviders;

    public ILaunchConfigurationAccessor getConfigurationAccessor() {
        return this.configAccessor;
    }

    public void prepareStopInMain(ILaunchConfiguration configuration) throws CoreException {
        super.prepareStopInMain(configuration);
    }

    public void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        super.setDefaultSourceLocator(launch, configuration);
    }

    public boolean supportsPreviewFeatures(ILaunchConfiguration configuration) {
        return super.supportsPreviewFeatures(configuration);
    }

    public boolean supportsModule() {
        return super.supportsModule();
    }

    public boolean supportsModularProjectAndLauncher(ILaunchConfiguration configuration) {
        return JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration) && this.supportsModule();
    }

    protected synchronized void clearBuffers() {
        if (this.unresolvedClasspath != null) {
            this.unresolvedClasspath.clear();
            this.unresolvedClasspath = null;
        }
        if (this.resolvedClasspath != null) {
            this.resolvedClasspath.clear();
            this.resolvedClasspath = null;
        }
        if (this.bufferedClasspath8 != null) {
            this.bufferedClasspath8.clear();
            this.bufferedClasspath8 = null;
        }
        if (this.bufferedClasspath != null) {
            this.bufferedClasspath.clear();
            this.bufferedClasspath = null;
        }
        if (this.bufferedModulepath != null) {
            this.bufferedModulepath.clear();
            this.bufferedModulepath = null;
        }
        if (this.bufferedClasspathProviders != null) {
            this.bufferedClasspathProviders.clear();
            this.bufferedClasspathProviders = null;
        }
    }

    private SrePathUtils.ExtraClassPathProviders ensureClasspathProvidersBuffer() {
        SrePathUtils.ExtraClassPathProviders providers;
        SrePathUtils.ExtraClassPathProviders extraClassPathProviders = providers = this.bufferedClasspathProviders == null ? null : this.bufferedClasspathProviders.get();
        if (providers == null) {
            providers = new SrePathUtils.ExtraClassPathProviders();
            this.bufferedClasspathProviders = new SoftReference<SrePathUtils.ExtraClassPathProviders>(providers);
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRuntimeClasspathEntry[] getOrComputeUnresolvedSARLRuntimeClasspath(ILaunchConfiguration configuration) throws CoreException {
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration = this;
        synchronized (abstractSARLLaunchConfiguration) {
            IRuntimeClasspathEntry[] entries;
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries = this.unresolvedClasspath == null ? null : this.unresolvedClasspath.get();
            if (entries != null) {
                return entries;
            }
        }
        IRuntimeClasspathEntry[] entries = SrePathUtils.computeUnresolvedSARLRuntimeClasspath(configuration, this.configAccessor, cfg -> this.getJavaProject(cfg), this.ensureClasspathProvidersBuffer());
        if (entries == null) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, "Unable to computer the raw classpath from the launch configuration"));
        }
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration2 = this;
        synchronized (abstractSARLLaunchConfiguration2) {
            this.unresolvedClasspath = new SoftReference<IRuntimeClasspathEntry[]>(entries);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRuntimeClasspathEntry[] getOrComputeResolvedSARLRuntimeClasspath(ILaunchConfiguration configuration) throws CoreException {
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration = this;
        synchronized (abstractSARLLaunchConfiguration) {
            IRuntimeClasspathEntry[] entries;
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries = this.resolvedClasspath == null ? null : this.resolvedClasspath.get();
            if (entries != null) {
                return entries;
            }
        }
        IRuntimeClasspathEntry[] entries = this.getOrComputeUnresolvedSARLRuntimeClasspath(configuration);
        IRuntimeClasspathEntry[] entries2 = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        if (entries2 == null) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, "Unable to computer the resolved classpath from the launch configuration"));
        }
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration2 = this;
        synchronized (abstractSARLLaunchConfiguration2) {
            this.resolvedClasspath = new SoftReference<IRuntimeClasspathEntry[]>(entries2);
        }
        return entries2;
    }

    private static boolean isNotSREEntry(IRuntimeClasspathEntry entry) {
        try {
            File file = new File(entry.getLocation());
            if (file.isDirectory()) {
                return !SARLRuntime.isUnpackedSRE(file);
            }
            if (file.canRead()) {
                return !SARLRuntime.isPackedSRE(file);
            }
        }
        catch (Throwable e) {
            SARLEclipsePlugin.getDefault().log(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true, since="0.12")
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean isMavenProject;
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration = this;
        synchronized (abstractSARLLaunchConfiguration) {
            String[] classpathEntries;
            String[] stringArray = classpathEntries = this.bufferedClasspath8 == null ? null : this.bufferedClasspath8.get();
            if (classpathEntries != null) {
                return classpathEntries;
            }
        }
        IRuntimeClasspathEntry[] entries = this.getOrComputeResolvedSARLRuntimeClasspath(configuration);
        boolean needSREEntry = isMavenProject = this.getJavaProject(configuration).getProject().hasNature("org.eclipse.m2e.core.maven2Nature");
        ArrayList<String> userEntryList = new ArrayList<String>(entries.length + 1);
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < entries.length) {
            String location;
            if (!(entries[i].getClasspathProperty() != 3 && entries[i].getClasspathProperty() != 5 || (location = entries[i].getLocation()) == null || set.contains(location))) {
                userEntryList.add(location);
                set.add(location);
                if (needSREEntry) {
                    needSREEntry = AbstractSARLLaunchConfiguration.isNotSREEntry(entries[i]);
                }
            }
            ++i;
        }
        if (needSREEntry) {
            int insertIndex = 0;
            for (IRuntimeClasspathEntry entry : SrePathUtils.getSREClasspathEntries(configuration, this.configAccessor, cfg -> this.getJavaProject(cfg))) {
                String location;
                if (entry.getClasspathProperty() != 3 && entry.getClasspathProperty() != 5 || (location = entry.getLocation()) == null || set.contains(location)) continue;
                userEntryList.add(insertIndex, location);
                set.add(location);
                ++insertIndex;
            }
        }
        String[] classpathEntries = userEntryList.toArray(new String[userEntryList.size()]);
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration2 = this;
        synchronized (abstractSARLLaunchConfiguration2) {
            this.bufferedClasspath8 = new SoftReference<String[]>(classpathEntries);
        }
        return classpathEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        boolean isMavenProject;
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration = this;
        synchronized (abstractSARLLaunchConfiguration) {
            String[] modulepathEntries;
            String[] classpathEntries = this.bufferedClasspath == null ? null : this.bufferedClasspath.get();
            String[] stringArray = modulepathEntries = this.bufferedModulepath == null ? null : this.bufferedModulepath.get();
            if (classpathEntries != null && modulepathEntries != null) {
                return new String[][]{classpathEntries, modulepathEntries};
            }
        }
        IRuntimeClasspathEntry[] entries = this.getOrComputeResolvedSARLRuntimeClasspath(configuration);
        boolean needSREEntry = isMavenProject = this.getJavaProject(configuration).getProject().hasNature("org.eclipse.m2e.core.maven2Nature");
        ArrayList<String> classpathEntries = new ArrayList<String>(entries.length);
        ArrayList<String> modulepathEntries = new ArrayList<String>(entries.length);
        TreeSet<String> classpathSet = new TreeSet<String>();
        TreeSet<String> modulepathSet = new TreeSet<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                switch (entry.getClasspathProperty()) {
                    case 3: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(location);
                        classpathSet.add(location);
                        if (!needSREEntry) break;
                        needSREEntry = AbstractSARLLaunchConfiguration.isNotSREEntry(entry);
                        break;
                    }
                    case 5: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(location);
                        classpathSet.add(location);
                        if (!needSREEntry) break;
                        needSREEntry = AbstractSARLLaunchConfiguration.isNotSREEntry(entry);
                        break;
                    }
                    case 4: {
                        if (modulepathSet.contains(location)) break;
                        modulepathEntries.add(location);
                        modulepathSet.add(location);
                        if (!needSREEntry) break;
                        needSREEntry = AbstractSARLLaunchConfiguration.isNotSREEntry(entry);
                        break;
                    }
                }
            }
            ++n2;
        }
        if (needSREEntry) {
            int insertIndex = 0;
            for (IRuntimeClasspathEntry entry : SrePathUtils.getSREClasspathEntries(configuration, this.configAccessor, cfg -> this.getJavaProject(cfg))) {
                String location = entry.getLocation();
                if (location == null) continue;
                switch (entry.getClasspathProperty()) {
                    case 3: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(insertIndex, location);
                        classpathSet.add(location);
                        ++insertIndex;
                        break;
                    }
                    case 5: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(insertIndex, location);
                        classpathSet.add(location);
                        ++insertIndex;
                        break;
                    }
                    case 4: {
                        if (modulepathSet.contains(location)) break;
                        modulepathEntries.add(insertIndex, location);
                        modulepathSet.add(location);
                        ++insertIndex;
                        break;
                    }
                }
            }
        }
        String[] classpath = classpathEntries.toArray(new String[classpathEntries.size()]);
        String[] modulepath = modulepathEntries.toArray(new String[modulepathEntries.size()]);
        AbstractSARLLaunchConfiguration abstractSARLLaunchConfiguration2 = this;
        synchronized (abstractSARLLaunchConfiguration2) {
            this.bufferedClasspath = new SoftReference<String[]>(classpath);
            this.bufferedModulepath = new SoftReference<String[]>(modulepath);
        }
        return new String[][]{classpath, modulepath};
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        if (JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration)) {
            return null;
        }
        String[][] paths = this.getBootpathExt(configuration);
        String[] pre = paths[0];
        String[] main = paths[1];
        String[] app = paths[2];
        if (pre == null && main == null && app == null) {
            return null;
        }
        IRuntimeClasspathEntry[] entries = this.getOrComputeResolvedSARLRuntimeClasspath(configuration);
        ArrayList<String> bootEntries = new ArrayList<String>(entries.length);
        boolean empty = true;
        boolean allStandard = true;
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getClasspathProperty() != 3 && (location = entries[i].getLocation()) != null) {
                empty = false;
                bootEntries.add(location);
                allStandard = allStandard && entries[i].getClasspathProperty() == 1;
            }
            ++i;
        }
        if (empty) {
            return new String[0];
        }
        if (allStandard) {
            return null;
        }
        return bootEntries.toArray(new String[bootEntries.size()]);
    }

    public String[][] getBootpathExt(ILaunchConfiguration configuration) throws CoreException {
        String[][] bootpathInfo = new String[3][];
        IRuntimeClasspathEntry[] entries = this.getOrComputeUnresolvedSARLRuntimeClasspath(configuration);
        ArrayList<IRuntimeClasspathEntry> bootEntriesPrepend = new ArrayList<IRuntimeClasspathEntry>();
        int index = 0;
        IRuntimeClasspathEntry jreEntry = null;
        while (jreEntry == null && index < entries.length) {
            IRuntimeClasspathEntry entry = entries[index];
            if (JavaRuntime.isVMInstallReference((IRuntimeClasspathEntry)entry)) {
                jreEntry = entry;
            } else if (entry.getClasspathProperty() == 2) {
                bootEntriesPrepend.add(entry);
            }
            ++index;
        }
        IRuntimeClasspathEntry[] bootEntriesPrep = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])bootEntriesPrepend.toArray(new IRuntimeClasspathEntry[bootEntriesPrepend.size()]), (ILaunchConfiguration)configuration);
        String[] entriesPrep = null;
        if (bootEntriesPrep.length > 0) {
            entriesPrep = new String[bootEntriesPrep.length];
            int i = 0;
            while (i < bootEntriesPrep.length) {
                entriesPrep[i] = bootEntriesPrep[i].getLocation();
                ++i;
            }
        }
        if (jreEntry != null) {
            IVMInstall install;
            LibraryLocation[] libraryLocations;
            ArrayList<IRuntimeClasspathEntry> bootEntriesAppend = new ArrayList<IRuntimeClasspathEntry>();
            while (index < entries.length) {
                IRuntimeClasspathEntry entry = entries[index];
                if (entry.getClasspathProperty() == 2) {
                    bootEntriesAppend.add(entry);
                }
                ++index;
            }
            bootpathInfo[0] = entriesPrep;
            IRuntimeClasspathEntry[] bootEntriesApp = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])bootEntriesAppend.toArray(new IRuntimeClasspathEntry[bootEntriesAppend.size()]), (ILaunchConfiguration)configuration);
            if (bootEntriesApp.length > 0) {
                bootpathInfo[2] = new String[bootEntriesApp.length];
                int i = 0;
                while (i < bootEntriesApp.length) {
                    bootpathInfo[2][i] = bootEntriesApp[i].getLocation();
                    ++i;
                }
            }
            if ((libraryLocations = (install = this.getVMInstall(configuration)).getLibraryLocations()) != null && !JRERuntimeClasspathEntryResolver.isSameArchives((LibraryLocation[])libraryLocations, (LibraryLocation[])install.getVMInstallType().getDefaultLibraryLocations(install.getInstallLocation()))) {
                IRuntimeClasspathEntry[] bootEntries = null;
                if (jreEntry.getType() == 4) {
                    IRuntimeClasspathEntry bootEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)jreEntry.getPath(), (int)2, (IJavaProject)this.getJavaProject(configuration));
                    bootEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)bootEntry, (ILaunchConfiguration)configuration);
                } else {
                    bootEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)jreEntry, (ILaunchConfiguration)configuration);
                }
                String[] bootpath = new String[bootEntriesPrep.length + bootEntries.length + bootEntriesApp.length];
                if (bootEntriesPrep.length > 0) {
                    System.arraycopy(bootpathInfo[0], 0, bootpath, 0, bootEntriesPrep.length);
                }
                int dest = bootEntriesPrep.length;
                int i = 0;
                while (i < bootEntries.length) {
                    bootpath[dest] = bootEntries[i].getLocation();
                    ++dest;
                    ++i;
                }
                if (bootEntriesApp.length > 0) {
                    System.arraycopy(bootpathInfo[2], 0, bootpath, dest, bootEntriesApp.length);
                }
                bootpathInfo[0] = null;
                bootpathInfo[1] = bootpath;
                bootpathInfo[2] = null;
            }
        } else {
            bootpathInfo[1] = entriesPrep == null ? new String[0] : entriesPrep;
        }
        return bootpathInfo;
    }

    protected abstract String getProgramArguments(ILaunchConfiguration var1, ISREInstall var2, String var3) throws CoreException;

    public final String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String standardProgramArguments = super.getProgramArguments(configuration);
        ISREInstall sre = SrePathUtils.getSREInstallFor(configuration, this.getConfigurationAccessor(), cfg -> this.getJavaProject(cfg));
        assert (sre != null);
        return this.getProgramArguments(configuration, sre, standardProgramArguments);
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (this.getConfigurationAccessor().isEmbeddedSRE(configuration)) {
            return new EmbeddedNotModularVMRunner();
        }
        return super.getVMRunner(configuration, mode);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String launchConfigArgs = super.getVMArguments(configuration);
        ISREInstall sre = SrePathUtils.getSREInstallFor(configuration, this.getConfigurationAccessor(), cfg -> this.getJavaProject(cfg));
        assert (sre != null);
        IStringVariableManager substitutor = VariablesPlugin.getDefault().getStringVariableManager();
        String sreArgs = substitutor.performStringSubstitution(sre.getJVMArguments());
        return LaunchConfigurationUtils.join(sreArgs, launchConfigArgs);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            ILaunchProcess process = this.createLaunchingProcess(configuration, mode, launch);
            SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.AbstractSARLLaunchConfiguration_0, configuration.getName()), (int)process.getStepNumber());
            while (process.prepare((IProgressMonitor)progressMonitor.newChild(1))) {
                if (!progressMonitor.isCanceled()) continue;
                return;
            }
            while (process.launch((IProgressMonitor)progressMonitor.newChild(1))) {
                if (!progressMonitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            this.clearBuffers();
        }
    }

    public String showCommandLine(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            String cmdLine;
            ILaunchProcess process = this.createLaunchingProcess(configuration, mode, launch);
            SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.AbstractSARLLaunchConfiguration_0, configuration.getName()), (int)process.getStepNumber());
            while (process.prepare((IProgressMonitor)progressMonitor.newChild(1))) {
                if (!progressMonitor.isCanceled()) continue;
                return "";
            }
            IVMRunner runner = this.getVMRunner(configuration, mode);
            String string = cmdLine = runner.showCommandLine(process.getVirtualMachineRunnerConfiguration(), launch, monitor);
            return string;
        }
        finally {
            this.clearBuffers();
        }
    }

    protected abstract ILaunchProcess createLaunchingProcess(ILaunchConfiguration var1, String var2, ILaunch var3);
}

