/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.general;

import io.sarl.eclipse.launching.runner.general.AbstractEmbeddedVMRunner;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.DynamicURLClassLoader;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.URISchemeType;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class EmbeddedNotModularVMRunner
extends AbstractEmbeddedVMRunner {
    @Override
    protected AbstractEmbeddedVMRunner.MainClassFinder getMainClassFinder() {
        return new CpMainClassFinder();
    }

    protected static class CpMainClassFinder
    implements AbstractEmbeddedVMRunner.MainClassFinder {
        private ClassLoader classLoader;

        protected CpMainClassFinder() {
        }

        @Override
        public void initialize(VMRunnerConfiguration configuration, ILaunch launch) {
            String[] classpath = configuration.getClassPath();
            URL[] classPathURLs = new URL[classpath.length];
            Arrays.parallelSetAll(classPathURLs, index -> {
                Object path = classpath[index];
                URL url = FileSystem.convertStringToURL((String)path, (boolean)false);
                if (!((String)(path = url.getFile())).endsWith(".jar") && !((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                try {
                    return new URI(URISchemeType.FILE.name(), null, (String)path, null).toURL();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.classLoader = DynamicURLClassLoader.newInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (URL[])classPathURLs);
            ClassLoaderFinder.setPreferredClassLoader((ClassLoader)this.classLoader);
        }

        @Override
        public Class<?> getMainClass(String mainClass) throws Exception {
            return this.classLoader.loadClass(mainClass);
        }

        @Override
        public void release() {
            ClassLoaderFinder.popPreferredClassLoader();
        }
    }
}

