/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.runner.general;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.Extensions;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProvider;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProviderFactories;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.buildpath.SARLClasspathContainerInitializer;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.runner.general.IJavaProjectAccessor;
import io.sarl.eclipse.launching.runner.general.Messages;
import io.sarl.eclipse.launching.sreproviding.EclipseIDEProjectSREProvider;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.RuntimeClasspathProvider;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public final class SrePathUtils {
    private SrePathUtils() {
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedSARLRuntimeClasspath(ILaunchConfiguration configuration, ILaunchConfigurationAccessor configAccessor, IJavaProjectAccessor projectAccessor, ExtraClassPathProviders classpathProviders) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        TreeSet<String> addedEntries = new TreeSet<String>();
        ArrayList<IRuntimeClasspathEntry> filteredEntries = new ArrayList<IRuntimeClasspathEntry>();
        List<IRuntimeClasspathEntry> sreClasspathEntries = null;
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            if (entry.getPath().equals((Object)SARLClasspathContainerInitializer.CONTAINER_ID)) {
                if (sreClasspathEntries == null) {
                    sreClasspathEntries = SrePathUtils.getSREClasspathEntries(configuration, configAccessor, projectAccessor);
                }
                for (IRuntimeClasspathEntry containerEntry : sreClasspathEntries) {
                    String location = containerEntry.getLocation();
                    if (Strings.isNullOrEmpty((String)location)) {
                        filteredEntries.add(containerEntry);
                        continue;
                    }
                    if (!addedEntries.add(location)) continue;
                    filteredEntries.add(containerEntry);
                }
            } else {
                String location = entry.getLocation();
                if (Strings.isNullOrEmpty((String)location)) {
                    filteredEntries.add(entry);
                } else if (addedEntries.add(location)) {
                    filteredEntries.add(entry);
                }
            }
            ++n2;
        }
        for (String containerId : configAccessor.getExtraClasspathProviders(configuration)) {
            RuntimeClasspathProvider provider = classpathProviders.getProvider(containerId);
            if (provider != null) {
                IRuntimeClasspathEntry[] extraEntries = provider.computeUnresolvedClasspath(configuration);
                if (extraEntries == null) continue;
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = extraEntries;
                int n3 = extraEntries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry extraEntry = iRuntimeClasspathEntryArray2[n4];
                    String location = extraEntry.getLocation();
                    if (Strings.isNullOrEmpty((String)location)) {
                        filteredEntries.add(extraEntry);
                    } else if (addedEntries.add(location)) {
                        filteredEntries.add(extraEntry);
                    }
                    ++n4;
                }
                continue;
            }
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, "Classpath provider not found: " + containerId));
        }
        return filteredEntries.toArray(new IRuntimeClasspathEntry[filteredEntries.size()]);
    }

    public static List<IRuntimeClasspathEntry> getSREClasspathEntries(ILaunchConfiguration configuration, ILaunchConfigurationAccessor configAccessor, IJavaProjectAccessor projectAccessor) throws CoreException {
        ISREInstall sre = SrePathUtils.getSREInstallFor(configuration, configAccessor, projectAccessor);
        return sre.getClassPathEntries();
    }

    public static ISREInstall getSREInstallFor(ILaunchConfiguration configuration, ILaunchConfigurationAccessor configAccessor, IJavaProjectAccessor projectAccessor) throws CoreException {
        ISREInstall sre;
        assert (configAccessor != null);
        assert (projectAccessor != null);
        if (configAccessor.getUseProjectSREFlag(configuration)) {
            sre = SrePathUtils.getProjectSpecificSRE(configuration, true, projectAccessor);
        } else if (configAccessor.getUseSystemSREFlag(configuration)) {
            sre = SARLRuntime.getDefaultSREInstall();
            if (sre != null) {
                SrePathUtils.verifySREValidity(sre, sre.getId());
            }
        } else {
            String runtime = configAccessor.getSREId(configuration);
            sre = SARLRuntime.getSREFromId(runtime);
            if (sre != null) {
                SrePathUtils.verifySREValidity(sre, runtime);
            }
        }
        if (sre == null) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, Messages.SrepathUtils_0));
        }
        return sre;
    }

    private static ISREInstall getProjectSpecificSRE(ILaunchConfiguration configuration, boolean verify, IJavaProjectAccessor projectAccessor) throws CoreException {
        assert (projectAccessor != null);
        IJavaProject jprj = projectAccessor.get(configuration);
        if (jprj != null) {
            IProject prj = jprj.getProject();
            assert (prj != null);
            ISREInstall sre = SrePathUtils.getSREFromExtension(prj, verify);
            if (sre != null) {
                return sre;
            }
            EclipseIDEProjectSREProvider provider = new EclipseIDEProjectSREProvider(prj);
            sre = provider.getProjectSREInstall();
            if (sre != null) {
                if (verify) {
                    SrePathUtils.verifySREValidity(sre, sre.getId());
                }
                return sre;
            }
        }
        ISREInstall sre = SARLRuntime.getDefaultSREInstall();
        if (verify) {
            SrePathUtils.verifySREValidity(sre, sre == null ? Messages.SrepathUtils_1 : sre.getId());
        }
        return sre;
    }

    private static ISREInstall getSREFromExtension(IProject project, boolean verify) {
        Optional<ISREInstall> sreInstall = ProjectSREProviderFactories.getSREProviderFactoryStreamFromExtension().map(it -> {
            ISREInstall sre;
            ProjectSREProvider provider = it.getProjectSREProvider(project);
            if (provider != null && (sre = provider.getProjectSREInstall()) != null) {
                return sre;
            }
            return null;
        }).filter(it -> it != null).findFirst();
        if (sreInstall.isPresent()) {
            ISREInstall sre = sreInstall.get();
            try {
                if (verify) {
                    SrePathUtils.verifySREValidity(sre, sre.getId());
                }
                return sre;
            }
            catch (CoreException e) {
                SARLEclipsePlugin.getDefault().log(e);
            }
        }
        return null;
    }

    private static void verifySREValidity(ISREInstall sre, String runtime) throws CoreException {
        if (sre == null) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(io.sarl.eclipse.launching.dialog.Messages.RuntimeEnvironmentTab_6, runtime)));
        }
        if (!sre.getValidity(0).isOK()) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(io.sarl.eclipse.launching.dialog.Messages.RuntimeEnvironmentTab_5, sre.getName())));
        }
    }

    public static class ExtraClassPathProviders {
        private Map<String, RuntimeClasspathProvider> cpProviders;

        public RuntimeClasspathProvider getProvider(String identifier) {
            this.ensureProviders();
            return this.cpProviders.get(identifier);
        }

        protected void ensureProviders() {
            if (this.cpProviders == null) {
                this.cpProviders = Extensions.getExtensions((String)"org.eclipse.jdt.launching", (String)"classpathProviders").map(it -> new RuntimeClasspathProvider(it)).collect(Collectors.toMap(it -> it.getIdentifier(), it -> it, (oldValue, newValue) -> newValue, () -> new HashMap()));
            }
        }
    }
}

