/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.shortcuts;

import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.shortcuts.Messages;
import io.sarl.eclipse.util.AbstractSarlScriptInteractiveSelector;
import io.sarl.lang.sarl.SarlScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.Pair;

public abstract class AbstractSarlLaunchShortcut<ET extends EObject, JT>
extends AbstractSarlScriptInteractiveSelector<ET, JT>
implements ILaunchShortcut2 {
    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            return this.findResource(sel.toArray());
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)editorpart);
        if (xtextEditor != null) {
            return xtextEditor.getResource();
        }
        return null;
    }

    protected abstract String getElementQualifiedName(ILaunchConfiguration var1);

    protected abstract String getConfigurationType();

    protected abstract Class<JT> getValidJavaType();

    private IResource findResource(Object[] elements) {
        try {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                URI fileURI = this.getResourceURIForValidEObject(element);
                if (fileURI != null) {
                    for (Pair storage : this.storage2UriMapper.getStorages(fileURI)) {
                        IResource res;
                        IStorage obj = (IStorage)storage.getFirst();
                        if (!(obj instanceof IResource) || !this.isValidResource(res = (IResource)obj)) continue;
                        return res;
                    }
                } else {
                    LinkedList<Object> stack = new LinkedList<Object>();
                    stack.add(element);
                    Class evalidType = this.getValidEObjectType();
                    Class<JT> jvalidType = this.getValidJavaType();
                    while (!stack.isEmpty()) {
                        int n3;
                        Object current = stack.removeFirst();
                        if (current instanceof IFile) {
                            URI resourceURI;
                            ResourceSet resourceSet;
                            Resource resource;
                            IFile file = (IFile)current;
                            if (!this.isValidResource((IResource)file) || (resource = (resourceSet = this.resourceSetProvider.get(file.getProject())).getResource(resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)) == null) continue;
                            for (EObject content : resource.getContents()) {
                                if (!(content instanceof SarlScript) || EcoreUtil2.getAllContentsOfType((EObject)content, evalidType).isEmpty()) continue;
                                return file;
                            }
                            continue;
                        }
                        if (current instanceof IFolder) {
                            IFolder folder = (IFolder)current;
                            if (!this.isValidResource((IResource)folder)) continue;
                            try {
                                stack.addAll(Arrays.asList(folder.members(0)));
                            }
                            catch (CoreException coreException) {}
                            continue;
                        }
                        if (current instanceof IType) {
                            IType type = (IType)current;
                            String qn = type.getFullyQualifiedName();
                            IJavaProject project = type.getJavaProject();
                            if (!this.jdt.isSubClassOf(this.jdt.toTypeFinder(project), qn, jvalidType.getName())) continue;
                            return type.getResource();
                        }
                        if (current instanceof IPackageFragment) {
                            IPackageFragment fragment = (IPackageFragment)current;
                            stack.addAll(Arrays.asList(fragment.getNonJavaResources()));
                            IJavaElement[] iJavaElementArray = fragment.getChildren();
                            n3 = iJavaElementArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IJavaElement child = iJavaElementArray[n4];
                                stack.add(child);
                                ++n4;
                            }
                            continue;
                        }
                        if (current instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot fragment = (IPackageFragmentRoot)current;
                            stack.addAll(Arrays.asList(fragment.getNonJavaResources()));
                            IJavaElement[] iJavaElementArray = fragment.getChildren();
                            int n5 = iJavaElementArray.length;
                            n3 = 0;
                            while (n3 < n5) {
                                IJavaElement child = iJavaElementArray[n3];
                                stack.add(child);
                                ++n3;
                            }
                            continue;
                        }
                        if (!(current instanceof IJavaProject)) continue;
                        IJavaProject cvalue = (IJavaProject)current;
                        stack.addAll(Arrays.asList(cvalue.getNonJavaResources()));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private void searchAndLaunch(String mode, Object ... scope) {
        AbstractSarlScriptInteractiveSelector.ElementDescription element = this.searchAndSelect(true, scope);
        if (element != null) {
            try {
                this.launch(element.projectName, element.elementName, mode);
            }
            catch (CoreException e) {
                SARLEclipsePlugin.getDefault().openError(AbstractSarlLaunchShortcut.getShell(), io.sarl.eclipse.util.Messages.AbstractSarlScriptInteractiveSelector_1, e.getStatus().getMessage(), null, e);
            }
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection cvalue = (IStructuredSelection)selection;
            this.searchAndLaunch(mode, cvalue.toArray());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)editor);
        ISelection selection = xtextEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            EObject elt;
            ITextSelection sel = (ITextSelection)selection;
            EObject obj = (EObject)xtextEditor.getDocument().readOnly(resource -> {
                IParseResult parseRes = resource.getParseResult();
                if (parseRes == null) {
                    return null;
                }
                ICompositeNode rootNode = parseRes.getRootNode();
                ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)sel.getOffset());
                return NodeModelUtils.findActualSemanticObjectFor((INode)node);
            });
            if (obj != null && (elt = EcoreUtil2.getContainerOfType((EObject)obj, this.getValidEObjectType())) != null) {
                this.searchAndLaunch(mode, elt);
                return;
            }
        } else if (selection != null) {
            this.launch(selection, mode);
            return;
        }
        this.searchAndLaunch(mode, xtextEditor.getResource());
    }

    protected void launch(String projectName, String fullyQualifiedName, String mode) throws CoreException {
        List<ILaunchConfiguration> configs = this.getCandidates(projectName, fullyQualifiedName);
        ILaunchConfiguration config = null;
        int count = configs.size();
        if (count == 1) {
            config = configs.get(0);
        } else if (count > 1 && (config = this.chooseConfiguration(configs)) == null) {
            return;
        }
        if (config == null) {
            config = this.createConfiguration(projectName, fullyQualifiedName);
        }
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected List<ILaunchConfiguration> getCandidates(String projectName, String fullyQualifiedName) throws CoreException {
        ILaunchConfigurationType ctype = AbstractSarlLaunchShortcut.getLaunchManager().getLaunchConfigurationType(this.getConfigurationType());
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        ILaunchConfiguration[] configs = AbstractSarlLaunchShortcut.getLaunchManager().getLaunchConfigurations(ctype);
        candidateConfigs = new ArrayList(configs.length);
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (Objects.equals(this.getElementQualifiedName(config), fullyQualifiedName) && Objects.equals(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""), projectName)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        return candidateConfigs;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractSarlLaunchShortcut.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.AbstractSarlLaunchShortcut_0);
        dialog.setMessage(Messages.AbstractSarlLaunchShortcut_1);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(String var1, String var2);
}

