/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.shortcuts;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.shortcuts.AbstractSarlLaunchShortcut;
import io.sarl.eclipse.launching.shortcuts.Messages;
import io.sarl.lang.core.Agent;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.ui.labeling.SARLImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class AgentLaunchShortcut
extends AbstractSarlLaunchShortcut<SarlAgent, Agent> {
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private ILaunchConfigurationAccessor accessor;
    @Inject
    private SARLImages images;

    @Override
    protected Class<SarlAgent> getValidEObjectType() {
        return SarlAgent.class;
    }

    @Override
    protected Class<Agent> getValidJavaType() {
        return Agent.class;
    }

    @Override
    protected String getConfigurationType() {
        return this.accessor.getAgentLaunchConfigurationType();
    }

    @Override
    protected String getElementQualifiedName(ILaunchConfiguration configuration) {
        return this.accessor.getAgent(configuration);
    }

    @Override
    protected URI getResourceURIForValidEObject(Object object) {
        if (object instanceof SarlAgent) {
            SarlAgent agent = (SarlAgent)object;
            return agent.eResource().getURI();
        }
        return null;
    }

    @Override
    protected String getQualifiedNameFor(SarlAgent element) {
        return this.nameProvider.getFullyQualifiedName((EObject)element).toString();
    }

    @Override
    protected Image getElementImage(Object element) {
        return this.images.forAgent(JvmVisibility.PRIVATE, 0).createImage();
    }

    @Override
    protected ILaunchConfiguration createConfiguration(String projectName, String fullyQualifiedNameOfAgent) {
        try {
            return this.configurator.newAgentLaunchConfiguration(projectName, fullyQualifiedNameOfAgent);
        }
        catch (CoreException exception) {
            SARLEclipsePlugin.getDefault().openError(AgentLaunchShortcut.getShell(), io.sarl.eclipse.util.Messages.AbstractSarlScriptInteractiveSelector_1, exception.getStatus().getMessage(), null, exception);
            return null;
        }
    }

    @Override
    protected boolean isSelectableElement(SarlAgent element) {
        return element != null && !Strings.isNullOrEmpty((String)element.getName());
    }

    @Override
    protected String getElementLabel() {
        return Messages.AgentLaunchShortcut_0;
    }

    @Override
    protected String getElementsLabel() {
        return Messages.AgentLaunchShortcut_1;
    }

    @Override
    protected String getElementLongLabel() {
        return Messages.AgentLaunchShortcut_2;
    }
}

