/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.shortcuts;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.shortcuts.AbstractSarlLaunchShortcut;
import io.sarl.eclipse.launching.shortcuts.Messages;
import io.sarl.eclipse.launching.shortcuts.SarlStandardClasspathProvider;
import io.sarl.lang.sarl.SarlClass;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class ApplicationLaunchShortcut
extends AbstractSarlLaunchShortcut<SarlClass, Object> {
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private ILaunchConfigurationAccessor accessor;

    @Override
    protected URI getResourceURIForValidEObject(Object object) {
        if (object instanceof SarlClass) {
            SarlClass clazz = (SarlClass)object;
            return clazz.eResource().getURI();
        }
        return null;
    }

    @Override
    protected Image getElementImage(Object element) {
        return JavaPluginImages.DESC_OBJS_CLASS.createImage();
    }

    @Override
    protected Class<SarlClass> getValidEObjectType() {
        return SarlClass.class;
    }

    @Override
    protected Class<Object> getValidJavaType() {
        return Object.class;
    }

    @Override
    protected String getQualifiedNameFor(SarlClass element) {
        return this.nameProvider.getFullyQualifiedName((EObject)element).toString();
    }

    @Override
    protected String getConfigurationType() {
        return this.accessor.getApplicationLaunchConfigurationType();
    }

    @Override
    protected String getElementQualifiedName(ILaunchConfiguration configuration) {
        return this.accessor.getMain(configuration);
    }

    @Override
    protected ILaunchConfiguration createConfiguration(String projectName, String fullyQualifiedName) {
        try {
            return this.configurator.newApplicationLaunchConfiguration(projectName, fullyQualifiedName, SarlStandardClasspathProvider.class);
        }
        catch (CoreException exception) {
            SARLEclipsePlugin.getDefault().openError(ApplicationLaunchShortcut.getShell(), io.sarl.eclipse.util.Messages.AbstractSarlScriptInteractiveSelector_1, exception.getStatus().getMessage(), null, exception);
            return null;
        }
    }

    @Override
    protected boolean isSelectableElement(SarlClass element) {
        return element != null && !Strings.isNullOrEmpty((String)element.getName());
    }

    @Override
    protected String getElementLabel() {
        return Messages.ApplicationLaunchShortcut_0;
    }

    @Override
    protected String getElementsLabel() {
        return Messages.ApplicationLaunchShortcut_1;
    }

    @Override
    protected String getElementLongLabel() {
        return Messages.ApplicationLaunchShortcut_2;
    }
}

