/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.shortcuts;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public static final String HAS_AGENT_PROPERTY = "hasAgent";
    public static final String HAS_MAIN_PROPERTY = "hasMain";
    private FileExtensionProvider fileExtensionProvider;

    @Inject
    public void setSarlFileExtension(FileExtensionProvider fileExtensionProvider) {
        this.fileExtensionProvider = fileExtensionProvider;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (HAS_AGENT_PROPERTY.equals(property)) {
            return this.testHasAgent(receiver);
        }
        if (HAS_MAIN_PROPERTY.equals(property)) {
            return this.testHasMain(receiver);
        }
        return false;
    }

    protected boolean testHasAgent(Object receiver) {
        return receiver instanceof IPackageFragment || receiver instanceof IPackageFragmentRoot || this.isInSarlEditor(receiver) || this.isSarlScript(receiver) || this.hasSarlNatureOnProject(receiver);
    }

    protected boolean testHasMain(Object receiver) {
        return this.isSarlScript(receiver) || this.isInSarlEditor(receiver);
    }

    protected boolean isInSarlEditor(Object receiver) {
        if (receiver instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)receiver;
            return this.fileExtensionProvider.isValid(input.getFile().getFileExtension());
        }
        return false;
    }

    protected boolean isSarlScript(Object receiver) {
        if (receiver instanceof IFile) {
            IFile file = (IFile)receiver;
            return this.fileExtensionProvider.isValid(file.getFileExtension());
        }
        return false;
    }

    protected boolean hasSarlNatureOnProject(Object receiver) {
        if (receiver instanceof IJavaProject) {
            IJavaProject project = (IJavaProject)receiver;
            try {
                return project.getProject().hasNature("io.sarl.eclipse.SARLProjectNature");
            }
            catch (CoreException coreException) {
            }
        } else if (receiver instanceof IProject) {
            IProject project = (IProject)receiver;
            try {
                return project.hasNature("io.sarl.eclipse.SARLProjectNature");
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

