/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.shortcuts;

import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.buildpath.SARLClasspathContainerInitializer;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;

public class SarlStandardClasspathProvider
extends StandardClasspathProvider {
    public static final String EXTENSION_IDENTIFIER = SarlStandardClasspathProvider.class.getName();

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] classpath = super.computeUnresolvedClasspath(configuration);
        ISREInstall sre = SARLRuntime.getDefaultSREInstall();
        if (sre != null) {
            IPath containerId = sre.getPreferredClassPathContainerPath();
            if (containerId != null && !containerId.equals((Object)SARLClasspathContainerInitializer.CONTAINER_ID)) {
                IClasspathEntry library = JavaCore.newContainerEntry((IPath)containerId);
                IRuntimeClasspathEntry runtimeEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)library.getPath(), (int)3);
                IRuntimeClasspathEntry[] newClasspath = new IRuntimeClasspathEntry[classpath.length + 1];
                System.arraycopy(classpath, 0, newClasspath, 0, classpath.length);
                newClasspath[classpath.length] = runtimeEntry;
                classpath = newClasspath;
            } else {
                List entries = sre.getClassPathEntries();
                IRuntimeClasspathEntry[] newClasspath = new IRuntimeClasspathEntry[classpath.length + entries.size()];
                System.arraycopy(classpath, 0, newClasspath, 0, classpath.length);
                Iterator iterator = entries.iterator();
                int j = classpath.length;
                while (j < newClasspath.length && iterator.hasNext()) {
                    newClasspath[j] = (IRuntimeClasspathEntry)iterator.next();
                    ++j;
                }
                classpath = newClasspath;
            }
        }
        return classpath;
    }
}

