/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.sreproviding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProvider;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.properties.RuntimeEnvironmentPropertyPage;
import io.sarl.eclipse.runtime.SARLRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class EclipseIDEProjectSREProvider
implements ProjectSREProvider {
    private final boolean projectSpecificConfiguration;
    private final boolean projectUseSystemSRE;
    private final String projectSRE;

    public EclipseIDEProjectSREProvider(IProject project) {
        boolean tmpSpecific = false;
        boolean tmpUseSystem = false;
        String tmpSRE = null;
        if (project != null) {
            try {
                QualifiedName propertyName = RuntimeEnvironmentPropertyPage.qualify("HAS_PROJECT_SPECIFIC");
                tmpSpecific = Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)project.getPersistentProperty(propertyName), (Object)Boolean.FALSE.toString()));
                if (tmpSpecific && !(tmpUseSystem = Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)project.getPersistentProperty(propertyName = RuntimeEnvironmentPropertyPage.qualify("USE_SYSTEM_WIDE_SRE")), (Object)Boolean.FALSE.toString())))) {
                    propertyName = RuntimeEnvironmentPropertyPage.qualify("SRE_INSTALL_ID");
                    tmpSRE = Strings.nullToEmpty((String)project.getPersistentProperty(propertyName));
                }
            }
            catch (CoreException e) {
                SARLEclipsePlugin.getDefault().log(e);
            }
        }
        this.projectSpecificConfiguration = tmpSpecific;
        this.projectUseSystemSRE = tmpUseSystem;
        this.projectSRE = tmpSRE;
    }

    public boolean hasProjectSpecificSREConfiguration() {
        return this.projectSpecificConfiguration;
    }

    public boolean isSystemSREUsed() {
        return this.projectUseSystemSRE;
    }

    public String getSREInstallIdentifier() {
        return this.projectSRE;
    }

    public ISREInstall getProjectSREInstall() {
        ISREInstall sre = null;
        if (this.projectSpecificConfiguration && !this.projectUseSystemSRE && !Strings.isNullOrEmpty((String)this.projectSRE)) {
            sre = SARLRuntime.getSREFromId(this.projectSRE);
        }
        if (sre == null) {
            sre = SARLRuntime.getDefaultSREInstall();
        }
        return sre;
    }
}

