/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.launching.sreproviding;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProvider;
import io.sarl.eclipse.runtime.AbstractSREInstall;
import io.sarl.lang.core.SRE;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JreServiceProjectSREProvider
implements ProjectSREProvider {
    private final String id;
    private final String name;
    private final String location;
    private final String bootstrap;
    private final List<IRuntimeClasspathEntry> classpath;

    public JreServiceProjectSREProvider(String id, String name, String location, String bootstrap, List<IRuntimeClasspathEntry> classpath) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.bootstrap = bootstrap;
        this.classpath = classpath;
    }

    public boolean hasProjectSpecificSREConfiguration() {
        return true;
    }

    public boolean isSystemSREUsed() {
        return false;
    }

    public String getSREInstallIdentifier() {
        return this.id;
    }

    public ISREInstall getProjectSREInstall() {
        return new BootstrappedSREInstall(this.id, this.name, this.location, this.bootstrap, this.classpath);
    }

    private static class BootstrappedSREInstall
    extends AbstractSREInstall {
        private final String location;

        BootstrappedSREInstall(String id, String name, String location, String bootstrap, List<IRuntimeClasspathEntry> classpath) {
            super(id);
            this.setName(name);
            this.location = location;
            this.setBootstrap(bootstrap);
            this.setMainClass(SRE.class.getName());
            this.setClassPathEntries(classpath);
        }

        public String getName() {
            String name = this.getNameNoDefault();
            if (Strings.isNullOrEmpty((String)name)) {
                return this.getLocation();
            }
            return name;
        }

        public String getLocation() {
            return this.location;
        }

        public IPath getPreferredClassPathContainerPath() {
            return null;
        }

        public Map<String, String> getAvailableCommandLineOptions() {
            return Collections.emptyMap();
        }

        public String getSREArguments() {
            return "";
        }

        public String getJVMArguments() {
            return "";
        }

        public void getAsXML(Document document, Element element) throws IOException {
        }

        public void setFromXML(Element element) throws IOException {
        }

        @Override
        protected void resolveDirtyFields(boolean forceSettings) {
        }
    }
}

