/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.log;

import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.log.Messages;
import io.sarl.eclipse.log.SubmitEclipseLogWizard;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.xtext.util.Strings;
import org.osgi.service.prefs.BackingStoreException;

public class IssueInformationPage
extends WizardPage {
    public static final String PREFERENCE_LOGIN = IssueInformationPage.class.getName() + ".githubLogin";
    private static final char ECHO_CHAR = '*';
    private final URL link;
    private Text titleField;
    private Text descriptionField;
    private Text trackerLogin;
    private Text trackerPassword;

    protected IssueInformationPage(URL link) {
        super(Messages.IssueInformationPage_0);
        this.link = link;
        this.setTitle(Messages.SubmitEclipseLogWizard_0);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.link != null) {
            Link linkWidget = new Link(composite, 2048);
            linkWidget.setText(MessageFormat.format(Messages.IssueInformationPage_9, this.link.toString()));
            linkWidget.setFont(composite.getFont());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            linkWidget.setLayoutData((Object)gd);
            linkWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        SubmitEclipseLogWizard cvalue;
                        WizardDialog dialog;
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        browser.openURL(IssueInformationPage.this.link);
                        IWizard wizard = IssueInformationPage.this.getWizard();
                        if (wizard instanceof SubmitEclipseLogWizard && (dialog = (cvalue = (SubmitEclipseLogWizard)wizard).getWizardDialog()) != null) {
                            dialog.close();
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
            });
        }
        SWTFactory.createLabel((Composite)composite, (String)Messages.IssueInformationPage_1, (int)1);
        this.titleField = SWTFactory.createSingleText((Composite)composite, (int)1);
        SWTFactory.createLabel((Composite)composite, (String)Messages.IssueInformationPage_2, (int)1);
        this.descriptionField = SWTFactory.createText((Composite)composite, (int)2626, (int)1);
        this.descriptionField.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel((Composite)composite, (String)Messages.IssueInformationPage_3, (int)1);
        this.trackerLogin = SWTFactory.createSingleText((Composite)composite, (int)1);
        SWTFactory.createLabel((Composite)composite, (String)Messages.IssueInformationPage_4, (int)1);
        this.trackerPassword = SWTFactory.createSingleText((Composite)composite, (int)1);
        this.trackerPassword.setEchoChar('*');
        this.titleField.addModifyListener(listeningEvent -> this.updatePageStatus());
        this.descriptionField.addModifyListener(listeningEvent -> this.updatePageStatus());
        this.trackerLogin.addModifyListener(listeningEvent -> this.updatePageStatus());
        this.trackerPassword.addModifyListener(listeningEvent -> this.updatePageStatus());
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.initFields();
        this.updatePageStatus();
    }

    public String getIssueTitle() {
        return this.titleField.getText();
    }

    public String getIssueDescription() {
        return this.descriptionField.getText();
    }

    public String getGithubLogin() {
        return this.trackerLogin.getText();
    }

    public String getGithubPassword() {
        return this.trackerPassword.getText();
    }

    protected void initFields() {
        IEclipsePreferences prefs = SARLEclipsePlugin.getDefault().getPreferences();
        this.trackerLogin.setText(prefs.get(PREFERENCE_LOGIN, ""));
    }

    protected void updatePageStatus() {
        boolean ok;
        if (Strings.isEmpty((String)this.titleField.getText())) {
            ok = false;
            this.setMessage(Messages.IssueInformationPage_5, 3);
        } else if (Strings.isEmpty((String)this.trackerLogin.getText())) {
            ok = false;
            this.setMessage(Messages.IssueInformationPage_6, 3);
        } else if (Strings.isEmpty((String)this.trackerPassword.getText())) {
            ok = false;
            this.setMessage(Messages.IssueInformationPage_7, 3);
        } else {
            ok = true;
            if (Strings.isEmpty((String)this.descriptionField.getText())) {
                this.setMessage(Messages.IssueInformationPage_8, 2);
            } else {
                this.setMessage(null, 0);
            }
        }
        this.setPageComplete(ok);
    }

    public boolean performFinish() {
        IEclipsePreferences prefs = SARLEclipsePlugin.getDefault().getPreferences();
        String login = this.trackerLogin.getText();
        if (Strings.isEmpty((String)login)) {
            prefs.remove(PREFERENCE_LOGIN);
        } else {
            prefs.put(PREFERENCE_LOGIN, login);
        }
        try {
            prefs.sync();
            return true;
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)e.getLocalizedMessage(), (String)e.getLocalizedMessage(), (IStatus)SARLEclipsePlugin.getDefault().createStatus(4, e));
            return false;
        }
    }
}

