/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.log;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.log.IssueInformationPage;
import io.sarl.eclipse.log.Messages;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.util.Strings;
import org.osgi.util.tracker.ServiceTracker;

public class SubmitEclipseLogWizard
extends Wizard {
    private static final String GITHUB_PUBLIC_URL = "https://github.com/sarl/sarl/issues/new";
    private static final String GITHUB_URL = "https://api.github.com/repos/sarl/sarl/issues";
    private static final int RESPONSE_CODE = 201;
    private IssueInformationPage detailPage;
    private WeakReference<WizardDialog> wizardDialog;

    public SubmitEclipseLogWizard() {
        this.setDefaultPageImageDescriptor(SARLEclipsePlugin.getDefault().getImageDescriptor("icons/sarl_submit_issue_dialog.png"));
        this.setWindowTitle(Messages.SubmitEclipseLogWizard_0);
    }

    public static int open(Shell parentShell) {
        SubmitEclipseLogWizard wizard = new SubmitEclipseLogWizard();
        WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
        wizard.setWizardDialog(dialog);
        return dialog.open();
    }

    void setWizardDialog(WizardDialog dialog) {
        assert (dialog != null);
        this.wizardDialog = new WeakReference<WizardDialog>(dialog);
    }

    WizardDialog getWizardDialog() {
        WeakReference<WizardDialog> ref = this.wizardDialog;
        return ref == null ? null : (WizardDialog)ref.get();
    }

    public void addPages() {
        URL url = null;
        try {
            url = new URI(GITHUB_PUBLIC_URL).toURL();
        }
        catch (Exception exception) {}
        this.detailPage = new IssueInformationPage(url);
        this.addPage((IWizardPage)this.detailPage);
    }

    public boolean performFinish() {
        if (this.detailPage.performFinish()) {
            try {
                String title = this.detailPage.getIssueTitle();
                String description = this.detailPage.getIssueDescription();
                String login = this.detailPage.getGithubLogin();
                String password = this.detailPage.getGithubPassword();
                Job job = Job.create((String)Messages.SubmitEclipseLogWizard_0, monitor -> {
                    try {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_1);
                        Charset charset = Charset.defaultCharset();
                        String content = this.buildContent(description, charset);
                        subMonitor.setWorkRemaining(1);
                        if (subMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        return this.submit(charset, title, content, login, password, (IProgressMonitor)subMonitor.split(1));
                    }
                    catch (Exception exception) {
                        return SARLEclipsePlugin.getDefault().createStatus(4, exception);
                    }
                });
                job.schedule();
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)e.getLocalizedMessage(), (String)e.getLocalizedMessage(), (IStatus)SARLEclipsePlugin.getDefault().createStatus(4, e));
            }
        }
        return false;
    }

    protected IStatus submit(Charset charset, String title, String body, String login, String password, IProgressMonitor progress) throws Exception {
        URL url;
        Object data;
        IProxyData[] iProxyDataArray;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_15);
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson((Object)new GithubIssueJson(title, body));
        subMonitor.setWorkRemaining(9);
        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_2);
        ServiceTracker proxyTracker = new ServiceTracker(SARLEclipsePlugin.getDefault().getBundle().getBundleContext(), IProxyService.class, null);
        proxyTracker.open();
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            IProxyData[] proxyDataForHost;
            URI uri = new URI(GITHUB_URL);
            iProxyDataArray = proxyDataForHost = ((IProxyService)proxyTracker.getService()).select(uri);
            int n = proxyDataForHost.length;
            int n2 = 0;
            while (n2 < n) {
                data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    System.setProperty("http.proxySet", "true");
                    System.setProperty("http.proxyHost", data.getHost());
                }
                if (data.getHost() != null) {
                    System.setProperty("http.proxyPort", String.valueOf(data.getPort()));
                }
                if (subMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ++n2;
            }
            url = uri.toURL();
        }
        finally {
            proxyTracker.close();
        }
        subMonitor.setWorkRemaining(8);
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_3);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        subMonitor.setWorkRemaining(7);
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_4);
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", "SARL IDE");
        String auth = Base64.getEncoder().encodeToString((login + ":" + password).getBytes());
        con.setRequestProperty("Authorization", "Basic " + auth);
        con.setDoOutput(true);
        con.setDoInput(true);
        subMonitor.setWorkRemaining(6);
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        data = null;
        Object var15_19 = null;
        try (DataOutputStream writer = new DataOutputStream(con.getOutputStream());){
            writer.writeBytes(json);
            writer.flush();
        }
        catch (Throwable throwable) {
            if (data == null) {
                data = throwable;
            } else if (data != throwable) {
                ((Throwable)data).addSuppressed(throwable);
            }
            throw data;
        }
        subMonitor.setWorkRemaining(3);
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.setTaskName(Messages.SubmitEclipseLogWizard_6);
        int responseCode = con.getResponseCode();
        StringBuffer response = new StringBuffer();
        Throwable throwable = null;
        iProxyDataArray = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
                if (!subMonitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        subMonitor.setWorkRemaining(0);
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (responseCode != 201) {
            return SARLEclipsePlugin.getDefault().createStatus(4, Messages.SubmitEclipseLogWizard_14, (Throwable)new Exception(response.toString()));
        }
        return Status.OK_STATUS;
    }

    protected String buildContent(String description, Charset charset) throws IOException {
        StringBuilder fullContent = new StringBuilder();
        if (!Strings.isEmpty((String)description)) {
            fullContent.append(description);
            fullContent.append(Messages.SubmitEclipseLogWizard_8);
        }
        SARLEclipsePlugin plugin = SARLEclipsePlugin.getDefault();
        plugin.getLog().log(plugin.createStatus(1, Messages.SubmitEclipseLogWizard_12));
        fullContent.append(Messages.SubmitEclipseLogWizard_9);
        String filename = Platform.getLogFileLocation().toOSString();
        File log = new File(filename);
        if (!log.exists()) {
            throw new IOException("Unable to find the log file");
        }
        List logLines = Files.readLines((File)log, (Charset)charset);
        int logStartIndex = -1;
        int i = logLines.size() - 1;
        while (logStartIndex == -1 && i >= 0) {
            String line = (String)logLines.get(i);
            if (line.startsWith("!SESSION")) {
                logStartIndex = i;
            }
            --i;
        }
        i = logStartIndex;
        while (i < logLines.size()) {
            fullContent.append((String)logLines.get(i));
            fullContent.append(Messages.SubmitEclipseLogWizard_8);
            ++i;
        }
        fullContent.append(Messages.SubmitEclipseLogWizard_10);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            fullContent.append(Objects.toString(entry.getKey()));
            fullContent.append(Messages.SubmitEclipseLogWizard_11);
            fullContent.append(Objects.toString(entry.getValue()));
            fullContent.append(Messages.SubmitEclipseLogWizard_8);
        }
        fullContent.append(Messages.SubmitEclipseLogWizard_13);
        return fullContent.toString();
    }

    public static class GithubIssueJson {
        private final String title;
        private final String body;

        public GithubIssueJson(String title, String body) {
            this.title = title;
            this.body = body;
        }

        public String getTitle() {
            return this.title;
        }

        public String getBody() {
            return this.body;
        }
    }
}

