/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.natures;

import com.google.inject.Inject;
import io.sarl.eclipse.natures.IProjectUnconfigurator;
import io.sarl.eclipse.natures.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveSarlNatureHandler
extends AbstractHandler {
    @Inject
    private IProjectUnconfigurator configurator;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (Object obj : structuredSelection) {
                if (obj instanceof IJavaProject) {
                    IJavaProject cvalue = (IJavaProject)obj;
                    projects.add(cvalue.getProject());
                    continue;
                }
                if (!(obj instanceof IProject)) continue;
                IProject cvalue = (IProject)obj;
                projects.add(cvalue);
            }
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            this.convertAllWithProgress(activeShell, projects);
        }
        return null;
    }

    private boolean convertAllWithProgress(Shell shell, final List<IProject> projects) throws ExecutionException {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.RemoveSarlNatureHandler_0, projects.size());
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
                try {
                    try {
                        for (IProject project : projects) {
                            RemoveSarlNatureHandler.this.doConvert(project, (IProgressMonitor)mon.newChild(1));
                        }
                    }
                    catch (ExecutionException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InvocationTargetException exception) {
            throw new ExecutionException(MessageFormat.format(Messages.RemoveSarlNatureHandler_1, exception.getLocalizedMessage()), (Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return false;
    }

    protected void doConvert(IProject project, IProgressMonitor monitor) throws ExecutionException {
        monitor.setTaskName(MessageFormat.format(Messages.RemoveSarlNatureHandler_2, project.getName()));
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.configurator.canUnconfigure(project, (IProgressMonitor)mon.newChild(1))) {
            try {
                this.configurator.unconfigure(project, (IProgressMonitor)mon.newChild(1));
            }
            catch (CoreException exception) {
                throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        monitor.done();
    }
}

