/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.natures;

import com.google.common.base.Strings;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.sarl.apputils.eclipseextensions.buildpath.SARLFolderComparator;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectConfigurationFragment;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectConfigurationFragments;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectFolderAccessor;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectFolderAccessors;
import io.sarl.apputils.uiextensions.Bundles;
import io.sarl.apputils.uiextensions.ProjectNatures;
import io.sarl.eclipse.SARLEclipseExecutableExtensionFactory;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.buildpath.SARLClasspathContainerInitializer;
import io.sarl.eclipse.natures.IProjectUnconfigurator;
import io.sarl.eclipse.natures.Messages;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.ui.preferences.SARLPreferences;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class SARLProjectConfigurator
implements ProjectConfigurator,
IProjectUnconfigurator {
    private final String fileExtension;
    private final Collection<String> candidates;

    public SARLProjectConfigurator() {
        Injector injector = SARLEclipseExecutableExtensionFactory.getSARLInjector();
        String fileExtension = SarlUtils.getMajorFileExtension((String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"file.extensions")))));
        this.fileExtension = Strings.isNullOrEmpty((String)fileExtension) ? null : "." + fileExtension;
        injector.injectMembers((Object)this);
        this.candidates = new ArrayList<String>();
        this.candidates.addAll(Arrays.asList(Bundles.SRC_FOLDERS));
        this.candidates.add("src/test/sarl");
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        LinkedHashSet<File> projectFolders = new LinkedHashSet<File>();
        if (this.fileExtension != null) {
            HashSet<String> visitedDirectories = new HashSet<String>();
            this.collectProjectFoldersFromDirectory(projectFolders, root, visitedDirectories, true, monitor);
        }
        return projectFolders;
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile((IPath)new Path(".project")).exists();
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        LinkedHashSet<IFolder> ignoredFolders = new LinkedHashSet<IFolder>();
        String[] stringArray = Bundles.BIN_FOLDERS;
        int n = Bundles.BIN_FOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String binPath = stringArray[n2];
            ignoredFolders.add(project.getFolder(Path.fromPortableString((String)binPath)));
            ++n2;
        }
        ignoredFolders.add(project.getFolder(Path.fromPortableString((String)"src/main/resources")));
        ignoredFolders.add(project.getFolder(Path.fromPortableString((String)"src/main/generated-sources/sarl")));
        ignoredFolders.add(project.getFolder(Path.fromPortableString((String)"src-gen")));
        ignoredFolders.add(project.getFolder(Path.fromPortableString((String)"src/test/generated-sources/sarl")));
        return ignoredFolders;
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        try {
            boolean bl = project != null && !project.hasNature("io.sarl.eclipse.SARLProjectNature");
            return bl;
        }
        catch (CoreException coreException) {
            return false;
        }
        finally {
            monitor.done();
        }
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        try {
            SARLProjectConfigurator.configureSARLProject(project, true, true, true, monitor);
            this.safeRefresh(project, monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean canUnconfigure(IProject project, IProgressMonitor monitor) {
        try {
            boolean bl = project != null && project.hasNature("io.sarl.eclipse.SARLProjectNature");
            return bl;
        }
        catch (CoreException coreException) {
            return false;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void unconfigure(IProject project, IProgressMonitor monitor) throws CoreException {
        block5: {
            try {
                List fragments = ProjectConfigurationFragments.getConfigurationFragmentsFromExtension();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(4 + fragments.size()));
                IProjectDescription description = project.getDescription();
                LinkedList<String> natures = new LinkedList<String>(Arrays.asList(description.getNatureIds()));
                natures.remove("org.eclipse.xtext.ui.shared.xtextNature");
                natures.remove("io.sarl.eclipse.SARLProjectNature");
                for (ProjectConfigurationFragment fragment : fragments) {
                    fragment.unconfigure(project, (IProgressMonitor)mon.newChild(1), natures);
                }
                String[] newNatures = natures.toArray(new String[natures.size()]);
                mon.worked(1);
                IStatus status = ResourcesPlugin.getWorkspace().validateNatureSet(newNatures);
                mon.worked(1);
                if (status.getCode() == 0) {
                    description.setNatureIds(newNatures);
                    project.setDescription(description, (IProgressMonitor)mon.newChild(1));
                    this.safeRefresh(project, (IProgressMonitor)mon.newChild(1));
                    break block5;
                }
                throw new CoreException(status);
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void safeRefresh(IProject project, IProgressMonitor monitor) {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException exception) {
            SARLEclipsePlugin.getDefault().log(exception);
        }
    }

    public static String[] getSARLProjectSourceFolders() {
        return new String[]{"src/main/sarl", "src/main/java", "src/main/resources", "src/test/sarl", "src/it/sarl", "src/main/generated-sources/sarl", "src/test/generated-sources/sarl"};
    }

    public static String[] getSARLProjectBinFolders() {
        return new String[]{"target/classes", "target/test-classes"};
    }

    public static void configureSARLProject(IProject project, boolean addNatures, boolean configureJavaNature, boolean createFolders, IProgressMonitor monitor) {
        try {
            IFolder testGenerationFolderFolder;
            List fragments = ProjectConfigurationFragments.getConfigurationFragmentsFromExtension();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
            IStatus status = Status.OK_STATUS;
            if (addNatures) {
                SARLProjectConfigurator.addSarlNatures(project, (IProgressMonitor)subMonitor.newChild(1));
                if (status != null && !status.isOK()) {
                    SARLEclipsePlugin.getDefault().getLog().log(status);
                }
                if (!fragments.isEmpty()) {
                    SubMonitor subprogress = subMonitor.newChild(1);
                    subprogress.setWorkRemaining(fragments.size());
                    for (ProjectConfigurationFragment fragment : fragments) {
                        fragment.updateNatures(project, (IProgressMonitor)subprogress.newChild(1));
                    }
                    subprogress.worked(fragments.size());
                }
            }
            TreeSet<IFolder> sourceFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> testSourceFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> generationFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> testGenerationFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            OutParameter generationFolder = new OutParameter();
            OutParameter testGenerationFolder = new OutParameter();
            OutParameter outputFolder = new OutParameter();
            OutParameter testOutputFolder = new OutParameter();
            SARLProjectConfigurator.ensureSourceFolders(project, createFolders, subMonitor, sourceFolders, testSourceFolders, generationFolders, testGenerationFolders, (OutParameter<IFolder>)generationFolder, (OutParameter<IFolder>)testGenerationFolder, (OutParameter<IFolder>)outputFolder, (OutParameter<IFolder>)testOutputFolder);
            if (!fragments.isEmpty()) {
                SubMonitor subprogress = subMonitor.newChild(1);
                subprogress.setWorkRemaining(fragments.size());
                for (ProjectConfigurationFragment fragment : fragments) {
                    fragment.updateSourceFolders(project, createFolders, (IProgressMonitor)subprogress.newChild(1), sourceFolders, testSourceFolders, generationFolders, testGenerationFolders);
                }
                subprogress.worked(fragments.size());
            }
            IPath testGenerationFolderPath = (testGenerationFolderFolder = (IFolder)testGenerationFolder.get()) == null ? null : testGenerationFolderFolder.getProjectRelativePath();
            SARLPreferences.setSpecificSARLConfigurationFor((IProject)project, (IPath)((IFolder)generationFolder.get()).getProjectRelativePath(), (IPath)testGenerationFolderPath);
            subMonitor.worked(1);
            if (!fragments.isEmpty()) {
                SubMonitor subprogress = subMonitor.newChild(1);
                subprogress.setWorkRemaining(fragments.size());
                for (ProjectConfigurationFragment fragment : fragments) {
                    fragment.updateSpecificConfiguration(project, (IProgressMonitor)subprogress.newChild(1), ((IFolder)generationFolder.get()).getProjectRelativePath(), testGenerationFolderPath);
                }
                subprogress.worked(fragments.size());
            }
            if (configureJavaNature) {
                if (!addNatures) {
                    ProjectNatures.addNatures((IProject)project, (IProgressMonitor)subMonitor.newChild(1), (String[])new String[]{"org.eclipse.jdt.core.javanature"});
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                subMonitor.worked(1);
                BuildPathsBlock.flush(SARLProjectConfigurator.buildClassPathEntries(javaProject, (IFolder[])sourceFolders.toArray(IFolder[]::new), (IFolder[])testSourceFolders.toArray(IFolder[]::new), (IFolder[])generationFolders.toArray(IFolder[]::new), (IFolder[])testGenerationFolders.toArray(IFolder[]::new), ((IFolder)testOutputFolder.get()).getFullPath(), false, true), (IPath)((IFolder)outputFolder.get()).getFullPath(), (IJavaProject)javaProject, null, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
        catch (CoreException exception) {
            SARLEclipsePlugin.getDefault().log(exception);
        }
    }

    private static void ensureSourceFolders(IProject project, boolean createFolders, SubMonitor monitor, SortedSet<IFolder> sourcePaths, SortedSet<IFolder> testSourcePaths, SortedSet<IFolder> generationPaths, SortedSet<IFolder> testGenerationPaths, OutParameter<IFolder> standardGenerationFolder, OutParameter<IFolder> testingGenerationFolder, OutParameter<IFolder> classOutput, OutParameter<IFolder> testClassOutput) throws CoreException {
        Optional projectFolderAccessorOpt = ProjectFolderAccessors.getProjectFolderAccessorStreamFromExtension().findAny();
        if (projectFolderAccessorOpt.isEmpty()) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, "Unable to acquire a Project Folder Accessor"));
        }
        ProjectFolderAccessor projectFolderAccessor = (ProjectFolderAccessor)projectFolderAccessorOpt.get();
        IFolder sourceSarlFolder = projectFolderAccessor.ensureSourceFolder(project, "src/main/sarl", true, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder sourceJavaFolder = projectFolderAccessor.ensureSourceFolder(project, "src/main/java", false, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder resourcesFolder = projectFolderAccessor.ensureSourceFolder(project, "src/main/resources", false, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder testSourceSarlFolder = projectFolderAccessor.ensureSourceFolder(project, "src/test/sarl", false, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder generationFolder = projectFolderAccessor.ensureGeneratedSourceFolder(project, "src/main/generated-sources/sarl", true, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder testGenerationFolder = projectFolderAccessor.ensureGeneratedSourceFolder(project, "src/test/generated-sources/sarl", false, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder outputFolder = projectFolderAccessor.ensureOutputFolder(project, "target/classes", true, createFolders, (IProgressMonitor)monitor.newChild(1));
        IFolder testOutputFolder = projectFolderAccessor.ensureOutputFolder(project, "target/test-classes", true, createFolders, (IProgressMonitor)monitor.newChild(1));
        if (sourcePaths != null) {
            assert (sourceSarlFolder != null) : "sourceSarlFolder must not be null";
            if (sourceJavaFolder != null) {
                if (resourcesFolder != null) {
                    sourcePaths.add(sourceSarlFolder);
                    sourcePaths.add(sourceJavaFolder);
                    sourcePaths.add(resourcesFolder);
                } else {
                    sourcePaths.add(sourceSarlFolder);
                    sourcePaths.add(sourceJavaFolder);
                }
            } else if (resourcesFolder != null) {
                sourcePaths.add(sourceSarlFolder);
                sourcePaths.add(resourcesFolder);
            } else {
                sourcePaths.add(sourceSarlFolder);
            }
        }
        if (testSourcePaths != null && testSourceSarlFolder != null) {
            testSourcePaths.add(testSourceSarlFolder);
        }
        if (generationPaths != null) {
            assert (generationFolder != null) : "generationFolder must not be null";
            generationPaths.add(generationFolder);
        }
        if (testGenerationPaths != null && testGenerationFolder != null) {
            testGenerationPaths.add(testGenerationFolder);
        }
        if (standardGenerationFolder != null) {
            assert (generationFolder != null) : "generationFolder must not be null";
            standardGenerationFolder.set((Object)generationFolder);
        }
        if (testingGenerationFolder != null && testGenerationFolder != null) {
            testingGenerationFolder.set((Object)testGenerationFolder);
        }
        if (classOutput != null) {
            assert (outputFolder != null) : "outputFolder must not be null";
            classOutput.set((Object)outputFolder);
        }
        if (testClassOutput != null) {
            assert (testOutputFolder != null) : "testOutputFolder must not be null";
            testClassOutput.set((Object)testOutputFolder);
        }
    }

    public static void configureSARLSourceFolders(IProject project, boolean createFolders, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
            TreeSet<IFolder> sourceFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> testSourceFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> generationFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            TreeSet<IFolder> testGenerationFolders = new TreeSet<IFolder>((Comparator<IFolder>)SARLFolderComparator.getSingleton());
            OutParameter testOutputFolder = new OutParameter();
            SARLProjectConfigurator.ensureSourceFolders(project, createFolders, subMonitor, sourceFolders, testSourceFolders, generationFolders, testGenerationFolders, null, null, null, (OutParameter<IFolder>)testOutputFolder);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            subMonitor.worked(1);
            BuildPathsBlock.flush(SARLProjectConfigurator.buildClassPathEntries(javaProject, (IFolder[])sourceFolders.toArray(IFolder[]::new), (IFolder[])testSourceFolders.toArray(IFolder[]::new), (IFolder[])generationFolders.toArray(IFolder[]::new), (IFolder[])testGenerationFolders.toArray(IFolder[]::new), ((IFolder)testOutputFolder.get()).getFullPath(), true, false), (IPath)javaProject.getOutputLocation(), (IJavaProject)javaProject, null, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
        catch (CoreException exception) {
            SARLEclipsePlugin.getDefault().log(exception);
        }
    }

    public static List<IClasspathEntry> getDefaultSourceClassPathEntries(IPath projectFolder) {
        IPath srcJava = projectFolder.append(Path.fromPortableString((String)"src/main/java"));
        IClasspathEntry srcJavaEntry = JavaCore.newSourceEntry((IPath)srcJava.makeAbsolute());
        IPath srcSarl = projectFolder.append(Path.fromPortableString((String)"src/main/sarl"));
        IClasspathEntry srcSarlEntry = JavaCore.newSourceEntry((IPath)srcSarl.makeAbsolute());
        IPath srcGeneratedSources = projectFolder.append(Path.fromPortableString((String)"src/main/generated-sources/sarl"));
        IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)Boolean.TRUE.toString());
        IClasspathEntry srcGeneratedSourcesEntry = JavaCore.newSourceEntry((IPath)srcGeneratedSources.makeAbsolute(), (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, null, (IClasspathAttribute[])new IClasspathAttribute[]{attr});
        IPath srcResources = projectFolder.append(Path.fromPortableString((String)"src/main/resources"));
        IClasspathEntry srcResourcesEntry = JavaCore.newSourceEntry((IPath)srcResources.makeAbsolute());
        return Arrays.asList(srcSarlEntry, srcJavaEntry, srcResourcesEntry, srcGeneratedSourcesEntry);
    }

    private static List<CPListElement> buildClassPathEntries(IJavaProject project, IFolder[] sourcePaths, IFolder[] testSourcePaths, IFolder[] generationPaths, IFolder[] testGenerationPaths, IPath testOutputPath, boolean keepProjectClasspath, boolean addSarllLibraries) {
        IClasspathEntry entry;
        IClasspathAttribute attr0;
        IPath filename;
        IFolder sourcePath;
        ArrayList<CPListElement> list = new ArrayList<CPListElement>();
        TreeSet<String> added = new TreeSet<String>();
        IFolder[] iFolderArray = sourcePaths;
        int n = sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            sourcePath = iFolderArray[n2];
            if (sourcePath != null && added.add((filename = sourcePath.getFullPath().makeAbsolute()).toPortableString())) {
                IClasspathEntry entry2 = JavaCore.newSourceEntry((IPath)filename, (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, null);
                list.add(CPListElement.create((IClasspathEntry)entry2, (boolean)false, (IJavaProject)project));
            }
            ++n2;
        }
        iFolderArray = testSourcePaths;
        n = testSourcePaths.length;
        n2 = 0;
        while (n2 < n) {
            sourcePath = iFolderArray[n2];
            if (sourcePath != null && added.add((filename = sourcePath.getFullPath().makeAbsolute()).toPortableString())) {
                attr0 = JavaCore.newClasspathAttribute((String)"test", (String)Boolean.TRUE.toString());
                entry = JavaCore.newSourceEntry((IPath)filename, (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, (IPath)testOutputPath, (IClasspathAttribute[])new IClasspathAttribute[]{attr0});
                list.add(CPListElement.create((IClasspathEntry)entry, (boolean)false, (IJavaProject)project));
            }
            ++n2;
        }
        iFolderArray = generationPaths;
        n = generationPaths.length;
        n2 = 0;
        while (n2 < n) {
            sourcePath = iFolderArray[n2];
            if (sourcePath != null && added.add((filename = sourcePath.getFullPath().makeAbsolute()).toPortableString())) {
                IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)Boolean.TRUE.toString());
                entry = JavaCore.newSourceEntry((IPath)filename, (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, null, (IClasspathAttribute[])new IClasspathAttribute[]{attr});
                list.add(CPListElement.create((IClasspathEntry)entry, (boolean)false, (IJavaProject)project));
            }
            ++n2;
        }
        iFolderArray = testGenerationPaths;
        n = testGenerationPaths.length;
        n2 = 0;
        while (n2 < n) {
            sourcePath = iFolderArray[n2];
            if (sourcePath != null && added.add((filename = sourcePath.getFullPath().makeAbsolute()).toPortableString())) {
                attr0 = JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)Boolean.TRUE.toString());
                IClasspathAttribute attr1 = JavaCore.newClasspathAttribute((String)"test", (String)Boolean.TRUE.toString());
                IClasspathEntry entry3 = JavaCore.newSourceEntry((IPath)filename, (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, (IPath)testOutputPath, (IClasspathAttribute[])new IClasspathAttribute[]{attr0, attr1});
                list.add(CPListElement.create((IClasspathEntry)entry3, (boolean)false, (IJavaProject)project));
            }
            ++n2;
        }
        if (addSarllLibraries) {
            iFolderArray = PreferenceConstants.getDefaultJRELibrary();
            n = iFolderArray.length;
            n2 = 0;
            while (n2 < n) {
                IFolder current = iFolderArray[n2];
                if (current != null && added.add(current.getPath().toPortableString())) {
                    list.add(CPListElement.create((IClasspathEntry)current, (boolean)true, (IJavaProject)project));
                    break;
                }
                ++n2;
            }
            if (added.add(SARLClasspathContainerInitializer.CONTAINER_ID.toPortableString())) {
                list.add(CPListElement.create((IClasspathEntry)JavaCore.newContainerEntry((IPath)SARLClasspathContainerInitializer.CONTAINER_ID), (boolean)true, (IJavaProject)project));
            }
        }
        if (keepProjectClasspath) {
            try {
                iFolderArray = project.getRawClasspath();
                n = iFolderArray.length;
                n2 = 0;
                while (n2 < n) {
                    IFolder entry4 = iFolderArray[n2];
                    if (added.add(entry4.getPath().toPortableString())) {
                        list.add(CPListElement.create((IClasspathEntry)entry4, (boolean)false, (IJavaProject)project));
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                SARLEclipsePlugin.getDefault().log(exception);
            }
        }
        return list;
    }

    protected void collectProjectFoldersFromDirectory(Collection<File> folders, File directory, Set<String> directoriesVisited, boolean nestedProjects, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(NLS.bind((String)Messages.SARLProjectConfigurator_0, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return;
        }
        Set<String> visited = directoriesVisited;
        if (visited == null) {
            visited = new HashSet<String>();
            try {
                visited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        LinkedHashSet<File> subdirectories = new LinkedHashSet<File>();
        File[] fileArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File rootFile;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                subdirectories.add(file);
            } else if (file.getName().endsWith(this.fileExtension) && (rootFile = this.getProjectFolderForSourceFolder(file.getParentFile())) != null) {
                folders.add(rootFile);
                return;
            }
            ++n2;
        }
        for (File subdir : subdirectories) {
            try {
                String canonicalPath = subdir.getCanonicalPath();
                if (!visited.add(canonicalPath)) {
                    continue;
                }
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
            this.collectProjectFoldersFromDirectory(folders, subdir, visited, nestedProjects, monitor);
        }
    }

    private File getProjectFolderForSourceFolder(File file) {
        IPath filePath = Path.fromOSString((String)file.getAbsolutePath());
        for (String rawPath : this.candidates) {
            IPath path = Path.fromPortableString((String)rawPath);
            IPath parent = null;
            Object fp = (IPath)filePath.clone();
            while (fp != null) {
                if (path.isPrefixOf(fp)) {
                    if (parent == null) {
                        return file.getParentFile();
                    }
                    return parent.toFile();
                }
                parent = parent == null ? Path.fromPortableString((String)("/" + fp.segment(0))) : parent.append(fp.segment(0));
                fp = fp.segmentCount() > 1 ? fp.removeFirstSegments(1) : null;
            }
        }
        return null;
    }

    public static String[] getSarlNatures() {
        return new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.xtext.ui.shared.xtextNature", "io.sarl.eclipse.SARLProjectNature"};
    }

    public static IStatus addSarlNatures(IProject project, IProgressMonitor monitor) {
        return ProjectNatures.addNatures((IProject)project, (IProgressMonitor)monitor, (String[])SARLProjectConfigurator.getSarlNatures());
    }
}

