/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.preferences;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.uiextensions.Utilities;
import io.sarl.eclipse.preferences.Messages;
import io.sarl.eclipse.runtime.ISREInstallChangedListener;
import io.sarl.eclipse.runtime.SARLRuntime;
import io.sarl.eclipse.wizards.sreinstall.AddSREInstallWizard;
import io.sarl.eclipse.wizards.sreinstall.EditSREInstallWizard;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SREsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionProvider {
    public static final String ID = "io.sarl.eclipse.preferences.SREsPreferencePage";
    private static final int WRAP_WIDTH = 300;
    private static final int WIDTH_HINT = 350;
    private static final int HEIGHT_HINT = 250;
    private static final int DEFAULT_WIDTH = 117;
    private Table sreTable;
    private CheckboxTableViewer sresList;
    private final InstallListener installListener = new InstallListener();
    private final List<ISREInstall> sreArray = new ArrayList<ISREInstall>();
    private final ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private ISelection prevSelection = new StructuredSelection();
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private Button copyButton;
    private Button resetButton;
    private Column sortColumn = Column.NAME;

    protected void refreshSREListUI() {
        Display display = Display.getDefault();
        if (display.getThread().equals(Thread.currentThread())) {
            if (!this.sresList.isBusy()) {
                this.sresList.refresh();
            }
        } else {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!SREsPreferencePage.this.sresList.isBusy()) {
                        SREsPreferencePage.this.sresList.refresh();
                    }
                }
            });
        }
    }

    public void setErrorMessage(Throwable exception) {
        if (exception != null) {
            String message = exception.getLocalizedMessage();
            if (Strings.isNullOrEmpty((String)message)) {
                message = exception.getMessage();
            }
            if (Strings.isNullOrEmpty((String)message)) {
                message = MessageFormat.format(Messages.SREsPreferencePage_9, exception.getClass().getName());
            }
            this.setErrorMessage(message);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ISREInstall[] sres;
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        parent.setLayout((Layout)layout);
        SWTFactory.createWrapLabel((Composite)parent, (String)Messages.SREsPreferencePage_0, (int)1, (int)300);
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        SWTFactory.createWrapLabel((Composite)parent, (String)Messages.SREsPreferencePage_1, (int)1, (int)300);
        Font font = parent.getFont();
        Composite listComposite = SWTFactory.createComposite((Composite)parent, (Font)font, (int)2, (int)1, (int)1808);
        this.sreTable = new Table(listComposite, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.sreTable.setLayoutData((Object)gd);
        this.sreTable.setFont(font);
        this.sreTable.setHeaderVisible(true);
        this.sreTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.sreTable, 0);
        column.setText(Messages.SREsPreferencePage_2);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SREsPreferencePage.this.sortByName();
                SREsPreferencePage.this.sresList.refresh(true);
            }
        });
        column.setWidth(117);
        column = new TableColumn(this.sreTable, 0);
        column.setText(Messages.SREsPreferencePage_3);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SREsPreferencePage.this.sortByLocation();
                SREsPreferencePage.this.sresList.refresh(true);
            }
        });
        column.setWidth(117);
        this.sresList = new CheckboxTableViewer(this.sreTable);
        this.sresList.setLabelProvider((IBaseLabelProvider)new SRELabelProvider());
        this.sresList.setContentProvider((IContentProvider)new SREsContentProvider());
        this.sresList.setUseHashlookup(true);
        this.sresList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                SREsPreferencePage.this.enableButtons();
            }
        });
        this.sresList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    SREsPreferencePage.this.setDefaultSRE((ISREInstall)event.getElement());
                } else {
                    SREsPreferencePage.this.setDefaultSRE(null);
                }
            }
        });
        this.sresList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SREsPreferencePage.this.sresList.getSelection().isEmpty()) {
                    SREsPreferencePage.this.editSRE();
                }
            }
        });
        this.sreTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && SREsPreferencePage.this.removeButton.isEnabled()) {
                    SREsPreferencePage.this.removeSREs();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)listComposite, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.addButton = SWTFactory.createPushButton((Composite)buttons, (String)Messages.SREsPreferencePage_4, null);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SREsPreferencePage.this.addSRE();
            }
        });
        this.editButton = SWTFactory.createPushButton((Composite)buttons, (String)Messages.SREsPreferencePage_5, null);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SREsPreferencePage.this.editSRE();
            }
        });
        this.copyButton = SWTFactory.createPushButton((Composite)buttons, (String)Messages.SREsPreferencePage_6, null);
        this.copyButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SREsPreferencePage.this.copySRE();
            }
        });
        this.removeButton = SWTFactory.createPushButton((Composite)buttons, (String)Messages.SREsPreferencePage_7, null);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SREsPreferencePage.this.removeSREs();
            }
        });
        this.resetButton = SWTFactory.createPushButton((Composite)buttons, (String)Messages.SREsPreferencePage_10, null);
        this.resetButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                SREsPreferencePage.this.resetSREs();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)listComposite, (int)1);
        ISREInstall[] iSREInstallArray = sres = SARLRuntime.getSREInstalls();
        int n = sres.length;
        int n2 = 0;
        while (n2 < n) {
            ISREInstall sre = iSREInstallArray[n2];
            sre.revalidate();
            ++n2;
        }
        this.setSREs(sres);
        this.setDefaultSRE(SARLRuntime.getDefaultSREInstall());
        this.restoreColumnSettings(JavaPlugin.getDefault().getDialogSettings());
        this.enableButtons();
        SARLRuntime.addSREInstallChangedListener(this.installListener);
        this.applyDialogFont(parent);
        return parent;
    }

    protected void setSREs(ISREInstall[] sres) {
        this.sreArray.clear();
        ISREInstall[] iSREInstallArray = sres;
        int n = sres.length;
        int n2 = 0;
        while (n2 < n) {
            ISREInstall sre = iSREInstallArray[n2];
            this.sreArray.add(sre);
            ++n2;
        }
        this.sresList.setInput(this.sreArray);
        this.refreshSREListUI();
        this.updateUI();
    }

    public ISREInstall[] getSREs() {
        return this.sreArray.toArray(new ISREInstall[this.sreArray.size()]);
    }

    private boolean isDuplicateName(String name) {
        String sreName = Strings.nullToEmpty((String)name);
        for (ISREInstall sre : this.sreArray) {
            if (!sreName.equals(sre.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateId(String id) {
        String normalizedId = Strings.nullToEmpty((String)id);
        for (ISREInstall sre : this.sreArray) {
            if (!normalizedId.equals(sre.getId())) continue;
            return true;
        }
        return false;
    }

    private String createUniqueIdentifier() {
        String id = SARLRuntime.createUniqueIdentifier();
        while (this.isDuplicateId(id)) {
            id = SARLRuntime.createUniqueIdentifier();
        }
        return id;
    }

    public String createUniqueName(String name) {
        if (!this.isDuplicateName(name)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = name.substring(0, start + 1) + (numericValue + 1) + ")";
            return this.createUniqueName(newName);
        }
        return this.createUniqueName(name + " (1)");
    }

    protected void addSRE() {
        ISREInstall result;
        AddSREInstallWizard wizard = new AddSREInstallWizard(this.createUniqueIdentifier(), this.sreArray.toArray(new ISREInstall[this.sreArray.size()]));
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (result = wizard.getCreatedSRE()) != null) {
            this.sreArray.add(result);
            this.refreshSREListUI();
            this.sresList.setSelection((ISelection)new StructuredSelection((Object)result));
            if (!this.sresList.isBusy()) {
                this.sresList.refresh(true);
            }
            this.updateUI();
            if (this.getDefaultSRE() == null) {
                this.setDefaultSRE(result);
            }
        }
    }

    protected void editSRE() {
        IStructuredSelection selection = (IStructuredSelection)this.sresList.getSelection();
        ISREInstall sre = (ISREInstall)selection.getFirstElement();
        if (sre == null) {
            return;
        }
        EditSREInstallWizard wizard = new EditSREInstallWizard(sre, this.sreArray.toArray(new ISREInstall[this.sreArray.size()]));
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.sresList.setSelection((ISelection)new StructuredSelection((Object)sre));
            this.sresList.refresh(true);
            this.updateUI();
        }
    }

    protected void copySRE() {
        IStructuredSelection selection = (IStructuredSelection)this.sresList.getSelection();
        Iterator it = selection.iterator();
        ArrayList<ISREInstall> newEntries = new ArrayList<ISREInstall>();
        while (it.hasNext()) {
            ISREInstall selectedSRE = (ISREInstall)it.next();
            ISREInstall copy = selectedSRE.copy(this.createUniqueIdentifier());
            copy.setName(this.createUniqueName(selectedSRE.getName()));
            EditSREInstallWizard wizard = new EditSREInstallWizard(copy, this.sreArray.toArray(new ISREInstall[this.sreArray.size()]));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            int dlgResult = dialog.open();
            if (dlgResult == 0) {
                newEntries.add(copy);
                continue;
            }
            assert (dlgResult == 1);
            break;
        }
        if (!newEntries.isEmpty()) {
            this.sreArray.addAll(newEntries);
            this.refreshSREListUI();
            this.sresList.setSelection((ISelection)new StructuredSelection(newEntries.toArray()));
        } else {
            this.sresList.setSelection((ISelection)selection);
        }
        this.sresList.refresh(true);
        this.updateUI();
    }

    protected void removeSREs() {
        IStructuredSelection selection = (IStructuredSelection)this.sresList.getSelection();
        ISREInstall[] vms = new ISREInstall[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            vms[i] = (ISREInstall)iter.next();
            ++i;
        }
        this.removeSREs(vms);
    }

    public void removeSREs(ISREInstall ... sres) {
        ISREInstall defaultSRE = this.getDefaultSRE();
        String defaultId = defaultSRE == null ? null : defaultSRE.getId();
        int defaultIndex = -1;
        if (defaultId != null) {
            int i = 0;
            while (defaultIndex == -1 && i < this.sreTable.getItemCount()) {
                if (defaultId.equals(((ISREInstall)this.sreTable.getItem(i).getData()).getId())) {
                    defaultIndex = i;
                }
                ++i;
            }
        }
        String normedDefaultId = Strings.nullToEmpty((String)defaultId);
        boolean defaultIsRemoved = false;
        ISREInstall[] iSREInstallArray = sres;
        int n = sres.length;
        int n2 = 0;
        while (n2 < n) {
            ISREInstall sre = iSREInstallArray[n2];
            if (this.sreArray.remove(sre) && sre.getId().equals(normedDefaultId)) {
                defaultIsRemoved = true;
            }
            ++n2;
        }
        this.refreshSREListUI();
        if (defaultIsRemoved) {
            if (this.sreTable.getItemCount() == 0) {
                this.setSelection(null);
            } else {
                if (defaultIndex < 0) {
                    defaultIndex = 0;
                } else if (defaultIndex >= this.sreTable.getItemCount()) {
                    defaultIndex = this.sreTable.getItemCount() - 1;
                }
                this.setSelection((ISelection)new StructuredSelection(this.sreTable.getItem(defaultIndex).getData()));
            }
        }
        this.sresList.refresh(true);
        if (defaultIsRemoved) {
            this.fireDefaultSREChanged();
        }
        this.updateUI();
    }

    protected void resetSREs() {
        try {
            SARLRuntime.reset();
        }
        catch (CoreException e) {
            this.setErrorMessage(e);
        }
    }

    private boolean verifyValidity(ISREInstall sre, boolean errorMessages) {
        if (!sre.getValidity().isOK()) {
            if (errorMessages) {
                this.setErrorMessage(MessageFormat.format(io.sarl.eclipse.launching.dialog.Messages.RuntimeEnvironmentTab_5, sre.getName()));
            }
            return false;
        }
        Bundle bundle = Platform.getBundle((String)"io.sarl.lang");
        if (bundle != null) {
            Version maxVersion;
            Version minVersion;
            Version sarlVersion = bundle.getVersion();
            int cmp = Utilities.compareVersionToRange((Version)sarlVersion, (Version)(minVersion = Utilities.parseVersion((String)sre.getMinimalSARLVersion())), (Version)(maxVersion = Utilities.parseVersion((String)sre.getMaximalSARLVersion())));
            if (cmp < 0) {
                if (errorMessages) {
                    this.setErrorMessage(MessageFormat.format(io.sarl.eclipse.runtime.Messages.AbstractSREInstall_0, sarlVersion.toString(), minVersion.toString()));
                }
                return false;
            }
            if (cmp > 0) {
                if (errorMessages) {
                    this.setErrorMessage(MessageFormat.format(io.sarl.eclipse.runtime.Messages.AbstractSREInstall_1, sarlVersion.toString(), maxVersion.toString()));
                }
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.sreArray.isEmpty()) {
            this.setMessage(io.sarl.eclipse.launching.dialog.Messages.RuntimeEnvironmentTab_7);
        } else {
            ISREInstall defaultSRE = this.getDefaultSRE();
            if (defaultSRE == null) {
                this.setErrorMessage(Messages.SREsPreferencePage_8);
                return false;
            }
            if (!this.verifyValidity(defaultSRE, true)) {
                return false;
            }
        }
        return super.isValid();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ISREInstall defaultSRE = SREsPreferencePage.this.getDefaultSRE();
                ISREInstall[] sres = SREsPreferencePage.this.getSREs();
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    SARLRuntime.setSREInstalls(sres, (IProgressMonitor)monitor);
                    SARLRuntime.setDefaultSREInstall(defaultSRE, (IProgressMonitor)monitor, false);
                    SARLRuntime.saveSREConfiguration((IProgressMonitor)monitor);
                    canceled[0] = monitor.isCanceled();
                }
                catch (CoreException e) {
                    SREsPreferencePage.this.setErrorMessage(e);
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        int columnCount = this.sreTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put("io.sarl.eclipse.preferences.SREsPreferencePage.columnWidth" + i, this.sreTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put("io.sarl.eclipse.preferences.SREsPreferencePage.sortColumn", this.sortColumn.name());
        return super.performOk();
    }

    private void restoreColumnWidths(IDialogSettings settings) {
        int columnCount = this.sreTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt("io.sarl.eclipse.preferences.SREsPreferencePage.columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0 || i == this.sreTable.getColumnCount() - 1) {
                this.sreTable.getColumn(i).pack();
            } else {
                this.sreTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    private void restoreColumnSettings(IDialogSettings settings) {
        this.sresList.getTable().layout(true);
        this.restoreColumnWidths(settings);
        this.sortColumn = Column.NAME;
        try {
            String columnName = settings.get("io.sarl.eclipse.preferences.SREsPreferencePage.sortColumn");
            if (!Strings.isNullOrEmpty((String)columnName)) {
                this.sortColumn = Column.valueOf(columnName);
                if (this.sortColumn == null) {
                    this.sortColumn = Column.NAME;
                }
            }
        }
        catch (Throwable throwable) {}
        switch (this.sortColumn) {
            case NAME: {
                this.sortByName();
                break;
            }
            case LOCATION: {
                this.sortByLocation();
            }
        }
    }

    public void dispose() {
        SARLRuntime.removeSREInstallChangedListener(this.installListener);
        super.dispose();
    }

    public void setDefaultSRE(ISREInstall sre) {
        if (sre == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)sre));
        }
    }

    private void updateUI() {
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
        this.updateApplyButton();
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection cvalue = (IStructuredSelection)selection;
            if (!selection.equals(this.prevSelection)) {
                this.prevSelection = selection;
                Object sre = cvalue.getFirstElement();
                if (sre == null) {
                    this.sresList.setCheckedElements(new Object[0]);
                    this.updateUI();
                } else {
                    this.sresList.setCheckedElements(new Object[]{sre});
                    this.sresList.reveal(sre);
                    this.updateUI();
                }
                this.sresList.refresh(true);
                this.fireDefaultSREChanged();
                this.updateUI();
            }
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.sresList.getCheckedElements());
    }

    private void fireDefaultSREChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.selectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISREInstall getDefaultSRE() {
        Object[] objects = this.sresList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (ISREInstall)objects[0];
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.sresList.getSelection();
        int selectionCount = selection.size();
        this.editButton.setEnabled(selectionCount == 1);
        this.copyButton.setEnabled(selectionCount > 0);
        if (selectionCount > 0 && selectionCount <= this.sresList.getTable().getItemCount()) {
            for (ISREInstall install : selection) {
                if (!SARLRuntime.isPlatformSRE(install)) continue;
                this.removeButton.setEnabled(false);
                return;
            }
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private void sortByName() {
        this.sresList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISREInstall) {
                    ISREInstall left = (ISREInstall)e1;
                    if (e2 instanceof ISREInstall) {
                        ISREInstall right = (ISREInstall)e2;
                        return left.getName().compareToIgnoreCase(right.getName());
                    }
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.sortColumn = Column.NAME;
    }

    private void sortByLocation() {
        this.sresList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISREInstall) {
                    ISREInstall left = (ISREInstall)e1;
                    if (e2 instanceof ISREInstall) {
                        ISREInstall right = (ISREInstall)e2;
                        return left.getLocation().compareToIgnoreCase(right.getLocation());
                    }
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.sortColumn = Column.LOCATION;
    }

    private static enum Column {
        NAME,
        LOCATION;

    }

    private class InstallListener
    implements ISREInstallChangedListener {
        InstallListener() {
        }

        @Override
        public void sreAdded(ISREInstall sre) {
            if (!SREsPreferencePage.this.sreArray.contains(sre)) {
                SREsPreferencePage.this.sreArray.add(sre);
                SREsPreferencePage.this.refreshSREListUI();
            }
        }

        @Override
        public void sreRemoved(ISREInstall sre) {
            if (SREsPreferencePage.this.sreArray.contains(sre)) {
                SREsPreferencePage.this.sreArray.remove(sre);
                SREsPreferencePage.this.refreshSREListUI();
            }
        }

        @Override
        public void sreChanged(PropertyChangeEvent event) {
            ISREInstall sre;
            if ("io.sarl.eclipse.PROPERTY_NAME".equals(event.getProperty()) && SREsPreferencePage.this.sreArray.contains(sre = (ISREInstall)event.getSource())) {
                SREsPreferencePage.this.refreshSREListUI();
            }
        }

        @Override
        public void defaultSREInstallChanged(ISREInstall previous, ISREInstall current) {
            SREsPreferencePage.this.setDefaultSRE(current);
        }
    }

    private class SRELabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        SRELabelProvider() {
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }

        private boolean isValid(Object element) {
            if (element instanceof ISREInstall) {
                ISREInstall sre = (ISREInstall)element;
                return SREsPreferencePage.this.verifyValidity(sre, false);
            }
            return true;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (this.isValid(element)) {
                return SREsPreferencePage.this.getControl().getDisplay().getSystemColor(24);
            }
            return SREsPreferencePage.this.getControl().getDisplay().getSystemColor(3);
        }

        public Color getBackground(Object element, int columnIndex) {
            return SREsPreferencePage.this.getControl().getDisplay().getSystemColor(25);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ISREInstall) {
                ISREInstall sre = (ISREInstall)element;
                switch (columnIndex) {
                    case 0: {
                        String name = sre.getName();
                        if (SREsPreferencePage.this.getDefaultSRE() == element) {
                            return MessageFormat.format(JREMessages.InstalledJREsBlock_7, name);
                        }
                        return name;
                    }
                    case 1: {
                        return sre.getLocation();
                    }
                }
            }
            return element == null ? "" : element.toString();
        }
    }

    private class SREsContentProvider
    implements IStructuredContentProvider {
        SREsContentProvider() {
        }

        public Object[] getElements(Object input) {
            return SREsPreferencePage.this.sreArray.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

