/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.properties;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.SARLRuntime;
import io.sarl.eclipse.runtime.SREConfigurationBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RuntimeEnvironmentPropertyPage
extends PropertyAndPreferencePage {
    public static final String PROPERTY_PAGE_ID = "io.sarl.eclipse.properties.SRE";
    public static final String PREFERENCE_PAGE_ID = "io.sarl.eclipse.preferences.SREsPreferencePage";
    public static final String PROPERTY_QUALIFIER = "io.sarl.eclipse.launch.SRE";
    public static final String PROPERTY_NAME_SRE_INSTALL_ID = "SRE_INSTALL_ID";
    public static final String PROPERTY_NAME_USE_SYSTEM_WIDE_SRE = "USE_SYSTEM_WIDE_SRE";
    public static final String PROPERTY_NAME_HAS_PROJECT_SPECIFIC = "HAS_PROJECT_SPECIFIC";
    private SREConfigurationBlock sreBlock;

    public static QualifiedName qualify(String name) {
        return new QualifiedName(PROPERTY_QUALIFIER, name);
    }

    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    protected Control createPreferenceContent(Composite composite) {
        this.sreBlock = new SREConfigurationBlock(true, null, null);
        Control ctrl = this.sreBlock.createControl(composite);
        this.sreBlock.initialize();
        try {
            String useSystemWide = this.getProject().getPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_USE_SYSTEM_WIDE_SRE));
            String sreInstallId = this.getProject().getPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_SRE_INSTALL_ID));
            ISREInstall sre = SARLRuntime.getSREFromId(sreInstallId);
            boolean notify = this.sreBlock.getNotify();
            try {
                this.sreBlock.setNotify(false);
                this.sreBlock.selectSpecificSRE(sre);
                if (Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)useSystemWide), (Object)Boolean.TRUE.toString()))) {
                    this.sreBlock.selectSystemWideSRE();
                } else {
                    this.sreBlock.selectSpecificSRE();
                }
            }
            finally {
                this.sreBlock.setNotify(notify);
            }
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
        }
        return ctrl;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        try {
            String value = project.getPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_HAS_PROJECT_SPECIFIC));
            return Boolean.parseBoolean(value);
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
            return false;
        }
    }

    protected boolean saveProjectSpecificOptions(IProject project, boolean useSpecificOptions) {
        if (project != null) {
            try {
                project.setPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_HAS_PROJECT_SPECIFIC), Boolean.toString(useSpecificOptions));
                return true;
            }
            catch (CoreException e) {
                SARLEclipsePlugin.getDefault().log(e);
            }
        }
        return false;
    }

    protected void performDefaults() {
        this.sreBlock.selectSRE(null);
        super.performDefaults();
    }

    public boolean performOk() {
        IProject prj = this.getProject();
        if (prj == null || !super.performOk() || !this.saveProjectSpecificOptions(this.getProject(), this.useProjectSettings())) {
            return false;
        }
        ISREInstall projectSRE = this.sreBlock.getSelectedSRE();
        boolean isSystemWide = this.sreBlock.isSystemWideDefaultSRE();
        String id = projectSRE == null ? null : projectSRE.getId();
        try {
            prj.setPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_USE_SYSTEM_WIDE_SRE), Boolean.toString(isSystemWide));
            prj.setPersistentProperty(RuntimeEnvironmentPropertyPage.qualify(PROPERTY_NAME_SRE_INSTALL_ID), id);
            return true;
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
            return false;
        }
    }
}

