/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlAnnotationType;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlEnumeration;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.ui.refactoring.RefactoredResourceCopier;

public class SarlMoveElementHandler
extends AbstractHandler {
    @Inject
    private Provider<SyncUtil> syncUtil;
    @Inject
    private RefactoredResourceCopier resourceCopier;
    private final PolymorphicDispatcher<Object> moveDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_move", (int)2, (int)2, (Object)((Object)this));

    private static String getTypeName(XtendMember element) {
        if (element instanceof SarlBehaviorUnit) {
            return "a SARL behavior unit";
        }
        if (element instanceof XtendConstructor) {
            return "a SARL class constructor";
        }
        if (element instanceof XtendFunction) {
            return "a SARL action";
        }
        if (element instanceof XtendField) {
            return "a SARL field";
        }
        if (element instanceof SarlAgent) {
            return "a SARL agent";
        }
        if (element instanceof SarlArtifact) {
            return "a SARL artifact";
        }
        if (element instanceof SarlBehavior) {
            return "a SARL behavior";
        }
        if (element instanceof SarlCapacity) {
            return "a SARL capacity";
        }
        if (element instanceof SarlEvent) {
            return "a SARL event";
        }
        if (element instanceof SarlSkill) {
            return "a SARL skill";
        }
        if (element instanceof SarlSpace) {
            return "a SARL space";
        }
        if (element instanceof SarlAnnotationType) {
            if (element.getDeclaringType() != null) {
                return "an inner SARL annotation";
            }
            return "a SARL annotation";
        }
        if (element instanceof SarlClass) {
            if (element.getDeclaringType() != null) {
                return "an inner SARL class";
            }
            return "a SARL class";
        }
        if (element instanceof SarlEnumeration) {
            if (element.getDeclaringType() != null) {
                return "an inner SARL enumeration";
            }
            return "a SARL enumeration";
        }
        if (element instanceof SarlInterface) {
            if (element.getDeclaringType() != null) {
                return "an inner SARL interface";
            }
            return "a SARL interface";
        }
        if (element instanceof AnonymousClass) {
            return "a SARL anonymous class";
        }
        return MessageFormat.format("a SARL element of type {0}", element.eClass().getName());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ((SyncUtil)this.syncUtil.get()).totalSync(true);
            XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IXtextDocument document = editor.getDocument();
                XtextResource resource = this.reloadResource(document);
                XtendMember semanticObject = SarlMoveElementHandler.findSemanticObject(resource, selection);
                if (semanticObject == null) {
                    SARLEclipsePlugin.getDefault().openError(editor.getShell(), "Move Element", "Unable to find a SARL element into the current selection.", "The current selection is not inside a SARL element", null);
                }
                this.moveDispatcher.invoke(new Object[]{semanticObject, editor.getShell()});
            }
            return null;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private XtextResource reloadResource(IXtextDocument document) {
        IUnitOfWork function = it -> this.resourceCopier.loadIntoNewResourceSet(it);
        return (XtextResource)document.priorityReadOnly(function);
    }

    private static XtendMember findSemanticObject(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            EObject currentSemanticElement;
            ICompositeNode rootNode = parseResult.getRootNode();
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)selection.getOffset());
            if (node == null) {
                return null;
            }
            if (node.isHidden()) {
                node = selection.getLength() > node.getLength() ? NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)node.getEndOffset()) : NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selection.getOffset() - 1));
            } else if (node.getOffset() == selection.getOffset()) {
                node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selection.getOffset() - 1));
            }
            if (node != null && (currentSemanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node)) != null) {
                if (currentSemanticElement instanceof XtendMember) {
                    XtendMember cvalue = (XtendMember)currentSemanticElement;
                    return cvalue;
                }
                return (XtendMember)EcoreUtil2.getContainerOfType((EObject)currentSemanticElement.eContainer(), XtendMember.class);
            }
        }
        return null;
    }

    protected void showUnsupportedElementError(XtendMember element, Shell shell) {
        String typeName = SarlMoveElementHandler.getTypeName(element);
        SARLEclipsePlugin.getDefault().openError(shell, "Move Element", MessageFormat.format("Unable to move {0}.", typeName), MessageFormat.format("The refactoring feature does not support ", typeName), null);
    }

    protected void _move(XtendMember element, Shell shell) {
        this.showUnsupportedElementError(element, shell);
    }

    protected void _move(XtendTypeDeclaration element, Shell shell) {
        if (element instanceof AnonymousClass) {
            this.showUnsupportedElementError((XtendMember)element, shell);
        } else if (element.getDeclaringType() != null) {
            this.showUnsupportedElementError((XtendMember)element, shell);
        } else {
            this.showUnsupportedElementError((XtendMember)element, shell);
        }
    }
}

