/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.runtime;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.uiextensions.Utilities;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.Messages;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class AbstractSREInstall
implements ISREInstall {
    private String id;
    private String name;
    private String minimalSarlVersion;
    private String maximalSarlVersion;
    private String mainClass;
    private String bootstrap;
    private List<IRuntimeClasspathEntry> classPathEntries;
    private Map<String, String> attributeMap;
    private boolean dirty = true;
    private boolean notify = true;

    public AbstractSREInstall(String id) {
        this.id = id;
    }

    public AbstractSREInstall clone() {
        try {
            AbstractSREInstall clone = (AbstractSREInstall)super.clone();
            HashMap<String, String> hashMap = clone.attributeMap = this.attributeMap == null ? null : new HashMap<String, String>(this.attributeMap);
            if (this.classPathEntries != null) {
                clone.classPathEntries = new ArrayList<IRuntimeClasspathEntry>(this.classPathEntries);
            }
            if (this.classPathEntries != null) {
                clone.classPathEntries = new ArrayList<IRuntimeClasspathEntry>(this.classPathEntries);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public ISREInstall copy(String uId) {
        AbstractSREInstall copy = this.clone();
        copy.id = uId;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.getId().equals(((ISREInstall)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public boolean getNotify() {
        return this.notify;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected IStatus revalidate(int ignoreCauses) {
        try {
            this.setDirty(false);
            this.resolveDirtyFields(false);
            return this.getValidity(ignoreCauses);
        }
        catch (Throwable e) {
            if ((ignoreCauses & 1) == 0) {
                return SARLEclipsePlugin.getDefault().createStatus(4, 1, e);
            }
            return SARLEclipsePlugin.getDefault().createOkStatus();
        }
    }

    public final IStatus revalidate() {
        return this.revalidate(0);
    }

    public IStatus getValidity(int ignoreCauses) {
        if (this.isDirty()) {
            return this.revalidate(ignoreCauses);
        }
        IStatus status = null;
        try {
            String iMainClass = this.getMainClass();
            if (Strings.isNullOrEmpty((String)iMainClass) && (ignoreCauses & 8) == 0) {
                return SARLEclipsePlugin.getDefault().createStatus(4, 8, Messages.AbstractSREInstall_2);
            }
            String iName = this.getName();
            if (Strings.isNullOrEmpty((String)iName) && (ignoreCauses & 0x10) == 0) {
                return SARLEclipsePlugin.getDefault().createStatus(4, 16, Messages.AbstractSREInstall_3);
            }
            status = this.getLibraryLocationValidity(ignoreCauses);
            if (status == null) {
                status = this.getSARLVersionValidity(ignoreCauses);
            }
        }
        catch (Throwable throwable) {}
        if (status == null) {
            status = SARLEclipsePlugin.getDefault().createOkStatus();
        }
        return status;
    }

    private IStatus getLibraryLocationValidity(int ignoreCauses) {
        List<IRuntimeClasspathEntry> locations = this.getClassPathEntries();
        if ((locations == null || locations.isEmpty()) && (ignoreCauses & 2) == 0) {
            return SARLEclipsePlugin.getDefault().createStatus(4, 2, Messages.AbstractSREInstall_4);
        }
        return null;
    }

    private IStatus getSARLVersionValidity(int ignoreCauses) {
        Bundle bundle = Platform.getBundle((String)"io.sarl.lang");
        if (bundle != null) {
            Version maxVersion;
            Version minVersion;
            Version sarlVersion = bundle.getVersion();
            int cmp = Utilities.compareVersionToRange((Version)sarlVersion, (Version)(minVersion = Utilities.parseVersion((String)this.getMinimalSARLVersion())), (Version)(maxVersion = Utilities.parseVersion((String)this.getMaximalSARLVersion())));
            if (cmp < 0 && (ignoreCauses & 4) == 0) {
                return SARLEclipsePlugin.getDefault().createStatus(4, 4, MessageFormat.format(Messages.AbstractSREInstall_0, sarlVersion.toString(), minVersion.toString()));
            }
            if (cmp > 0 && (ignoreCauses & 4) == 0) {
                return SARLEclipsePlugin.getDefault().createStatus(4, 4, MessageFormat.format(Messages.AbstractSREInstall_1, sarlVersion.toString(), maxVersion.toString()));
            }
        }
        return null;
    }

    protected abstract void resolveDirtyFields(boolean var1);

    public String getId() {
        return this.id;
    }

    public String getNameNoDefault() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.name;
    }

    public String getMinimalSARLVersion() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.minimalSarlVersion;
    }

    public String getMaximalSARLVersion() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.maximalSarlVersion;
    }

    public String getMainClass() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.mainClass;
    }

    public String getBootstrap() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.bootstrap;
    }

    public List<IRuntimeClasspathEntry> getClassPathEntries() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (this.classPathEntries == null) {
            return new ArrayList<IRuntimeClasspathEntry>();
        }
        return this.classPathEntries;
    }

    public Map<String, String> getVMSpecificAttributesMap() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (this.attributeMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public void setName(String name) {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        String normalizedName = Strings.nullToEmpty((String)name);
        if (!name.equals(Strings.nullToEmpty((String)this.name))) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_NAME", (Object)this.name, (Object)normalizedName);
            this.name = normalizedName;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setClassPathEntries(List<IRuntimeClasspathEntry> libraries) {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (libraries == null && this.classPathEntries != null || libraries != null && (this.classPathEntries == null || libraries != this.classPathEntries)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_LIBRARY_LOCATIONS", this.classPathEntries, libraries);
            this.classPathEntries = libraries;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setMinimalSARLVersion(String version) {
        String newVersion;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (!(newVersion = Strings.nullToEmpty((String)version)).isEmpty()) {
            try {
                Version.parseVersion((String)newVersion);
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (!newVersion.equals(Strings.nullToEmpty((String)this.minimalSarlVersion))) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_MINIMAL_SARL_VERSION", (Object)this.minimalSarlVersion, (Object)newVersion);
            this.minimalSarlVersion = newVersion;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setMaximalSARLVersion(String version) {
        String newVersion;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (!(newVersion = Strings.nullToEmpty((String)version)).isEmpty()) {
            try {
                Version.parseVersion((String)newVersion);
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (!newVersion.equals(Strings.nullToEmpty((String)this.maximalSarlVersion))) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_MAXIMAL_SARL_VERSION", (Object)this.maximalSarlVersion, (Object)newVersion);
            this.maximalSarlVersion = newVersion;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setVMSpecificAttributesMap(Map<String, String> attributes) {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (!Objects.equal(attributes, this.attributeMap)) {
            Map<Object, Object> newValues = attributes == null ? Collections.emptyMap() : attributes;
            Map<Object, Object> oldValues = this.attributeMap == null ? Collections.emptyMap() : this.attributeMap;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_VM_ATTRIBUTES", oldValues, newValues);
            this.attributeMap = attributes;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setMainClass(String mainClass) {
        String normalizedName;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (!(normalizedName = Strings.nullToEmpty((String)mainClass)).equals(Strings.nullToEmpty((String)this.mainClass))) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_MAINCLASS", (Object)this.mainClass, (Object)normalizedName);
            this.mainClass = normalizedName;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public void setBootstrap(String bootstrap) {
        String normalizedName;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        if (!(normalizedName = Strings.nullToEmpty((String)bootstrap)).equals(Strings.nullToEmpty((String)this.bootstrap))) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_BOOTSTRAP", (Object)this.bootstrap, (Object)normalizedName);
            this.bootstrap = normalizedName;
            if (this.notify) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }
}

