/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.runtime;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.AbstractSREInstall;
import io.sarl.eclipse.runtime.Messages;
import io.sarl.eclipse.runtime.SARLRuntime;
import io.sarl.eclipse.runtime.SREException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestBasedSREInstall
extends AbstractSREInstall {
    private IPath jarFile;
    private String vmArguments = "";
    private String programArguments = "";
    private String cliDefaultContextID;
    private String cliRandomContextID;
    private String cliBootAgentContextID;
    private String cliNoMoreOption;
    private String cliEmbedded;
    private String cliLogOption;
    private String cliLogValues;
    private String cliLogDefaultValue;
    private String manifestMainClass;
    private String manifestName;
    private transient SoftReference<Map<String, String>> optionBuffer;

    public ManifestBasedSREInstall(String id) {
        super(id);
    }

    public IPath getPreferredClassPathContainerPath() {
        return null;
    }

    @Override
    public ManifestBasedSREInstall clone() {
        ManifestBasedSREInstall clone = (ManifestBasedSREInstall)super.clone();
        clone.jarFile = this.jarFile == null ? null : Path.fromPortableString((String)clone.jarFile.toPortableString());
        return clone;
    }

    @Override
    public ManifestBasedSREInstall copy(String id) {
        return (ManifestBasedSREInstall)super.copy(id);
    }

    public IPath getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(IPath jarFile) {
        if (!Objects.equal((Object)jarFile, (Object)this.jarFile)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_JAR_FILE", (Object)this.jarFile, (Object)jarFile);
            this.jarFile = jarFile;
            this.setDirty(true);
            if (this.getNotify()) {
                SARLRuntime.fireSREChanged(event);
            }
        }
    }

    public String getLocation() {
        IPath iJarFile = this.getJarFile();
        if (iJarFile == null) {
            return this.getName();
        }
        return iJarFile.toOSString();
    }

    public String getName() {
        String nam = this.getNameNoDefault();
        if (Strings.isNullOrEmpty((String)nam)) {
            IPath path = this.getJarFile();
            nam = path != null ? path.removeFileExtension().lastSegment() : this.getId();
        }
        return nam;
    }

    @Override
    protected void resolveDirtyFields(boolean forceSettings) {
        block52: {
            if (this.jarFile != null) {
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (JarFile jFile = new JarFile(this.jarFile.toFile());){
                        String vmArgs;
                        Attributes sarlSection;
                        Manifest manifest = jFile.getManifest();
                        this.manifestMainClass = manifest.getMainAttributes().getValue("Main-Class");
                        if (Strings.isNullOrEmpty((String)this.manifestMainClass)) {
                            throw new SREException(MessageFormat.format(Messages.StandardSREInstall_0, this.getId()));
                        }
                        if (forceSettings || Strings.isNullOrEmpty((String)this.getMainClass())) {
                            this.setMainClass(this.manifestMainClass);
                        }
                        if ((sarlSection = manifest.getAttributes("SARL-Runtime-Environment")) == null) {
                            throw new SREException(Messages.StandardSREInstall_1);
                        }
                        String sarlVersion = sarlSection.getValue("SARL-Spec-Version");
                        String minVersion = null;
                        String maxVersion = null;
                        if (!Strings.isNullOrEmpty((String)sarlVersion)) {
                            try {
                                Version sarlVer = Version.parseVersion((String)sarlVersion);
                                if (sarlVer != null) {
                                    minVersion = new Version(sarlVer.getMajor(), sarlVer.getMinor(), 0).toString();
                                    maxVersion = new Version(sarlVer.getMajor(), sarlVer.getMinor() + 1, 0).toString();
                                }
                            }
                            catch (Throwable throwable2) {}
                        }
                        if (forceSettings || Strings.isNullOrEmpty((String)this.getMinimalSARLVersion())) {
                            this.setMinimalSARLVersion(minVersion);
                        }
                        if (forceSettings || Strings.isNullOrEmpty((String)this.getMaximalSARLVersion())) {
                            this.setMaximalSARLVersion(maxVersion);
                        }
                        this.manifestName = Strings.nullToEmpty((String)sarlSection.getValue("SRE-Name"));
                        if (forceSettings || Strings.isNullOrEmpty((String)this.getNameNoDefault())) {
                            this.setName(this.manifestName);
                        }
                        if (!this.vmArguments.equals(vmArgs = Strings.nullToEmpty((String)sarlSection.getValue("VM-Arguments")))) {
                            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_VM_ARGUMENTS", (Object)this.vmArguments, (Object)Strings.nullToEmpty((String)vmArgs));
                            this.vmArguments = vmArgs;
                            if (this.getNotify()) {
                                SARLRuntime.fireSREChanged(event);
                            }
                        }
                        this.setVMSpecificAttributesMap(null);
                        this.optionBuffer = null;
                        this.cliDefaultContextID = sarlSection.getValue("CLI-Default-Context-ID");
                        this.cliRandomContextID = sarlSection.getValue("CLI-Random-Context-ID");
                        this.cliBootAgentContextID = sarlSection.getValue("CLI-BootAgent-Context-ID");
                        this.cliNoMoreOption = sarlSection.getValue("CLI-No-More-Option");
                        this.cliEmbedded = sarlSection.getValue("CLI-Embedded");
                        this.cliLogOption = sarlSection.getValue("CLI-Log");
                        this.cliLogValues = sarlSection.getValue("CLI-Log-Values");
                        this.cliLogDefaultValue = sarlSection.getValue("CLI-Log-Default-Value");
                        String programArgs = Strings.nullToEmpty((String)sarlSection.getValue("Program-Arguments"));
                        if (!this.programArguments.equals(programArgs)) {
                            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "io.sarl.eclipse.PROPERTY_PROGRAM_ARGUMENTS", (Object)this.programArguments, (Object)programArgs);
                            this.programArguments = programArgs;
                            if (this.getNotify()) {
                                SARLRuntime.fireSREChanged(event);
                            }
                        }
                        if (forceSettings || this.getClassPathEntries().isEmpty()) {
                            ArrayList<IRuntimeClasspathEntry> classPath = new ArrayList<IRuntimeClasspathEntry>();
                            LibraryLocation location = new LibraryLocation(this.jarFile, (IPath)Path.EMPTY, (IPath)Path.EMPTY);
                            IClasspathEntry cpEntry = JavaCore.newLibraryEntry((IPath)location.getSystemLibraryPath(), (IPath)location.getSystemLibrarySourcePath(), (IPath)location.getPackageRootPath());
                            RuntimeClasspathEntry rtcpEntry = new RuntimeClasspathEntry(cpEntry);
                            rtcpEntry.setClasspathProperty(3);
                            classPath.add((IRuntimeClasspathEntry)rtcpEntry);
                            String classPathStr = manifest.getMainAttributes().getValue("Class-Path");
                            IPath rootPath = this.jarFile.removeLastSegments(1);
                            if (!Strings.isNullOrEmpty((String)classPathStr)) {
                                String[] stringArray = classPathStr.split(Pattern.quote(":"));
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String cpElement = stringArray[n2];
                                    IPath path = ManifestBasedSREInstall.parsePath(cpElement, (IPath)Path.EMPTY, rootPath);
                                    location = new LibraryLocation(path, (IPath)Path.EMPTY, (IPath)Path.EMPTY);
                                    cpEntry = JavaCore.newLibraryEntry((IPath)location.getSystemLibraryPath(), (IPath)location.getSystemLibrarySourcePath(), (IPath)location.getPackageRootPath());
                                    rtcpEntry = new RuntimeClasspathEntry(cpEntry);
                                    rtcpEntry.setClasspathProperty(3);
                                    classPath.add((IRuntimeClasspathEntry)rtcpEntry);
                                    ++n2;
                                }
                            }
                            this.setClassPathEntries(classPath);
                        }
                        ZipEntry jEntry = jFile.getEntry("META-INF/services/io.sarl.bootstrap.SREBootstrap");
                        String bootstrap = null;
                        if (jEntry != null) {
                            Throwable throwable3 = null;
                            Object var15_20 = null;
                            try (InputStream is = jFile.getInputStream(jEntry);){
                                Throwable throwable4 = null;
                                Object var18_30 = null;
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                                    String line = reader.readLine();
                                    if (line != null && !(line = line.trim()).isEmpty()) {
                                        bootstrap = line;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable4 == null) {
                                        throwable4 = throwable5;
                                    } else if (throwable4 != throwable5) {
                                        throwable4.addSuppressed(throwable5);
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable3 == null) {
                                    throwable3 = throwable6;
                                } else if (throwable3 != throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                throw throwable3;
                            }
                        }
                        if (forceSettings || Strings.isNullOrEmpty((String)this.getBootstrap())) {
                            this.setBootstrap(bootstrap);
                        }
                        break block52;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            throwable = throwable7;
                        } else if (throwable != throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        throw throwable;
                    }
                }
                catch (SREException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new SREException(e);
                }
            }
            throw new SREException(Messages.StandardSREInstall_2);
        }
    }

    public String getSREArguments() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.programArguments;
    }

    public String getJVMArguments() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        return this.vmArguments;
    }

    @Override
    public IStatus getValidity(int ignoreCauses) {
        block5: {
            if (this.isDirty()) {
                return this.revalidate(ignoreCauses);
            }
            try {
                File file;
                IPath path = this.getJarFile();
                if (path == null && (ignoreCauses & 0x20) == 0) {
                    return SARLEclipsePlugin.getDefault().createStatus(4, 32, Messages.StandardSREInstall_2);
                }
                File file2 = file = path == null ? null : path.toFile();
                if (!(file != null && file.canRead() || (ignoreCauses & 0x20) != 0)) {
                    return SARLEclipsePlugin.getDefault().createStatus(4, 32, Messages.StandardSREInstall_3);
                }
            }
            catch (Throwable e) {
                if ((ignoreCauses & 1) != 0) break block5;
                return SARLEclipsePlugin.getDefault().createStatus(4, 1, e);
            }
        }
        return super.getValidity(ignoreCauses);
    }

    public void getAsXML(Document document, Element element) throws IOException {
        String bootstrap;
        String mainClass;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        IPath path = this.getJarFile();
        element.setAttribute("libraryPath", path.toPortableString());
        String name = Strings.nullToEmpty((String)this.getName());
        if (!name.equals(this.manifestName)) {
            element.setAttribute("name", name);
        }
        if (!(mainClass = Strings.nullToEmpty((String)this.getMainClass())).equals(this.manifestMainClass)) {
            element.setAttribute("mainClass", mainClass);
        }
        if (!Strings.isNullOrEmpty((String)(bootstrap = Strings.nullToEmpty((String)this.getBootstrap())))) {
            element.setAttribute("bootstrap", bootstrap);
        } else {
            element.removeAttribute("bootstrap");
        }
        List<IRuntimeClasspathEntry> libraries = this.getClassPathEntries();
        if (libraries.size() != 1 || !libraries.get(0).getClasspathEntry().getPath().equals((Object)this.jarFile)) {
            IPath rootPath = path.removeLastSegments(1);
            for (IRuntimeClasspathEntry location : libraries) {
                Element libraryNode = document.createElement("libraryLocation");
                libraryNode.setAttribute("systemLibraryPath", ManifestBasedSREInstall.makeRelativePath(location.getPath(), path, rootPath));
                libraryNode.setAttribute("packageRootPath", ManifestBasedSREInstall.makeRelativePath(location.getSourceAttachmentRootPath(), path, rootPath));
                libraryNode.setAttribute("sourcePath", ManifestBasedSREInstall.makeRelativePath(location.getSourceAttachmentPath(), path, rootPath));
                element.appendChild(libraryNode);
            }
        }
    }

    public void setFromXML(Element element) throws IOException {
        block13: {
            IPath path = ManifestBasedSREInstall.parsePath(element.getAttribute("libraryPath"), null, null);
            try {
                String bootstrap;
                String mainClass;
                if (path == null) break block13;
                this.setJarFile(path);
                String name = element.getAttribute("name");
                if (!Strings.isNullOrEmpty((String)name)) {
                    this.setName(name);
                }
                if (!Strings.isNullOrEmpty((String)(mainClass = element.getAttribute("mainClass")))) {
                    this.setMainClass(mainClass);
                }
                if (!Strings.isNullOrEmpty((String)(bootstrap = element.getAttribute("bootstrap")))) {
                    this.setBootstrap(bootstrap);
                }
                ArrayList<IRuntimeClasspathEntry> locations = new ArrayList<IRuntimeClasspathEntry>();
                NodeList children = element.getChildNodes();
                IPath rootPath = path.removeLastSegments(1);
                int i = 0;
                while (i < children.getLength()) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        Element libraryNode = (Element)node;
                        if ("libraryLocation".equalsIgnoreCase(node.getNodeName())) {
                            IPath systemLibraryPath = ManifestBasedSREInstall.parsePath(libraryNode.getAttribute("systemLibraryPath"), null, rootPath);
                            if (systemLibraryPath != null) {
                                IPath packageRootPath = ManifestBasedSREInstall.parsePath(libraryNode.getAttribute("packageRootPath"), (IPath)Path.EMPTY, rootPath);
                                IPath sourcePath = ManifestBasedSREInstall.parsePath(libraryNode.getAttribute("sourcePath"), (IPath)Path.EMPTY, rootPath);
                                URL javadoc = null;
                                try {
                                    String urlTxt = libraryNode.getAttribute("javadoc");
                                    javadoc = new URI(urlTxt).toURL();
                                }
                                catch (Throwable throwable) {}
                                LibraryLocation location = new LibraryLocation(systemLibraryPath, sourcePath, packageRootPath, javadoc);
                                IClasspathEntry cpEntry = JavaCore.newLibraryEntry((IPath)location.getSystemLibraryPath(), (IPath)location.getSystemLibrarySourcePath(), (IPath)location.getPackageRootPath());
                                RuntimeClasspathEntry rtcpEntry = new RuntimeClasspathEntry(cpEntry);
                                rtcpEntry.setClasspathProperty(3);
                                locations.add((IRuntimeClasspathEntry)rtcpEntry);
                            } else {
                                SARLEclipsePlugin.getDefault().logErrorMessage(MessageFormat.format(Messages.StandardSREInstall_4, this.getId()));
                            }
                        }
                    }
                    ++i;
                }
                if (!locations.isEmpty()) {
                    this.setClassPathEntries(locations);
                }
                return;
            }
            catch (Throwable exception) {
                throw new IOException(MessageFormat.format(Messages.StandardSREInstall_5, this.getId()), exception);
            }
        }
        throw new IOException(MessageFormat.format(Messages.StandardSREInstall_5, this.getId()));
    }

    private static IPath parsePath(String path, IPath defaultPath, IPath rootPath) {
        if (!Strings.isNullOrEmpty((String)path)) {
            try {
                IPath pathObject = Path.fromPortableString((String)path);
                if (pathObject != null) {
                    if (rootPath != null && !pathObject.isAbsolute()) {
                        return rootPath.append(pathObject);
                    }
                    return pathObject;
                }
            }
            catch (Throwable throwable) {}
        }
        return defaultPath;
    }

    private static String makeRelativePath(IPath pathToConvert, IPath jarPath, IPath rootPath) {
        if (pathToConvert == null) {
            return null;
        }
        if (!jarPath.equals((Object)pathToConvert) && rootPath.isPrefixOf(pathToConvert)) {
            return pathToConvert.makeRelativeTo(rootPath).toPortableString();
        }
        return pathToConvert.toPortableString();
    }

    public Map<String, String> getAvailableCommandLineOptions() {
        HashMap options;
        if (this.isDirty()) {
            this.setDirty(false);
            this.resolveDirtyFields(true);
        }
        HashMap hashMap = options = this.optionBuffer == null ? null : this.optionBuffer.get();
        if (options == null) {
            options = Maps.newHashMap();
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Default-Context-ID", this.cliDefaultContextID);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Random-Context-ID", this.cliRandomContextID);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-BootAgent-Context-ID", this.cliBootAgentContextID);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-No-More-Option", this.cliNoMoreOption);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Embedded", this.cliEmbedded);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Log", this.cliLogOption);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Log-Values", this.cliLogValues);
            ManifestBasedSREInstall.putIfNotempty(options, "CLI-Log-Default-Value", this.cliLogDefaultValue);
            this.optionBuffer = new SoftReference<HashMap>(options);
        }
        return Collections.unmodifiableMap(options);
    }

    private static void putIfNotempty(Map<String, String> map, String key, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            map.put(key, value);
        }
    }
}

