/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.runtime;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstalls;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.ISREInstallChangedListener;
import io.sarl.eclipse.runtime.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SARLRuntime {
    public static final String DEFAULT_PREFERENCE_KEY = "io.sarl.eclipse.runtime.PREF_SRE_XML";
    private static boolean enableSreExtensionPoints = true;
    private static String currentPreferenceKey = "io.sarl.eclipse.runtime.PREF_SRE_XML";
    private static final ListenerList<ISREInstallChangedListener> SRE_LISTENERS = new ListenerList();
    private static final Map<String, ISREInstall> ALL_SRE_INSTALLS = new HashMap<String, ISREInstall>();
    private static Set<String> platformSREInstalls;
    private static String defaultSREId;
    private static final ReentrantLock LOCK;

    static {
        LOCK = new ReentrantLock();
    }

    private SARLRuntime() {
    }

    public static String getCurrentPreferenceKey() {
        LOCK.lock();
        try {
            String string = currentPreferenceKey;
            return string;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void setCurrentPreferenceKey(String key) {
        LOCK.lock();
        try {
            currentPreferenceKey = Strings.isNullOrEmpty((String)key) ? DEFAULT_PREFERENCE_KEY : key;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void addSREInstallChangedListener(ISREInstallChangedListener listener) {
        SRE_LISTENERS.add((Object)listener);
    }

    public static void removeSREInstallChangedListener(ISREInstallChangedListener listener) {
        SRE_LISTENERS.remove((Object)listener);
    }

    public static void fireSREChanged(PropertyChangeEvent event) {
        Object[] objectArray = SRE_LISTENERS.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISREInstallChangedListener)listener).sreChanged(event);
            ++n2;
        }
    }

    public static void fireSREAdded(ISREInstall installation) {
        Object[] objectArray = SRE_LISTENERS.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISREInstallChangedListener)listener).sreAdded(installation);
            ++n2;
        }
    }

    public static void fireSRERemoved(ISREInstall installation) {
        Object[] objectArray = SRE_LISTENERS.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISREInstallChangedListener)listener).sreRemoved(installation);
            ++n2;
        }
    }

    public static ISREInstall getSREFromId(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        SARLRuntime.initializeSREs();
        LOCK.lock();
        try {
            ISREInstall iSREInstall = ALL_SRE_INSTALLS.get(id);
            return iSREInstall;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static String getDefaultSREId() {
        LOCK.lock();
        try {
            SARLRuntime.initializeSREs();
            String string = defaultSREId;
            return string;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static ISREInstall getDefaultSREInstall() {
        ISREInstall install = SARLRuntime.getSREFromId(SARLRuntime.getDefaultSREId());
        if (install != null && install.getValidity().isOK()) {
            return install;
        }
        LOCK.lock();
        try {
            SARLRuntime.initializeSREs();
        }
        finally {
            LOCK.unlock();
        }
        return SARLRuntime.getSREFromId(SARLRuntime.getDefaultSREId());
    }

    public static void setSREInstalls(ISREInstall[] sres, IProgressMonitor monitor) throws CoreException {
        TreeMap<String, ISREInstall> allKeys;
        String newDefaultId;
        String oldDefaultId;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SARLRuntime_0, (int)(sres.length * 2 + ALL_SRE_INSTALLS.size()));
        SARLRuntime.initializeSREs();
        ArrayList<ISREInstall> newElements = new ArrayList<ISREInstall>();
        LOCK.lock();
        try {
            newDefaultId = oldDefaultId = SARLRuntime.getDefaultSREId();
            allKeys = new TreeMap<String, ISREInstall>(ALL_SRE_INSTALLS);
            ISREInstall[] iSREInstallArray = sres;
            int n = sres.length;
            int n2 = 0;
            while (n2 < n) {
                ISREInstall sre = iSREInstallArray[n2];
                if (allKeys.remove(sre.getId()) == null) {
                    newElements.add(sre);
                    ALL_SRE_INSTALLS.put(sre.getId(), sre);
                }
                mon.worked(1);
                ++n2;
            }
            for (ISREInstall sre : allKeys.values()) {
                ALL_SRE_INSTALLS.remove(sre.getId());
                platformSREInstalls.remove(sre.getId());
                mon.worked(1);
            }
            if (oldDefaultId != null && !ALL_SRE_INSTALLS.containsKey(oldDefaultId)) {
                newDefaultId = null;
            }
        }
        finally {
            LOCK.unlock();
        }
        boolean changed = false;
        mon.subTask(Messages.SARLRuntime_1);
        if (oldDefaultId != null && newDefaultId == null) {
            changed = true;
            SARLRuntime.setDefaultSREInstall(null, monitor);
        }
        mon.worked(1);
        mon.subTask(Messages.SARLRuntime_2);
        for (ISREInstall sre : allKeys.values()) {
            changed = true;
            SARLRuntime.fireSRERemoved(sre);
        }
        for (ISREInstall sre : newElements) {
            changed = true;
            SARLRuntime.fireSREAdded(sre);
        }
        mon.worked(1);
        if (changed) {
            SARLRuntime.saveSREConfiguration((IProgressMonitor)mon.newChild(sres.length - 2));
        }
    }

    public static void setDefaultSREInstall(ISREInstall sre, IProgressMonitor monitor) throws CoreException {
        SARLRuntime.setDefaultSREInstall(sre, monitor, true);
    }

    public static void setDefaultSREInstall(ISREInstall sre, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        SARLRuntime.initializeSREs();
        ISREInstall previous = null;
        ISREInstall current = null;
        LOCK.lock();
        try {
            if (defaultSREId != null) {
                previous = SARLRuntime.getSREFromId(defaultSREId);
            }
            String string = defaultSREId = sre == null ? null : sre.getId();
            if (savePreference) {
                SARLRuntime.saveSREConfiguration(monitor);
            }
            if (defaultSREId != null) {
                current = SARLRuntime.getSREFromId(defaultSREId);
            }
        }
        finally {
            LOCK.unlock();
        }
        if (previous != current) {
            SARLRuntime.fireDefaultSREChanged(previous, current);
        }
    }

    private static void fireDefaultSREChanged(ISREInstall previous, ISREInstall current) {
        Object[] objectArray = SRE_LISTENERS.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISREInstallChangedListener)listener).defaultSREInstallChanged(previous, current);
            ++n2;
        }
    }

    public static ISREInstall[] getSREInstalls() {
        SARLRuntime.initializeSREs();
        LOCK.lock();
        try {
            ISREInstall[] iSREInstallArray = ALL_SRE_INSTALLS.values().toArray(new ISREInstall[ALL_SRE_INSTALLS.size()]);
            return iSREInstallArray;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static boolean isPlatformSRE(ISREInstall sre) {
        if (sre != null) {
            LOCK.lock();
            try {
                boolean bl = platformSREInstalls.contains(sre.getId());
                return bl;
            }
            finally {
                LOCK.unlock();
            }
        }
        return false;
    }

    public static void saveSREConfiguration(IProgressMonitor monitor) throws CoreException {
        SARLEclipsePlugin plugin = SARLEclipsePlugin.getDefault();
        plugin.getPreferences().put(SARLRuntime.getCurrentPreferenceKey(), SARLRuntime.getSREsAsXML(monitor));
        plugin.savePreferences();
    }

    public static void clearSREConfiguration() throws CoreException {
        SARLEclipsePlugin plugin = SARLEclipsePlugin.getDefault();
        plugin.getPreferences().remove(SARLRuntime.getCurrentPreferenceKey());
        plugin.savePreferences();
    }

    private static void initializeSREExtensions() {
        ISREInstalls.getSREInstallStreamFromExtension().forEach(sre -> {
            platformSREInstalls.add(sre.getId());
            ALL_SRE_INSTALLS.put(sre.getId(), (ISREInstall)sre);
        });
    }

    public static String getSREAsXML(ISREInstall sre) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmldocument = builder.newDocument();
            Element sreNode = xmldocument.createElement("SRE");
            sreNode.setAttribute("platform", Boolean.toString(SARLRuntime.isPlatformSRE(sre)));
            sreNode.setAttribute("id", sre.getId());
            sreNode.setAttribute("class", sre.getClass().getName());
            sre.getAsXML(xmldocument, sreNode);
            xmldocument.appendChild(sreNode);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            Throwable throwable = null;
            Object var8_10 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                DOMSource source = new DOMSource(xmldocument);
                PrintWriter flot = new PrintWriter(baos);
                StreamResult xmlStream = new StreamResult(flot);
                trans.transform(source, xmlStream);
                return new String(baos.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, e));
        }
    }

    public static void setSREFromXML(ISREInstall sre, String xml) throws CoreException {
        try {
            Element root = SARLRuntime.parseXML(xml, false);
            sre.setFromXML(root);
        }
        catch (Throwable e) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, e));
        }
    }

    public static String getSREsAsXML(IProgressMonitor monitor) throws CoreException {
        SARLRuntime.initializeSREs();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmldocument = builder.newDocument();
            Element rootElement = SARLRuntime.getXml(xmldocument);
            xmldocument.appendChild(rootElement);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            Throwable throwable = null;
            Object var8_10 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                DOMSource source = new DOMSource(xmldocument);
                PrintWriter flot = new PrintWriter(baos);
                StreamResult xmlStream = new StreamResult(flot);
                trans.transform(source, xmlStream);
                return new String(baos.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, e));
        }
    }

    private static Element getXml(Document xmlDocument) throws IOException {
        Element sresNode = xmlDocument.createElement("SREs");
        LOCK.lock();
        try {
            for (ISREInstall sre : ALL_SRE_INSTALLS.values()) {
                Element sreNode = xmlDocument.createElement("SRE");
                sreNode.setAttribute("platform", Boolean.toString(SARLRuntime.isPlatformSRE(sre)));
                sreNode.setAttribute("id", sre.getId());
                sreNode.setAttribute("class", sre.getClass().getName());
                sre.getAsXML(xmlDocument, sreNode);
                sresNode.appendChild(sreNode);
            }
            if (!Strings.isNullOrEmpty((String)defaultSREId)) {
                sresNode.setAttribute("defaultSRE", defaultSREId);
            }
        }
        finally {
            LOCK.unlock();
        }
        return sresNode;
    }

    private static Element parseXML(String rawXml, boolean isMultiple) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(rawXml.getBytes()));){
            return SARLRuntime.parseXML(stream, isMultiple);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Element parseXML(InputStream stream, boolean isMultiple) throws IOException {
        Element config = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(new InputSource(stream)).getDocumentElement();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(LaunchingMessages.JavaRuntime_badFormat);
        }
        if (config == null || isMultiple && !config.getNodeName().equalsIgnoreCase("SREs") || !isMultiple && !config.getNodeName().equalsIgnoreCase("SRE")) {
            throw new IOException("Invalid XML format of the SRE preferences");
        }
        return config;
    }

    private static ISREInstall createSRE(String classname, String id) {
        if (!Strings.isNullOrEmpty((String)id)) {
            try {
                Class<ISREInstall> type = Class.forName(classname).asSubclass(ISREInstall.class);
                Constructor<ISREInstall> cons = type.getConstructor(String.class);
                return cons.newInstance(id);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private static String initializePersistedSREs() {
        block28: {
            String rawXml = SARLEclipsePlugin.getDefault().getPreferences().get(SARLRuntime.getCurrentPreferenceKey(), "");
            try {
                Element config = null;
                if (!Strings.isNullOrEmpty((String)rawXml)) {
                    config = SARLRuntime.parseXML(rawXml, true);
                } else {
                    IPath stateLocation;
                    IPath stateFile;
                    File file;
                    SARLEclipsePlugin plugin = SARLEclipsePlugin.getDefault();
                    if (plugin.getBundle() != null && (file = (stateFile = (stateLocation = plugin.getStateLocation()).append("sreConfiguration.xml")).toFile()).exists()) {
                        try {
                            Throwable throwable = null;
                            Object var7_12 = null;
                            try (BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(file));){
                                config = SARLRuntime.parseXML(fileInputStream, true);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            SARLEclipsePlugin.getDefault().log(e);
                        }
                    }
                }
                if (config == null) break block28;
                String defaultId = config.getAttribute("defaultSRE");
                NodeList children = config.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    block29: {
                        try {
                            ISREInstall sre;
                            Node child = children.item(i);
                            if (!"SRE".equalsIgnoreCase(child.getNodeName()) || !(child instanceof Element)) break block29;
                            Element element = (Element)child;
                            boolean isPlatform = Boolean.parseBoolean(element.getAttribute("platform"));
                            String id = element.getAttribute("id");
                            if (!isPlatform || !ALL_SRE_INSTALLS.containsKey(id)) {
                                sre = SARLRuntime.createSRE(element.getAttribute("class"), id);
                                if (sre == null) {
                                    throw new IOException("Invalid XML format of the SRE preferences of " + id);
                                }
                                try {
                                    sre.setFromXML(element);
                                }
                                catch (IOException e) {
                                    SARLEclipsePlugin.getDefault().log(e);
                                }
                                ALL_SRE_INSTALLS.put(id, sre);
                                if (isPlatform) {
                                    platformSREInstalls.add(id);
                                }
                                break block29;
                            }
                            sre = ALL_SRE_INSTALLS.get(id);
                            if (sre != null) {
                                try {
                                    sre.setFromXML(element);
                                }
                                catch (IOException e) {
                                    SARLEclipsePlugin.getDefault().log(e);
                                }
                            }
                        }
                        catch (IOException e) {
                            SARLEclipsePlugin.getDefault().log(e);
                        }
                    }
                    ++i;
                }
                return defaultId;
            }
            catch (IOException e) {
                SARLEclipsePlugin.getDefault().log(e);
            }
        }
        return null;
    }

    private static void initializeSREs() {
        ISREInstall[] newSREs = new ISREInstall[]{};
        boolean savePrefs = false;
        LOCK.lock();
        String previousDefault = defaultSREId;
        try {
            Iterator<ISREInstall> iterator;
            if (platformSREInstalls == null) {
                String oldDefaultId;
                platformSREInstalls = new HashSet<String>();
                ALL_SRE_INSTALLS.clear();
                if (enableSreExtensionPoints) {
                    SARLRuntime.initializeSREExtensions();
                }
                String predefinedDefaultId = Strings.nullToEmpty((String)SARLRuntime.initializePersistedSREs());
                newSREs = new ISREInstall[ALL_SRE_INSTALLS.size()];
                ISREInstall initDefaultSRE = null;
                iterator = ALL_SRE_INSTALLS.values().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    ISREInstall sre;
                    newSREs[i] = sre = iterator.next();
                    if (sre.getValidity().isOK() && initDefaultSRE == null && sre.getId().equals(predefinedDefaultId)) {
                        initDefaultSRE = sre;
                    }
                    ++i;
                }
                defaultSREId = oldDefaultId = initDefaultSRE == null ? null : initDefaultSRE.getId();
                savePrefs = true;
            }
            if (Strings.isNullOrEmpty((String)defaultSREId)) {
                ISREInstall firstSRE = null;
                ISREInstall firstValidSRE = null;
                iterator = ALL_SRE_INSTALLS.values().iterator();
                while (firstValidSRE == null && iterator.hasNext()) {
                    ISREInstall sre = iterator.next();
                    if (firstSRE == null) {
                        firstSRE = sre;
                    }
                    if (!sre.getValidity().isOK()) continue;
                    firstValidSRE = sre;
                }
                if (firstValidSRE == null) {
                    firstValidSRE = firstSRE;
                }
                if (firstValidSRE != null) {
                    savePrefs = true;
                    defaultSREId = firstValidSRE.getId();
                }
            }
        }
        finally {
            LOCK.unlock();
        }
        if (savePrefs) {
            SARLRuntime.safeSaveSREConfiguration();
        }
        if (newSREs.length > 0) {
            ISREInstall[] iSREInstallArray = newSREs;
            int n = newSREs.length;
            int n2 = 0;
            while (n2 < n) {
                ISREInstall sre = iSREInstallArray[n2];
                SARLRuntime.fireSREAdded(sre);
                ++n2;
            }
        }
        if (!Objects.equal((Object)previousDefault, (Object)defaultSREId)) {
            SARLRuntime.fireDefaultSREChanged(SARLRuntime.getSREFromId(previousDefault), SARLRuntime.getSREFromId(defaultSREId));
        }
    }

    private static void safeSaveSREConfiguration() {
        try {
            SARLRuntime.saveSREConfiguration(null);
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
        }
    }

    public static String createUniqueIdentifier() {
        String id;
        while (SARLRuntime.getSREFromId(id = UUID.randomUUID().toString()) != null) {
        }
        return id;
    }

    public static void reset() throws CoreException {
        LOCK.lock();
        try {
            SARLRuntime.clearSREConfiguration();
            ISREInstall previous = SARLRuntime.getDefaultSREInstall();
            HashMap<String, ISREInstall> oldSREs = new HashMap<String, ISREInstall>(ALL_SRE_INSTALLS);
            ALL_SRE_INSTALLS.clear();
            platformSREInstalls = null;
            defaultSREId = null;
            for (ISREInstall sre : oldSREs.values()) {
                SARLRuntime.fireSRERemoved(sre);
            }
            if (previous != null) {
                SARLRuntime.fireDefaultSREChanged(previous, null);
            }
            SARLRuntime.initializeSREs();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUnpackedSRE(File directory) {
        File manifestFile = new File(directory, "META-INF");
        if (!(manifestFile = new File(manifestFile, "MANIFEST.MF")).canRead()) return false;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream manifestStream = new FileInputStream(manifestFile);){
                boolean bl;
                Manifest manifest = new Manifest(manifestStream);
                Attributes sarlSection = manifest.getAttributes("SARL-Runtime-Environment");
                if (sarlSection == null) {
                    return false;
                }
                String sarlVersion = sarlSection.getValue("SARL-Spec-Version");
                if (sarlVersion == null) return false;
                if (sarlVersion.isEmpty()) {
                    return false;
                }
                Version sarlVer = Version.parseVersion((String)sarlVersion);
                if (sarlVer != null) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isUnpackedSRE(IPath directory) {
        block4: {
            try {
                File file;
                IPath path;
                IFile location = ResourcesPlugin.getWorkspace().getRoot().getFile(directory);
                if (location == null || (path = location.getLocation()) == null || !(file = path.toFile()).exists()) break block4;
                if (file.isDirectory()) {
                    return SARLRuntime.isUnpackedSRE(file);
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return SARLRuntime.isUnpackedSRE(directory.makeAbsolute().toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPackedSRE(File jarFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JarFile jFile = new JarFile(jarFile);){
                boolean bl;
                Manifest manifest = jFile.getManifest();
                if (manifest == null) {
                    return false;
                }
                Attributes sarlSection = manifest.getAttributes("SARL-Runtime-Environment");
                if (sarlSection == null) {
                    return false;
                }
                String sarlVersion = sarlSection.getValue("SARL-Spec-Version");
                if (sarlVersion == null) return false;
                if (sarlVersion.isEmpty()) {
                    return false;
                }
                Version sarlVer = Version.parseVersion((String)sarlVersion);
                if (sarlVer != null) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isPackedSRE(IPath jarFile) {
        block4: {
            try {
                File file;
                IPath path;
                IFile location = ResourcesPlugin.getWorkspace().getRoot().getFile(jarFile);
                if (location == null || (path = location.getLocation()) == null || !(file = path.toFile()).exists()) break block4;
                if (file.isFile()) {
                    return SARLRuntime.isPackedSRE(file);
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return SARLRuntime.isPackedSRE(jarFile.makeAbsolute().toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsUnpackedBootstrap(File directory) {
        String[] elements = "META-INF/services/io.sarl.bootstrap.SREBootstrap".split("/");
        File serviceFile = directory;
        Object object = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = object[n2];
            serviceFile = new File(serviceFile, element);
            ++n2;
        }
        if (!serviceFile.isFile()) return false;
        if (!serviceFile.canRead()) return false;
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (FileInputStream is = new FileInputStream(serviceFile);){
                object = null;
                Object var7_12 = null;
                try {
                    BufferedReader reader;
                    block17: {
                        reader = new BufferedReader(new InputStreamReader(is));
                        try {
                            String line = reader.readLine();
                            if (line == null || (line = line.trim()).isEmpty()) break block17;
                            if (reader == null) return true;
                        }
                        catch (Throwable throwable2) {
                            if (reader == null) throw throwable2;
                            reader.close();
                            throw throwable2;
                        }
                        reader.close();
                        return true;
                    }
                    if (reader == null) return false;
                    reader.close();
                    return false;
                }
                catch (Throwable throwable3) {
                    if (object == null) {
                        object = throwable3;
                        throw object;
                    }
                    if (object == throwable3) throw object;
                    ((Throwable)object).addSuppressed(throwable3);
                    throw object;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static boolean containsUnpackedBootstrap(IPath directory) {
        File file;
        IPath path;
        IFile location = ResourcesPlugin.getWorkspace().getRoot().getFile(directory);
        if (location != null && (path = location.getLocation()) != null && (file = path.toFile()).exists()) {
            if (file.isDirectory()) {
                return SARLRuntime.containsUnpackedBootstrap(file);
            }
            return false;
        }
        return SARLRuntime.containsUnpackedBootstrap(directory.makeAbsolute().toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsPackedBootstrap(File jarFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JarFile jFile = new JarFile(jarFile);){
                BufferedReader reader;
                block24: {
                    ZipEntry jEntry = jFile.getEntry("META-INF/services/io.sarl.bootstrap.SREBootstrap");
                    if (jEntry == null) return false;
                    Throwable throwable2 = null;
                    Object var6_9 = null;
                    try {
                        InputStream is = jFile.getInputStream(jEntry);
                        Throwable throwable3 = null;
                        Object var9_14 = null;
                        try {
                            block25: {
                                reader = new BufferedReader(new InputStreamReader(is));
                                try {
                                    String line = reader.readLine();
                                    if (line == null || (line = line.trim()).isEmpty()) break block24;
                                    if (reader == null) break block25;
                                }
                                catch (Throwable throwable4) {
                                    if (reader == null) throw throwable4;
                                    reader.close();
                                    throw throwable4;
                                }
                                reader.close();
                            }
                            if (is == null) return true;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                        is.close();
                        return true;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                if (reader == null) return false;
                reader.close();
                return false;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static boolean containsPackedBootstrap(IPath jarFile) {
        block4: {
            try {
                File file;
                IPath path;
                IFile location = ResourcesPlugin.getWorkspace().getRoot().getFile(jarFile);
                if (location == null || (path = location.getLocation()) == null || !(file = path.toFile()).exists()) break block4;
                if (file.isFile()) {
                    return SARLRuntime.containsPackedBootstrap(file);
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return SARLRuntime.containsPackedBootstrap(jarFile.makeAbsolute().toFile());
    }

    public static String getDeclaredBootstrap(IPath path) {
        block8: {
            try {
                File file;
                IPath pathLocation;
                IFile location = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (location == null || (pathLocation = location.getLocation()) == null || !(file = pathLocation.toFile()).exists()) break block8;
                if (file.isDirectory()) {
                    return SARLRuntime.getDeclaredBootstrapInFolder(file);
                }
                if (file.isFile()) {
                    return SARLRuntime.getDeclaredBootstrapInJar(file);
                }
                return null;
            }
            catch (Exception exception) {}
        }
        File file = path.makeAbsolute().toFile();
        if (file.exists()) {
            if (file.isDirectory()) {
                return SARLRuntime.getDeclaredBootstrapInJar(file);
            }
            if (file.isFile()) {
                return SARLRuntime.getDeclaredBootstrapInFolder(file);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDeclaredBootstrapInJar(File jarFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JarFile jFile = new JarFile(jarFile);){
                BufferedReader reader;
                block24: {
                    ZipEntry jEntry = jFile.getEntry("META-INF/services/io.sarl.bootstrap.SREBootstrap");
                    if (jEntry == null) return null;
                    Throwable throwable2 = null;
                    Object var6_9 = null;
                    try {
                        String string;
                        InputStream is = jFile.getInputStream(jEntry);
                        Throwable throwable3 = null;
                        Object var9_14 = null;
                        try {
                            block25: {
                                reader = new BufferedReader(new InputStreamReader(is));
                                try {
                                    String line = reader.readLine();
                                    if (line == null || (line = line.trim()).isEmpty()) break block24;
                                    string = line;
                                    if (reader == null) break block25;
                                }
                                catch (Throwable throwable4) {
                                    if (reader == null) throw throwable4;
                                    reader.close();
                                    throw throwable4;
                                }
                                reader.close();
                            }
                            if (is == null) return string;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                        is.close();
                        return string;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                if (reader == null) return null;
                reader.close();
                return null;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDeclaredBootstrapInFolder(File directory) {
        String[] elements = "META-INF/services/io.sarl.bootstrap.SREBootstrap".split("/");
        File serviceFile = directory;
        Object object = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = object[n2];
            serviceFile = new File(serviceFile, element);
            ++n2;
        }
        if (!serviceFile.isFile()) return null;
        if (!serviceFile.canRead()) return null;
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (FileInputStream is = new FileInputStream(serviceFile);){
                object = null;
                Object var7_12 = null;
                try {
                    BufferedReader reader;
                    block17: {
                        String string;
                        reader = new BufferedReader(new InputStreamReader(is));
                        try {
                            String line = reader.readLine();
                            if (line == null || (line = line.trim()).isEmpty()) break block17;
                            string = line;
                            if (reader == null) return string;
                        }
                        catch (Throwable throwable2) {
                            if (reader == null) throw throwable2;
                            reader.close();
                            throw throwable2;
                        }
                        reader.close();
                        return string;
                    }
                    if (reader == null) return null;
                    reader.close();
                    return null;
                }
                catch (Throwable throwable3) {
                    if (object == null) {
                        object = throwable3;
                        throw object;
                    }
                    if (object == throwable3) throw object;
                    ((Throwable)object).addSuppressed(throwable3);
                    throw object;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

