/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.runtime;

import com.google.common.base.MoreObjects;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProvider;
import io.sarl.apputils.eclipseextensions.sreprovider.ProjectSREProviderFactory;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.ISREInstallChangedListener;
import io.sarl.eclipse.runtime.Messages;
import io.sarl.eclipse.runtime.ProjectProvider;
import io.sarl.eclipse.runtime.SARLRuntime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SREConfigurationBlock {
    public static final String PROPERTY_SRE_CONFIGURATION = "PROPERTY_SRE_CONFIGURATION";
    private Composite control;
    private final ListenerList<IPropertyChangeListener> listeners = new ListenerList();
    private final String title;
    private ISREInstallChangedListener sreListener;
    private final boolean enableSystemWideSelector;
    private final List<ProjectSREProviderFactory> projectProviderFactories;
    private final ProjectProvider project;
    private ProjectSREProvider projectProvider;
    private Button systemSREButton;
    private Button projectSREButton;
    private Button specificSREButton;
    private final List<ISREInstall> runtimeEnvironments = new ArrayList<ISREInstall>();
    private Combo runtimeEnvironmentCombo;
    private Button runtimeEnvironmentSearchButton;
    private boolean notify = true;

    public SREConfigurationBlock(boolean enableSystemWideSelector, ProjectProvider project, List<ProjectSREProviderFactory> projectProviderFactories) {
        this(null, enableSystemWideSelector, project, projectProviderFactories);
    }

    public SREConfigurationBlock(String title, boolean enableSystemWideSelector, ProjectProvider project, List<ProjectSREProviderFactory> projectProviderFactories) {
        this.title = title;
        this.enableSystemWideSelector = enableSystemWideSelector;
        this.project = project;
        this.projectProviderFactories = projectProviderFactories != null ? projectProviderFactories : Collections.emptyList();
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        if (this.notify) {
            org.eclipse.jface.util.PropertyChangeEvent event = new org.eclipse.jface.util.PropertyChangeEvent((Object)this, PROPERTY_SRE_CONFIGURATION, null, (Object)this.getSelectedSRE());
            Object[] listeners = this.listeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                listener.propertyChange(event);
                ++i;
            }
        }
    }

    private ISREInstall retreiveProjectSRE() {
        if (this.projectProviderFactories.isEmpty() || this.project == null) {
            return null;
        }
        if (this.projectProvider == null) {
            IProject project = this.project.getProject();
            if (project == null) {
                return null;
            }
            Iterator<ProjectSREProviderFactory> iterator = this.projectProviderFactories.iterator();
            while (this.projectProvider == null && iterator.hasNext()) {
                ProjectSREProviderFactory factory = iterator.next();
                this.projectProvider = factory.getProjectSREProvider(project);
            }
            if (this.projectProvider == null) {
                return null;
            }
        }
        return this.projectProvider.getProjectSREInstall();
    }

    private void doSystemSREButtonClick() {
        if (this.specificSREButton != null) {
            this.specificSREButton.setSelection(false);
        }
        if (this.projectSREButton != null) {
            this.projectSREButton.setSelection(false);
        }
        if (this.systemSREButton != null) {
            this.systemSREButton.setSelection(true);
        }
        this.handleSystemWideConfigurationSelected();
    }

    private void doProjectSREButtonClick() {
        if (this.specificSREButton != null) {
            this.specificSREButton.setSelection(false);
        }
        if (this.systemSREButton != null) {
            this.systemSREButton.setSelection(false);
        }
        if (this.projectSREButton != null) {
            this.projectSREButton.setSelection(true);
        }
        this.handleProjectConfigurationSelected();
    }

    private void doSpecificSREButtonClick() {
        if (this.systemSREButton != null) {
            this.systemSREButton.setSelection(false);
        }
        if (this.projectSREButton != null) {
            this.projectSREButton.setSelection(false);
        }
        if (this.specificSREButton != null) {
            this.specificSREButton.setSelection(true);
        }
        this.handleSpecificConfigurationSelected();
    }

    private void createSystemWideSelector(Group parent) {
        if (this.enableSystemWideSelector) {
            ISREInstall wideSystemSRE = SARLRuntime.getDefaultSREInstall();
            String wideSystemSRELabel = wideSystemSRE == null ? Messages.SREConfigurationBlock_0 : wideSystemSRE.getName();
            this.systemSREButton = SWTFactory.createRadioButton((Composite)parent, (String)MessageFormat.format(Messages.SREConfigurationBlock_1, wideSystemSRELabel), (int)3);
            this.systemSREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (SREConfigurationBlock.this.systemSREButton.getSelection()) {
                        SREConfigurationBlock.this.handleSystemWideConfigurationSelected();
                    }
                }
            });
        }
    }

    private void createSRESelector(Group parent) {
        this.runtimeEnvironmentCombo = SWTFactory.createCombo((Composite)parent, (int)12, (int)1, (String[])new String[0]);
        this.runtimeEnvironmentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SREConfigurationBlock.this.firePropertyChange();
            }
        });
        ControlAccessibleListener.addListener((Control)this.runtimeEnvironmentCombo, (String)parent.getText());
        this.runtimeEnvironmentSearchButton = SWTFactory.createPushButton((Composite)parent, (String)Messages.SREConfigurationBlock_4, null);
        this.runtimeEnvironmentSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SREConfigurationBlock.this.handleInstalledSREsButtonSelected();
            }
        });
    }

    private void createProjectSelector(Group parent) {
        if (!this.projectProviderFactories.isEmpty()) {
            this.projectSREButton = SWTFactory.createRadioButton((Composite)parent, (String)MessageFormat.format(Messages.SREConfigurationBlock_3, Messages.SREConfigurationBlock_0), (int)3);
            this.projectSREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (SREConfigurationBlock.this.projectSREButton.getSelection()) {
                        SREConfigurationBlock.this.handleProjectConfigurationSelected();
                    }
                }
            });
        }
    }

    public Control createControl(Composite parent) {
        this.control = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        int nbColumns = this.enableSystemWideSelector ? 3 : 2;
        Group group = SWTFactory.createGroup((Composite)this.control, (String)((String)MoreObjects.firstNonNull((Object)this.title, (Object)Messages.SREConfigurationBlock_7)), (int)nbColumns, (int)1, (int)768);
        if (this.enableSystemWideSelector || !this.projectProviderFactories.isEmpty()) {
            this.createSystemWideSelector(group);
            this.createProjectSelector(group);
            this.specificSREButton = SWTFactory.createRadioButton((Composite)group, (String)Messages.SREConfigurationBlock_2, (int)1);
            this.specificSREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (SREConfigurationBlock.this.specificSREButton.getSelection()) {
                        SREConfigurationBlock.this.handleSpecificConfigurationSelected();
                    }
                }
            });
        } else {
            this.systemSREButton = null;
            this.projectSREButton = null;
            this.specificSREButton = null;
        }
        this.createSRESelector(group);
        return this.getControl();
    }

    public void updateExternalSREButtonLabels() {
        if (this.enableSystemWideSelector) {
            ISREInstall wideSystemSRE = SARLRuntime.getDefaultSREInstall();
            String wideSystemSRELabel = wideSystemSRE == null ? Messages.SREConfigurationBlock_0 : wideSystemSRE.getName();
            this.systemSREButton.setText(MessageFormat.format(Messages.SREConfigurationBlock_1, wideSystemSRELabel));
        }
        if (!this.projectProviderFactories.isEmpty()) {
            ISREInstall projectSRE = this.retreiveProjectSRE();
            String projectSRELabel = projectSRE == null ? Messages.SREConfigurationBlock_0 : projectSRE.getName();
            this.projectSREButton.setText(MessageFormat.format(Messages.SREConfigurationBlock_3, projectSRELabel));
        }
    }

    public Composite getControl() {
        return this.control;
    }

    public final boolean selectSRE(ISREInstall sre) {
        if (sre == null) {
            if (this.enableSystemWideSelector) {
                return this.selectSystemWideSRE();
            }
            if (!this.projectProviderFactories.isEmpty()) {
                return this.selectProjectSRE();
            }
        }
        return this.selectSpecificSRE(sre);
    }

    public boolean selectSystemWideSRE() {
        if (this.enableSystemWideSelector && !this.systemSREButton.getSelection()) {
            this.doSystemSREButtonClick();
            return true;
        }
        return false;
    }

    public boolean selectProjectSRE() {
        if (!this.projectProviderFactories.isEmpty() && !this.projectSREButton.getSelection()) {
            this.doProjectSREButtonClick();
            return true;
        }
        return false;
    }

    public boolean selectSpecificSRE() {
        if (this.enableSystemWideSelector && this.systemSREButton.getSelection()) {
            this.doSpecificSREButtonClick();
            return true;
        }
        return false;
    }

    public boolean selectSpecificSRE(ISREInstall sre) {
        ISREInstall theSRE = sre;
        if (theSRE == null) {
            theSRE = SARLRuntime.getDefaultSREInstall();
        }
        if (theSRE != null) {
            boolean changed = false;
            boolean oldNotify = this.notify;
            try {
                int selection;
                int index;
                ISREInstall oldSRE;
                this.notify = false;
                if (this.isSystemWideDefaultSRE()) {
                    this.doSpecificSREButtonClick();
                    changed = true;
                }
                if ((oldSRE = this.getSelectedSRE()) != theSRE && (index = this.indexOf(theSRE)) >= 0) {
                    this.runtimeEnvironmentCombo.select(index);
                    changed = true;
                }
                if (!(this.runtimeEnvironments.isEmpty() || (selection = this.runtimeEnvironmentCombo.getSelectionIndex()) >= 0 && selection < this.runtimeEnvironments.size())) {
                    selection = this.indexOf(theSRE);
                    this.runtimeEnvironmentCombo.select(selection < 0 ? 0 : selection);
                    changed = true;
                }
            }
            finally {
                this.notify = oldNotify;
            }
            if (changed) {
                this.firePropertyChange();
                return true;
            }
        }
        return false;
    }

    private int indexOf(ISREInstall sre) {
        if (sre != null) {
            Iterator<ISREInstall> iterator = this.runtimeEnvironments.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                ISREInstall knownSRE = iterator.next();
                if (knownSRE.getId().equals(sre.getId())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String[] getSRELabels() {
        String[] labels = new String[this.runtimeEnvironments.size()];
        int i = 0;
        while (i < this.runtimeEnvironments.size()) {
            labels[i] = this.runtimeEnvironments.get(i).getName();
            ++i;
        }
        return labels;
    }

    public boolean isSystemWideDefaultSRE() {
        return this.enableSystemWideSelector && this.systemSREButton.getSelection();
    }

    public boolean isProjectSRE() {
        return !this.projectProviderFactories.isEmpty() && this.projectSREButton.getSelection();
    }

    public ISREInstall getSelectedSRE() {
        if (this.enableSystemWideSelector && this.systemSREButton.getSelection()) {
            return SARLRuntime.getDefaultSREInstall();
        }
        if (!this.projectProviderFactories.isEmpty() && this.projectSREButton.getSelection()) {
            return this.retreiveProjectSRE();
        }
        return this.getSpecificSRE();
    }

    public ISREInstall getSpecificSRE() {
        int index = this.runtimeEnvironmentCombo.getSelectionIndex();
        if (index >= 0 && index < this.runtimeEnvironments.size()) {
            return this.runtimeEnvironments.get(index);
        }
        return null;
    }

    public void updateEnableState() {
        boolean comboEnabled = !this.runtimeEnvironments.isEmpty();
        boolean searchEnabled = true;
        if (this.isSystemWideDefaultSRE() || this.isProjectSRE()) {
            comboEnabled = false;
            searchEnabled = false;
        }
        this.runtimeEnvironmentCombo.setEnabled(comboEnabled);
        this.runtimeEnvironmentSearchButton.setEnabled(searchEnabled);
    }

    public void initialize() {
        this.runtimeEnvironments.clear();
        ISREInstall[] sres = SARLRuntime.getSREInstalls();
        Arrays.sort(sres, new Comparator<ISREInstall>(){

            @Override
            public int compare(ISREInstall o1, ISREInstall o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<String> labels = new ArrayList<String>(sres.length);
        int i = 0;
        while (i < sres.length) {
            if (sres[i].getValidity().isOK()) {
                this.runtimeEnvironments.add(sres[i]);
                labels.add(sres[i].getName());
            }
            ++i;
        }
        this.runtimeEnvironmentCombo.setItems(labels.toArray(new String[labels.size()]));
        this.updateExternalSREButtonLabels();
        if (this.enableSystemWideSelector) {
            this.specificSREButton.setSelection(false);
            if (!this.projectProviderFactories.isEmpty()) {
                this.projectSREButton.setSelection(false);
            }
            this.systemSREButton.setSelection(true);
        } else if (!this.projectProviderFactories.isEmpty()) {
            this.specificSREButton.setSelection(false);
            if (this.enableSystemWideSelector) {
                this.systemSREButton.setSelection(false);
            }
            this.projectSREButton.setSelection(true);
        }
        this.sreListener = new InstallChange();
        SARLRuntime.addSREInstallChangedListener(this.sreListener);
        this.updateEnableState();
        this.firePropertyChange();
    }

    public void dispose() {
        if (this.sreListener != null) {
            SARLRuntime.removeSREInstallChangedListener(this.sreListener);
            this.sreListener = null;
        }
    }

    protected void handleInstalledSREsButtonSelected() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getControl().getShell(), (String)"io.sarl.eclipse.preferences.SREsPreferencePage", (String[])new String[]{"io.sarl.eclipse.preferences.SREsPreferencePage"}, null).open();
    }

    protected void handleSystemWideConfigurationSelected() {
        this.updateEnableState();
        this.firePropertyChange();
    }

    protected void handleProjectConfigurationSelected() {
        this.updateEnableState();
        this.firePropertyChange();
    }

    protected void handleSpecificConfigurationSelected() {
        this.updateEnableState();
        this.firePropertyChange();
    }

    public IStatus validate(ISREInstall sre) {
        IStatus status = this.enableSystemWideSelector && this.systemSREButton.getSelection() ? (SARLRuntime.getDefaultSREInstall() == null ? SARLEclipsePlugin.getDefault().createStatus(4, Messages.SREConfigurationBlock_5) : SARLEclipsePlugin.getDefault().createOkStatus()) : (!this.projectProviderFactories.isEmpty() && this.projectSREButton.getSelection() ? (this.retreiveProjectSRE() == null ? SARLEclipsePlugin.getDefault().createStatus(4, Messages.SREConfigurationBlock_6) : SARLEclipsePlugin.getDefault().createOkStatus()) : (this.runtimeEnvironments.isEmpty() ? SARLEclipsePlugin.getDefault().createStatus(4, Messages.SREConfigurationBlock_8) : sre.getValidity()));
        return status;
    }

    private class InstallChange
    implements ISREInstallChangedListener {
        InstallChange() {
        }

        @Override
        public void sreRemoved(ISREInstall sre) {
            int index = SREConfigurationBlock.this.indexOf(sre);
            if (index >= 0) {
                SREConfigurationBlock.this.runtimeEnvironments.remove(index);
                SREConfigurationBlock.this.runtimeEnvironmentCombo.setItems(SREConfigurationBlock.this.getSRELabels());
                SREConfigurationBlock.this.updateEnableState();
                index = SREConfigurationBlock.this.runtimeEnvironmentCombo.getSelectionIndex();
                if (index < 0) {
                    index = SREConfigurationBlock.this.runtimeEnvironmentCombo.getItemCount() - 1;
                    SREConfigurationBlock.this.runtimeEnvironmentCombo.select(index);
                }
            }
        }

        @Override
        public void sreChanged(PropertyChangeEvent event) {
            if (!"io.sarl.eclipse.PROPERTY_NAME".equals(event.getProperty()) && !"io.sarl.eclipse.PROPERTY_MAINCLASS".equals(event.getProperty())) {
                return;
            }
            ISREInstall sre = (ISREInstall)event.getSource();
            if (SREConfigurationBlock.this.indexOf(sre) >= 0) {
                SREConfigurationBlock.this.runtimeEnvironmentCombo.setItems(SREConfigurationBlock.this.getSRELabels());
                int index = SREConfigurationBlock.this.runtimeEnvironmentCombo.getSelectionIndex();
                if (index < 0) {
                    index = SREConfigurationBlock.this.indexOf(sre);
                    if (index < 0) {
                        index = SREConfigurationBlock.this.runtimeEnvironmentCombo.getItemCount() - 1;
                    }
                    SREConfigurationBlock.this.runtimeEnvironmentCombo.select(index);
                }
                if (sre == SARLRuntime.getDefaultSREInstall()) {
                    SREConfigurationBlock.this.updateExternalSREButtonLabels();
                }
            }
        }

        @Override
        public void sreAdded(ISREInstall sre) {
            if (sre.getValidity().isOK()) {
                ISREInstall current = SREConfigurationBlock.this.getSpecificSRE();
                SREConfigurationBlock.this.runtimeEnvironments.add(sre);
                SREConfigurationBlock.this.runtimeEnvironmentCombo.setItems(SREConfigurationBlock.this.getSRELabels());
                SREConfigurationBlock.this.updateEnableState();
                int index = SREConfigurationBlock.this.indexOf(current);
                if (index < 0 && SREConfigurationBlock.this.runtimeEnvironmentCombo.getItemCount() > 0) {
                    index = 0;
                }
                if (index >= 0) {
                    SREConfigurationBlock.this.runtimeEnvironmentCombo.select(index);
                }
            }
        }

        @Override
        public void defaultSREInstallChanged(ISREInstall previous, ISREInstall current) {
            SREConfigurationBlock.this.updateExternalSREButtonLabels();
        }
    }
}

