/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.typehierarchy;

import com.google.inject.Inject;
import io.sarl.eclipse.typehierarchy.SarlScriptTypeSelector;
import io.sarl.eclipse.util.AbstractSarlScriptInteractiveSelector;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;

public class OpenTypeHierarchyHandler
extends AbstractHandler {
    @Inject
    private SarlScriptTypeSelector typeSelector;
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private SarlJvmModelAssociations sarlAssociations;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection activeSelection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (activeSelection != null && activeSelection != StructuredSelection.EMPTY) {
            AbstractSarlScriptInteractiveSelector.ElementDescription selectedElement = this.typeSelector.searchAndSelect(false, activeSelection.toArray());
            if (selectedElement != null) {
                XtendTypeDeclaration cvalue;
                EObject jvmElement;
                IJavaElement realJavaElement = null;
                if (selectedElement.element instanceof IJavaElement) {
                    IJavaElement cvalue2;
                    realJavaElement = cvalue2 = (IJavaElement)selectedElement.element;
                } else if (selectedElement.element instanceof XtendTypeDeclaration && (jvmElement = this.sarlAssociations.getPrimaryJvmElement((EObject)(cvalue = (XtendTypeDeclaration)selectedElement.element))) instanceof JvmIdentifiableElement) {
                    JvmIdentifiableElement cvalue0 = (JvmIdentifiableElement)jvmElement;
                    realJavaElement = this.javaElementFinder.findElementFor(cvalue0);
                }
                if (realJavaElement != null) {
                    OpenTypeHierarchyUtil.open((IJavaElement)realJavaElement, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
            } else {
                OpenTypeHierarchyAction jdtTool = new OpenTypeHierarchyAction(HandlerUtil.getActiveSite((ExecutionEvent)event));
                jdtTool.run(activeSelection);
            }
        }
        return null;
    }
}

