/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.util;

import com.google.inject.Inject;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.launching.config.ILaunchConfigurationConfigurator;
import io.sarl.eclipse.util.Jdt2Ecore;
import io.sarl.eclipse.util.Messages;
import io.sarl.lang.core.Agent;
import io.sarl.lang.sarl.SarlScript;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public abstract class AbstractSarlScriptInteractiveSelector<ET extends EObject, JT> {
    @Inject
    protected IStorage2UriMapper storage2UriMapper;
    @Inject
    protected ILaunchConfigurationConfigurator configurator;
    @Inject
    protected IResourceSetProvider resourceSetProvider;
    @Inject
    protected Jdt2Ecore jdt;
    @Inject
    protected ILabelProvider labelProvider;

    protected boolean isValidResource(IResource resource) {
        return resource.isAccessible() && !resource.isHidden() && !resource.isPhantom() && !resource.isDerived();
    }

    protected abstract boolean isSelectableElement(ET var1);

    protected abstract URI getResourceURIForValidEObject(Object var1);

    protected abstract Class<ET> getValidEObjectType();

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected abstract String getQualifiedNameFor(ET var1);

    private List<ElementDescription> findElements(Object[] selection, IProgressService progress) throws InvocationTargetException, InterruptedException {
        ArrayList<ElementDescription> descs = new ArrayList<ElementDescription>();
        progress.busyCursorWhile(monitor -> {
            try {
                monitor.beginTask(MessageFormat.format(Messages.AbstractSarlScriptInteractiveSelector_0, this.getElementsLabel()), selection.length);
                Object[] objectArray2 = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray2[n2];
                    URI fileURI = this.getResourceURIForValidEObject(element);
                    if (fileURI != null) {
                        Iterator iterator = this.storage2UriMapper.getStorages(fileURI).iterator();
                        if (iterator.hasNext()) {
                            Pair storage = (Pair)iterator.next();
                            descs.add(new ElementDescription(((IProject)storage.getSecond()).getName(), this.getQualifiedNameFor((EObject)element), element));
                        }
                    } else {
                        LinkedList<Object> stack = new LinkedList<Object>();
                        stack.add(element);
                        Class<ET> validElementType = this.getValidEObjectType();
                        while (!stack.isEmpty()) {
                            Object current = stack.removeFirst();
                            if (current instanceof IFile) {
                                IFile file = (IFile)current;
                                if (!this.isValidResource((IResource)file)) continue;
                                ResourceSet resourceSet = this.resourceSetProvider.get(file.getProject());
                                URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                                if (resourceURI == null) continue;
                                try {
                                    Resource resource = resourceSet.getResource(resourceURI, true);
                                    if (resource == null) continue;
                                    String projectName = file.getProject().getName();
                                    for (EObject content : resource.getContents()) {
                                        if (!(content instanceof SarlScript)) continue;
                                        List types = EcoreUtil2.getAllContentsOfType((EObject)content, validElementType);
                                        for (EObject elt : types) {
                                            if (!this.isSelectableElement(elt)) continue;
                                            descs.add(new ElementDescription(projectName, this.getQualifiedNameFor(elt), elt));
                                        }
                                    }
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            if (current instanceof IFolder) {
                                IFolder folder = (IFolder)current;
                                if (!this.isValidResource((IResource)folder)) continue;
                                try {
                                    stack.addAll(Arrays.asList(folder.members(0)));
                                }
                                catch (CoreException coreException) {}
                                continue;
                            }
                            if (current instanceof IType) {
                                IType type = (IType)current;
                                String qn = type.getFullyQualifiedName();
                                IJavaProject project = type.getJavaProject();
                                if (!this.jdt.isSubClassOf(this.jdt.toTypeFinder(project), qn, Agent.class.getName())) continue;
                                descs.add(new ElementDescription(project.getElementName(), qn, type));
                                continue;
                            }
                            if (current instanceof IPackageFragment) {
                                IPackageFragment fragment = (IPackageFragment)current;
                                stack.addAll(Arrays.asList(fragment.getNonJavaResources()));
                                IJavaElement[] iJavaElementArray = fragment.getChildren();
                                int n3 = iJavaElementArray.length;
                                int content = 0;
                                while (content < n3) {
                                    IJavaElement child = iJavaElementArray[content];
                                    stack.add(child);
                                    ++content;
                                }
                                continue;
                            }
                            if (current instanceof IPackageFragmentRoot) {
                                IPackageFragmentRoot fragment = (IPackageFragmentRoot)current;
                                stack.addAll(Arrays.asList(fragment.getNonJavaResources()));
                                IJavaElement[] iJavaElementArray = fragment.getChildren();
                                int n4 = iJavaElementArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    IJavaElement child = iJavaElementArray[n5];
                                    stack.add(child);
                                    ++n5;
                                }
                                continue;
                            }
                            if (!(current instanceof IJavaProject)) continue;
                            IJavaProject cvalue = (IJavaProject)current;
                            stack.addAll(Arrays.asList(cvalue.getNonJavaResources()));
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
            }
            catch (JavaModelException exception) {
                throw new InvocationTargetException(exception);
            }
        });
        return descs;
    }

    public ElementDescription searchAndSelect(boolean showEmptySelectionError, Object ... scope) {
        try {
            List<ElementDescription> elements = this.findElements(scope, PlatformUI.getWorkbench().getProgressService());
            ElementDescription element = null;
            if (elements == null || elements.isEmpty()) {
                if (showEmptySelectionError) {
                    SARLEclipsePlugin.getDefault().openError(AbstractSarlScriptInteractiveSelector.getShell(), Messages.AbstractSarlScriptInteractiveSelector_1, MessageFormat.format(Messages.AbstractSarlScriptInteractiveSelector_2, this.getElementLabel()), null, null);
                }
            } else {
                element = elements.size() > 1 ? this.chooseElement(elements) : elements.get(0);
            }
            return element;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            SARLEclipsePlugin.getDefault().openError(AbstractSarlScriptInteractiveSelector.getShell(), Messages.AbstractSarlScriptInteractiveSelector_1, null, null, exception);
        }
        return null;
    }

    protected abstract String getElementLabel();

    protected abstract String getElementLongLabel();

    protected abstract String getElementsLabel();

    private ElementDescription chooseElement(List<ElementDescription> elements) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractSarlScriptInteractiveSelector.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setElements(elements.toArray());
        dialog.setTitle(MessageFormat.format(Messages.AbstractSarlScriptInteractiveSelector_3, this.getElementLabel()));
        dialog.setMessage(MessageFormat.format(Messages.AbstractSarlScriptInteractiveSelector_3, this.getElementLongLabel()));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ElementDescription)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract Image getElementImage(Object var1);

    public static class ElementDescription {
        public final String projectName;
        public final String elementName;
        public final Object element;

        protected ElementDescription(String project, String name, Object element) {
            this.projectName = project;
            this.elementName = name;
            this.element = element;
        }

        public String toString() {
            return this.elementName;
        }
    }

    private class LabelProvider
    implements ILabelProvider {
        LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            AbstractSarlScriptInteractiveSelector.this.labelProvider.addListener(listener);
        }

        public void dispose() {
            AbstractSarlScriptInteractiveSelector.this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return AbstractSarlScriptInteractiveSelector.this.labelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            AbstractSarlScriptInteractiveSelector.this.labelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            if (element instanceof ElementDescription) {
                ElementDescription cvalue = (ElementDescription)element;
                return AbstractSarlScriptInteractiveSelector.this.getElementImage(cvalue.element);
            }
            return AbstractSarlScriptInteractiveSelector.this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ElementDescription) {
                ElementDescription cvalue = (ElementDescription)element;
                return cvalue.elementName;
            }
            return AbstractSarlScriptInteractiveSelector.this.labelProvider.getText(element);
        }
    }
}

