/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.util;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IFormalParameterBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlConstructorBuilder;
import io.sarl.lang.codebuilder.builders.ITypeParameterBuilder;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.FormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.util.Utils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;

@Singleton
public class Jdt2Ecore {
    private static final String GENERATED_NAME = "Generated";
    @Inject
    private TypeReferences ecoreTypeReferences;
    @Inject
    private TypesFactory ecoreTypeFactory;
    @Inject
    private IActionPrototypeProvider actionPrototypeProvider;

    public static ConversionContext contextualize(XtendTypeDeclaration context, TypeReferences references) {
        assert (references != null);
        return new EcoreTypeConversionContext(context, references);
    }

    public TypeFinder toTypeFinder(final IJavaProject project) {
        return new TypeFinder(){

            @Override
            public IType findType(String typeName) throws JavaModelException {
                return project.findType(typeName);
            }
        };
    }

    public boolean isValidSuperType(String typeName) {
        return !Strings.isNullOrEmpty((String)typeName) && !"java.lang.Object".equals(typeName);
    }

    public boolean isVisible(TypeFinder typeFinder, IType fromType, IMember target) throws JavaModelException {
        int flags = target.getFlags();
        if (Flags.isPublic((int)flags)) {
            return true;
        }
        String fromTypeName = fromType.getFullyQualifiedName();
        String memberType = target.getDeclaringType().getFullyQualifiedName();
        if (Flags.isPrivate((int)flags)) {
            return target.getDeclaringType().getFullyQualifiedName().equals(fromTypeName);
        }
        if (Flags.isProtected((int)flags)) {
            Object t = fromType;
            while (t != null) {
                if (memberType.equals(t.getFullyQualifiedName())) {
                    return true;
                }
                String typeName = t.getSuperclassName();
                t = Strings.isNullOrEmpty((String)typeName) ? null : typeFinder.findType(typeName);
            }
        }
        IPackageFragment f1 = target.getDeclaringType().getPackageFragment();
        IPackageFragment f2 = fromType.getPackageFragment();
        if (f1.isDefaultPackage()) {
            return f2.isDefaultPackage();
        }
        return f1.getElementName().equals(f2.getElementName());
    }

    public FormalParameterProvider getFormalParameterProvider(ConversionContext context, IMethod operation) throws JavaModelException {
        if (context == null) {
            throw new IllegalArgumentException("Null conversion context");
        }
        return new JdtFormalParameterList(context, operation);
    }

    private static void fillTypeParameters(XtendTypeDeclaration type, Map<String, JvmParameterizedTypeReference> typeParameters, TypeReferences references) {
        if (type != null && !type.isAnonymous()) {
            if (!type.isStatic()) {
                Jdt2Ecore.fillTypeParameters(type.getDeclaringType(), typeParameters, references);
            }
            try {
                Method method = type.getClass().getDeclaredMethod("getTypeParameters", new Class[0]);
                List params = (List)method.invoke((Object)type, new Object[0]);
                for (JvmTypeParameter param : params) {
                    JvmParameterizedTypeReference ref = references.createTypeRef((JvmType)param, new JvmTypeReference[0]);
                    typeParameters.put(param.getName(), ref);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void fillTypeParameters(IMethod operation, LocalConversionContext context) {
        try {
            TypeBasedLocalTypeResolver resolver = new TypeBasedLocalTypeResolver(operation.getDeclaringType());
            ITypeParameter[] iTypeParameterArray = operation.getTypeParameters();
            int n = iTypeParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter param = iTypeParameterArray[n2];
                String[] bounds = param.getBoundsSignatures();
                JvmTypeReference[] boundTypes = new JvmTypeReference[bounds.length];
                int i = 0;
                String[] stringArray = bounds;
                int n3 = bounds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String bound = stringArray[n4];
                    boundTypes[i] = this.convertSignatureFromJdt2Ecore(bound, resolver, context);
                    ++i;
                    ++n4;
                }
                JvmTypeParameter parameter = this.ecoreTypeFactory.createJvmTypeParameter();
                parameter.setName(param.getElementName());
                JvmTypeReference[] jvmTypeReferenceArray = boundTypes;
                int n5 = boundTypes.length;
                n3 = 0;
                while (n3 < n5) {
                    JvmTypeReference constraint = jvmTypeReferenceArray[n3];
                    JvmUpperBound upper = this.ecoreTypeFactory.createJvmUpperBound();
                    upper.setOwner((JvmConstraintOwner)parameter);
                    upper.setTypeReference(constraint);
                    parameter.getConstraints().add((Object)upper);
                    ++n3;
                }
                context.declareTypeParameter(param.getElementName(), this.ecoreTypeReferences.createTypeRef((JvmType)parameter, new JvmTypeReference[0]));
                ++n2;
            }
        }
        catch (Throwable throwable) {}
    }

    public IStatus populateInheritanceContext(ConversionContext context, TypeFinder typeFinder, Map<ActionPrototype, IMethod> finalOperations, Map<ActionPrototype, IMethod> overridableOperations, Map<String, IField> inheritedFields, Map<ActionPrototype, IMethod> operationsToImplement, Map<ActionParameterTypes, IMethod> superConstructors, String superClass, List<String> superInterfaces) throws JavaModelException {
        int n;
        IType type;
        SuperTypeIterator typeIterator;
        SARLEclipsePlugin plugin = SARLEclipsePlugin.getDefault();
        if (context == null) {
            return plugin.createStatus(4, "Null conversion context");
        }
        TreeSet<ActionPrototype> treatedElements = new TreeSet<ActionPrototype>();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (operationsToImplement != null) {
            typeIterator = new SuperTypeIterator(context, typeFinder, true, superInterfaces);
            while (typeIterator.hasNext()) {
                type = typeIterator.next();
                IMethod[] iMethodArray = type.getMethods();
                n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod operation = iMethodArray[n2];
                    if (!(Flags.isStatic((int)operation.getFlags()) || Flags.isFinal((int)operation.getFlags()) || operation.isLambdaMethod() || operation.isConstructor())) {
                        LocalConversionContext localContext = new LocalConversionContext(context);
                        this.fillTypeParameters(operation, localContext);
                        ActionParameterTypes sig = this.actionPrototypeProvider.createParameterTypes(Flags.isVarargs((int)operation.getFlags()), this.getFormalParameterProvider(localContext, operation));
                        ActionPrototype actionKey = this.actionPrototypeProvider.createActionPrototype(operation.getElementName(), sig);
                        if (treatedElements.add(actionKey)) {
                            if (Flags.isDefaultMethod((int)operation.getFlags())) {
                                if (!overridableOperations.containsKey(actionKey)) {
                                    overridableOperations.put(actionKey, operation);
                                }
                            } else if (!operationsToImplement.containsKey(actionKey)) {
                                operationsToImplement.put(actionKey, operation);
                            }
                        }
                    }
                    ++n2;
                }
            }
            statuses.addAll(typeIterator.getStatuses());
        }
        if (this.isValidSuperType(superClass)) {
            typeIterator = new SuperTypeIterator(context, typeFinder, false, superClass);
            while (typeIterator.hasNext()) {
                type = typeIterator.next();
                boolean checkForConstructors = superConstructors != null && type.getFullyQualifiedName().equals(superClass);
                IMethod[] iMethodArray = type.getMethods();
                int n3 = iMethodArray.length;
                n = 0;
                while (n < n3) {
                    IMethod operation = iMethodArray[n];
                    if (!Flags.isStatic((int)operation.getFlags()) && !operation.isLambdaMethod() && this.isVisible(typeFinder, type, (IMember)operation)) {
                        LocalConversionContext localContext = new LocalConversionContext(context);
                        this.fillTypeParameters(operation, localContext);
                        if (!operation.isConstructor() && !SarlUtils.isHiddenMember((String)operation.getElementName())) {
                            sig = this.actionPrototypeProvider.createParameterTypes(Flags.isVarargs((int)operation.getFlags()), this.getFormalParameterProvider(localContext, operation));
                            ActionPrototype actionKey = this.actionPrototypeProvider.createActionPrototype(operation.getElementName(), sig);
                            if (treatedElements.add(actionKey)) {
                                int flags = operation.getFlags();
                                if (Flags.isAbstract((int)flags) && !Flags.isDefaultMethod((int)flags)) {
                                    if (operationsToImplement != null) {
                                        operationsToImplement.put(actionKey, operation);
                                    }
                                } else if (Flags.isFinal((int)flags)) {
                                    if (finalOperations != null) {
                                        finalOperations.put(actionKey, operation);
                                    }
                                    if (operationsToImplement != null) {
                                        operationsToImplement.remove(actionKey);
                                    }
                                } else {
                                    if (overridableOperations != null) {
                                        overridableOperations.put(actionKey, operation);
                                    }
                                    if (operationsToImplement != null) {
                                        operationsToImplement.remove(actionKey);
                                    }
                                }
                            }
                        } else if (checkForConstructors && operation.isConstructor() && superConstructors != null) {
                            sig = this.actionPrototypeProvider.createParameterTypes(Flags.isVarargs((int)operation.getFlags()), this.getFormalParameterProvider(localContext, operation));
                            superConstructors.put(sig, operation);
                        }
                    }
                    ++n;
                }
                if (inheritedFields == null) continue;
                iMethodArray = type.getFields();
                n3 = iMethodArray.length;
                n = 0;
                while (n < n3) {
                    IMethod field = iMethodArray[n];
                    if (!Flags.isStatic((int)field.getFlags()) && !SarlUtils.isHiddenMember((String)field.getElementName()) && this.isVisible(typeFinder, type, (IMember)field)) {
                        inheritedFields.putIfAbsent(field.getElementName(), (IField)field);
                    }
                    ++n;
                }
            }
            statuses.addAll(typeIterator.getStatuses());
        }
        if (statuses.isEmpty()) {
            return plugin.createOkStatus();
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        return plugin.createMultiStatus(statuses);
    }

    public boolean isGeneratedOperation(IMethod method) {
        return this.getAnnotation((IAnnotatable)method, SyntheticMember.class.getName()) != null || this.getAnnotation((IAnnotatable)method, GENERATED_NAME) != null;
    }

    public IAnnotation getAnnotation(IAnnotatable element, String qualifiedName) {
        if (element != null) {
            try {
                int separator = qualifiedName.lastIndexOf(46);
                String simpleName = separator >= 0 && separator < qualifiedName.length() - 1 ? qualifiedName.substring(separator + 1, qualifiedName.length()) : qualifiedName;
                IAnnotation[] iAnnotationArray = element.getAnnotations();
                int n = iAnnotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    String name = annotation.getElementName();
                    if (name.equals(simpleName) || name.equals(qualifiedName)) {
                        return annotation;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public JvmConstructor getJvmConstructor(IMethod constructor, ConversionContext context) throws JavaModelException {
        JvmType type;
        if (context != null && constructor.isConstructor() && (type = this.ecoreTypeReferences.findDeclaredType(constructor.getDeclaringType().getFullyQualifiedName(), context.getEcoreContext())) instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)type;
            ActionParameterTypes jdtSignature = this.actionPrototypeProvider.createParameterTypes(Flags.isVarargs((int)constructor.getFlags()), this.getFormalParameterProvider(context, constructor));
            for (JvmConstructor jvmConstructor : declaredType.getDeclaredConstructors()) {
                ActionParameterTypes jvmSignature = this.actionPrototypeProvider.createParameterTypesFromJvmModel(jvmConstructor.isVarArgs(), (List)jvmConstructor.getParameters());
                if (!jvmSignature.equals((Object)jdtSignature)) continue;
                return jvmConstructor;
            }
        }
        return null;
    }

    public JvmOperation getJvmOperation(IMethod method, ConversionContext context) throws JavaModelException {
        if (!(context == null || method.isConstructor() || method.isLambdaMethod() || method.isMainMethod())) {
            JvmType type = this.ecoreTypeReferences.findDeclaredType(method.getDeclaringType().getFullyQualifiedName(), context.getEcoreContext());
            return this.getJvmOperation(context, method, type);
        }
        return null;
    }

    private JvmOperation getJvmOperation(ConversionContext conversionContext, IMethod method, JvmType context) throws JavaModelException {
        if (context instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)context;
            ActionParameterTypes jdtSignature = this.actionPrototypeProvider.createParameterTypes(Flags.isVarargs((int)method.getFlags()), this.getFormalParameterProvider(conversionContext, method));
            for (JvmOperation jvmOperation : declaredType.getDeclaredOperations()) {
                ActionParameterTypes jvmSignature = this.actionPrototypeProvider.createParameterTypesFromJvmModel(jvmOperation.isVarArgs(), (List)jvmOperation.getParameters());
                if (!jvmSignature.equals((Object)jdtSignature)) continue;
                return jvmOperation;
            }
        }
        return null;
    }

    private String extractDefaultValue(IMethod operation, IAnnotation annot) throws JavaModelException, IllegalArgumentException {
        String fieldId;
        IAnnotation annotation = annot;
        Object value = annotation.getMemberValuePairs()[0].getValue();
        String string = fieldId = value == null ? null : value.toString();
        if (!Strings.isNullOrEmpty((String)fieldId)) {
            String methodName = Utils.createNameForHiddenDefaultValueFunction((String)fieldId);
            IMethod method = operation.getDeclaringType().getMethod(methodName, new String[0]);
            if (method != null && (annotation = this.getAnnotation((IAnnotatable)method, SarlSourceCode.class.getName())) != null) {
                return annotation.getMemberValuePairs()[0].getValue().toString();
            }
        }
        return null;
    }

    protected IFormalParameterBuilder[] createFormalParametersWith(ParameterBuilder parameterBuilder, IMethod operation, LocalTypeResolver resolver, ConversionContext context) throws JavaModelException, IllegalArgumentException {
        boolean isVarargs = Flags.isVarargs((int)operation.getFlags());
        ILocalVariable[] rawParameters = operation.getParameters();
        FormalParameterProvider parameters = this.getFormalParameterProvider(context, operation);
        int len = parameters.getFormalParameterCount();
        IFormalParameterBuilder[] paramBuilders = new IFormalParameterBuilder[len];
        int i = 0;
        while (i < len) {
            ILocalVariable rawParameter = rawParameters[i];
            IAnnotation annotation = this.getAnnotation((IAnnotatable)rawParameter, DefaultValue.class.getName());
            String defaultValue = annotation != null ? this.extractDefaultValue(operation, annotation) : null;
            boolean isV = isVarargs && i == len - 1;
            JvmTypeReference type = parameters.getFormalParameterTypeReference(i, isV);
            if (isV && type instanceof JvmGenericArrayTypeReference) {
                JvmGenericArrayTypeReference arrayType = (JvmGenericArrayTypeReference)type;
                type = arrayType.getComponentType();
            }
            IFormalParameterBuilder sarlParameter = parameterBuilder.addParameter(parameters.getFormalParameterName(i));
            sarlParameter.setParameterType(type);
            if (defaultValue != null) {
                sarlParameter.getDefaultValue().setExpression(defaultValue);
            }
            if (isV) {
                sarlParameter.setVarArg(true);
            }
            paramBuilders[i] = sarlParameter;
            ++i;
        }
        return paramBuilders;
    }

    protected JvmTypeReference convertSignatureFromJdt2Ecore(String jdtSignature, LocalTypeResolver resolver, ConversionContext context) {
        String[] jdtTypeParameters;
        String jdtErasure;
        int kind = Signature.getTypeSignatureKind((String)jdtSignature);
        boolean isWildcard = kind == 5;
        char wildcard = '\u0000';
        if (isWildcard) {
            wildcard = jdtSignature.charAt(0);
            jdtErasure = Signature.getTypeErasure((String)jdtSignature.substring(1));
        } else {
            jdtErasure = Signature.getTypeErasure((String)jdtSignature);
        }
        String ecoreTypeName = Signature.toString((String)jdtErasure);
        JvmParameterizedTypeReference ecoreTypeParameter = context.getDeclaredTypeParameter(ecoreTypeName);
        if (ecoreTypeParameter != null) {
            if (isWildcard) {
                return this.wildcard(wildcard, ecoreTypeParameter);
            }
            return ecoreTypeParameter;
        }
        JvmParameterizedTypeReference ecoreRawType = context.findType(ecoreTypeName, resolver);
        if (ecoreRawType != null && (jdtTypeParameters = Signature.getTypeArguments((String)jdtSignature)).length > 0) {
            JvmTypeReference[] ecoreTypeParameters = new JvmTypeReference[jdtTypeParameters.length];
            int i = 0;
            String[] stringArray = jdtTypeParameters;
            int n = jdtTypeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String jdtTypeParameter = stringArray[n2];
                ecoreTypeParameters[i] = this.convertSignatureFromJdt2Ecore(jdtTypeParameter, resolver, context);
                ++i;
                ++n2;
            }
            JvmParameterizedTypeReference result = this.ecoreTypeReferences.createTypeRef(ecoreRawType.getType(), ecoreTypeParameters);
            if (isWildcard) {
                return this.wildcard(wildcard, result);
            }
            return result;
        }
        if (isWildcard) {
            return this.wildcard(wildcard, ecoreRawType);
        }
        return ecoreRawType;
    }

    private JvmTypeReference wildcard(char wildcard, JvmParameterizedTypeReference type) {
        switch (wildcard) {
            case '*': {
                return this.ecoreTypeReferences.wildCard();
            }
            case '+': {
                return this.ecoreTypeReferences.wildCardExtends((JvmTypeReference)type);
            }
            case '-': {
                return this.ecoreTypeReferences.wildCardSuper((JvmTypeReference)type);
            }
        }
        return type;
    }

    protected ConversionContext createTypeParametersWith(TypeParameterBuilder parameterBuilder, IMethod operation, LocalTypeResolver resolver, ConversionContext context) throws JavaModelException, IllegalArgumentException {
        int len = operation.getTypeParameters().length;
        if (len > 0) {
            LocalConversionContext localContext = new LocalConversionContext(context);
            ITypeParameter[] iTypeParameterArray = operation.getTypeParameters();
            int n = iTypeParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter operationTypeParameter = iTypeParameterArray[n2];
                ITypeParameterBuilder typeParameterBuilder = parameterBuilder.addTypeParameter(operationTypeParameter.getElementName());
                String[] stringArray = operationTypeParameter.getBoundsSignatures();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String bound = stringArray[n4];
                    typeParameterBuilder.addUpperConstraint(this.convertSignatureFromJdt2Ecore(bound, resolver, context));
                    ++n4;
                }
                localContext.declareTypeParameter(operationTypeParameter.getElementName(), this.ecoreTypeReferences.createTypeRef((JvmType)typeParameterBuilder.getJvmTypeParameter(), new JvmTypeReference[0]));
                ++n2;
            }
            return localContext;
        }
        return context;
    }

    public void createStandardConstructorsWith(ConstructorBuilder codeBuilder, Collection<IMethod> superClassConstructors, ConversionContext context) throws JavaModelException {
        if (superClassConstructors != null && context != null) {
            for (IMethod constructor : superClassConstructors) {
                if (this.isGeneratedOperation(constructor)) continue;
                TypeBasedLocalTypeResolver resolver = new TypeBasedLocalTypeResolver(constructor.getDeclaringType());
                ISarlConstructorBuilder cons = codeBuilder.addConstructor();
                ConversionContext localContext = this.createTypeParametersWith(name -> cons.addTypeParameter(name), constructor, resolver, context);
                IFormalParameterBuilder[] sarlParams = this.createFormalParametersWith(name -> cons.addParameter(name), constructor, resolver, localContext);
                IBlockExpressionBuilder block = cons.getExpression();
                IExpressionBuilder superCall = block.addExpression();
                XFeatureCall call = XbaseFactory.eINSTANCE.createXFeatureCall();
                superCall.setXExpression((XExpression)call);
                superCall.setDocumentation(block.getAutoGeneratedActionString());
                call.setFeature((JvmIdentifiableElement)this.getJvmConstructor(constructor, localContext));
                call.setExplicitOperationCall(true);
                EList arguments = call.getFeatureCallArguments();
                IFormalParameterBuilder[] iFormalParameterBuilderArray = sarlParams;
                int n = sarlParams.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormalParameterBuilder currentParam = iFormalParameterBuilderArray[n2];
                    XFeatureCall argumentSource = XbaseFactory.eINSTANCE.createXFeatureCall();
                    arguments.add((Object)argumentSource);
                    currentParam.setReferenceInto(argumentSource);
                    ++n2;
                }
            }
        }
    }

    public void createActionsWith(ActionBuilder codeBuilder, Collection<IMethod> methods, ConversionContext context) throws JavaModelException, IllegalArgumentException {
        if (methods != null && context != null) {
            for (IMethod operation : methods) {
                if (this.isGeneratedOperation(operation)) continue;
                TypeBasedLocalTypeResolver resolver = new TypeBasedLocalTypeResolver(operation.getDeclaringType());
                ISarlActionBuilder action = codeBuilder.addAction(operation.getElementName());
                ConversionContext localContext = this.createTypeParametersWith(name -> action.addTypeParameter(name), operation, resolver, context);
                action.setReturnType(this.convertSignatureFromJdt2Ecore(operation.getReturnType(), resolver, localContext));
                IFormalParameterBuilder[] sarlParams = this.createFormalParametersWith(name -> action.addParameter(name), operation, resolver, localContext);
                if (localContext.getEcoreContext() == null) continue;
                JvmType type = this.ecoreTypeReferences.findDeclaredType(operation.getDeclaringType().getFullyQualifiedName(), localContext.getEcoreContext());
                JvmOperation superOperation = this.getJvmOperation(localContext, operation, type);
                IBlockExpressionBuilder block = action.getExpression();
                if (!(type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)type).isInterface() || superOperation == null || superOperation.isAbstract())) {
                    IExpressionBuilder superCall = block.addExpression();
                    XMemberFeatureCall call = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
                    superCall.setXExpression((XExpression)call);
                    superCall.setDocumentation(block.getAutoGeneratedActionString());
                    call.setFeature((JvmIdentifiableElement)superOperation);
                    call.setMemberCallTarget((XExpression)superCall.createReferenceToSuper());
                    EList arguments = call.getMemberCallArguments();
                    IFormalParameterBuilder[] iFormalParameterBuilderArray = sarlParams;
                    int n = sarlParams.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFormalParameterBuilder currentParam = iFormalParameterBuilderArray[n2];
                        XFeatureCall argumentSource = XbaseFactory.eINSTANCE.createXFeatureCall();
                        arguments.add((Object)argumentSource);
                        currentParam.setReferenceInto(argumentSource);
                        ++n2;
                    }
                    continue;
                }
                JvmTypeReference ret = superOperation != null ? superOperation.getReturnType() : null;
                block.setDefaultAutoGeneratedContent(ret == null ? null : ret.getIdentifier());
            }
        }
    }

    public boolean isSubClassOf(ConversionContext context, TypeFinder typeFinder, String subClass, String superClass) throws JavaModelException {
        if (context != null) {
            SuperTypeIterator typeIterator = new SuperTypeIterator(context, typeFinder, false, subClass);
            while (typeIterator.hasNext()) {
                IType type = typeIterator.next();
                if (!Objects.equals(type.getFullyQualifiedName(), superClass)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubClassOf(TypeFinder typeFinder, String subClass, String superClass) throws JavaModelException {
        return this.isSubClassOf(Jdt2Ecore.contextualize(null, this.ecoreTypeReferences), typeFinder, subClass, superClass);
    }

    @FunctionalInterface
    public static interface ActionBuilder {
        public ISarlActionBuilder addAction(String var1);
    }

    @FunctionalInterface
    public static interface ConstructorBuilder {
        public ISarlConstructorBuilder addConstructor();
    }

    public static interface ConversionContext {
        public Notifier getEcoreContext();

        public JvmParameterizedTypeReference getDeclaredTypeParameter(String var1);

        public JvmParameterizedTypeReference findType(String var1, LocalTypeResolver var2);
    }

    protected static class EcoreTypeConversionContext
    implements ConversionContext,
    Serializable {
        private static final long serialVersionUID = -3929314423261518377L;
        private final TypeReferences references;
        private final XtendTypeDeclaration context;
        private Map<String, JvmParameterizedTypeReference> typeParameters;

        protected EcoreTypeConversionContext(XtendTypeDeclaration context, TypeReferences references) {
            assert (references != null);
            this.context = context;
            this.references = references;
        }

        @Override
        public Notifier getEcoreContext() {
            return this.context;
        }

        @Override
        public JvmParameterizedTypeReference getDeclaredTypeParameter(String name) {
            if (this.typeParameters == null) {
                this.typeParameters = new HashMap<String, JvmParameterizedTypeReference>();
                Jdt2Ecore.fillTypeParameters(this.context, this.typeParameters, this.references);
            }
            return this.typeParameters.get(name);
        }

        @Override
        public JvmParameterizedTypeReference findType(String typeName, LocalTypeResolver resolver) {
            String tn;
            try {
                tn = resolver.resolve(typeName);
            }
            catch (JavaModelException javaModelException) {
                tn = typeName;
            }
            JvmType type = this.references.findDeclaredType(tn, (Notifier)(this.context == null ? new ResourceSetImpl() : this.context));
            if (type != null) {
                return this.references.createTypeRef(type, new JvmTypeReference[0]);
            }
            throw new TypeNotPresentException(typeName, null);
        }
    }

    private class JdtFormalParameterList
    implements FormalParameterProvider {
        private final ConversionContext context;
        private final int nb;
        private final String[] names;
        private final JvmTypeReference[] types;

        JdtFormalParameterList(ConversionContext context, IMethod operation) throws JavaModelException {
            this.context = context;
            this.nb = operation.getNumberOfParameters();
            this.names = operation.getParameterNames();
            this.types = new JvmTypeReference[this.nb];
            ILocalVariable[] unresolvedParameters = operation.getParameters();
            int i = 0;
            while (i < this.nb) {
                this.types[i] = this.resolve(operation, unresolvedParameters[i].getTypeSignature());
                ++i;
            }
        }

        private JvmTypeReference resolve(IMethod operation, String typename) throws JavaModelException {
            ICompilationUnit unit;
            TypeBasedLocalTypeResolver resolver = new TypeBasedLocalTypeResolver(operation.getDeclaringType());
            if ('Q' == Signature.getElementType((String)typename).charAt(0) && (unit = operation.getCompilationUnit()) != null) {
                String post = "." + String.valueOf(Jdt2Ecore.this.convertSignatureFromJdt2Ecore(typename, resolver, this.context));
                IImportDeclaration[] iImportDeclarationArray = unit.getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IImportDeclaration decl = iImportDeclarationArray[n2];
                    if (decl.getElementName().endsWith(post)) {
                        return this.context.findType(decl.getElementName(), resolver);
                    }
                    ++n2;
                }
            }
            return Jdt2Ecore.this.convertSignatureFromJdt2Ecore(typename, resolver, this.context);
        }

        public int getFormalParameterCount() {
            return this.nb;
        }

        public String getFormalParameterName(int position) {
            return this.names[position];
        }

        public String getFormalParameterType(int position, boolean isVarArgs) {
            return this.types[position].getIdentifier();
        }

        public JvmTypeReference getFormalParameterTypeReference(int position, boolean isVarargs) {
            return this.types[position];
        }

        public boolean hasFormalParameterDefaultValue(int position) {
            return false;
        }

        public XExpression getFormalParameterDefaultValue(int position) {
            return null;
        }

        public String getFormalParameterDefaultValueString(int position) {
            return null;
        }

        public EObject getFormalParameter(int position) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class LocalConversionContext
    implements ConversionContext,
    Serializable {
        private static final long serialVersionUID = 4491570488424452153L;
        private final ConversionContext parent;
        private final Map<String, JvmParameterizedTypeReference> localTypeParameters = new HashMap<String, JvmParameterizedTypeReference>();

        protected LocalConversionContext(ConversionContext parent) {
            assert (parent != null);
            this.parent = parent;
        }

        @Override
        public Notifier getEcoreContext() {
            return this.parent.getEcoreContext();
        }

        public LocalConversionContext declareTypeParameter(String name, JvmParameterizedTypeReference reference) {
            this.localTypeParameters.put(name, reference);
            return this;
        }

        @Override
        public JvmParameterizedTypeReference getDeclaredTypeParameter(String name) {
            JvmParameterizedTypeReference reference = this.localTypeParameters.get(name);
            if (reference != null) {
                return reference;
            }
            return this.parent.getDeclaredTypeParameter(name);
        }

        @Override
        public JvmParameterizedTypeReference findType(String typeName, LocalTypeResolver resolver) {
            return this.parent.findType(typeName, resolver);
        }
    }

    @FunctionalInterface
    public static interface LocalTypeResolver {
        public String resolve(String var1) throws JavaModelException;
    }

    @FunctionalInterface
    protected static interface ParameterBuilder {
        public IFormalParameterBuilder addParameter(String var1);
    }

    private class SuperTypeIterator
    implements Iterator<IType> {
        private final ConversionContext context;
        private final TypeFinder typeFinder;
        private final Set<String> encountered = new TreeSet<String>();
        private final Deque<String> queue = new LinkedList<String>();
        private final boolean isInterface;
        private final List<IStatus> statuses = new ArrayList<IStatus>();
        private IType current;

        SuperTypeIterator(ConversionContext context, TypeFinder typeFinder, boolean isInterface, String ... typeNames) {
            this(context, typeFinder, isInterface, Arrays.asList(typeNames));
        }

        SuperTypeIterator(ConversionContext context, TypeFinder typeFinder, boolean isInterface, Collection<String> typeNames) {
            this.context = context;
            this.isInterface = isInterface;
            this.typeFinder = typeFinder;
            this.queue.addAll(typeNames);
            this.updateCurrent();
        }

        public Collection<IStatus> getStatuses() {
            return this.statuses;
        }

        private void updateCurrent() {
            this.current = null;
            while (this.current == null && !this.queue.isEmpty()) {
                String typeName = this.queue.removeFirst();
                if (!Jdt2Ecore.this.isValidSuperType(typeName) || this.encountered.contains(typeName)) continue;
                try {
                    this.current = this.typeFinder.findType(typeName);
                    if (this.current != null) continue;
                    this.statuses.add(SARLEclipsePlugin.getDefault().createStatus(4, new ClassNotFoundException(typeName)));
                }
                catch (JavaModelException e) {
                    this.current = null;
                    this.statuses.add(SARLEclipsePlugin.getDefault().createStatus(4, e));
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public IType next() {
            IType c = this.current;
            if (c == null) {
                throw new NoSuchElementException();
            }
            String name = c.getFullyQualifiedName();
            this.encountered.add(name);
            try {
                String[] superTypes = this.isInterface ? c.getSuperInterfaceTypeSignatures() : new String[]{c.getSuperclassTypeSignature()};
                String[] stringArray = superTypes;
                int n = superTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String resolvedSignature;
                    String signature = stringArray[n2];
                    if (!Strings.isNullOrEmpty((String)signature) && !Strings.isNullOrEmpty((String)(resolvedSignature = this.resolveType(c, signature)))) {
                        this.queue.add(resolvedSignature);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
            this.updateCurrent();
            return c;
        }

        private String resolveType(IType type, String signature) {
            TypeBasedLocalTypeResolver resolver = new TypeBasedLocalTypeResolver(type);
            return Jdt2Ecore.this.convertSignatureFromJdt2Ecore(signature, resolver, this.context).getType().getIdentifier();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class TypeBasedLocalTypeResolver
    implements LocalTypeResolver,
    Serializable {
        private static final long serialVersionUID = -1468256062447840456L;
        private final IType type;

        public TypeBasedLocalTypeResolver(IType type) {
            this.type = type;
        }

        @Override
        public String resolve(String type) throws JavaModelException {
            String[][] resolved = this.type.resolveType(type);
            if (resolved != null) {
                String[][] stringArray = resolved;
                if (resolved.length != 0) {
                    String[] entry = stringArray[0];
                    if (Strings.isNullOrEmpty((String)entry[0])) {
                        return entry[1];
                    }
                    return entry[0] + "." + entry[1];
                }
            }
            return type;
        }
    }

    @FunctionalInterface
    public static interface TypeFinder {
        public IType findType(String var1) throws JavaModelException;
    }

    @FunctionalInterface
    protected static interface TypeParameterBuilder {
        public ITypeParameterBuilder addTypeParameter(String var1);
    }
}

