/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.elements;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.util.Jdt2Ecore;
import io.sarl.eclipse.wizards.elements.AbstractSuperTypeSelectionDialog;
import io.sarl.eclipse.wizards.elements.FieldInitializerUtil;
import io.sarl.eclipse.wizards.elements.Messages;
import io.sarl.eclipse.wizards.elements.SarlSpecificTypeSelectionExtension;
import io.sarl.lang.codebuilder.CodeBuilderFactory;
import io.sarl.lang.codebuilder.builders.IBlockExpressionBuilder;
import io.sarl.lang.codebuilder.builders.IExpressionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlActionBuilder;
import io.sarl.lang.codebuilder.builders.ISarlBehaviorUnitBuilder;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.formatting2.FormatterFacade;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class AbstractNewSarlElementWizardPage
extends NewTypeWizardPage {
    protected static final String JAVA_FILE_EXTENSION = "java";
    protected static final int COLUMNS = 4;
    protected static final String INITIALIZE_EVENT_NAME = "io.sarl.api.core.Initialize";
    protected static final String DESTROY_EVENT_NAME = "io.sarl.api.core.Destroy";
    protected static final String CONTEXTJOINED_EVENT_NAME = "io.sarl.api.core.ContextJoined";
    protected static final String CONTEXTLEFT_EVENT_NAME = "io.sarl.api.core.ContextLeft";
    protected static final String MEMBERJOINED_EVENT_NAME = "io.sarl.api.core.MemberJoined";
    protected static final String MEMBERLEFT_EVENT_NAME = "io.sarl.api.core.MemberLeft";
    protected static final String SPACECREATED_EVENT_NAME = "io.sarl.api.core.SpaceCreated";
    protected static final String SPACEDESTROYED_EVENT_NAME = "io.sarl.api.core.SpaceDestroyed";
    protected static final String PARTICIPANTJOINED_EVENT_NAME = "io.sarl.api.core.ParticipantJoined";
    protected static final String PARTICIPANTLEFT_EVENT_NAME = "io.sarl.api.core.ParticipantLeft";
    protected static final String AGENTSPAWNED_EVENT_NAME = "io.sarl.api.core.AgentSpawned";
    protected static final String AGENTKILLED_EVENT_NAME = "io.sarl.api.core.AgentKilled";
    protected static final String LOGGING_CAPACITY_NAME = "io.sarl.api.core.Logging";
    protected static final String INSTALL_SKILL_NAME = "install";
    protected static final String UNINSTALL_SKILL_NAME = "uninstall";
    protected static final String PREPARE_UNINSTALL_SKILL_NAME = "prepareUninstallation";
    private static final int STEPS = 8;
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private static final String SETTINGS_GENERATEEVENTHANDLERS = "generate_event_handlers";
    private static final String SETTINGS_GENERATELIFECYCLEFUNCTIONS = "generate_lifecycle_functions";
    @Inject
    protected CodeBuilderFactory codeBuilderFactory;
    @Inject
    protected TypeReferences ecoreTypeReferences;
    @Inject
    protected IResourceSetProvider resourceSetFactory;
    @Inject
    private Jdt2Ecore jdt2sarl;
    @Inject
    private FieldInitializerUtil fieldInitializer;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    @Inject
    private Injector injector;
    private String[] sarlFileExtensions;
    private IResource resource;
    private SelectionButtonDialogFieldGroup methodStubsButtons;
    private boolean isConstructorCreationEnabled;
    private boolean isInheritedCreationEnabled;
    private boolean isDefaultEventGenerated;
    private boolean isDefaultLifecycleFunctionsGenerated;
    @Inject
    private FormatterFacade formatterFacade;
    @Inject
    private IJvmTypeProvider.Factory jdtTypeProviderFactory;
    private boolean hasSuperTypeField;
    private boolean hasSuperInterfaceField;

    public AbstractNewSarlElementWizardPage(int typeKind, String title) {
        super(typeKind, title);
    }

    public boolean isSuperTypeActivated() {
        return this.hasSuperTypeField;
    }

    public boolean isSuperInterfaceActivated() {
        return this.hasSuperInterfaceField;
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.hasSuperTypeField = true;
        super.createSuperClassControls(composite, nColumns);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.hasSuperInterfaceField = true;
        super.createSuperInterfacesControls(composite, nColumns);
    }

    @Inject
    public void setFileExtension(@Named(value="file.extensions") String fileExtension) {
        this.sarlFileExtensions = SarlUtils.getFileExtensions((String)fileExtension);
    }

    protected abstract void doStatusUpdate();

    public IResource getResource() {
        return this.resource;
    }

    protected void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doStatusUpdate();
            this.setFocus();
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    protected IStatus typeNameChanged() {
        assert (this.sarlFileExtensions != null);
        IPackageFragment packageFragment = this.getPackageFragment();
        String typeName = this.getTypeName();
        if (packageFragment != null && !Strings.isNullOrEmpty((String)typeName) && this.isSarlFile(packageFragment, typeName)) {
            Object packageName = "";
            if (!packageFragment.isDefaultPackage()) {
                packageName = packageFragment.getElementName() + ".";
            }
            return SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(this.getExistingElementErrorMessage(), (String)packageName + this.getTypeName()));
        }
        return super.typeNameChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSarlFile(IPackageFragment packageFragment, String filename) {
        if (AbstractNewSarlElementWizardPage.isFileExists(packageFragment, filename, this.sarlFileExtensions)) {
            return true;
        }
        IJavaProject project = this.getPackageFragmentRoot().getJavaProject();
        if (project == null) return false;
        try {
            String packageName = packageFragment.getElementName();
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IPackageFragment fragment = root.getPackageFragment(packageName);
                if (AbstractNewSarlElementWizardPage.isFileExists(fragment, filename, JAVA_FILE_EXTENSION)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected static boolean isFileExists(IPackageFragment packageFragment, String filename, String ... extensions) {
        IResource resource;
        assert (extensions != null);
        if (packageFragment != null && (resource = packageFragment.getResource()) instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                StringBuilder ffn = new StringBuilder();
                ffn.append(filename);
                ffn.append('.');
                ffn.append(extension);
                if (folder.getFile(ffn.toString()).exists()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected abstract String getExistingElementErrorMessage();

    protected String getInvalidSubtypeErrorMessage() {
        throw new UnsupportedOperationException();
    }

    protected String getInvalidInterfaceTypeErrorMessage() {
        throw new UnsupportedOperationException();
    }

    protected String getMissedSuperInterfaceErrorMessage() {
        throw new UnsupportedOperationException();
    }

    protected void init(IStructuredSelection selection) {
        IJavaElement elem = this.fieldInitializer.getSelectedResource(selection);
        this.initContainerPage(elem);
        this.initTypePage(elem);
        try {
            this.getRootSuperType();
            this.reinitSuperClass();
        }
        catch (Throwable throwable) {}
        try {
            this.getRootSuperInterface();
            this.reinitSuperInterfaces();
        }
        catch (Throwable throwable) {}
        this.doStatusUpdate();
    }

    public boolean isAddComments() {
        return true;
    }

    protected boolean isValidExtendedType(String className) throws JavaModelException {
        if (!Strings.isNullOrEmpty((String)className)) {
            IType rootType = this.getRootSuperType();
            if (rootType == null) {
                IStatus status = SARLEclipsePlugin.getDefault().createStatus(4, Messages.AbstractNewSarlElementWizardPage_3);
                throw new JavaModelException(new CoreException(status));
            }
            IType type = this.getJavaProject().findType(className);
            if (type == null) {
                IStatus status = SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_4, className));
                throw new JavaModelException(new CoreException(status));
            }
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            if (hierarchy == null || !hierarchy.contains(rootType)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isValidImplementedType(String className) throws JavaModelException {
        if (!Strings.isNullOrEmpty((String)className)) {
            IType rootType = this.getRootSuperInterface();
            assert (rootType != null);
            IType type = this.getJavaProject().findType(className);
            assert (type != null);
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            assert (hierarchy != null);
            if (!hierarchy.contains(rootType)) {
                return false;
            }
        }
        return true;
    }

    private void reinitSuperClass() {
        String className = this.getSuperClass();
        try {
            if (!this.isValidExtendedType(className)) {
                IType rootType = this.getRootSuperType();
                assert (rootType != null);
                this.setSuperClass(rootType.getFullyQualifiedName(), true);
            }
        }
        catch (JavaModelException ex) {
            this.fSuperClassStatus = SARLEclipsePlugin.getDefault().createStatus(4, ex);
        }
    }

    private void reinitSuperInterfaces() {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        HashSet<String> validInterfaces = new HashSet<String>();
        for (String interfaceName : this.getSuperInterfaces()) {
            try {
                if (!this.isValidImplementedType(interfaceName)) {
                    IType rootType = this.getRootSuperInterface();
                    assert (rootType != null);
                    validInterfaces.add(rootType.getFullyQualifiedName());
                    continue;
                }
                validInterfaces.add(interfaceName);
            }
            catch (JavaModelException ex) {
                status.add(SARLEclipsePlugin.getDefault().createStatus(4, ex));
            }
        }
        this.setSuperInterfaces(new ArrayList(validInterfaces), true);
        if (status.isEmpty() && this.isSuperInterfaceNeeded()) {
            try {
                status.add(SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(this.getMissedSuperInterfaceErrorMessage(), this.getRootSuperInterface().getFullyQualifiedName())));
            }
            catch (Throwable throwable) {}
        }
        if (status.isEmpty()) {
            this.fSuperInterfacesStatus = SARLEclipsePlugin.getDefault().createOkStatus();
        } else {
            IStatus[] tab = new IStatus[status.size()];
            status.toArray(tab);
            this.fSuperInterfacesStatus = SARLEclipsePlugin.getDefault().createMultiStatus(tab);
        }
    }

    protected IStatus superClassChanged() {
        IStatus status = super.superClassChanged();
        assert (status != null);
        if (status.isOK() && this.isSuperTypeActivated()) {
            String className = this.getSuperClass();
            try {
                if (!this.isValidExtendedType(className)) {
                    status = SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(this.getInvalidSubtypeErrorMessage(), className));
                }
            }
            catch (JavaModelException ex) {
                status = ex.getJavaModelStatus();
            }
        }
        return status;
    }

    protected IStatus superInterfacesChanged() {
        IStatus status = super.superInterfacesChanged();
        assert (status != null);
        if (status.isOK() && this.isSuperInterfaceActivated()) {
            ArrayList<IStatus> statusInfo = new ArrayList<IStatus>();
            boolean hasInterface = false;
            for (String superInterface : this.getSuperInterfaces()) {
                try {
                    if (!this.isValidImplementedType(superInterface)) {
                        statusInfo.add(SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(this.getInvalidInterfaceTypeErrorMessage(), superInterface)));
                        continue;
                    }
                    hasInterface = true;
                }
                catch (JavaModelException ex) {
                    statusInfo.add(SARLEclipsePlugin.getDefault().createStatus(4, ex));
                }
            }
            if (!hasInterface && this.isSuperInterfaceNeeded()) {
                try {
                    statusInfo.add(SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(this.getMissedSuperInterfaceErrorMessage(), this.getRootSuperInterface().getFullyQualifiedName())));
                }
                catch (Throwable throwable) {}
            }
            if (!statusInfo.isEmpty()) {
                IStatus[] tab = new IStatus[statusInfo.size()];
                statusInfo.toArray(tab);
                status = SARLEclipsePlugin.getDefault().createMultiStatus(tab);
            }
        }
        return status;
    }

    protected boolean isSuperInterfaceNeeded() {
        return false;
    }

    protected IType getRootSuperType() throws JavaModelException {
        throw new UnsupportedOperationException();
    }

    protected IType getRootSuperInterface() throws JavaModelException {
        throw new UnsupportedOperationException();
    }

    protected Composite createCommonControls(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)4, (int)1, (int)768);
        this.createContainerControls(composite, 4);
        this.createPackageControls(composite, 4);
        this.createSeparator(composite, 4);
        this.createTypeNameControls(composite, 4);
        return composite;
    }

    public final void createControl(Composite parent) {
        Composite composite = this.createCommonControls(parent);
        this.createPageControls(composite);
        this.setControl((Control)composite);
        this.readSettings();
        this.doStatusUpdate();
    }

    protected abstract void createPageControls(Composite var1);

    protected final int asyncCreateType() {
        final int[] size = new int[1];
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                size[0] = AbstractNewSarlElementWizardPage.this.createSARLType(monitor);
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            SARLEclipsePlugin.getDefault().openError(this.getShell(), this.getTitle(), realException.getMessage(), null, realException);
        }
        return size[0];
    }

    public final void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    private ICompilationUnit getCompilationUnitStub() {
        String compilationUnitName = this.getCompilationUnitName(this.getTypeName());
        return new CompilationUnit((PackageFragment)this.getPackageFragment(), compilationUnitName, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    protected void createInheritedMembers(String defaultSuperTypeQualifiedName, Jdt2Ecore.ConversionContext context, boolean generateActionBlocks, Jdt2Ecore.ConstructorBuilder constructorBuilder, Jdt2Ecore.ActionBuilder actionBuilder, String superTypeQualifiedName, String ... superInterfaceQualifiedNames) throws JavaModelException {
        this.createInheritedMembers(defaultSuperTypeQualifiedName, context, generateActionBlocks, constructorBuilder, actionBuilder, superTypeQualifiedName, Arrays.asList(superInterfaceQualifiedNames));
    }

    protected void createInheritedMembers(String defaultSuperTypeQualifiedName, Jdt2Ecore.ConversionContext context, boolean generateActionBlocks, Jdt2Ecore.ConstructorBuilder constructorBuilder, Jdt2Ecore.ActionBuilder actionBuilder, String superTypeQualifiedName, List<String> superInterfaceQualifiedNames) throws JavaModelException {
        assert (context != null);
        Jdt2Ecore.TypeFinder typeFinder = this.getTypeFinder();
        TreeMap baseConstructors = Maps.newTreeMap(null);
        this.jdt2sarl.populateInheritanceContext(context, typeFinder, null, null, null, null, baseConstructors, defaultSuperTypeQualifiedName, Collections.emptyList());
        TreeMap constructors = this.isCreateConstructors() ? Maps.newTreeMap(null) : null;
        HashMap operationsToImplement = this.isCreateInherited() ? Maps.newHashMap() : null;
        this.jdt2sarl.populateInheritanceContext(context, typeFinder, null, null, null, operationsToImplement, constructors, superTypeQualifiedName, superInterfaceQualifiedNames);
        if (context.getEcoreContext() != null) {
            if (constructors != null && constructorBuilder != null) {
                for (Map.Entry constructor : constructors.entrySet()) {
                    if (baseConstructors.containsKey(constructor.getKey())) continue;
                    this.jdt2sarl.createStandardConstructorsWith(constructorBuilder, Collections.singletonList((IMethod)constructor.getValue()), context);
                    break;
                }
            }
            if (operationsToImplement != null && actionBuilder != null) {
                this.jdt2sarl.createActionsWith(actionBuilder, operationsToImplement.values(), generateActionBlocks ? context : null);
            }
        }
    }

    protected final Jdt2Ecore.TypeFinder getTypeFinder() {
        return this.jdt2sarl.toTypeFinder(this.getJavaProject());
    }

    public int createSARLType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            SubMonitor mainmon = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getTitle(), (int)8);
            IPackageFragment packageFragment = this.getPackageFragment();
            if (!packageFragment.exists()) {
                packageFragment = this.getPackageFragmentRoot().createPackageFragment(this.getPackageFragment().getElementName(), true, (IProgressMonitor)mainmon.newChild(1));
            } else {
                mainmon.worked(1);
            }
            IFolder packageResource = (IFolder)packageFragment.getResource();
            if (!packageResource.exists()) {
                CoreUtility.createFolder((IFolder)packageResource, (boolean)true, (boolean)true, (IProgressMonitor)mainmon.newChild(1));
            } else {
                mainmon.worked(1);
            }
            String majorFileExtension = SarlUtils.getMajorFileExtension((String[])this.sarlFileExtensions);
            IFile sarlFile = packageResource.getFile(this.getTypeName() + "." + majorFileExtension);
            int index = 1;
            while (sarlFile.exists()) {
                sarlFile = packageResource.getFile(this.getTypeName() + index + "." + majorFileExtension);
                ++index;
            }
            URI sarlUri = this.storage2UriMapper.getUri((IStorage)sarlFile);
            ResourceSet resourceSet = this.resourceSetFactory.get(packageFragment.getJavaProject().getProject());
            ICompilationUnit compilationUnit = this.getCompilationUnitStub();
            String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(sarlUri).getLineSeparator();
            mainmon.worked(1);
            SubMonitor mon1 = mainmon.newChild(1);
            mon1.setTaskName(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_5, this.getTypeName()));
            String typeComment = this.getTypeComment(compilationUnit, lineSeparator);
            IJvmTypeProvider typeProvider = this.jdtTypeProviderFactory.findOrCreateTypeProvider(resourceSet);
            ImportManager imports = new ImportManager(true);
            this.injector.injectMembers((Object)imports);
            FakeTreeAppendable appender = new FakeTreeAppendable(imports);
            this.injector.injectMembers((Object)appender);
            this.generateTypeContent((ISourceAppender)appender, typeProvider, typeComment, (IProgressMonitor)mon1);
            mon1.done();
            SubMonitor mon2 = mainmon.newChild(1);
            mon2.setTaskName(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_6, this.getTypeName()));
            String fileComment = this.getFileComment(compilationUnit, lineSeparator);
            StringBuilder realContent = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)fileComment)) {
                realContent.append(fileComment);
                realContent.append(lineSeparator);
                realContent.append(lineSeparator);
            }
            realContent.append(appender.getContent());
            realContent.append(lineSeparator);
            mon2.done();
            SubMonitor mon3 = mainmon.newChild(1);
            mon3.setTaskName(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_7, this.getTypeName()));
            String content = this.formatterFacade.format(realContent.toString());
            mon3.done();
            SubMonitor mon4 = mainmon.newChild(1);
            mon4.setTaskName(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_8, this.getTypeName()));
            Throwable throwable = null;
            Object var24_27 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());){
                sarlFile.create((InputStream)stream, true, (IProgressMonitor)mon4);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.setResource((IResource)sarlFile);
            this.saveSettings();
            mon4.done();
            return content.length();
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, e));
        }
    }

    protected void readSettings() {
        IDialogSettings section;
        boolean createConstructors = false;
        boolean createUnimplemented = true;
        boolean createEventHandlers = true;
        boolean createLifecycleFunctions = true;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(this.getName())) != null) {
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
            createUnimplemented = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
            createEventHandlers = section.getBoolean(SETTINGS_GENERATEEVENTHANDLERS);
            createLifecycleFunctions = section.getBoolean(SETTINGS_GENERATELIFECYCLEFUNCTIONS);
        }
        this.setMethodStubSelection(createConstructors, createUnimplemented, createEventHandlers, createLifecycleFunctions, true);
    }

    protected void saveSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings section = dialogSettings.getSection(this.getName());
            if (section == null) {
                section = dialogSettings.addNewSection(this.getName());
            }
            section.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
            section.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
            section.put(SETTINGS_GENERATEEVENTHANDLERS, this.isCreateStandardEventHandlers());
            section.put(SETTINGS_GENERATELIFECYCLEFUNCTIONS, this.isCreateStandardLifecycleFunctions());
        }
    }

    protected abstract void generateTypeContent(ISourceAppender var1, IJvmTypeProvider var2, String var3, IProgressMonitor var4) throws Exception;

    protected void createMethodStubControls(Composite composite, int columns, boolean enableConstructors, boolean enableInherited, boolean defaultEvents, boolean lifecycleFunctions) {
        this.isConstructorCreationEnabled = enableConstructors;
        this.isInheritedCreationEnabled = enableInherited;
        this.isDefaultEventGenerated = defaultEvents;
        this.isDefaultLifecycleFunctionsGenerated = lifecycleFunctions;
        ArrayList<String> nameList = new ArrayList<String>(4);
        if (enableConstructors) {
            nameList.add(Messages.AbstractNewSarlElementWizardPage_0);
        }
        if (enableInherited) {
            nameList.add(Messages.AbstractNewSarlElementWizardPage_1);
        }
        if (defaultEvents) {
            nameList.add(Messages.AbstractNewSarlElementWizardPage_17);
        }
        if (lifecycleFunctions) {
            nameList.add(Messages.AbstractNewSarlElementWizardPage_18);
        }
        if (nameList.isEmpty()) {
            return;
        }
        String[] buttonNames = new String[nameList.size()];
        nameList.toArray(buttonNames);
        this.methodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames, 1);
        this.methodStubsButtons.setLabelText(Messages.AbstractNewSarlElementWizardPage_2);
        Label labelControl = this.methodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)columns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.methodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(columns - 1));
    }

    protected boolean isCreateConstructors() {
        return this.isConstructorCreationEnabled && this.methodStubsButtons.isSelected(0);
    }

    protected boolean isCreateInherited() {
        int idx = 0;
        if (this.isConstructorCreationEnabled) {
            ++idx;
        }
        return this.isInheritedCreationEnabled && this.methodStubsButtons.isSelected(idx);
    }

    protected boolean isCreateStandardEventHandlers() {
        int idx = 0;
        if (this.isConstructorCreationEnabled) {
            ++idx;
        }
        if (this.isInheritedCreationEnabled) {
            ++idx;
        }
        return this.isDefaultEventGenerated && this.methodStubsButtons.isSelected(idx);
    }

    protected boolean isCreateStandardLifecycleFunctions() {
        int idx = 0;
        if (this.isConstructorCreationEnabled) {
            ++idx;
        }
        if (this.isInheritedCreationEnabled) {
            ++idx;
        }
        if (this.isDefaultEventGenerated) {
            ++idx;
        }
        return this.isDefaultLifecycleFunctionsGenerated && this.methodStubsButtons.isSelected(idx);
    }

    protected void setMethodStubSelection(boolean createConstructors, boolean createInherited, boolean createEventHandlers, boolean createLifecycleFunctions, boolean canBeModified) {
        if (this.methodStubsButtons != null) {
            int idx = 0;
            if (this.isConstructorCreationEnabled) {
                this.methodStubsButtons.setSelection(idx, createConstructors);
                ++idx;
            }
            if (this.isInheritedCreationEnabled) {
                this.methodStubsButtons.setSelection(idx, createInherited);
                ++idx;
            }
            if (this.isDefaultEventGenerated) {
                this.methodStubsButtons.setSelection(idx, createEventHandlers);
                ++idx;
            }
            if (this.isDefaultLifecycleFunctionsGenerated) {
                this.methodStubsButtons.setSelection(idx, createLifecycleFunctions);
                ++idx;
            }
            this.methodStubsButtons.setEnabled(canBeModified);
        }
    }

    protected AbstractSuperTypeSelectionDialog<?> createSuperClassSelectionDialog(Shell parent, IRunnableContext context, IJavaProject project, SarlSpecificTypeSelectionExtension extension, boolean multi) {
        return null;
    }

    protected IType chooseSuperClass() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJvmTypeProvider typeProvider = this.jdtTypeProviderFactory.findOrCreateTypeProvider(this.resourceSetFactory.get(project.getProject()));
        SarlSpecificTypeSelectionExtension extension = new SarlSpecificTypeSelectionExtension(typeProvider);
        this.injector.injectMembers((Object)extension);
        AbstractSuperTypeSelectionDialog<?> dialog = this.createSuperClassSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), project, extension, false);
        if (dialog == null) {
            return super.chooseSuperClass();
        }
        this.injector.injectMembers(dialog);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_message);
        dialog.setInitialPattern(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected AbstractSuperTypeSelectionDialog<?> createSuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, IJavaProject project, SarlSpecificTypeSelectionExtension extension, boolean multi) {
        return null;
    }

    private static void createInfoCall(IExpressionBuilder builder, String message) {
        JvmTypeReference capacity = builder.newTypeRef(LOGGING_CAPACITY_NAME);
        String objectType = Object.class.getName();
        String objectArrayType = objectType + "[]";
        JvmOperation infoMethod = (JvmOperation)Iterables.find((Iterable)((JvmDeclaredType)capacity.getType()).getDeclaredOperations(), it -> {
            if (Objects.equals(it.getSimpleName(), "info") && it.getParameters().size() == 2) {
                String type1 = ((JvmFormalParameter)it.getParameters().get(0)).getParameterType().getIdentifier();
                String type2 = ((JvmFormalParameter)it.getParameters().get(1)).getParameterType().getIdentifier();
                return Objects.equals(objectType, type1) && Objects.equals(objectArrayType, type2);
            }
            return false;
        }, null);
        if (infoMethod != null) {
            builder.setExpression("info(\"" + message + "\")");
            ((XFeatureCall)builder.getXExpression()).setFeature((JvmIdentifiableElement)infoMethod);
        }
    }

    protected void createStandardSARLEventTemplates(String elementTypeName, Functions.Function1<? super String, ? extends ISarlBehaviorUnitBuilder> behaviorUnitAdder, Procedures.Procedure1<? super String> usesAdder) throws JavaModelException {
        if (this.isCreateStandardEventHandlers()) {
            IType type;
            try {
                type = this.getTypeFinder().findType(INITIALIZE_EVENT_NAME);
            }
            catch (JavaModelException javaModelException) {
                type = null;
            }
            if (type == null) {
                IStatus status = SARLEclipsePlugin.getDefault().createStatus(4, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_4, INITIALIZE_EVENT_NAME));
                throw new JavaModelException(new CoreException(status));
            }
            usesAdder.apply((Object)LOGGING_CAPACITY_NAME);
            ISarlBehaviorUnitBuilder unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)INITIALIZE_EVENT_NAME);
            IBlockExpressionBuilder block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_9, elementTypeName));
            IExpressionBuilder expr = block.addExpression();
            AbstractNewSarlElementWizardPage.createInfoCall(expr, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_26, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)DESTROY_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_10, elementTypeName));
            expr = block.addExpression();
            AbstractNewSarlElementWizardPage.createInfoCall(expr, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_27, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)AGENTSPAWNED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_11, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)AGENTKILLED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_12, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)CONTEXTJOINED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_13, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)CONTEXTLEFT_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_14, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)MEMBERJOINED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_15, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)MEMBERLEFT_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_16, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)MEMBERLEFT_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_16, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)SPACECREATED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_21, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)SPACEDESTROYED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_22, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)PARTICIPANTJOINED_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_23, elementTypeName));
            unit = (ISarlBehaviorUnitBuilder)behaviorUnitAdder.apply((Object)PARTICIPANTLEFT_EVENT_NAME);
            block = unit.getExpression();
            block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_24, elementTypeName));
        }
    }

    protected boolean createStandardSARLLifecycleFunctionTemplates(String elementTypeName, Functions.Function1<? super String, ? extends ISarlActionBuilder> actionAdder, Procedures.Procedure1<? super String> usesAdder) {
        if (!this.isCreateStandardLifecycleFunctions()) {
            return false;
        }
        usesAdder.apply((Object)LOGGING_CAPACITY_NAME);
        ISarlActionBuilder action = (ISarlActionBuilder)actionAdder.apply((Object)INSTALL_SKILL_NAME);
        IBlockExpressionBuilder block = action.getExpression();
        block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_19, elementTypeName));
        IExpressionBuilder expr = block.addExpression();
        AbstractNewSarlElementWizardPage.createInfoCall(expr, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_28, elementTypeName));
        action = (ISarlActionBuilder)actionAdder.apply((Object)PREPARE_UNINSTALL_SKILL_NAME);
        block = action.getExpression();
        block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_25, elementTypeName));
        expr = block.addExpression();
        AbstractNewSarlElementWizardPage.createInfoCall(expr, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_29, elementTypeName));
        action = (ISarlActionBuilder)actionAdder.apply((Object)UNINSTALL_SKILL_NAME);
        block = action.getExpression();
        block.setInnerDocumentation(MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_20, elementTypeName));
        expr = block.addExpression();
        AbstractNewSarlElementWizardPage.createInfoCall(expr, MessageFormat.format(Messages.AbstractNewSarlElementWizardPage_30, elementTypeName));
        return true;
    }

    protected void chooseSuperInterfaces() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return;
        }
        IJvmTypeProvider typeProvider = this.jdtTypeProviderFactory.findOrCreateTypeProvider(this.resourceSetFactory.get(project.getProject()));
        SarlSpecificTypeSelectionExtension extension = new SarlSpecificTypeSelectionExtension(typeProvider);
        this.injector.injectMembers((Object)extension);
        AbstractSuperTypeSelectionDialog<?> dialog = this.createSuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), project, extension, true);
        if (dialog != null) {
            Object[] tab;
            this.injector.injectMembers(dialog);
            dialog.setTitle(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_interface_title);
            dialog.setMessage(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_message);
            try {
                dialog.setInitialPattern(this.getRootSuperInterface().getFullyQualifiedName());
            }
            catch (JavaModelException exception) {
                SARLEclipsePlugin.getDefault().log(exception);
            }
            if (dialog.open() == 0 && (tab = dialog.getResult()) != null) {
                ArrayList<String> list = new ArrayList<String>(tab.length);
                Object[] objectArray = tab;
                int n = tab.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IType) {
                        IType type = (IType)obj;
                        list.add(type.getFullyQualifiedName());
                    }
                    ++n2;
                }
                this.setSuperInterfaces(list, true);
            }
        } else {
            super.chooseSuperInterfaces();
        }
    }
}

