/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.elements;

import io.sarl.apputils.uiextensions.Utilities;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.wizards.elements.Messages;
import io.sarl.eclipse.wizards.elements.SarlSpecificTypeSelectionExtension;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSuperTypeSelectionDialog<T extends NewTypeWizardPage>
extends OpenTypeSelectionDialog {
    private static final String JAVA_ELEMENT_DELIMITERS = TextProcessor.getDefaultDelimiters() + "<>(),?{} ";
    private static final int ADD_ID = 1025;
    private final T typeWizardPage;
    private final List<String> oldContent;

    public AbstractSuperTypeSelectionDialog(Shell parent, IRunnableContext context, T page, IJavaSearchScope scope, int elementType, SarlSpecificTypeSelectionExtension extension, boolean multi) {
        super(parent, multi, context, scope, elementType, (TypeSelectionExtension)extension);
        this.typeWizardPage = page;
        this.oldContent = this.saveWizardPage(this.typeWizardPage);
        this.setStatusLineAboveButtons(true);
    }

    public static IJavaSearchScope createSearchScope(IJavaProject project, Class<?> type, boolean onlySubTypes) {
        try {
            IType superType = project.findType(type.getName());
            return SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)superType, (boolean)onlySubTypes, (boolean)true, null);
        }
        catch (JavaModelException e) {
            SARLEclipsePlugin.getDefault().log(e);
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.AbstractSuperTypeSelectionDialog_1, true);
        super.createButtonsForButtonBar(parent);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("DialogBounds_" + ((Object)((Object)this)).getClass().getName());
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected abstract List<String> saveWizardPage(T var1);

    protected abstract void restoreWizardPage(T var1, List<String> var2);

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.restoreWizardPage(this.typeWizardPage, this.oldContent);
    }

    protected void cancelPressed() {
        this.restoreWizardPage(this.typeWizardPage, this.oldContent);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.fillWizardPageWithSelectedTypes();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.fillWizardPageWithSelectedTypes();
        super.okPressed();
    }

    protected abstract boolean addTypeToWizardPage(T var1, String var2);

    private void fillWizardPageWithSelectedTypes() {
        StructuredSelection selection = this.getSelectedItems();
        if (selection == null) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof TypeNameMatch)) continue;
            TypeNameMatch type = (TypeNameMatch)obj;
            this.accessedHistoryItem(obj);
            String qualifiedName = Utilities.getNameWithTypeParameters((IType)type.getType());
            String message = this.addTypeToWizardPage(this.typeWizardPage, qualifiedName) ? MessageFormat.format(Messages.AbstractSuperTypeSelectionDialog_2, TextProcessor.process((String)qualifiedName, (String)JAVA_ELEMENT_DELIMITERS)) : MessageFormat.format(Messages.AbstractSuperTypeSelectionDialog_3, TextProcessor.process((String)qualifiedName, (String)JAVA_ELEMENT_DELIMITERS));
            this.updateStatus((IStatus)new StatusInfo(1, message));
        }
    }

    protected void handleDoubleClick() {
        this.buttonPressed(1025);
    }

    protected abstract int getSuperTypeCount(T var1);

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() == 0 && this.getSuperTypeCount(this.typeWizardPage) > this.oldContent.size()) {
            this.updateStatus(Status.OK_STATUS);
            this.getButton(1025).setEnabled(false);
        } else {
            this.getButton(1025).setEnabled(this.getButton(0).isEnabled());
        }
    }
}

