/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.newfile;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import io.sarl.eclipse.wizards.newfile.NewSarlFileWizardPage;
import io.sarl.lang.core.util.SarlUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class NewSarlFileWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewSarlFileWizardPage pageOne;
    private final String fileExtension;
    @Inject
    private Injector injector;

    @Inject
    public NewSarlFileWizard(@Named(value="file.extensions") String fileExtension) {
        this.fileExtension = SarlUtils.getMajorFileExtension((String)fileExtension);
    }

    public void init(IWorkbench iworkbench, IStructuredSelection iselection) {
        this.workbench = iworkbench;
        this.selection = iselection;
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new NewSarlFileWizardPage(this.selection, this.fileExtension);
        this.injector.injectMembers((Object)this.pageOne);
        this.addPage((IWizardPage)this.pageOne);
    }

    public boolean performFinish() {
        boolean result;
        IFile file = this.pageOne.createNewFile();
        boolean bl = result = file != null;
        if (result) {
            try {
                IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

