/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.newfile;

import com.google.inject.Inject;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.wizards.newfile.Messages;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.conversion.XbaseValueConverterService;

public class NewSarlFileWizardPage
extends WizardNewFileCreationPage {
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private XbaseValueConverterService converter;

    public NewSarlFileWizardPage(IStructuredSelection selection, String fileExtension) {
        super(Messages.NewSarlFileWizardPage_1, selection);
        this.setTitle(Messages.NewSarlFileWizardPage_1);
        this.setDescription(Messages.NewSarlFileWizardPage_2);
        this.setFileExtension(fileExtension);
        this.setImageDescriptor(SARLEclipsePlugin.getDefault().getImageDescriptor("icons/sarl_new_file_dialog.png"));
    }

    private static IPath determinePackageName(IPath path) {
        if (path != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            try {
                if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getPath().isPrefixOf(path)) {
                            return path.removeFirstSegments(entry.getPath().segmentCount());
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected InputStream getInitialContents() {
        StringBuilder content = new StringBuilder();
        IPath folderInWorkspace = this.getContainerFullPath();
        IPath packagePath = NewSarlFileWizardPage.determinePackageName(folderInWorkspace);
        if (packagePath != null && packagePath.segmentCount() > 0) {
            content.append(this.grammarAccess.getPackageKeyword() + " ");
            StringBuilder packageName = new StringBuilder();
            packageName.append(packagePath.segment(0));
            int i = 1;
            while (i < packagePath.segmentCount()) {
                packageName.append(this.grammarAccess.getFullStopKeyword());
                packageName.append(packagePath.segment(i));
                ++i;
            }
            content.append(this.converter.getQualifiedNameValueConverter().toString((Object)packageName.toString()));
            content.append("\n");
        }
        return new StringInputStream(content.toString());
    }
}

