/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.newproject;

import io.sarl.apputils.eclipseextensions.buildpath.SARLClasspathEntryComparator;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectConfigurationFragment;
import io.sarl.apputils.uiextensions.classpath.SarlClassPathDetector;
import io.sarl.apputils.uiextensions.classpath.SarlDefaultClassPathProvider;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.natures.SARLProjectConfigurator;
import io.sarl.eclipse.wizards.newproject.MainProjectWizardPage;
import io.sarl.eclipse.wizards.newproject.Messages;
import io.sarl.lang.core.util.OutParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class BuildSettingWizardPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private static final int FILE_COPY_BLOCK_SIZE = 8192;
    private static final int UPDATE_PROJECT_MONITORED_STEPS = 7;
    private final MainProjectWizardPage firstPage;
    private URI currProjectLocation;
    private IProject currProject;
    private boolean keepContent;
    private File dotProjectBackup;
    private File dotClasspathBackup;
    private Boolean isAutobuild;
    private Map<String, IFileStore> orginalFolders;

    public BuildSettingWizardPage(MainProjectWizardPage mainPage) {
        this.setPageComplete(false);
        this.firstPage = mainPage;
        this.currProjectLocation = null;
        this.currProject = null;
        this.keepContent = false;
        this.dotProjectBackup = null;
        this.dotClasspathBackup = null;
        this.isAutobuild = null;
        this.setTitle(Messages.NewSarlProjectWizard_0);
        this.setDescription(Messages.BuildSettingWizardPage_0);
        this.setImageDescriptor(SARLEclipsePlugin.getDefault().getImageDescriptor("icons/sarl_new_project_dialog.png"));
    }

    protected final boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        boolean isShownFirstTime;
        boolean bl = isShownFirstTime = visible && this.currProject == null;
        if (visible) {
            if (isShownFirstTime) {
                this.createProvisonalProject();
            }
        } else if (this.getContainer().getCurrentPage() == this.firstPage) {
            this.removeProvisonalProject();
        }
        super.setVisible(visible);
        if (isShownFirstTime) {
            this.setFocus();
        }
    }

    private static boolean hasExistingContent(URI realLocation) throws CoreException {
        IFileStore file = EFS.getStore((URI)realLocation);
        return file.fetchInfo().exists();
    }

    private IStatus changeToNewProject() {
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.getInfoStatus();
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.NewJavaProjectWizardPageTwo_error_title;
            String message = NewWizardMessages.NewJavaProjectWizardPageTwo_error_message;
            this.updateStatus(e);
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private void updateStatus(Throwable event) {
        Throwable cause = event;
        while (cause != null && !(cause instanceof CoreException) && cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        if (cause instanceof CoreException) {
            CoreException cvalue = (CoreException)cause;
            this.updateStatus(cvalue.getStatus());
        } else {
            String message = cause != null ? cause.getLocalizedMessage() : event.getLocalizedMessage();
            StatusInfo status = new StatusInfo(4, message);
            this.updateStatus((IStatus)status);
        }
    }

    private static URI getRealLocation(String projectName, URI location) {
        URI theLocation = location;
        if (theLocation == null) {
            try {
                URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                theLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(projectName).toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Assert.isTrue((boolean)false, (String)"Can't happen");
            }
        }
        return theLocation;
    }

    private IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        IStatus result = StatusInfo.OK_STATUS;
        try {
            subMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_initialize, 7);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String projectName = this.firstPage.getProjectName();
            this.currProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.currProjectLocation = this.firstPage.getProjectLocationURI();
            URI realLocation = BuildSettingWizardPage.getRealLocation(projectName, this.currProjectLocation);
            this.keepContent = BuildSettingWizardPage.hasExistingContent(realLocation);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.keepContent) {
                this.rememberExistingFiles(realLocation);
                this.rememberExisitingFolders(realLocation);
            }
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                BuildSettingWizardPage.createProject((IProject)this.currProject, (URI)this.currProjectLocation, (IProgressMonitor)subMonitor.newChild(2));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 567) {
                    result = new StatusInfo(1, MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageTwo_DeleteCorruptProjectFile_message, e.getLocalizedMessage()));
                    BuildSettingWizardPage.deleteProjectFile(realLocation);
                    if (this.currProject.exists()) {
                        this.currProject.delete(true, null);
                    }
                    BuildSettingWizardPage.createProject((IProject)this.currProject, (URI)this.currProjectLocation, null);
                }
                throw e;
            }
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.initializeBuildPath(JavaCore.create((IProject)this.currProject), (IProgressMonitor)subMonitor.newChild(2));
            this.configureJavaProject((IProgressMonitor)subMonitor.newChild(3));
        }
        finally {
            subMonitor.done();
        }
        return result;
    }

    private void keepExistingBuildPath(IProject project, OutParameter<IClasspathEntry[]> classpath, OutParameter<IPath> outputLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IClasspathEntry[] entries = null;
        IPath outLocation = null;
        if (!project.getFile(FILENAME_CLASSPATH).exists()) {
            if (classpath != null) {
                TreeSet<IClasspathEntry> cpEntries = new TreeSet<IClasspathEntry>((Comparator<IClasspathEntry>)SARLClasspathEntryComparator.getSingleton());
                List<IClasspathEntry> originalEntries = SARLProjectConfigurator.getDefaultSourceClassPathEntries(new Path(this.firstPage.getProjectName()).makeAbsolute());
                cpEntries.addAll(originalEntries);
                this.firstPage.putDefaultClasspathEntriesIn(cpEntries);
                if (!cpEntries.isEmpty()) {
                    classpath.set((Object)cpEntries.toArray(new IClasspathEntry[cpEntries.size()]));
                }
            }
            if (outputLocation != null) {
                outputLocation.set((Object)this.firstPage.getOutputLocation());
            }
            SarlClassPathDetector detector = new SarlClassPathDetector(this.currProject, (SarlDefaultClassPathProvider)this.firstPage, (IProgressMonitor)subMonitor.newChild(1));
            entries = detector.getClasspath();
            outLocation = detector.getOutputLocation();
            if (entries.length == 0) {
                entries = null;
            }
        }
        subMonitor.worked(2);
        if (classpath != null && entries != null) {
            classpath.set(entries);
        }
        if (outputLocation != null && outLocation != null) {
            outputLocation.set(outLocation);
        }
        subMonitor.done();
    }

    private void buildNewBuildPath(IProject project, OutParameter<IClasspathEntry[]> classpath, OutParameter<IPath> outputLocation, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] entries;
        TreeSet<IClasspathEntry> cpEntries = new TreeSet<IClasspathEntry>((Comparator<IClasspathEntry>)SARLClasspathEntryComparator.getSingleton());
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        IPath projectFolder = new Path(this.firstPage.getProjectName()).makeAbsolute();
        List<IClasspathEntry> originalEntries = SARLProjectConfigurator.getDefaultSourceClassPathEntries(projectFolder);
        TreeSet<IClasspathEntry> allEntries = null;
        Iterator iterator = this.firstPage.getActivatedProjectExtensions().iterator();
        while (iterator.hasNext()) {
            ProjectConfigurationFragment configuration = (ProjectConfigurationFragment)iterator.next();
            entries = configuration.getDefaultSourceClassPathEntries(projectFolder);
            if (allEntries == null) {
                allEntries = new TreeSet(SARLClasspathEntryComparator.getSingleton());
                allEntries.addAll(originalEntries);
            }
            allEntries.addAll((Collection<IClasspathEntry>)entries);
        }
        if (allEntries == null) {
            allEntries = new TreeSet<IClasspathEntry>((Comparator<IClasspathEntry>)SARLClasspathEntryComparator.getSingleton());
            allEntries.addAll(originalEntries);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(allEntries.size() + 1));
        for (IClasspathEntry sourceClasspathEntry : allEntries) {
            IPath path = sourceClasspathEntry.getPath();
            if (path.segmentCount() > 1) {
                IFolder folder = root.getFolder(path);
                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)subMonitor.newChild(1));
            }
            cpEntries.add(sourceClasspathEntry);
        }
        this.firstPage.putDefaultClasspathEntriesIn(cpEntries);
        entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        IPath outLocation = this.firstPage.getOutputLocation();
        if (outLocation.segmentCount() > 1) {
            IFolder folder = root.getFolder(outLocation);
            CoreUtility.createDerivedFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (classpath != null) {
            classpath.set((Object)entries);
        }
        if (outputLocation != null) {
            outputLocation.set((Object)outLocation);
        }
    }

    protected void initializeBuildPath(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new NullProgressMonitor();
        }
        theMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_monitor_init_build_path, 2);
        try {
            try {
                OutParameter entries = new OutParameter();
                OutParameter outputLocation = new OutParameter();
                IProject project = javaProject.getProject();
                if (this.keepContent) {
                    this.keepExistingBuildPath(project, (OutParameter<IClasspathEntry[]>)entries, (OutParameter<IPath>)outputLocation, theMonitor);
                } else {
                    this.buildNewBuildPath(project, (OutParameter<IClasspathEntry[]>)entries, (OutParameter<IPath>)outputLocation, theMonitor);
                }
                if (theMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.init(javaProject, (IPath)outputLocation.get(), (IClasspathEntry[])entries.get(), false);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof CoreException) {
                    CoreException cvalue = (CoreException)throwable;
                    throw cvalue;
                }
                Throwable ee = e.getCause() != null && e.getCause() != e ? e.getCause() : e;
                throw new CoreException(SARLEclipsePlugin.getDefault().createStatus(4, ee));
            }
        }
        finally {
            theMonitor.done();
        }
    }

    private static void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private void rememberExisitingFolders(URI projectLocation) {
        this.orginalFolders = new TreeMap<String, IFileStore>();
        try {
            IFileStore[] children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int i = 0;
            while (i < children.length) {
                IFileStore child = children[i];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !this.orginalFolders.containsKey(info.getName())) {
                    this.orginalFolders.put(info.getName(), child);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
        }
    }

    private void restoreExistingFolders(URI projectLocation) {
        TreeMap<String, IFileStore> foldersToKeep = new TreeMap<String, IFileStore>(this.orginalFolders);
        for (IFileStore originalFileStore : this.orginalFolders.values()) {
            try {
                File localFile = originalFileStore.toLocalFile(0, null);
                if (localFile == null) continue;
                File canonicalFile = localFile.getCanonicalFile();
                IFileStore canonicalFileStore = originalFileStore.getFileSystem().fromLocalFile(canonicalFile);
                if (originalFileStore.equals(canonicalFileStore)) continue;
                foldersToKeep.put(canonicalFileStore.fetchInfo().getName(), canonicalFileStore);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        try {
            IFileStore[] children = EFS.getStore((URI)projectLocation).childStores(0, null);
            int i = 0;
            while (i < children.length) {
                IFileStore child = children[i];
                IFileInfo info = child.fetchInfo();
                if (info.isDirectory() && info.exists() && !foldersToKeep.containsKey(info.getName())) {
                    child.delete(0, null);
                    this.orginalFolders.remove(info.getName());
                }
                ++i;
            }
            for (IFileStore deleted : this.orginalFolders.values()) {
                deleted.mkdir(0, null);
            }
        }
        catch (CoreException e) {
            SARLEclipsePlugin.getDefault().log(e);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.dotProjectBackup = null;
        this.dotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.dotProjectBackup = BuildSettingWizardPage.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.dotClasspathBackup = BuildSettingWizardPage.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        int ticks = ((this.dotProjectBackup != null ? 1 : 0) + (this.dotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)subMonitor.newChild(1));
            if (this.dotProjectBackup != null) {
                BuildSettingWizardPage.copyFile(this.dotProjectBackup, projectFile, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.NewJavaProjectWizardPageTwo_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
            classpathFile.delete(0, (IProgressMonitor)subMonitor.newChild(1));
            if (this.dotClasspathBackup != null) {
                BuildSettingWizardPage.copyFile(this.dotClasspathBackup, classpathFile, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.NewJavaProjectWizardPageTwo_problem_restore_classpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        subMonitor.done();
    }

    private static File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            BuildSettingWizardPage.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageTwo_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static void copyFile(IFileStore source, File target) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = source.openInputStream(0, null);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FileOutputStream os = new FileOutputStream(target);){
                BuildSettingWizardPage.unsecureCopyFile(is, os);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(source);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (OutputStream os = target.openOutputStream(0, monitor);){
                BuildSettingWizardPage.unsecureCopyFile(is, os);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void unsecureCopyFile(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        int bytesRead = is.read(buffer);
        while (bytesRead > 0) {
            os.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer);
        }
        os.flush();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        try {
            try {
                monitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_create, 3);
                if (this.currProject == null) {
                    this.updateProject((IProgressMonitor)subMonitor.newChild(1));
                }
                String newProjectCompliance = this.keepContent ? null : this.firstPage.getCompilerCompliance();
                this.configureJavaProject(newProjectCompliance, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable e) {
                if (this.currProject != null) {
                    this.removeProvisonalProject();
                }
                throw e;
            }
        }
        finally {
            subMonitor.done();
            this.currProject = null;
            if (this.isAutobuild != null) {
                CoreUtility.setAutoBuilding((boolean)this.isAutobuild);
                this.isAutobuild = null;
            }
        }
    }

    protected IProject createProvisonalProject() {
        IStatus status = this.changeToNewProject();
        if (status != null) {
            this.updateStatus(status);
            if (!status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewJavaProjectWizardPageTwo_error_title, (String)NewWizardMessages.NewJavaProjectWizardPageTwo_error_title, (IStatus)status);
            }
        }
        return this.currProject;
    }

    protected void removeProvisonalProject() {
        if (!this.currProject.exists()) {
            this.currProject = null;
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                BuildSettingWizardPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.NewJavaProjectWizardPageTwo_error_remove_title;
            String message = NewWizardMessages.NewJavaProjectWizardPageTwo_error_remove_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor = this.currProjectLocation == null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)(noProgressMonitor ? null : monitor), (int)3);
        subMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_remove, 3);
        try {
            try {
                try {
                    boolean removeContent;
                    URI projLoc = this.currProject.getLocationURI();
                    boolean bl = removeContent = !this.keepContent && this.currProject.isSynchronized(2);
                    if (!removeContent) {
                        this.restoreExistingFolders(projLoc);
                    }
                    this.currProject.delete(removeContent, false, (IProgressMonitor)subMonitor.newChild(2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)subMonitor.newChild(1));
                }
                finally {
                    CoreUtility.setAutoBuilding((boolean)this.isAutobuild);
                    this.isAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            subMonitor.done();
            this.currProject = null;
            this.keepContent = false;
        }
    }

    public void performCancel() {
        if (this.currProject != null) {
            this.removeProvisonalProject();
        }
    }

    private class UpdateRunnable
    implements IRunnableWithProgress {
        private IStatus infoStatus = Status.OK_STATUS;

        UpdateRunnable() {
        }

        public IStatus getInfoStatus() {
            return this.infoStatus;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    if (BuildSettingWizardPage.this.isAutobuild == null) {
                        BuildSettingWizardPage.this.isAutobuild = CoreUtility.setAutoBuilding((boolean)false);
                    }
                    this.infoStatus = BuildSettingWizardPage.this.updateProject(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

