/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.newproject;

import io.sarl.apputils.eclipseextensions.projectconfig.ProjectConfigurationFragment;
import io.sarl.apputils.eclipseextensions.projectconfig.ProjectConfigurationFragments;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.apputils.uiextensions.classpath.SarlDefaultClassPathProvider;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.buildpath.SARLClasspathContainerInitializer;
import io.sarl.eclipse.runtime.SREConfigurationBlock;
import io.sarl.eclipse.wizards.newproject.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public class MainProjectWizardPage
extends WizardPage
implements SarlDefaultClassPathProvider {
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];
    private final NameGroup nameGroup;
    private final LocationGroup locationGroup;
    private final SREConfigurationBlock sreGroup;
    private final JREGroup jreGroup;
    private final DetectGroup detectGroup;
    private final Validator validator;
    private final WorkingSetGroup workingSetGroup;
    private final ProjectConfiguratorsGroup configuratorGroup;

    public MainProjectWizardPage() {
        super(Messages.NewSarlProjectWizard_0);
        this.setPageComplete(false);
        this.nameGroup = new NameGroup();
        this.locationGroup = new LocationGroup();
        this.sreGroup = new SREConfigurationBlock(Messages.MainProjectWizardPage_0, true, null, null);
        this.jreGroup = new JREGroup();
        this.workingSetGroup = new WorkingSetGroup();
        this.detectGroup = new DetectGroup();
        this.configuratorGroup = new ProjectConfiguratorsGroup();
        this.nameGroup.addObserver(this.locationGroup);
        this.detectGroup.addObserver(this.jreGroup);
        this.locationGroup.addObserver(this.detectGroup);
        this.configuratorGroup.addObserver(this.locationGroup);
        this.nameGroup.notifyObservers();
        this.validator = new Validator();
        this.nameGroup.addObserver(this.validator);
        this.locationGroup.addObserver(this.validator);
        this.configuratorGroup.addObserver(this.validator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        this.setWorkingSets(new IWorkingSet[0]);
        MainProjectWizardPage.initializeDefaultVM();
        this.setTitle(Messages.NewSarlProjectWizard_0);
        this.setDescription(Messages.MainProjectWizardPage_1);
        this.setImageDescriptor(SARLEclipsePlugin.getDefault().getImageDescriptor("icons/sarl_new_project_dialog.png"));
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
        this.setWorkingSets(MainProjectWizardPage.getSelectedWorkingSet(selection, activePart));
    }

    private static void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        Control nameControl = this.createNameControl(composite);
        nameControl.setLayoutData((Object)new GridData(768));
        Control locationControl = this.createLocationControl(composite);
        locationControl.setLayoutData((Object)new GridData(768));
        Control sreControl = this.createSRESelectionControl(composite);
        sreControl.setLayoutData((Object)new GridData(768));
        Control jreControl = this.createJRESelectionControl(composite);
        jreControl.setLayoutData((Object)new GridData(768));
        Control workingSetControl = this.createWorkingSetControl(composite);
        workingSetControl.setLayoutData((Object)new GridData(768));
        Control projectConfiguratorControl = this.createProjectConfiguratorControl(composite);
        projectConfiguratorControl.setLayoutData((Object)new GridData(768));
        Control infoControl = this.createInfoControl(composite);
        infoControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
        this.sreGroup.initialize();
        this.sreGroup.selectSpecificSRE(null);
        this.sreGroup.selectSystemWideSRE();
    }

    protected void setControl(Control newControl) {
        Dialog.applyDialogFont((Control)newControl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(newControl, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        super.setControl(newControl);
    }

    protected Control createNameControl(Composite composite) {
        return this.nameGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.locationGroup.createControl(composite);
    }

    protected Control createJRESelectionControl(Composite composite) {
        return this.jreGroup.createControl(composite);
    }

    protected Control createSRESelectionControl(Composite composite) {
        return this.sreGroup.createControl(composite);
    }

    protected Control createWorkingSetControl(Composite composite) {
        return this.workingSetGroup.createControl(composite);
    }

    protected Control createProjectConfiguratorControl(Composite composite) {
        return this.configuratorGroup.createControl(composite);
    }

    protected Control createInfoControl(Composite composite) {
        return this.detectGroup.createControl(composite);
    }

    public String getProjectName() {
        return this.nameGroup.getName();
    }

    public void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.nameGroup.setName(name);
    }

    public boolean isSystemDefaultSRE() {
        return this.sreGroup.isSystemWideDefaultSRE();
    }

    public ISREInstall getSRE() {
        return this.sreGroup.getSelectedSRE();
    }

    public URI getProjectLocationURI() {
        if (this.locationGroup.isUseDefaultSelected()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.locationGroup.getLocation());
    }

    public void setProjectLocationURI(URI uri) {
        IPath path = uri != null ? URIUtil.toPath((URI)uri) : null;
        this.locationGroup.setLocation(path);
    }

    public String getCompilerCompliance() {
        return this.jreGroup.getSelectedCompilerCompliance();
    }

    public void putDefaultClasspathEntriesIn(Collection<IClasspathEntry> classpathEntries) {
        IPath newPath = this.jreGroup.getJREContainerPath();
        if (newPath != null) {
            classpathEntries.add(JavaCore.newContainerEntry((IPath)newPath));
        } else {
            IClasspathEntry[] entries = PreferenceConstants.getDefaultJRELibrary();
            classpathEntries.addAll(Arrays.asList(entries));
        }
        IClasspathEntry sarlClasspathEntry = JavaCore.newContainerEntry((IPath)SARLClasspathContainerInitializer.CONTAINER_ID, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)true);
        classpathEntries.add(sarlClasspathEntry);
        Iterator iterator = this.configuratorGroup.getActivatedProjectExtensions().iterator();
        while (iterator.hasNext()) {
            ProjectConfigurationFragment extension = (ProjectConfigurationFragment)iterator.next();
            List binEntries = extension.getBinaryClassPathEntries(this.getOutputLocation());
            classpathEntries.addAll(binEntries);
        }
    }

    public IPath getOutputLocation() {
        IPath outputLocationPath = new Path(this.getProjectName()).makeAbsolute();
        outputLocationPath = outputLocationPath.append(Path.fromPortableString((String)"target/classes"));
        return outputLocationPath;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            throw new IllegalArgumentException();
        }
        this.workingSetGroup.setWorkingSets(workingSets);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameGroup.postSetFocus();
        }
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection, IWorkbenchPart activePart) {
        IWorkingSet[] selected = MainProjectWizardPage.getSelectedWorkingSet(selection);
        assert (selected != null);
        if (selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!MainProjectWizardPage.isValidWorkingSet(selected[i])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++i;
            }
            return selected;
        }
        selected = EMPTY_WORKING_SET_ARRAY;
        if (activePart instanceof PackageExplorerPart) {
            PackageExplorerPart explorerPart = (PackageExplorerPart)activePart;
            if (explorerPart.getRootMode() == 1) {
                IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
                if (filterWorkingSet != null && MainProjectWizardPage.isValidWorkingSet(filterWorkingSet)) {
                    selected = new IWorkingSet[]{filterWorkingSet};
                }
            } else {
                IWorkingSet cvalue;
                Object input = explorerPart.getViewPartInput();
                if (input instanceof IWorkingSet && MainProjectWizardPage.isValidWorkingSet(cvalue = (IWorkingSet)input)) {
                    selected = new IWorkingSet[]{cvalue};
                }
            }
        }
        return selected;
    }

    private static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        ITreeSelection treeSelection;
        IWorkingSet[] workingSet = EMPTY_WORKING_SET_ARRAY;
        if (selection instanceof ITreeSelection && !(treeSelection = (ITreeSelection)selection).isEmpty()) {
            workingSet = MainProjectWizardPage.getSelectedWorkingSet(treeSelection);
        }
        return workingSet;
    }

    private static IWorkingSet[] getSelectedWorkingSet(ITreeSelection treeSelection) {
        assert (!treeSelection.isEmpty());
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            IWorkingSet cvalue;
            Object candidate;
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length == 1 && paths[0].getSegmentCount() != 0 && (candidate = paths[0].getSegment(0)) instanceof IWorkingSet && MainProjectWizardPage.isValidWorkingSet(cvalue = (IWorkingSet)candidate)) {
                return new IWorkingSet[]{cvalue};
            }
        } else {
            ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
            for (Object element : elements) {
                IWorkingSet cvalue;
                if (!(element instanceof IWorkingSet) || !MainProjectWizardPage.isValidWorkingSet(cvalue = (IWorkingSet)element)) continue;
                result.add(cvalue);
            }
            return result.toArray(new IWorkingSet[result.size()]);
        }
        return EMPTY_WORKING_SET_ARRAY;
    }

    private static boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!"org.eclipse.jdt.ui.JavaWorkingSetPage".equals(id) && !"org.eclipse.ui.resourceWorkingSetPage".equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }

    public Stream<ProjectConfigurationFragment> getActivatedProjectExtensions() {
        return this.configuratorGroup.getActivatedProjectExtensions();
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private static final int HORIZONTAL_SPACING = 10;
        private static final int WIDTH_HINT = 50;
        private static final int HEIGHT_HINT = 3;
        private Link fHintText;
        private Label icon;
        private boolean fDetect = false;

        DetectGroup() {
        }

        public Control createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.icon = new Label(composite, 16384);
            this.icon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 128, false, false);
            this.icon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = MainProjectWizardPage.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = MainProjectWizardPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
            this.handlePossibleJVMChange();
            return composite;
        }

        public void handlePossibleJVMChange() {
            if (JavaRuntime.getDefaultVMInstall() == null) {
                this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_NoJREFound_link);
                this.fHintText.setVisible(true);
                this.icon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.icon.setVisible(true);
                return;
            }
            String selectedCompliance = MainProjectWizardPage.this.jreGroup.getSelectedCompilerCompliance();
            if (selectedCompliance != null) {
                String defaultCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                if (selectedCompliance.equals(defaultCompliance)) {
                    this.fHintText.setVisible(false);
                    this.icon.setVisible(false);
                } else {
                    this.fHintText.setText(MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_differendWorkspaceCC_message, TextProcessor.process((String)defaultCompliance), TextProcessor.process((String)selectedCompliance)));
                    this.fHintText.setVisible(true);
                    this.icon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    this.icon.setVisible(true);
                }
                return;
            }
            selectedCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            IVMInstall selectedJVM = MainProjectWizardPage.this.jreGroup.getSelectedJVM();
            if (selectedJVM == null) {
                selectedJVM = JavaRuntime.getDefaultVMInstall();
            }
            String jvmCompliance = "21";
            if (selectedJVM instanceof IVMInstall2) {
                IVMInstall2 cvalue = (IVMInstall2)selectedJVM;
                jvmCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)cvalue, (String)"21");
            }
            if (!selectedCompliance.equals(jvmCompliance)) {
                this.fHintText.setText(MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_jre_message, TextProcessor.process((String)selectedCompliance), TextProcessor.process((String)jvmCompliance)));
                this.fHintText.setVisible(true);
                this.icon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.icon.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
                this.icon.setVisible(false);
            }
        }

        private boolean computeDetectState() {
            if (MainProjectWizardPage.this.locationGroup.isUseDefaultSelected()) {
                String name = MainProjectWizardPage.this.nameGroup.getName();
                if (name.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(name) != null) {
                    return false;
                }
                File directory = MainProjectWizardPage.this.locationGroup.getLocation().append(name).toFile();
                return directory.isDirectory();
            }
            File directory = MainProjectWizardPage.this.locationGroup.getLocation().toFile();
            return directory.isDirectory();
        }

        @Override
        public void update(Observable observable, Object arg) {
            if (observable instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                this.fDetect = this.computeDetectState();
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_message);
                        this.icon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.icon.setVisible(true);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent event) {
            this.widgetDefaultSelected(event);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String id = "JRE".equals(event.text) ? "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage" : "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)MainProjectWizardPage.this.getShell(), (String)id, (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", "org.eclipse.jdt.ui.preferences.CompliancePreferencePage", "org.eclipse.jdt.debug.ui.jreProfiles"}, data).open();
            MainProjectWizardPage.this.jreGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
        private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
        private static final String LAST_SELECTED_JRE_KIND2 = "org.eclipse.jdt.ui.last.selected.jre.kind2";
        private static final int DEFAULT_JRE = 0;
        private static final int PROJECT_JRE = 1;
        private static final int EE_JRE = 2;
        private final SelectionButtonDialogField useDefaultJRE = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField useProjectJRE;
        private final SelectionButtonDialogField useEEJRE;
        private final ComboDialogField jreCombo;
        private final ComboDialogField eeCombo;
        private Group group;
        private Link preferenceLink;
        private IVMInstall[] installedJVMs;
        private String[] jreCompliance;
        private IExecutionEnvironment[] installedEEs;
        private String[] eeCompliance;

        JREGroup() {
            this.useDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.useProjectJRE = new SelectionButtonDialogField(16);
            this.useProjectJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_compliance);
            this.jreCombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.jreCombo);
            this.jreCombo.setDialogFieldListener((IDialogFieldListener)this);
            this.useEEJRE = new SelectionButtonDialogField(16);
            this.useEEJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_EE);
            this.eeCombo = new ComboDialogField(8);
            this.fillExecutionEnvironments(this.eeCombo);
            this.eeCombo.setDialogFieldListener((IDialogFieldListener)this);
            switch (this.getLastSelectedJREKind()) {
                case 0: {
                    this.useDefaultJRE.setSelection(true);
                    break;
                }
                case 1: {
                    this.useProjectJRE.setSelection(true);
                    break;
                }
                case 2: {
                    this.useEEJRE.setSelection(true);
                }
            }
            this.jreCombo.setEnabled(this.useProjectJRE.isSelected());
            this.eeCombo.setEnabled(this.useEEJRE.isSelected());
            this.useDefaultJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.useProjectJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.useEEJRE.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            this.group = new Group(composite, 0);
            this.group.setFont(composite.getFont());
            this.group.setLayout((Layout)MainProjectWizardPage.this.initGridLayout(new GridLayout(2, false), true));
            this.group.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_title);
            this.useEEJRE.doFillIntoGrid((Composite)this.group, 1);
            Combo eeComboControl = this.eeCombo.getComboControl((Composite)this.group);
            eeComboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            this.useProjectJRE.doFillIntoGrid((Composite)this.group, 1);
            Combo comboControl = this.jreCombo.getComboControl((Composite)this.group);
            comboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            this.useDefaultJRE.doFillIntoGrid((Composite)this.group, 1);
            this.preferenceLink = new Link((Composite)this.group, 0);
            this.preferenceLink.setFont(this.group.getFont());
            this.preferenceLink.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_link_description);
            this.preferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.preferenceLink.addSelectionListener((SelectionListener)this);
            this.updateEnableState();
            return this.group;
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedJRE();
            int selectionIndex = comboField.getSelectionIndex();
            if (this.useProjectJRE.isSelected() && selectionIndex != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.installedJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.installedJVMs, new Comparator<IVMInstall>(){

                @Override
                public int compare(IVMInstall i0, IVMInstall i1) {
                    if (i1 instanceof IVMInstall2) {
                        IVMInstall2 cvalue1 = (IVMInstall2)i1;
                        if (i0 instanceof IVMInstall2) {
                            IVMInstall2 cvalue0 = (IVMInstall2)i0;
                            String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)cvalue0, (String)"21");
                            String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)cvalue1, (String)"21");
                            int result = cc1.compareTo(cc0);
                            if (result != 0) {
                                return result;
                            }
                        }
                    }
                    return Policy.getComparator().compare(i0.getName(), i1.getName());
                }
            });
            selectionIndex = -1;
            String[] jreLabels = new String[this.installedJVMs.length];
            this.jreCompliance = new String[this.installedJVMs.length];
            int i = 0;
            while (i < this.installedJVMs.length) {
                IVMInstall iVMInstall;
                jreLabels[i] = this.installedJVMs[i].getName();
                if (selectedItem != null && jreLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                if ((iVMInstall = this.installedJVMs[i]) instanceof IVMInstall2) {
                    IVMInstall2 cvalue = (IVMInstall2)iVMInstall;
                    this.jreCompliance[i] = JavaModelUtil.getCompilerCompliance((IVMInstall2)cvalue, (String)"21");
                } else {
                    this.jreCompliance[i] = "21";
                }
                ++i;
            }
            comboField.setItems(jreLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultJVMName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private void fillExecutionEnvironments(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedEE();
            int selectionIndex = comboField.getSelectionIndex();
            if (this.useEEJRE.isSelected() && selectionIndex != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.installedEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            Arrays.sort(this.installedEEs, new Comparator<IExecutionEnvironment>(){

                @Override
                public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                    return Policy.getComparator().compare(arg0.getId(), arg1.getId());
                }
            });
            selectionIndex = -1;
            String[] eeLabels = new String[this.installedEEs.length];
            this.eeCompliance = new String[this.installedEEs.length];
            int i = 0;
            while (i < this.installedEEs.length) {
                eeLabels[i] = this.installedEEs[i].getId();
                if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.eeCompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)this.installedEEs[i]);
                ++i;
            }
            comboField.setItems(eeLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultEEName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            IVMInstall install = JavaRuntime.getDefaultVMInstall();
            if (install != null) {
                return install.getName();
            }
            return NewWizardMessages.NewJavaProjectWizardPageOne_UnknownDefaultJRE_name;
        }

        private String getDefaultEEName() {
            String defaultCC;
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            if (defaultVM != null) {
                int i = 0;
                while (i < environments.length) {
                    IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                    if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                        return environments[i].getId();
                    }
                    ++i;
                }
            }
            if (defaultVM instanceof IVMInstall2) {
                IVMInstall2 cvalue = (IVMInstall2)defaultVM;
                defaultCC = JavaModelUtil.getCompilerCompliance((IVMInstall2)cvalue, (String)"21");
            } else {
                defaultCC = "21";
            }
            int i = 0;
            while (i < environments.length) {
                String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environments[i]);
                if (defaultCC.endsWith(eeCompliance)) {
                    return environments[i].getId();
                }
                ++i;
            }
            return "21";
        }

        private String getDefaultJVMLabel() {
            return MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_default_compliance, this.getDefaultJVMName());
        }

        @Override
        public void update(Observable observable, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = MainProjectWizardPage.this.detectGroup.mustDetect();
            this.useDefaultJRE.setEnabled(!detect);
            this.useProjectJRE.setEnabled(!detect);
            this.useEEJRE.setEnabled(!detect);
            this.jreCombo.setEnabled(!detect && this.useProjectJRE.isSelected());
            this.eeCombo.setEnabled(!detect && this.useEEJRE.isSelected());
            if (this.preferenceLink != null) {
                this.preferenceLink.setEnabled(!detect);
            }
            if (this.group != null) {
                this.group.setEnabled(!detect);
            }
        }

        public void widgetSelected(SelectionEvent event) {
            this.widgetDefaultSelected(event);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)MainProjectWizardPage.this.getShell(), (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", "org.eclipse.jdt.ui.preferences.CompliancePreferencePage", "org.eclipse.jdt.debug.ui.jreProfiles"}, data).open();
            this.handlePossibleJVMChange();
            MainProjectWizardPage.this.detectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.useDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.jreCombo);
            this.fillExecutionEnvironments(this.eeCombo);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            MainProjectWizardPage.this.detectGroup.handlePossibleJVMChange();
            if (field == this.jreCombo) {
                if (this.useProjectJRE.isSelected()) {
                    this.storeSelectionValue(this.jreCombo, LAST_SELECTED_JRE_SETTINGS_KEY);
                }
            } else if (field == this.eeCombo) {
                if (this.useEEJRE.isSelected()) {
                    this.storeSelectionValue(this.eeCombo, LAST_SELECTED_EE_SETTINGS_KEY);
                }
            } else if (field == this.useDefaultJRE) {
                if (this.useDefaultJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 0);
                    this.useProjectJRE.setSelection(false);
                    this.useEEJRE.setSelection(false);
                }
            } else if (field == this.useProjectJRE) {
                if (this.useProjectJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 1);
                    this.useDefaultJRE.setSelection(false);
                    this.useEEJRE.setSelection(false);
                }
            } else if (field == this.useEEJRE && this.useEEJRE.isSelected()) {
                JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 2);
                this.useDefaultJRE.setSelection(false);
                this.useProjectJRE.setSelection(false);
            }
        }

        private void storeSelectionValue(ComboDialogField combo, String preferenceKey) {
            int index = combo.getSelectionIndex();
            if (index == -1) {
                return;
            }
            String item = combo.getItems()[index];
            JavaPlugin.getDefault().getDialogSettings().put(preferenceKey, item);
        }

        private int getLastSelectedJREKind() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            if (settings.get(LAST_SELECTED_JRE_KIND2) == null) {
                return 2;
            }
            return settings.getInt(LAST_SELECTED_JRE_KIND2);
        }

        private String getLastSelectedEE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
        }

        private String getLastSelectedJRE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
        }

        public IVMInstall getSelectedJVM() {
            int index;
            if (this.useProjectJRE.isSelected() && (index = this.jreCombo.getSelectionIndex()) >= 0 && index < this.installedJVMs.length) {
                return this.installedJVMs[index];
            }
            return null;
        }

        public IPath getJREContainerPath() {
            int index;
            if (this.useProjectJRE.isSelected()) {
                int index2 = this.jreCombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.installedJVMs.length) {
                    return JavaRuntime.newJREContainerPath((IVMInstall)this.installedJVMs[index2]);
                }
            } else if (this.useEEJRE.isSelected() && (index = this.eeCombo.getSelectionIndex()) >= 0 && index < this.installedEEs.length) {
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.installedEEs[index]);
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.useProjectJRE.isSelected()) {
                int index2 = this.jreCombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.jreCompliance.length) {
                    return this.jreCompliance[index2];
                }
            } else if (this.useEEJRE.isSelected() && (index = this.eeCombo.getSelectionIndex()) >= 0 && index < this.eeCompliance.length) {
                return this.eeCompliance[index];
            }
            return null;
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";
        protected final SelectionButtonDialogField useDefaults = new SelectionButtonDialogField(32);
        protected final StringButtonDialogField location;
        private String previousExternalLocation;

        LocationGroup() {
            this.useDefaults.setDialogFieldListener((IDialogFieldListener)this);
            this.useDefaults.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_location_desc);
            this.location = new StringButtonDialogField((IStringButtonAdapter)this);
            this.location.setDialogFieldListener((IDialogFieldListener)this);
            this.location.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
            this.location.setButtonLabel(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
            this.useDefaults.setSelection(true);
            this.previousExternalLocation = "";
        }

        public Control createControl(Composite composite) {
            Composite locationComposite = new Composite(composite, 0);
            locationComposite.setLayout((Layout)new GridLayout(4, false));
            this.useDefaults.doFillIntoGrid(locationComposite, 4);
            this.location.doFillIntoGrid(locationComposite, 4);
            LayoutUtil.setHorizontalGrabbing((Control)this.location.getTextControl(null));
            BidiUtils.applyBidiProcessing((Text)this.location.getTextControl(null), (String)"file");
            return locationComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        @Override
        public void update(Observable observable, Object arg) {
            if (this.isUseDefaultSelected()) {
                this.location.setText(this.getDefaultPath(MainProjectWizardPage.this.nameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isUseDefaultSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.location.getText().trim());
        }

        public boolean isUseDefaultSelected() {
            return this.useDefaults.isSelected();
        }

        public void setLocation(IPath path) {
            this.useDefaults.setSelection(path == null);
            if (path != null) {
                this.location.setText(path.toOSString());
            } else {
                this.location.setText(this.getDefaultPath(MainProjectWizardPage.this.nameGroup.getName()));
            }
            this.fireEvent();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(MainProjectWizardPage.this.getShell());
            dialog.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_directory_message);
            String directoryName = this.location.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                String oldDirectory = new Path(this.location.getText().trim()).lastSegment();
                this.location.setText(selectedDirectory);
                String lastSegment = new Path(selectedDirectory).lastSegment();
                if (lastSegment != null && (MainProjectWizardPage.this.nameGroup.getName().length() == 0 || MainProjectWizardPage.this.nameGroup.getName().equals(oldDirectory))) {
                    MainProjectWizardPage.this.nameGroup.setName(lastSegment);
                }
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.useDefaults) {
                boolean checked = this.useDefaults.isSelected();
                if (checked) {
                    this.previousExternalLocation = this.location.getText();
                    this.location.setText(this.getDefaultPath(MainProjectWizardPage.this.nameGroup.getName()));
                    this.location.setEnabled(false);
                } else {
                    this.location.setText(this.previousExternalLocation);
                    this.location.setEnabled(true);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField nameField = new StringDialogField();

        NameGroup() {
            this.nameField.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_NameGroup_label_text);
            this.nameField.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)new GridLayout(2, false));
            this.nameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
            return nameComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.nameField.getText().trim();
        }

        public void postSetFocus() {
            this.nameField.postSetFocusOnDialogField(MainProjectWizardPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.nameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class ProjectConfiguratorsGroup
    extends Observable
    implements IDialogFieldListener {
        private static final String LAST_SELECTED_SETTINGS_KEY_PREFIX = "io.sarl.eclipse.last.selected.create.projectconfigurators.";
        private final Map<SelectionButtonDialogField, ProjectConfigurationFragment> field2fragment = new TreeMap<SelectionButtonDialogField, ProjectConfigurationFragment>((a, b) -> {
            int ida = System.identityHashCode(a);
            int idb = System.identityHashCode(b);
            return Integer.compare(ida, idb);
        });

        ProjectConfiguratorsGroup() {
            for (ProjectConfigurationFragment configuration : ProjectConfigurationFragments.getConfigurationFragmentsFromExtension()) {
                SelectionButtonDialogField checkbox = new SelectionButtonDialogField(32);
                checkbox.setLabelText(configuration.getLabel());
                checkbox.setDialogFieldListener((IDialogFieldListener)this);
                checkbox.setEnabled(true);
                this.field2fragment.put(checkbox, configuration);
            }
        }

        public Control createControl(Composite composite) {
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            Group configuratorGroup = new Group(composite, 0);
            configuratorGroup.setFont(composite.getFont());
            configuratorGroup.setText(Messages.MainProjectWizardPage_2);
            configuratorGroup.setLayout((Layout)layout);
            for (Map.Entry<SelectionButtonDialogField, ProjectConfigurationFragment> entry : this.field2fragment.entrySet()) {
                ProjectConfigurationFragment fragment = entry.getValue();
                String pref = JavaPlugin.getDefault().getDialogSettings().get(ProjectConfiguratorsGroup.preferenceKey(fragment.getId()));
                SelectionButtonDialogField checkbox = entry.getKey();
                checkbox.setSelection(pref == null ? fragment.isActiveByDefault() : Boolean.parseBoolean(pref));
                checkbox.doFillIntoGrid((Composite)configuratorGroup, 2);
            }
            return configuratorGroup;
        }

        private static String preferenceKey(String configurationId) {
            return LAST_SELECTED_SETTINGS_KEY_PREFIX + configurationId;
        }

        private void handlePossibleChange(SelectionButtonDialogField field, ProjectConfigurationFragment fragment) {
            boolean selectedOrig;
            String pref = JavaPlugin.getDefault().getDialogSettings().get(ProjectConfiguratorsGroup.preferenceKey(fragment.getId()));
            boolean selected = selectedOrig = pref == null ? true : Boolean.parseBoolean(pref);
            if (field.isEnabled()) {
                selected = field.isSelected();
            }
            if (selectedOrig != selected) {
                IDialogSettings preferences = JavaPlugin.getDefault().getDialogSettings();
                preferences.put(ProjectConfiguratorsGroup.preferenceKey(fragment.getId()), field.isSelected());
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field instanceof SelectionButtonDialogField) {
                SelectionButtonDialogField cfield = (SelectionButtonDialogField)field;
                ProjectConfigurationFragment configuration = this.field2fragment.get(cfield);
                this.handlePossibleChange(cfield, configuration);
            }
        }

        Stream<ProjectConfigurationFragment> getActivatedProjectExtensions() {
            return this.field2fragment.entrySet().stream().filter(it -> ((SelectionButtonDialogField)it.getKey()).isEnabled() && ((SelectionButtonDialogField)it.getKey()).isSelected()).map(it -> (ProjectConfigurationFragment)it.getValue());
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        @Override
        public void update(Observable observable, Object arg) {
            try {
                IWorkspace workspace = JavaPlugin.getWorkspace();
                String name = MainProjectWizardPage.this.nameGroup.getName();
                this.checkProjectName(workspace, name);
                IProject handle = this.checkProjectExist(workspace, name);
                String location = MainProjectWizardPage.this.locationGroup.getLocation().toOSString();
                IPath projectPath = this.checkLocationSyntax(location);
                this.validateLocation(workspace, handle, projectPath);
                MainProjectWizardPage.this.setErrorMessage(null);
                MainProjectWizardPage.this.setMessage(null);
                MainProjectWizardPage.this.setPageComplete(true);
            }
            catch (ValidationException e) {
                MainProjectWizardPage.this.setMessage(e.getMessage());
                MainProjectWizardPage.this.setErrorMessage(e.getErrorMessage());
                MainProjectWizardPage.this.setPageComplete(false);
            }
        }

        private void checkProjectName(IWorkspace workspace, String name) throws ValidationException {
            if (name.length() == 0) {
                throw new ValidationException(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterProjectName, null);
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                throw new ValidationException(null, nameStatus.getMessage());
            }
        }

        private IProject checkProjectExist(IWorkspace workspace, String name) throws ValidationException {
            IProject handle = workspace.getRoot().getProject(name);
            if (handle.exists()) {
                throw new ValidationException(null, NewWizardMessages.NewJavaProjectWizardPageOne_Message_projectAlreadyExists);
            }
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    projectLocation = new Path(canonicalPath);
                }
                catch (IOException e) {
                    SARLEclipsePlugin.getDefault().log(e);
                }
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(MainProjectWizardPage.this.nameGroup.getName())) {
                    throw new ValidationException(null, MessageFormat.format(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidProjectNameForWorkspaceRoot, TextProcessor.process((String)existingName)));
                }
            }
            return handle;
        }

        private IPath checkLocationSyntax(String location) throws ValidationException {
            if (location.length() == 0) {
                throw new ValidationException(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterLocation, null);
            }
            if (!Path.EMPTY.isValidPath(location)) {
                throw new ValidationException(null, NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidDirectory);
            }
            IPath projectPath = null;
            if (!(MainProjectWizardPage.this.locationGroup.isUseDefaultSelected() || (projectPath = Path.fromOSString((String)location)).toFile().exists() || this.canCreate(projectPath.toFile()))) {
                throw new ValidationException(null, NewWizardMessages.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation);
            }
            return projectPath;
        }

        private void validateLocation(IWorkspace workspace, IProject handle, IPath projectPath) throws ValidationException {
            IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
            if (!locationStatus.isOK()) {
                throw new ValidationException(null, locationStatus.getMessage());
            }
        }

        private boolean canCreate(File file) {
            File fileInHierarchy = file;
            while (!fileInHierarchy.exists()) {
                if ((fileInHierarchy = fileInHierarchy.getParentFile()) != null) continue;
                return false;
            }
            return fileInHierarchy.canWrite();
        }

        private class ValidationException
        extends Exception {
            private static final long serialVersionUID = 2953587040979817037L;
            private final String errorMessage;

            ValidationException(String message, String errorMessage) {
                super(message);
                this.errorMessage = errorMessage;
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock workingSetBlock;

        WorkingSetGroup() {
            String[] workingSetIds = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.workingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, JavaPlugin.getDefault().getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_WorkingSets_group);
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.workingSetBlock.createContent((Composite)workingSetGroup);
            return workingSetGroup;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.workingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.workingSetBlock.getSelectedWorkingSets();
        }
    }
}

