/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.newproject;

import com.google.common.base.Strings;
import com.google.common.io.Resources;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.natures.SARLProjectConfigurator;
import io.sarl.eclipse.properties.RuntimeEnvironmentPropertyPage;
import io.sarl.eclipse.wizards.newproject.BuildSettingWizardPage;
import io.sarl.eclipse.wizards.newproject.MainProjectWizardPage;
import io.sarl.eclipse.wizards.newproject.Messages;
import io.sarl.lang.ui.preferences.SARLPreferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.StringInputStream;

public class NewSarlProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    public static final String POM_TEMPLATE_BASENAME = "pom_template.xml";
    private static final String DEFAULT_MAVEN_PROJECT_VERSION = "0.0.1-SNAPSHOT";
    private MainProjectWizardPage firstPage;
    private BuildSettingWizardPage secondPage;
    private IConfigurationElement fConfigElement;

    public NewSarlProjectWizard() {
        this(null, null);
    }

    public NewSarlProjectWizard(MainProjectWizardPage pageOne, BuildSettingWizardPage pageTwo) {
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.firstPage = pageOne;
        this.secondPage = pageTwo;
    }

    public static URL getPomTemplateLocation() {
        URL url = Resources.getResource(NewSarlProjectWizard.class, (String)POM_TEMPLATE_BASENAME);
        assert (url != null);
        return url;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setDefaultPageImageDescriptor(SARLEclipsePlugin.getDefault().getImageDescriptor("icons/sarl_new_project_dialog.png"));
        this.setWindowTitle(Messages.NewSarlProjectWizard_0);
    }

    public void addPages() {
        if (this.firstPage == null) {
            this.firstPage = new MainProjectWizardPage();
        }
        this.addPage((IWizardPage)this.firstPage);
        if (this.secondPage == null) {
            this.secondPage = new BuildSettingWizardPage(this.firstPage);
        }
        this.addPage((IWizardPage)this.secondPage);
        this.firstPage.init(this.getSelection(), this.getActivePart());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSourcePath(IJavaProject javaProject, IPath path) {
        if (path == null) return false;
        IPath pathInProject = javaProject.getProject().getFullPath().append(path);
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && pathInProject.equals((Object)entry.getPath())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    private static String buildInvalidOutputPathMessageFragment(IJavaProject javaProject) {
        StringBuilder sourceFolders = new StringBuilder();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    sourceFolders.append("\t");
                    sourceFolders.append(entry.getPath().toOSString());
                    sourceFolders.append("\n");
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        return sourceFolders.toString();
    }

    private static String toOSString(IPath path) {
        if (path == null) {
            return "";
        }
        return path.toOSString();
    }

    protected boolean validateSARLSpecificElements(IJavaProject javaProject) {
        IPath outputPath = SARLPreferences.getSARLOutputPathFor((IProject)javaProject.getProject());
        if (outputPath == null) {
            String message = MessageFormat.format(Messages.NewSarlProjectWizard_1, "src/main/generated-sources/sarl");
            IStatus status = SARLEclipsePlugin.getDefault().createStatus(4, message);
            this.handleFinishException(this.getShell(), new InvocationTargetException(new CoreException(status)));
            return false;
        }
        if (!NewSarlProjectWizard.hasSourcePath(javaProject, outputPath)) {
            String message = MessageFormat.format(Messages.NewSarlProjectWizard_2, NewSarlProjectWizard.toOSString(outputPath), NewSarlProjectWizard.buildInvalidOutputPathMessageFragment(javaProject));
            IStatus status = SARLEclipsePlugin.getDefault().createStatus(4, message);
            this.handleFinishException(this.getShell(), new InvocationTargetException(new CoreException(status)));
            return false;
        }
        return true;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.secondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            IJavaProject newElement;
            try {
                newElement = this.getCreatedElement();
            }
            catch (Throwable e) {
                this.handleFinishException(this.getShell(), new InvocationTargetException(e));
                return false;
            }
            this.createDefaultMavenPom(newElement, this.firstPage.getCompilerCompliance());
            SARLProjectConfigurator.configureSARLProject(newElement.getProject(), true, false, false, (IProgressMonitor)new NullProgressMonitor());
            if (!this.validateSARLSpecificElements(newElement)) {
                return false;
            }
            IWorkingSet[] workingSets = this.firstPage.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            try {
                newElement.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                this.handleFinishException(this.getShell(), new InvocationTargetException(e));
                return false;
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)newElement.getProject());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPart activePart = NewSarlProjectWizard.this.getActivePart();
                    if (activePart instanceof IPackagesViewPart) {
                        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                        view.tryToReveal((Object)newElement);
                    }
                }
            });
        }
        return res;
    }

    protected void createDefaultMavenPom(IJavaProject project, String compilerCompliance) {
        URL templateUrl;
        IFile pomFile = project.getProject().getFile("pom.xml");
        if (!pomFile.exists() && (templateUrl = NewSarlProjectWizard.getPomTemplateLocation()) != null) {
            Object var9_14;
            String compliance = Strings.isNullOrEmpty((String)compilerCompliance) ? "21" : compilerCompliance;
            String groupId = this.getDefaultMavenGroupId();
            StringBuilder content = new StringBuilder();
            try {
                Throwable throwable = null;
                var9_14 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(templateUrl.openStream()));){
                    String line = reader.readLine();
                    while (line != null) {
                        line = line.replaceAll(Pattern.quote("@GROUP_ID@"), groupId);
                        line = line.replaceAll(Pattern.quote("@PROJECT_NAME@"), project.getElementName());
                        line = line.replaceAll(Pattern.quote("@PROJECT_VERSION@"), DEFAULT_MAVEN_PROJECT_VERSION);
                        line = line.replaceAll(Pattern.quote("@SARL_VERSION@"), "0.15.1");
                        line = line.replaceAll(Pattern.quote("@JAVA_VERSION@"), compliance);
                        line = line.replaceAll(Pattern.quote("@FILE_ENCODING@"), Charset.defaultCharset().displayName());
                        content.append(line).append("\n");
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                throw new RuntimeIOException((Throwable)exception);
            }
            try {
                Throwable exception = null;
                var9_14 = null;
                try (StringInputStream is = new StringInputStream(content.toString());){
                    pomFile.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable) {
                    if (exception == null) {
                        exception = throwable;
                    } else if (exception != throwable) {
                        exception.addSuppressed(throwable);
                    }
                    throw exception;
                }
            }
            catch (CoreException exception) {
                throw new RuntimeException(exception);
            }
            catch (IOException exception) {
                throw new RuntimeIOException((Throwable)exception);
            }
        }
    }

    protected String getDefaultMavenGroupId() {
        String userdomain = System.getenv("userdomain");
        if (Strings.isNullOrEmpty((String)userdomain)) {
            return "com.foo";
        }
        String[] elements = userdomain.split(Pattern.quote("."));
        StringBuilder groupId = new StringBuilder();
        int i = elements.length - 1;
        while (i >= 0) {
            if (groupId.length() > 0) {
                groupId.append(".");
            }
            groupId.append(elements[i]);
            --i;
        }
        return groupId.toString();
    }

    IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException exception) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)exception, (Shell)this.getShell(), (String)title, (String)message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.secondPage.performCancel();
        return super.performCancel();
    }

    public IJavaProject getCreatedElement() {
        IJavaProject javaProject = this.secondPage.getJavaProject();
        try {
            IProject project = javaProject.getProject();
            ISREInstall sre = this.firstPage.getSRE();
            boolean useDefaultSRE = sre == null || this.firstPage.isSystemDefaultSRE();
            QualifiedName qn = RuntimeEnvironmentPropertyPage.qualify("HAS_PROJECT_SPECIFIC");
            project.setPersistentProperty(qn, Boolean.toString(!useDefaultSRE));
            if (!useDefaultSRE && sre != null) {
                qn = RuntimeEnvironmentPropertyPage.qualify("USE_SYSTEM_WIDE_SRE");
                project.setPersistentProperty(qn, Boolean.FALSE.toString());
                qn = RuntimeEnvironmentPropertyPage.qualify("SRE_INSTALL_ID");
                project.setPersistentProperty(qn, sre.getId());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return javaProject;
    }
}

