/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.sarlapp;

import com.google.inject.Inject;
import io.sarl.eclipse.launching.config.ILaunchConfigurationAccessor;
import io.sarl.eclipse.launching.runner.general.SrePathUtils;
import io.sarl.eclipse.wizards.sarlapp.FixedFatJarExportPage;
import io.sarl.eclipse.wizards.sarlapp.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ExportSarlApplicationPage
extends FixedFatJarExportPage {
    @Inject
    private ILaunchConfigurationAccessor configAccessor;
    private final Set<String> selectedJavaProjects;
    private final SrePathUtils.ExtraClassPathProviders extraClasspathProviders = new SrePathUtils.ExtraClassPathProviders();

    public ExportSarlApplicationPage(JarPackageData jarPackage, IStructuredSelection selection) {
        super(jarPackage, selection);
        this.selectedJavaProjects = ExportSarlApplicationPage.getSelectedJavaProjects(selection);
        this.setTitle(Messages.ExportSarlApplicationPage_0);
        this.setDescription(Messages.ExportSarlApplicationPage_1);
    }

    private static Set<String> getSelectedJavaProjects(IStructuredSelection selection) {
        HashSet<String> selectedProjects = new HashSet<String>();
        for (Object selectedElement : selection) {
            if (selectedElement instanceof Iterable) {
                Iterable cvalue = (Iterable)selectedElement;
                for (Object selectedSubElement : cvalue) {
                    if (!(selectedSubElement instanceof IJavaProject)) continue;
                    IJavaProject javaProject = (IJavaProject)selectedSubElement;
                    selectedProjects.add(javaProject.getElementName());
                }
                continue;
            }
            if (!(selectedElement instanceof IJavaProject)) continue;
            IJavaProject javaProject = (IJavaProject)selectedElement;
            selectedProjects.add(javaProject.getElementName());
        }
        return selectedProjects;
    }

    @Override
    protected FixedFatJarExportPage.LaunchConfigurationElement[] getLaunchConfigurations() {
        ArrayList<FixedFatJarExportPage.ExistingLaunchConfigurationElement> result = new ArrayList<FixedFatJarExportPage.ExistingLaunchConfigurationElement>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("io.sarl.eclipse.debug.ApplicationLaunchConfigType");
            ExportSarlApplicationPage.getLaunchConfiguration(result, type, manager, this.selectedJavaProjects);
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return result.toArray(new FixedFatJarExportPage.LaunchConfigurationElement[result.size()]);
    }

    private static void getLaunchConfiguration(List<FixedFatJarExportPage.ExistingLaunchConfigurationElement> result, ILaunchConfigurationType type, ILaunchManager manager, Set<String> selectedProjects) throws CoreException {
        ILaunchConfiguration[] launchconfigs = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < launchconfigs.length) {
            ILaunchConfiguration launchconfig = launchconfigs[i];
            if (!launchconfig.getAttribute("org.eclipse.debug.ui.private", false)) {
                String projectName = launchconfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (selectedProjects.isEmpty() || selectedProjects.contains(projectName)) {
                    result.add(new FixedFatJarExportPage.ExistingLaunchConfigurationElement(launchconfig, projectName));
                }
            }
            ++i;
        }
    }

    @Override
    protected IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = SrePathUtils.computeUnresolvedSARLRuntimeClasspath(configuration, this.configAccessor, cfg -> ExportSarlApplicationPage.getJavaProject(cfg), this.extraClasspathProviders);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            int classPathProperty = entries[i].getClasspathProperty();
            if (!(classPathProperty != 3 && classPathProperty != 5 && classPathProperty != 4 || (location = entries[i].getLocation()) == null || userEntries.contains(entry = Path.fromOSString((String)location)))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    protected static String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    protected static IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = ExportSarlApplicationPage.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    @Override
    protected IPackageFragmentRoot[] getRequiredPackageFragmentRoots(IPath[] classpathEntries, String projectName, MultiStatus status) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IJavaProject[] searchOrder = ExportSarlApplicationPage.getProjectSearchOrder(projectName);
        IJavaProject project = ExportSarlApplicationPage.getJavaProject(projectName);
        int i = 0;
        while (i < classpathEntries.length) {
            IPath entry = classpathEntries[i];
            IPackageFragmentRoot[] elements = ExportSarlApplicationPage.findRootsForClasspath(entry, searchOrder);
            if (elements == null) {
                File file = entry.toFile();
                IPackageFragmentRoot element = file.exists() ? project.getPackageFragmentRoot(file.getAbsolutePath()) : null;
                if (element != null) {
                    result.add(element);
                } else {
                    status.add((IStatus)new Status(2, "org.eclipse.jdt.ui", org.eclipse.jdt.internal.corext.util.Messages.format((String)FatJarPackagerMessages.FatJarPackageWizardPage_error_missingClassFile, (Object)ExportSarlApplicationPage.getPathLabel(entry, false))));
                }
            } else {
                int j = 0;
                while (j < elements.length) {
                    result.add(elements[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }
}

