/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.sarlapp;

import io.sarl.eclipse.wizards.sarlapp.FixedFatJarExportPage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class FixedFatJarExportWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "FatJarPackageWizard";
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;
    private JarPackageData fJarPackage;
    private FixedFatJarExportPage fJarPackageWizardPage;
    private IStructuredSelection fSelection;

    public FixedFatJarExportWizard() {
        IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarPackageWizardPage = this.createPageInstance(this.fJarPackage, this.fSelection);
        this.addPage((IWizardPage)this.fJarPackageWizardPage);
    }

    protected FixedFatJarExportPage createPageInstance(JarPackageData jarPackage, IStructuredSelection selection) {
        return new FixedFatJarExportPage(jarPackage, selection);
    }

    protected boolean executeExportOperation(IJarExportRunnable op, IStatus wizardPageStatus) {
        block7: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block7;
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)this.getShell(), (String)FatJarPackagerMessages.JarPackageWizard_jarExportError_title, (String)FatJarPackagerMessages.JarPackageWizard_jarExportError_message);
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            if (!wizardPageStatus.isOK()) {
                if (!(status instanceof MultiStatus)) {
                    status = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
                }
                ((MultiStatus)status).add(wizardPageStatus);
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)FatJarPackagerMessages.JarPackageWizard_jarExport_title, null, (IStatus)status);
            return !status.matches(4);
        }
        if (!wizardPageStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)FatJarPackagerMessages.JarPackageWizard_jarExport_title, null, (IStatus)wizardPageStatus);
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return super.getPreviousPage(page);
    }

    protected IStructuredSelection getSelectedJavaProjects() {
        ISelection currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            HashSet<IJavaProject> selectedElements = new HashSet<IJavaProject>();
            for (Object selectedElement : structuredSelection) {
                IJavaElement cvalue;
                IJavaProject javaProject;
                if (!(selectedElement instanceof IJavaElement) || (javaProject = (cvalue = (IJavaElement)selectedElement).getJavaProject()) == null) continue;
                selectedElements.add(javaProject);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getSelectedJavaProjects();
        this.fJarPackage = new JarPackageData();
        this.fJarPackage.setIncludeDirectoryEntries(true);
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(FatJarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_FAT_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, JarPackageData jarPackage) {
        Assert.isNotNull((Object)workbench);
        Assert.isNotNull((Object)jarPackage);
        this.fJarPackage = jarPackage;
        this.setInitializeFromJarPackage(true);
        this.setWindowTitle(FatJarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_FAT_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    public boolean performFinish() {
        IPIssueWarningDialog dialog;
        FixedFatJarExportPage.LibraryHandler libraryHandler = this.fJarPackageWizardPage.getLibraryHandler();
        this.fJarPackage.setJarBuilder((IJarBuilder)libraryHandler.getBuilder(this.fJarPackage));
        MultiStatus status = new MultiStatus(JavaPlugin.getPluginId(), 0, FatJarPackagerMessages.FatJarPackageWizard_JarExportProblems_message, null);
        Object[] elements = this.fJarPackageWizardPage.getSelectedElementsWithoutContainedChildren(status);
        this.fJarPackage.setElements(elements);
        if (libraryHandler.isShowWarning() && this.hasArchive(elements) && OptionalMessageDialog.isDialogEnabled((String)"RunnableJar.export.ipwarning") && (dialog = new IPIssueWarningDialog(this.getShell(), FatJarPackagerMessages.FatJarPackageWizard_IPIssueDialog_title, FatJarPackagerMessages.FatJarPackageWizard_IPIssueDialog_message)).open() != 0) {
            return false;
        }
        this.fJarPackageWizardPage.exportAntScript(status);
        if (!this.executeExportOperation(this.fJarPackage.createJarExportRunnable(this.getShell()), (IStatus)status)) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fJarPackageWizardPage.finish();
        return true;
    }

    private boolean hasArchive(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            IPackageFragmentRoot root;
            Object object = elements[i];
            if (object instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)object).isArchive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setInitializeFromJarPackage(boolean state) {
        this.fInitializeFromJarPackage = state;
    }

    private static final class IPIssueWarningDialog
    extends OptionalMessageDialog {
        private static final String ID = "RunnableJar.export.ipwarning";

        protected IPIssueWarningDialog(Shell parent, String title, String message) {
            super(ID, parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        }
    }
}

