/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.sreinstall;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreinstall.AbstractSREInstallPage;
import io.sarl.apputils.eclipseextensions.sreinstall.SREInstallPages;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.ManifestBasedSREInstall;
import io.sarl.eclipse.runtime.SREException;
import io.sarl.eclipse.wizards.sreinstall.Messages;
import io.sarl.eclipse.wizards.sreinstall.StandardSREPage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.Wizard;

public abstract class SREInstallWizard
extends Wizard {
    private ISREInstall sre;
    private String[] names;

    public SREInstallWizard(ISREInstall editSRE, ISREInstall[] currentInstalls) {
        this.sre = editSRE;
        ArrayList<String> names = new ArrayList<String>(currentInstalls.length);
        int i = 0;
        while (i < currentInstalls.length) {
            String name;
            ISREInstall install = currentInstalls[i];
            if (!(this.sre != null && install.getId().equals(this.sre.getId()) || Strings.isNullOrEmpty((String)(name = install.getNameNoDefault())) || name.equals(install.getId()))) {
                names.add(name);
            }
            ++i;
        }
        this.names = names.toArray(new String[names.size()]);
    }

    protected ISREInstall getOriginalSRE() {
        return this.sre;
    }

    public boolean performFinish() {
        return true;
    }

    public AbstractSREInstallPage getPage(ISREInstall sre) {
        List extensions = SREInstallPages.getSREInstallStreamFromExtension().collect(Collectors.toList());
        IConfigurationElement firstTypeMatching = null;
        for (IConfigurationElement info : extensions) {
            String id = info.getAttribute("sreInstallId");
            if (sre.getId().equals(Strings.nullToEmpty((String)id))) {
                try {
                    AbstractSREInstallPage page = (AbstractSREInstallPage)info.createExecutableExtension("class");
                    page.setExistingNames(this.names);
                    return page;
                }
                catch (CoreException e) {
                    SARLEclipsePlugin.getDefault().log(e);
                    continue;
                }
            }
            if (firstTypeMatching != null || !SREInstallWizard.isInstance(info.getAttribute("sreInstallType"), sre)) continue;
            firstTypeMatching = info;
        }
        if (firstTypeMatching != null) {
            try {
                AbstractSREInstallPage page = (AbstractSREInstallPage)firstTypeMatching.createExecutableExtension("class");
                page.setExistingNames(this.names);
                return page;
            }
            catch (CoreException e) {
                SARLEclipsePlugin.getDefault().log(e);
            }
        }
        if (sre == null || sre instanceof ManifestBasedSREInstall) {
            StandardSREPage standardVMPage = new StandardSREPage();
            standardVMPage.setExistingNames(this.names);
            return standardVMPage;
        }
        throw new SREException(MessageFormat.format(Messages.SREInstallWizard_5, sre.getName()));
    }

    private static boolean isInstance(String classname, ISREInstall sre) {
        if (!Strings.isNullOrEmpty((String)classname)) {
            Class<?> type = sre.getClass();
            while (type != null && !Object.class.equals(type)) {
                if (classname.equals(type.getName())) {
                    return true;
                }
                type = type.getSuperclass();
            }
        }
        return false;
    }
}

