/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.eclipse.wizards.sreinstall;

import com.google.common.base.Strings;
import io.sarl.apputils.eclipseextensions.sreinstall.AbstractSREInstallPage;
import io.sarl.apputils.eclipseextensions.sreprovider.ISREInstall;
import io.sarl.eclipse.runtime.ManifestBasedSREInstall;
import io.sarl.eclipse.runtime.SARLRuntime;
import io.sarl.eclipse.runtime.SREException;
import io.sarl.eclipse.wizards.sreinstall.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StandardSREPage
extends AbstractSREInstallPage {
    private Text sreLibraryTextField;
    private Text sreNameTextField;
    private Text sreMainClassTextField;
    private Text sreIdTextField;
    private ManifestBasedSREInstall originalSRE;
    private ManifestBasedSREInstall workingCopy;

    public StandardSREPage() {
        super("");
    }

    public Image getImage() {
        return JavaDebugImages.get((String)"IMG_WIZBAN_LIBRARY");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel((Composite)composite, (String)Messages.StandardSREPage_0, (int)1);
        this.sreLibraryTextField = SWTFactory.createSingleText((Composite)composite, (int)1);
        this.sreLibraryTextField.setEditable(false);
        Button folders = SWTFactory.createPushButton((Composite)composite, (String)Messages.StandardSREPage_1, null);
        GridData data = (GridData)folders.getLayoutData();
        data.horizontalAlignment = 3;
        SWTFactory.createLabel((Composite)composite, (String)Messages.StandardSREPage_2, (int)1);
        this.sreNameTextField = SWTFactory.createSingleText((Composite)composite, (int)2);
        SWTFactory.createLabel((Composite)composite, (String)Messages.StandardSREPage_3, (int)1);
        this.sreMainClassTextField = SWTFactory.createSingleText((Composite)composite, (int)2);
        SWTFactory.createLabel((Composite)composite, (String)Messages.StandardSREPage_8, (int)1);
        this.sreIdTextField = SWTFactory.createSingleText((Composite)composite, (int)2);
        this.sreIdTextField.setEditable(false);
        this.sreNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                StandardSREPage.this.workingCopy.setName(StandardSREPage.this.sreNameTextField.getText());
                StandardSREPage.this.setPageStatus(StandardSREPage.this.validate());
                StandardSREPage.this.updatePageStatus();
            }
        });
        this.sreMainClassTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                StandardSREPage.this.workingCopy.setMainClass(StandardSREPage.this.sreMainClassTextField.getText());
                StandardSREPage.this.setPageStatus(StandardSREPage.this.validate());
                StandardSREPage.this.updatePageStatus();
            }
        });
        folders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StandardSREPage.this.selectSRE();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setPageStatus(this.validate());
        this.updatePageStatus();
        this.initializeFields();
    }

    protected void selectSRE() {
        String selectedFile;
        File file = this.workingCopy.getJarFile() != null ? this.workingCopy.getJarFile().toFile() : null;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.StandardSREPage_4);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        if (file != null && file.exists()) {
            dialog.setFileName(file.getAbsolutePath());
        }
        if ((selectedFile = dialog.open()) != null) {
            IPath path = Path.fromOSString((String)selectedFile);
            this.createWorkingCopy();
            this.workingCopy.setJarFile(path);
            IStatus status = this.validate();
            this.initializeFields();
            this.setPageStatus(status);
            this.updatePageStatus();
        }
    }

    public boolean performFinish() {
        try {
            String xml = SARLRuntime.getSREAsXML(this.workingCopy);
            SARLRuntime.setSREFromXML(this.originalSRE, xml);
            return true;
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
    }

    public void initialize(ISREInstall sre) {
        if (!(sre instanceof ManifestBasedSREInstall)) {
            throw new SREException("Illegal SRE type: expecting ManifestBasedSREInstall.");
        }
        ManifestBasedSREInstall cvalue = (ManifestBasedSREInstall)sre;
        this.setTitle(MessageFormat.format(Messages.StandardSREPage_7, sre.getName()));
        this.originalSRE = cvalue;
        this.createWorkingCopy();
    }

    protected void createWorkingCopy() {
        this.workingCopy = this.originalSRE.clone();
        this.workingCopy.setNotify(false);
    }

    public ISREInstall createSelection(String id) {
        ManifestBasedSREInstall sre = new ManifestBasedSREInstall(id);
        sre.revalidate();
        this.initialize(sre);
        return sre;
    }

    private void initializeFields() {
        IPath path = this.workingCopy.getJarFile();
        String tooltip = null;
        String basename = null;
        if (path != null) {
            tooltip = path.toOSString();
            IPath tmpPath = path.removeTrailingSeparator();
            if (tmpPath != null) {
                basename = tmpPath.lastSegment();
            }
        }
        this.sreLibraryTextField.setText(Strings.nullToEmpty(basename));
        this.sreLibraryTextField.setToolTipText(Strings.nullToEmpty((String)tooltip));
        String name = this.workingCopy.getNameNoDefault();
        this.sreNameTextField.setText(Strings.nullToEmpty((String)name));
        String mainClass = this.workingCopy.getMainClass();
        this.sreMainClassTextField.setText(Strings.nullToEmpty((String)mainClass));
        this.sreIdTextField.setText(this.workingCopy.getId());
    }

    private IStatus validate() {
        IStatus status = this.workingCopy.revalidate();
        if (status.isOK()) {
            status = this.validateNameAgainstOtherSREs(this.workingCopy.getName());
        }
        return status;
    }
}

