/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.ui.tests.preferences;

import com.google.inject.Inject;
import io.sarl.lang.tests.api.AbstractSarlTest;
import io.sarl.lang.ui.preferences.SARLValidatorConfigurationBlock;
import io.sarl.lang.validation.StandardSarlConfigurableIssueCodesProvider;
import io.sarl.tests.api.tools.TestAssertions;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.xbase.ui.validation.XbaseValidationConfigurationBlock;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@DisplayName(value="SARLValidatorConfigurationBlock")
public class SARLValidatorConfigurationBlockTest
extends AbstractSarlTest {
    @Inject
    private StandardSarlConfigurableIssueCodesProvider configuration;
    private final Set<String> expectedKeys = new TreeSet<String>();
    private MockSARLValidatorConfigurationBlock block;

    @BeforeEach
    public void setUp() {
        this.expectedKeys.addAll(this.configuration.getConfigurableIssueCodes().keySet());
        this.block = new MockSARLValidatorConfigurationBlock();
    }

    private void assertConfigurableIssues() {
        TestAssertions.assertContainsCollection(this.block.keys, this.expectedKeys);
    }

    private void removeImplicitlySupportedIssues() {
        this.block.keys.add("org.eclipse.xtext.builder.copyJavaProblems");
        this.block.keys.add("org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call");
    }

    @DisplayName(value="All configurable issues in UI")
    @Test
    public void configurableIssues() {
        this.block.fillActiveAnnotationSection();
        this.block.fillCodingStyleSection();
        this.block.fillDispatchSection();
        this.block.fillJavaDocSection();
        this.block.fillPotentialProgrammingProblemsSection();
        this.block.fillRestrictedApiSection();
        this.block.fillUnusedCodeSection();
        this.removeImplicitlySupportedIssues();
        this.assertConfigurableIssues();
    }

    private static class MockSARLValidatorConfigurationBlock
    extends SARLValidatorConfigurationBlock {
        public final Set<String> keys = new TreeSet<String>();
        private final XbaseValidationConfigurationBlock.ComboBoxBuilder builder = this.createBuilder();

        protected Combo addJavaDelegatingComboBox(String prefKey, String label, Composite parent, int indent) {
            this.keys.add(prefKey);
            return (Combo)Mockito.mock(Combo.class);
        }

        protected Combo addComboBox(Composite parent, String label, String key, int indent, String[] values, String[] valueLabels) {
            this.keys.add(key);
            return (Combo)Mockito.mock(Combo.class);
        }

        public void fillCodingStyleSection() {
            this.fillCodingStyleSection(this.builder);
        }

        public void fillPotentialProgrammingProblemsSection() {
            this.fillPotentialProgrammingProblemsSection(this.builder);
        }

        public void fillRestrictedApiSection() {
            this.fillRestrictedApiSection(this.builder);
        }

        public void fillUnusedCodeSection() {
            this.fillUnusedCodeSection(this.builder);
        }

        public void fillActiveAnnotationSection() {
            this.fillActiveAnnotationSection(this.builder);
        }

        public void fillDispatchSection() {
            this.fillDispatchSection(this.builder);
        }

        public void fillJavaDocSection() {
            this.fillJavaDocSection(this.builder);
        }

        public XbaseValidationConfigurationBlock.ComboBoxBuilder createBuilder() {
            return new XbaseValidationConfigurationBlock.ComboBoxBuilder((XbaseValidationConfigurationBlock)this, (Composite)Mockito.mock(Composite.class), 0);
        }
    }
}

