/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import io.sarl.lang.compiler.batch.CompilerStatus;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.util.JavaVersion;

public abstract class AbstractJavaBatchCompiler
implements IJavaBatchCompiler {
    protected static String buildPath(Iterable<File> path, IProgressMonitor progress) {
        StringBuilder cmd = new StringBuilder();
        boolean first = true;
        for (File classpathPath : path) {
            if (progress.isCanceled()) {
                return null;
            }
            if (!classpathPath.exists()) continue;
            if (first) {
                first = false;
            } else {
                cmd.append(File.pathSeparator);
            }
            cmd.append(classpathPath.getAbsolutePath());
        }
        return cmd.toString();
    }

    protected boolean addJavaFilesDeeply(List<String> list, File root) {
        LinkedList<File> folders = new LinkedList<File>();
        if (root.exists()) {
            if (root.isDirectory()) {
                folders.addLast(root);
            } else {
                list.add(root.getAbsolutePath());
                return true;
            }
        }
        boolean changed = false;
        while (!folders.isEmpty()) {
            File current = (File)folders.removeFirst();
            assert (current.isDirectory());
            for (File subfile : current.listFiles()) {
                if (subfile.isDirectory()) {
                    folders.addLast(subfile);
                    continue;
                }
                if (!this.isJavaExtension(subfile)) continue;
                list.add(subfile.getAbsolutePath());
                changed = true;
            }
        }
        return changed;
    }

    protected boolean addFolderIfJavaFileDeeply(List<String> list, File root) {
        LinkedList<File> folders = new LinkedList<File>();
        if (root.exists() && root.isDirectory()) {
            folders.addLast(root);
        }
        while (!folders.isEmpty()) {
            File current = (File)folders.removeFirst();
            assert (current.isDirectory());
            for (File subfile : current.listFiles()) {
                if (subfile.isDirectory()) {
                    folders.addLast(subfile);
                    continue;
                }
                if (!this.isJavaExtension(subfile)) continue;
                list.add(root.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    protected boolean isJavaExtension(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            int index = name.lastIndexOf(46);
            if (index > 1 && ".java".equalsIgnoreCase(name.substring(index))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final CompilerStatus compile(File classDirectory, Iterable<File> sourcePathDirectories, Iterable<File> classPathEntries, Iterable<File> modulePathEntries, String javaVersion, String encoding, boolean isCompilerMoreVerbose, OptimizationLevel optimizationLevel, PrintWriter outWriter, PrintWriter errWriter, Logger logger, IProgressMonitor progress) {
        JavaVersion jversion = SarlBatchCompilerUtils.parseJavaVersion(javaVersion);
        return this.compile(classDirectory, sourcePathDirectories, classPathEntries, modulePathEntries, jversion, true, encoding, isCompilerMoreVerbose, optimizationLevel, outWriter, errWriter, logger, progress);
    }

    protected abstract CompilerStatus compile(File var1, Iterable<File> var2, Iterable<File> var3, Iterable<File> var4, JavaVersion var5, boolean var6, String var7, boolean var8, OptimizationLevel var9, PrintWriter var10, PrintWriter var11, Logger var12, IProgressMonitor var13);
}

