/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import java.util.Comparator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;

public class DefaultIssueComparator
implements Comparator<Issue> {
    private static int compareSafe(Integer n1, Integer n2) {
        if (n1 == null) {
            return n2 == null ? 0 : -1;
        }
        if (n2 == null) {
            return 1;
        }
        return Integer.compare(n1, n2);
    }

    private static int compareSafe(Severity s1, Severity s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo((Enum)s2);
    }

    private static int compareSafe(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @Override
    public int compare(Issue issue1, Issue issue2) {
        if (issue1 == issue2) {
            return 0;
        }
        if (issue1 == null) {
            return -1;
        }
        if (issue2 == null) {
            return 1;
        }
        URI u1 = issue1.getUriToProblem();
        URI u2 = issue2.getUriToProblem();
        int cmp = 0;
        if (u1 != u2 && u1 != null && u2 != null) {
            cmp = u1.toFileString().compareTo(u2.toFileString());
        }
        if (cmp != 0) {
            return cmp;
        }
        cmp = DefaultIssueComparator.compareSafe(issue1.getLineNumber(), issue2.getLineNumber());
        if (cmp != 0) {
            return cmp;
        }
        cmp = DefaultIssueComparator.compareSafe(issue1.getColumn(), issue2.getColumn());
        if (cmp != 0) {
            return cmp;
        }
        cmp = DefaultIssueComparator.compareSafe(issue1.getSeverity(), issue2.getSeverity());
        if (cmp != 0) {
            return cmp;
        }
        cmp = DefaultIssueComparator.compareSafe(issue1.getMessage(), issue2.getMessage());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(System.identityHashCode(issue1), System.identityHashCode(issue2));
    }
}

