/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.sarl.lang.compiler.batch.AbstractJavaBatchCompiler;
import io.sarl.lang.compiler.batch.CompilerStatus;
import io.sarl.lang.compiler.batch.Messages;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;

@Singleton
public class EcjBatchCompiler
extends AbstractJavaBatchCompiler {
    @Override
    public String getName() {
        return "Eclipse JDT Compiler";
    }

    @Override
    public CompilerStatus compile(File classDirectory, Iterable<File> sourcePathDirectories, Iterable<File> classPathEntries, Iterable<File> modulePathEntries, JavaVersion javaVersion, boolean isModuleSupport, String encoding, boolean isCompilerMoreVerbose, OptimizationLevel optimizationLevel, PrintWriter outWriter, PrintWriter errWriter, Logger logger, IProgressMonitor progress) {
        String path;
        assert (progress != null);
        ArrayList commandLineArguments = Lists.newArrayList();
        if (optimizationLevel != null) {
            switch (optimizationLevel) {
                case G2: {
                    commandLineArguments.add("-g:none");
                    commandLineArguments.add("-O");
                    break;
                }
                case G1: {
                    commandLineArguments.add("-g:none");
                    break;
                }
                default: {
                    commandLineArguments.add("-g");
                    commandLineArguments.add("-preserveAllLocals");
                }
            }
        }
        commandLineArguments.add("-nowarn");
        if (isCompilerMoreVerbose) {
            commandLineArguments.add("-verbose");
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        Iterator<File> classPathIterator = classPathEntries.iterator();
        if (classPathIterator.hasNext()) {
            path = EcjBatchCompiler.buildPath(classPathEntries, progress);
            if (path == null) {
                return CompilerStatus.CANCELED;
            }
            if (!Strings.isEmpty((String)path)) {
                commandLineArguments.add("-cp");
                commandLineArguments.add(path);
            }
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        if (isModuleSupport) {
            path = EcjBatchCompiler.buildPath(modulePathEntries, progress);
            if (path == null) {
                return CompilerStatus.CANCELED;
            }
            if (!Strings.isEmpty((String)path)) {
                commandLineArguments.add("-p");
                commandLineArguments.add(path);
            }
        }
        if (!classDirectory.exists()) {
            classDirectory.mkdirs();
        }
        commandLineArguments.add("-d");
        commandLineArguments.add(classDirectory.getAbsolutePath());
        commandLineArguments.add("-" + EcjBatchCompiler.ensureCompatibleJavaVersion(javaVersion));
        commandLineArguments.add("-proceedOnError");
        if (!Strings.isEmpty((String)encoding)) {
            commandLineArguments.add("-encoding");
            commandLineArguments.add(encoding);
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        boolean hasSourceFile = false;
        for (File sourceFolder : sourcePathDirectories) {
            if (progress.isCanceled()) {
                return CompilerStatus.CANCELED;
            }
            if (!this.addFolderIfJavaFileDeeply(commandLineArguments, sourceFolder.getAbsoluteFile())) continue;
            hasSourceFile = true;
        }
        if (!hasSourceFile) {
            return CompilerStatus.NOTHING_TO_COMPILE;
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        String[] arguments = new String[commandLineArguments.size()];
        commandLineArguments.toArray(arguments);
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            StringBuilder buf = new StringBuilder();
            for (String str : commandLineArguments) {
                if (Strings.isEmpty((String)str)) continue;
                buf.append(str).append("\n");
            }
            logger.finest(MessageFormat.format(Messages.EcjBatchCompiler_0, buf.toString()));
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        boolean status = BatchCompiler.compile((String[])arguments, (PrintWriter)outWriter, (PrintWriter)errWriter, (CompilationProgress)new ProgressMonitorCompilationProgress(progress));
        return status ? CompilerStatus.COMPILATION_SUCCESS : CompilerStatus.COMPILATION_FAILURE;
    }

    public static String ensureCompatibleJavaVersion(JavaVersion javaVersion) {
        switch (javaVersion) {
            case JAVA21: {
                return "19";
            }
        }
        return javaVersion.getQualifier();
    }

    private static class ProgressMonitorCompilationProgress
    extends CompilationProgress {
        private final IProgressMonitor monitor;

        ProgressMonitorCompilationProgress(IProgressMonitor monitor) {
            assert (monitor != null);
            this.monitor = monitor;
        }

        public void begin(int remainingWork) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public void setTaskName(String name) {
            this.monitor.subTask(name);
        }

        public void worked(int workIncrement, int remainingWork) {
        }
    }
}

