/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler.batch;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.sarl.lang.compiler.batch.AbstractJavaBatchCompiler;
import io.sarl.lang.compiler.batch.CompilerStatus;
import io.sarl.lang.compiler.batch.Messages;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.output.WriterOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;

@Singleton
public class JavacBatchCompiler
extends AbstractJavaBatchCompiler {
    @Override
    public String getName() {
        return "Javac";
    }

    @Override
    public CompilerStatus compile(File classDirectory, Iterable<File> sourcePathDirectories, Iterable<File> classPathEntries, Iterable<File> modulePathEntries, JavaVersion javaVersion, boolean isModuleSupport, String encoding, boolean isCompilerMoreVerbose, OptimizationLevel optimizationLevel, PrintWriter outWriter, PrintWriter errWriter, Logger logger, IProgressMonitor progress) {
        assert (progress != null);
        ArrayList commandLineArguments = Lists.newArrayList();
        if (optimizationLevel != null) {
            switch (optimizationLevel) {
                case G2: {
                    commandLineArguments.add("-g:none");
                    break;
                }
                case G1: {
                    commandLineArguments.add("-g:none");
                    break;
                }
                default: {
                    commandLineArguments.add("-g");
                }
            }
        }
        commandLineArguments.add("-nowarn");
        if (isCompilerMoreVerbose) {
            commandLineArguments.add("-verbose");
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        String path = JavacBatchCompiler.buildPath(classPathEntries, progress);
        if (path == null || progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        if (!Strings.isEmpty((String)path)) {
            commandLineArguments.add("-cp");
            commandLineArguments.add(path);
        }
        if (isModuleSupport) {
            path = JavacBatchCompiler.buildPath(modulePathEntries, progress);
            if (path == null || progress.isCanceled()) {
                return CompilerStatus.CANCELED;
            }
            if (!Strings.isEmpty((String)path)) {
                commandLineArguments.add("-p");
                commandLineArguments.add(path);
            }
        }
        if (!classDirectory.exists()) {
            classDirectory.mkdirs();
        }
        commandLineArguments.add("-d");
        commandLineArguments.add(classDirectory.getAbsolutePath());
        commandLineArguments.add("-source");
        commandLineArguments.add(javaVersion.getQualifier());
        commandLineArguments.add("-target");
        commandLineArguments.add(javaVersion.getQualifier());
        if (!Strings.isEmpty((String)encoding)) {
            commandLineArguments.add("-encoding");
            commandLineArguments.add(encoding);
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        boolean hasSourceFile = false;
        for (File sourceFolder : sourcePathDirectories) {
            if (progress.isCanceled()) {
                return CompilerStatus.CANCELED;
            }
            if (!this.addJavaFilesDeeply(commandLineArguments, sourceFolder.getAbsoluteFile())) continue;
            hasSourceFile = true;
        }
        if (!hasSourceFile) {
            return CompilerStatus.NOTHING_TO_COMPILE;
        }
        if (progress.isCanceled()) {
            return CompilerStatus.CANCELED;
        }
        String[] arguments = new String[commandLineArguments.size()];
        commandLineArguments.toArray(arguments);
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(MessageFormat.format(Messages.JavacBatchCompiler_0, Strings.concat((String)" ", (List)commandLineArguments)));
        }
        JavacErrorStream stderr = new JavacErrorStream(errWriter, logger);
        try {
            WriterOutputStream.Builder builder = WriterOutputStream.builder();
            builder.setWriter((Writer)outWriter);
            builder.setCharset(Charset.defaultCharset());
            WriterOutputStream stdout = builder.get();
            if (progress.isCanceled()) {
                return CompilerStatus.CANCELED;
            }
            JavaCompiler systemCompiler = this.getSystemJavaCompiler();
            int retcode = systemCompiler.run(null, (OutputStream)stdout, (OutputStream)((Object)stderr), arguments);
            return retcode == 0 ? CompilerStatus.COMPILATION_SUCCESS : CompilerStatus.COMPILATION_FAILURE;
        }
        catch (IOException ex) {
            if (logger != null) {
                logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            return CompilerStatus.COMPILATION_FAILURE;
        }
    }

    protected JavaCompiler getSystemJavaCompiler() {
        PrivilegedAction<JavaCompiler> action = () -> ToolProvider.getSystemJavaCompiler();
        JavaCompiler standardCompiler = action.run();
        if (standardCompiler == null) {
            ServiceLoader<JavaCompiler> sl = ServiceLoader.load(JavaCompiler.class);
            for (JavaCompiler tool : sl) {
                if (tool == null) continue;
                return tool;
            }
        }
        return standardCompiler;
    }

    private static class JavacErrorStream
    extends WriterOutputStream {
        private static final String NOTE_PREFIX = "Note:";
        private final Logger logger;

        JavacErrorStream(PrintWriter writer, Logger logger) {
            super((Writer)writer, Charset.defaultCharset());
            this.logger = logger;
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            String msg = new String(buffer, offset, length);
            if (msg.startsWith(NOTE_PREFIX)) {
                if (this.logger != null) {
                    this.logger.info(msg.substring(NOTE_PREFIX.length()).trim());
                }
                return;
            }
            super.write(buffer, offset, length);
        }
    }
}

